/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import org.netbeans.core.NbMainExplorer;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.RootFolderNode;
import org.netbeans.core.ui.MountNode;
import org.openide.TopManager;
import org.openide.actions.NewTemplateAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

final class DataSystem
extends AbstractNode
implements RepositoryListener,
NewTemplateAction.Cookie {
    private static DataSystem def;
    private transient Repository fileSystemPool;
    DataFilter filter;
    static /* synthetic */ Class class$org$netbeans$core$DataSystem;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$netbeans$core$actions$MountAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$CustomizeAction;

    private DataSystem(Children children, Repository repository, DataFilter dataFilter) {
        super(children);
        this.fileSystemPool = repository;
        this.filter = dataFilter;
        this.initialize();
        this.setIconBase("/org/netbeans/core/resources/repository");
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$core$DataSystem == null ? (class$org$netbeans$core$DataSystem = DataSystem.class$("org.netbeans.core.DataSystem")) : class$org$netbeans$core$DataSystem)).getString("dataSystemName"));
        this.setShortDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$DataSystem == null ? (class$org$netbeans$core$DataSystem = DataSystem.class$("org.netbeans.core.DataSystem")) : class$org$netbeans$core$DataSystem)).getString("CTL_Repository_Hint"));
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)repository));
        this.getCookieSet().add((Node.Cookie)this);
    }

    private DataSystem(Children children, DataFilter dataFilter) {
        this(children, NbTopManager.get().getRepository(), dataFilter);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$DataSystem == null ? (class$org$netbeans$core$DataSystem = DataSystem.class$("org.netbeans.core.DataSystem")) : class$org$netbeans$core$DataSystem);
    }

    public static Node getDataSystem(DataFilter dataFilter) {
        if (dataFilter == null) {
            if (def != null) {
                return def;
            }
            def = new DataSystem((Children)new DSMap(), DataFilter.ALL);
            return def;
        }
        return new DataSystem((Children)new DSMap(), dataFilter);
    }

    public static Node getDataSystem() {
        return DataSystem.getDataSystem(null);
    }

    void initialize() {
        this.fileSystemPool.addRepositoryListener(WeakListener.repository((RepositoryListener)this, (Object)this.fileSystemPool));
        Enumeration enumeration = this.fileSystemPool.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            fileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((DSMap)this.getChildren()), (Object)fileSystem));
        }
        this.refresh();
    }

    public Node.Handle getHandle() {
        return this.filter == DataFilter.ALL ? new DSHandle(null) : new DSHandle(this.filter);
    }

    static DataFolder createRoot(FileSystem fileSystem) {
        return DataFolder.findFolder((FileObject)fileSystem.getRoot());
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = DataSystem.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction)), null, SystemAction.get((Class)(class$org$netbeans$core$actions$MountAction == null ? (class$org$netbeans$core$actions$MountAction = DataSystem.class$("org.netbeans.core.actions.MountAction")) : class$org$netbeans$core$actions$MountAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = DataSystem.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$CustomizeAction == null ? (class$org$openide$actions$CustomizeAction = DataSystem.class$("org.openide.actions.CustomizeAction")) : class$org$openide$actions$CustomizeAction))};
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        repositoryEvent.getFileSystem().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)((DSMap)this.getChildren()), (Object)repositoryEvent.getFileSystem()));
        this.refresh();
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        this.refresh();
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        this.refresh();
    }

    void refresh() {
        this.refresh(null);
    }

    void refresh(FileSystem fileSystem) {
        ((DSMap)this.getChildren()).refresh(this.fileSystemPool, fileSystem);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        NbMainExplorer.SettingsTab settingsTab = new NbMainExplorer.SettingsTab();
        settingsTab.getExplorerManager().setRootContext(TopManager.getDefault().getPlaces().nodes().repositorySettings());
        settingsTab.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$DataSystem == null ? (class$org$netbeans$core$DataSystem = DataSystem.class$("org.netbeans.core.DataSystem")) : class$org$netbeans$core$DataSystem)).getString("ACSD_DataSystemCustomizer"));
        return settingsTab;
    }

    public TemplateWizard getTemplateWizard() {
        return MountNode.wizard();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class DSHandle
    implements Node.Handle {
        DataFilter filter;
        static final long serialVersionUID = -2266375092419944364L;

        public DSHandle(DataFilter dataFilter) {
            this.filter = dataFilter;
        }

        public Node getNode() {
            return DataSystem.getDataSystem(this.filter);
        }
    }

    static class DSMap
    extends Children.Keys
    implements PropertyChangeListener {
        DSMap() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataSystem dataSystem = this.getDS();
            if (dataSystem == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("hidden")) {
                dataSystem.refresh();
            } else if (propertyChangeEvent.getPropertyName().equals("root")) {
                FileSystem fileSystem = (FileSystem)propertyChangeEvent.getSource();
                dataSystem.refresh(fileSystem);
                dataSystem.refresh();
            }
        }

        private DataSystem getDS() {
            return (DataSystem)this.getNode();
        }

        protected Node[] createNodes(Object object) {
            FileSystem fileSystem = (FileSystem)object;
            DataFolder dataFolder = DataSystem.createRoot(fileSystem);
            RootFolderNode rootFolderNode = new RootFolderNode(dataFolder, dataFolder.createNodeChildren(this.getDS().filter));
            rootFolderNode = MountNode.customize((Node)rootFolderNode, fileSystem);
            return new Node[]{rootFolderNode};
        }

        public void refresh(Repository repository, FileSystem fileSystem) {
            Enumeration enumeration = repository.getFileSystems();
            ArrayList arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (fileSystem == e || ((FileSystem)e).isHidden()) continue;
                arrayList.add(e);
            }
            this.setKeys(arrayList);
        }
    }
}

