/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.core.CoronaDialog;
import org.netbeans.core.DataSystem;
import org.netbeans.core.awt.ButtonBar;
import org.netbeans.core.awt.ButtonBarButton;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

class FileSelector
extends CoronaDialog
implements PropertyChangeListener {
    static final long serialVersionUID = 6524404012203099065L;
    private ExplorerManager manager;
    private BeanTreeView tree;
    private JPanel base;
    private Node[] nodes;
    boolean cancelFlag;
    private boolean accepted;
    private ButtonBarButton okButton;
    private ButtonBarButton cancelButton;
    private NodeAcceptor acceptor;
    static /* synthetic */ Class class$org$netbeans$core$FileSelector;

    FileSelector(String string, String string2, Node node, NodeAcceptor nodeAcceptor, Component component) {
        super((Frame)null);
        this.acceptor = nodeAcceptor;
        ExplorerPanel explorerPanel = new ExplorerPanel();
        this.getCustomPane().setLayout(new BorderLayout());
        this.getCustomPane().add((Component)explorerPanel, "Center");
        this.manager = explorerPanel.getExplorerManager();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FileSelector.this.cancelFlag = true;
                FileSelector.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSelector.this.buttonPressed(1);
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 2);
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$FileSelector == null ? (class$org$netbeans$core$FileSelector = FileSelector.class$("org.netbeans.core.FileSelector")) : class$org$netbeans$core$FileSelector));
        this.okButton = new ButtonBarButton(resourceBundle.getString("CTL_FileSelectorOkButton"));
        this.cancelButton = new ButtonBarButton(resourceBundle.getString("CTL_FileSelectorCancelButton"));
        this.okButton.getAccessibleContext().setAccessibleDescription("ACSD_FileSelectorOkButton");
        this.cancelButton.getAccessibleContext().setAccessibleDescription("ACSD_FileSelectorCancelButton");
        this.getButtonBar().setButtons(new ButtonBarButton[0], new ButtonBarButton[]{this.okButton, this.cancelButton});
        this.getRootPane().setDefaultButton(this.okButton);
        this.setTitle(string);
        this.manager.setRootContext(node);
        explorerPanel.setLayout((LayoutManager)new BorderLayout(0, 5));
        explorerPanel.setBorder((Border)new EmptyBorder(12, 12, 0, 11));
        try {
            Node[] nodeArray;
            if (node instanceof DataSystem && (nodeArray = node.getChildren().getNodes()).length > 0) {
                final JComboBox<Node> jComboBox = new JComboBox<Node>(nodeArray);
                jComboBox.setRenderer(new FileSelectRenderer());
                jComboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Node node = (Node)jComboBox.getSelectedItem();
                        FileSelector.this.manager.setRootContext(node);
                    }
                });
                this.manager.setSelectedNodes(new Node[]{nodeArray[0]});
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout(5, 0));
                JLabel jLabel = new JLabel(string2.replace('&', ' '));
                jLabel.setDisplayedMnemonic(string2.charAt(string2.indexOf(38) + 1));
                jLabel.setLabelFor(jComboBox);
                jPanel.add((Component)jLabel, "West");
                jPanel.add(jComboBox, "Center");
                explorerPanel.add((Component)jPanel, (Object)"North");
            } else {
                this.manager.setSelectedNodes(new Node[]{node});
                JLabel jLabel = new JLabel(string2.replace('&', ' '));
                explorerPanel.add((Component)jLabel, (Object)"North");
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IllegalStateException(propertyVetoException.getMessage());
        }
        this.tree = new BeanTreeView();
        this.tree.setPopupAllowed(false);
        this.tree.setDefaultActionAllowed(false);
        this.tree.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$FileSelector == null ? (class$org$netbeans$core$FileSelector = FileSelector.class$("org.netbeans.core.FileSelector")) : class$org$netbeans$core$FileSelector)).getString("ACSN_FileSelectorTreeView"));
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$FileSelector == null ? (class$org$netbeans$core$FileSelector = FileSelector.class$("org.netbeans.core.FileSelector")) : class$org$netbeans$core$FileSelector)).getString("ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$FileSelector == null ? (class$org$netbeans$core$FileSelector = FileSelector.class$("org.netbeans.core.FileSelector")) : class$org$netbeans$core$FileSelector)).getString("ACSD_FileSelectorDialog"));
        explorerPanel.add((Component)this.tree, (Object)"Center");
        if (component != null) {
            explorerPanel.add(component, (Object)"South");
        }
        this.cancelFlag = false;
        this.accepted = true;
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.center();
        if (component != null) {
            component.requestFocus();
        }
        if (nodeAcceptor.acceptNodes(this.manager.getSelectedNodes())) {
            this.enableButton();
        } else {
            this.disableButton();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
            if (this.acceptor.acceptNodes(this.manager.getSelectedNodes())) {
                this.enableButton();
            } else {
                this.disableButton();
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 260;
        return dimension;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    void enableButton() {
        this.accepted = true;
        this.okButton.setEnabled(true);
    }

    void disableButton() {
        this.accepted = false;
        this.okButton.setEnabled(false);
    }

    protected void buttonPressed(ButtonBar.ButtonBarEvent buttonBarEvent) {
        int n = this.getButtonBar().getButtonIndex(buttonBarEvent.getButton());
        this.buttonPressed(n);
    }

    private void buttonPressed(int n) {
        switch (n) {
            case 0: {
                if (this.accepted) {
                    this.nodes = this.manager.getSelectedNodes();
                    break;
                }
                return;
            }
            case 1: {
                this.cancelFlag = true;
            }
        }
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FileSelectRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -7071698027341621636L;
        protected static Border hasFocusBorder;
        protected static Border noFocusBorder;

        public FileSelectRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
            hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof Node)) {
                return this;
            }
            Node node = (Node)object;
            ImageIcon imageIcon = new ImageIcon(node.getIcon(1));
            this.setIcon(imageIcon);
            this.setText(node.getDisplayName());
            if (bl) {
                super.setBackground(UIManager.getColor("List.selectionBackground"));
                super.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                super.setBackground(jList.getBackground());
                super.setForeground(jList.getForeground());
            }
            this.setBorder(bl2 ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

