/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ObjectStreamException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.Help;
import org.netbeans.core.Main;
import org.netbeans.core.NbPresenter;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.windows.CloneableTopComponent;

class JavaHelp
extends Help
implements ChangeListener,
WindowListener {
    private static final String MASTER_RESOURCE = "org.netbeans.core.resources.masterHelpSet";
    private static final String MASTER_RESOURCE_EXT = "xml";
    private HelpSet master = null;
    private Map availableJHelps = new HashMap();
    private JFrame frameViewer = null;
    private JDialog dialogViewer = null;
    private HelpSet lastFramedHelpSet = null;
    private HelpSet lastDialogHelpSet = null;
    private Boolean userClosedHelpViewer = null;
    private static final BoundedRangeModel mergeModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
    private static RequestProcessor helpLoader = null;
    static /* synthetic */ Class class$org$netbeans$core$JavaHelp;

    public JavaHelp() {
        NbPresenter.addChangeListener(this);
        Help.err.log("JavaHelp created");
    }

    private synchronized HelpSet getMaster() {
        if (this.master == null) {
            ClassLoader classLoader = (class$org$netbeans$core$JavaHelp == null ? (class$org$netbeans$core$JavaHelp = JavaHelp.class$("org.netbeans.core.JavaHelp")) : class$org$netbeans$core$JavaHelp).getClassLoader();
            try {
                HelpSet helpSet;
                this.master = new HelpSet(classLoader, NbBundle.getLocalizedFile((String)MASTER_RESOURCE, (String)MASTER_RESOURCE_EXT, (Locale)Locale.getDefault(), (ClassLoader)classLoader));
                Collection collection = this.getHelpSets();
                ArrayList<HelpSet> arrayList = new ArrayList<HelpSet>(Math.min(1, collection.size()));
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    helpSet = (HelpSet)iterator.next();
                    if (!this.shouldMerge(helpSet)) continue;
                    arrayList.add(helpSet);
                }
                mergeModel.setValue(0);
                mergeModel.setMaximum(arrayList.size());
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    helpSet = (HelpSet)iterator.next();
                    this.master.add(helpSet);
                    mergeModel.setValue(mergeModel.getValue() + 1);
                }
            }
            catch (HelpSetException helpSetException) {
                Help.err.notify((Throwable)helpSetException);
                this.master = new HelpSet();
            }
        }
        return this.master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void helpSetsChanged() {
        JavaHelp javaHelp = this;
        synchronized (javaHelp) {
            this.master = null;
        }
        mergeModel.setValue(0);
        mergeModel.setMaximum(0);
        super.helpSetsChanged();
    }

    public void showHelp(HelpCtx helpCtx, boolean bl) {
        String string;
        Runnable runnable;
        if (!SwingUtilities.isEventDispatchThread()) {
            Help.err.log("showHelp later...");
            final HelpCtx helpCtx2 = helpCtx;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JavaHelp.this.showHelp(helpCtx2);
                }
            });
            return;
        }
        Help.err.log("showing help: " + helpCtx);
        if (helpCtx == null) {
            helpCtx = HelpCtx.DEFAULT_HELP;
        }
        NbPresenter nbPresenter = NbPresenter.currentModalDialog;
        final HelpSet[] helpSetArray = new HelpSet[1];
        if (bl || helpCtx.equals((Object)HelpCtx.DEFAULT_HELP)) {
            runnable = new Runnable(){

                public void run() {
                    Help.err.log("getting master...");
                    helpSetArray[0] = JavaHelp.this.getMaster();
                    Help.err.log("getting master...done");
                }
            };
        } else {
            string = helpCtx.getHelpID();
            runnable = new Runnable(){

                public void run() {
                    Help.err.log("finding help set for " + string + "...");
                    helpSetArray[0] = JavaHelp.this.findHelpSetForID(string);
                    Help.err.log("finding help set for " + string + "...done");
                }
            };
        }
        if (this.master == null) {
            Help.err.log("showing progress dialog...");
            this.createProgressDialog(runnable, nbPresenter).show();
            Help.err.log("dialog done.");
        } else {
            runnable.run();
        }
        string = helpSetArray[0];
        if (string == null) {
            return;
        }
        JHelp jHelp = this.createJHelp((HelpSet)string);
        if (nbPresenter == null) {
            Help.err.log("showing as non-dialog");
            boolean bl2 = false;
            if (this.frameViewer == null) {
                bl2 = true;
                Help.err.log("creating new frame viewer");
                this.frameViewer = new JFrame();
                this.frameViewer.setIconImage(Utilities.loadImage((String)"org/netbeans/core/resources/actions/moduleHelp.gif"));
                JavaHelp.setViewerA11yDesc(this.frameViewer);
            }
            if (this.lastFramedHelpSet != string) {
                Help.err.log("changing displayed help set");
                this.frameViewer.setTitle(string.getTitle());
                this.frameViewer.getContentPane().removeAll();
                if (this.dialogViewer != null) {
                    Help.err.log("cleaning up old dialog viewer");
                    this.dialogViewer.setVisible(false);
                    this.dialogViewer.getContentPane().removeAll();
                }
                this.frameViewer.getContentPane().add((Component)jHelp, "Center");
                this.frameViewer.pack();
                this.frameViewer.repaint();
                this.lastFramedHelpSet = string;
            }
            if (bl2) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension dimension2 = this.frameViewer.getSize();
                if (dimension2.width > dimension.width) {
                    dimension2.width = dimension.width;
                    this.frameViewer.setSize(dimension2);
                }
                if (dimension2.height > dimension.height) {
                    dimension2.height = dimension.height;
                    this.frameViewer.setSize(dimension2);
                }
                this.frameViewer.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            } else {
                this.frameViewer.setState(0);
            }
            this.frameViewer.setVisible(true);
            this.frameViewer.requestFocus();
        } else {
            Help.err.log("showing as dialog");
            if (this.dialogViewer != null && !this.dialogViewer.isVisible()) {
                Help.err.log("destroying old dialog viewer and creating new");
                this.dialogViewer.getContentPane().removeAll();
                this.dialogViewer.dispose();
                this.dialogViewer = new JDialog((Dialog)nbPresenter, false);
                JavaHelp.setViewerA11yDesc(this.dialogViewer);
                this.lastDialogHelpSet = null;
            }
            if (this.dialogViewer == null) {
                Help.err.log("creating new dialog viewer");
                this.dialogViewer = new JDialog((Dialog)nbPresenter, false);
                JavaHelp.setViewerA11yDesc(this.dialogViewer);
                if (this.frameViewer != null && this.frameViewer.isVisible()) {
                    Help.err.log("hiding frame viewer");
                    this.dialogViewer.setBounds(this.frameViewer.getBounds());
                    this.frameViewer.setVisible(false);
                    this.frameViewer.getContentPane().removeAll();
                } else {
                    this.lastFramedHelpSet = null;
                }
            }
            if (this.lastDialogHelpSet != string) {
                Help.err.log("changing displayed help set");
                this.dialogViewer.setTitle(string.getTitle());
                this.dialogViewer.getContentPane().removeAll();
                this.dialogViewer.getContentPane().add((Component)jHelp, "Center");
                this.dialogViewer.pack();
                this.dialogViewer.repaint();
                this.lastDialogHelpSet = string;
            }
            this.rearrange(nbPresenter);
            this.dialogViewer.show();
        }
        this.displayInJHelp(jHelp, helpCtx.getHelpID(), helpCtx.getHelp());
    }

    private static void setViewerA11yDesc(Accessible accessible) {
        accessible.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$JavaHelp == null ? (class$org$netbeans$core$JavaHelp = JavaHelp.class$("org.netbeans.core.JavaHelp")) : class$org$netbeans$core$JavaHelp), (String)"ACSD_JavaHelp_viewer"));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        NbPresenter nbPresenter = NbPresenter.currentModalDialog;
        if (nbPresenter == null) {
            Help.err.log("modal dialog was hidden");
            if (this.lastFramedHelpSet != null && this.frameViewer != null && !this.frameViewer.isVisible()) {
                if (this.dialogViewer != null && this.userClosedHelpViewer != Boolean.TRUE) {
                    Help.err.log("reparenting to frame viewer");
                    this.frameViewer.getContentPane().removeAll();
                    this.frameViewer.getContentPane().add((Component)this.createJHelp(this.lastFramedHelpSet), "Center");
                    this.frameViewer.setState(0);
                    this.frameViewer.setVisible(true);
                    this.frameViewer.repaint();
                } else {
                    Help.err.log("leaving frame viewer closed");
                    this.frameViewer.getContentPane().removeAll();
                    this.lastFramedHelpSet = null;
                }
            } else if (this.lastFramedHelpSet == null) {
                Help.err.log("no existing framed help set");
            } else if (this.frameViewer == null) {
                Help.err.log("no existing frame viewer");
            } else {
                Help.err.log("frame viewer was already visible");
            }
            this.dialogViewer = null;
            this.lastDialogHelpSet = null;
            this.userClosedHelpViewer = null;
        } else {
            Help.err.log("modal dialog was shown");
            if (this.frameViewer != null && this.frameViewer.isVisible()) {
                Help.err.log("frame viewer was visible");
                this.frameViewer.setVisible(false);
                this.frameViewer.getContentPane().removeAll();
                if (this.dialogViewer == null || !this.dialogViewer.isVisible()) {
                    Help.err.log("dialog viewer did not exist or was invisible");
                    this.dialogViewer = new JDialog((Dialog)nbPresenter, false);
                    this.dialogViewer.setTitle(this.lastFramedHelpSet.getTitle());
                    this.dialogViewer.getContentPane().add((Component)this.createJHelp(this.lastFramedHelpSet), "Center");
                    this.dialogViewer.setBounds(this.frameViewer.getBounds());
                    JavaHelp.setViewerA11yDesc(this.dialogViewer);
                    this.rearrange(nbPresenter);
                    this.dialogViewer.setVisible(true);
                    this.lastDialogHelpSet = this.lastFramedHelpSet;
                    nbPresenter.addWindowListener(this);
                    this.dialogViewer.addWindowListener(this);
                }
            } else {
                Help.err.log("frame viewer was not visible");
                this.lastFramedHelpSet = null;
                if (this.frameViewer != null) {
                    Help.err.log("cleaning up invisible frame viewer");
                    this.frameViewer.getContentPane().removeAll();
                }
            }
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.userClosedHelpViewer != null) {
            Help.err.log("user closed another dialog, ignoring");
        } else if (windowEvent.getWindow() == this.dialogViewer) {
            Help.err.log("user closed the help viewer dialog");
            this.userClosedHelpViewer = Boolean.TRUE;
        } else {
            Help.err.log("user closed the main dialog");
            this.userClosedHelpViewer = Boolean.FALSE;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void rearrange(NbPresenter nbPresenter) {
        Rectangle rectangle;
        Rectangle rectangle2 = nbPresenter.getBounds();
        if (rectangle2.intersects(rectangle = this.dialogViewer.getBounds())) {
            Help.err.log("modal dialog and dialog viewer overlap");
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = dimension.width - rectangle2.width - rectangle.width;
            int n2 = dimension.height - rectangle2.height - rectangle.height;
            if (n >= n2) {
                int n3 = rectangle2.x + rectangle2.width / 2;
                int n4 = rectangle.x + rectangle.width / 2;
                if (n3 <= n4) {
                    Help.err.log(" send help to the right");
                    if (rectangle2.x + rectangle2.width + rectangle.width <= dimension.width) {
                        Help.err.log("there is enough place fo help");
                        rectangle.x = rectangle2.x + rectangle2.width;
                    } else {
                        Help.err.log("there is not enough place");
                        if (rectangle2.width + rectangle.width < dimension.width) {
                            Help.err.log("relocate both");
                            rectangle.x = dimension.width - rectangle.width;
                            rectangle2.x = rectangle.x - rectangle2.width;
                        } else {
                            Help.err.log("relocate both and resize help");
                            rectangle2.x = 0;
                            rectangle.x = rectangle2.width;
                            rectangle.width = dimension.width - rectangle2.width;
                        }
                    }
                } else {
                    Help.err.log("send help to the left");
                    if (rectangle2.x - rectangle.width > 0) {
                        Help.err.log("there is enough place for help");
                        rectangle.x = rectangle2.x - rectangle.width;
                    } else {
                        Help.err.log("there is not enough place");
                        if (rectangle2.width + rectangle.width < dimension.width) {
                            Help.err.log("relocate both");
                            rectangle.x = 0;
                            rectangle2.x = rectangle.width;
                        } else {
                            Help.err.log("relocate both and resize help");
                            rectangle2.x = dimension.width - rectangle2.width;
                            rectangle.x = 0;
                            rectangle.width = rectangle2.x;
                        }
                    }
                }
            } else {
                int n5 = rectangle2.y + rectangle2.height / 2;
                int n6 = rectangle.y + rectangle.height / 2;
                if (n5 <= n6) {
                    Help.err.log(" send help to the bottom");
                    if (rectangle2.y + rectangle2.height + rectangle.height <= dimension.height) {
                        Help.err.log("there is enough place fo help");
                        rectangle.y = rectangle2.y + rectangle2.height;
                    } else {
                        Help.err.log("there is not enough place");
                        if (rectangle2.height + rectangle.height < dimension.height) {
                            Help.err.log("relocate both");
                            rectangle.y = dimension.height - rectangle.height;
                            rectangle2.y = rectangle.y - rectangle2.height;
                        } else {
                            Help.err.log("relocate both and resize help");
                            rectangle2.y = 0;
                            rectangle.y = rectangle2.height;
                            rectangle.height = dimension.height - rectangle2.height;
                        }
                    }
                } else {
                    Help.err.log("send help to the top");
                    if (rectangle2.y - rectangle.height > 0) {
                        Help.err.log("there is enough place for help");
                        rectangle.y = rectangle2.y - rectangle.height;
                    } else {
                        Help.err.log("there is not enough place");
                        if (rectangle2.height + rectangle.height < dimension.height) {
                            Help.err.log("relocate both");
                            rectangle.y = 0;
                            rectangle2.y = rectangle.height;
                        } else {
                            Help.err.log("relocate both and resize help");
                            rectangle2.y = dimension.height - rectangle2.height;
                            rectangle.y = 0;
                            rectangle.height = rectangle2.y;
                        }
                    }
                }
            }
            nbPresenter.setBounds(rectangle2);
            this.dialogViewer.setBounds(rectangle);
        }
    }

    private JDialog createProgressDialog(Runnable runnable, JDialog jDialog) {
        return jDialog == null ? new ProgressDialog(runnable, TopManager.getDefault().getWindowManager().getMainWindow()) : new ProgressDialog(runnable, jDialog);
    }

    private static RequestProcessor getHelpLoader() {
        if (helpLoader == null) {
            helpLoader = new RequestProcessor("org.netbeans.core.JavaHelp");
        }
        return helpLoader;
    }

    private HelpSet findHelpSetForID(String string) {
        if (string != null) {
            Iterator iterator = this.getHelpSets().iterator();
            while (iterator.hasNext()) {
                HelpSet helpSet = (HelpSet)iterator.next();
                if (!helpSet.getCombinedMap().isValidID(string, helpSet)) continue;
                return helpSet;
            }
            JavaHelp.warnBadID(string);
        }
        return this.getMaster();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isValidID(String var1_1) {
        block2: {
            if (!this.helpSetsReady()) break block2;
            var2_2 = this.getHelpSets().iterator();
            if (!"org.netbeans.core.Help.MASTER_ID".equals(var1_1)) ** GOTO lbl13
            if (var2_2.hasNext()) {
                Help.err.log("master id, and >=1 help set");
                return true;
            }
            Help.err.log("master id, and 0 help sets");
            return false;
lbl-1000:
            // 1 sources

            {
                var3_3 = (HelpSet)var2_2.next();
                if (!var3_3.getCombinedMap().isValidID(var1_1, var3_3)) continue;
                Help.err.log("found normal valid id " + var1_1 + " in " + var3_3.getTitle());
                return true;
lbl13:
                // 2 sources

                ** while (var2_2.hasNext())
            }
lbl14:
            // 1 sources

            Help.err.log("did not find id " + var1_1);
            return false;
        }
        Help.err.log("not checking " + var1_1 + " specifically");
        return super.isValidID(var1_1);
    }

    private static void warnBadID(String string) {
        System.err.println(Main.getString("MSG_jh_id_not_found", string));
    }

    private synchronized void displayInJHelp(JHelp jHelp, String string, URL uRL) {
        Help.err.log("displayInJHelp: " + string + " " + uRL);
        try {
            if (string != null && !string.equals("org.netbeans.core.Help.MASTER_ID")) {
                HelpSet helpSet = jHelp.getModel().getHelpSet();
                if (helpSet.getCombinedMap().isValidID(string, helpSet)) {
                    jHelp.setCurrentID(string);
                } else {
                    JavaHelp.warnBadID(string);
                }
            } else if (uRL != null) {
                jHelp.setCurrentURL(uRL);
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            TopManager.getDefault().notifyException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JHelp createJHelp(HelpSet helpSet) {
        JHelp jHelp;
        Object object;
        Map map = this.availableJHelps;
        synchronized (map) {
            object = (Reference)this.availableJHelps.get(helpSet);
            if (object != null && (jHelp = (JHelp)((Reference)object).get()) != null) {
                return jHelp;
            }
        }
        try {
            jHelp = new JHelp(helpSet);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            TopManager.getDefault().notifyException(throwable);
            return new JHelp();
        }
        object = this.availableJHelps;
        synchronized (object) {
            this.availableJHelps.put(helpSet, new SoftReference<JHelp>(jHelp));
        }
        try {
            Map.ID iD = helpSet.getHomeID();
            if (iD == null) return jHelp;
            jHelp.setCurrentID(iD);
            return jHelp;
        }
        catch (Exception exception) {
            Help.err.notify(1, (Throwable)exception);
        }
        return jHelp;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class HelpComponent
    extends CloneableTopComponent {
        private static final long serialVersionUID = 882544693090803112L;

        public Object readResolve() throws ObjectStreamException {
            return null;
        }
    }

    private static final class ProgressDialog
    extends JDialog
    implements TaskListener,
    Runnable {
        private Runnable run;

        public ProgressDialog(Runnable runnable, JDialog jDialog) {
            super(jDialog, NbBundle.getMessage((Class)(class$org$netbeans$core$JavaHelp == null ? (class$org$netbeans$core$JavaHelp = JavaHelp.class$("org.netbeans.core.JavaHelp")) : class$org$netbeans$core$JavaHelp), (String)"TITLE_loading_help_sets"), true);
            this.init(runnable, jDialog);
        }

        public ProgressDialog(Runnable runnable, Frame frame) {
            super(frame, NbBundle.getMessage((Class)(class$org$netbeans$core$JavaHelp == null ? (class$org$netbeans$core$JavaHelp = JavaHelp.class$("org.netbeans.core.JavaHelp")) : class$org$netbeans$core$JavaHelp), (String)"TITLE_loading_help_sets"), true);
            this.init(runnable, frame);
        }

        private void init(Runnable runnable, Window window) {
            this.run = runnable;
            this.getContentPane().setLayout(new GridLayout(2, 2));
            this.getContentPane().add(new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$core$JavaHelp == null ? (class$org$netbeans$core$JavaHelp = JavaHelp.class$("org.netbeans.core.JavaHelp")) : class$org$netbeans$core$JavaHelp), (String)"LBL_parsing_help_sets")));
            this.getContentPane().add(new JProgressBar(Help.parseModel));
            this.getContentPane().add(new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$core$JavaHelp == null ? (class$org$netbeans$core$JavaHelp = JavaHelp.class$("org.netbeans.core.JavaHelp")) : class$org$netbeans$core$JavaHelp), (String)"LBL_merging_help_sets")));
            this.getContentPane().add(new JProgressBar(mergeModel));
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }

        public void show() {
            if (this.run != null) {
                Help.err.log("posting request from progress dialog...");
                JavaHelp.getHelpLoader();
                RequestProcessor.postRequest((Runnable)this.run).addTaskListener((TaskListener)this);
                this.run = null;
            }
            super.show();
        }

        public void taskFinished(Task task) {
            Help.err.log("posting request from progress dialog...request finished.");
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.hide();
            this.dispose();
        }
    }
}

