/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Keymap;
import org.netbeans.core.NbTopManager;

final class NbKeymap
implements Keymap {
    String name;
    Keymap parent;
    Map bindings;
    Action defaultAction;
    Map actions;

    NbKeymap() {
        this("Default", null);
    }

    NbKeymap(String string, Keymap keymap) {
        this.name = string;
        this.parent = keymap;
        this.bindings = new HashMap();
    }

    public Action getDefaultAction() {
        if (this.defaultAction != null) {
            return this.defaultAction;
        }
        return this.parent != null ? this.parent.getDefaultAction() : null;
    }

    public void setDefaultAction(Action action) {
        this.defaultAction = action;
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action getAction(KeyStroke keyStroke) {
        Action action = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            action = (Action)this.bindings.get(keyStroke);
        }
        if (action == null && this.parent != null) {
            action = this.parent.getAction(keyStroke);
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStroke[] getBoundKeyStrokes() {
        int n = 0;
        KeyStroke[] keyStrokeArray = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            keyStrokeArray = new KeyStroke[this.bindings.size()];
            Iterator iterator = this.bindings.keySet().iterator();
            while (iterator.hasNext()) {
                keyStrokeArray[n++] = (KeyStroke)iterator.next();
            }
        }
        return keyStrokeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action[] getBoundActions() {
        int n = 0;
        Action[] actionArray = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            actionArray = new Action[this.bindings.size()];
            Iterator iterator = this.bindings.values().iterator();
            while (iterator.hasNext()) {
                actionArray[n++] = (Action)iterator.next();
            }
        }
        return actionArray;
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        List list;
        Map map = this.actions;
        if (map == null) {
            map = this.buildReverseMapping();
        }
        if ((list = (List)map.get(action)) != null) {
            return list.toArray(new KeyStroke[list.size()]);
        }
        return new KeyStroke[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildReverseMapping() {
        HashMap<Action, List<KeyStroke>> hashMap = this.actions = new HashMap<Action, List<KeyStroke>>();
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            Set set = this.bindings.entrySet();
            Iterator iterator = this.bindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Action action = (Action)entry.getValue();
                KeyStroke keyStroke = (KeyStroke)entry.getKey();
                List<KeyStroke> list = (List<KeyStroke>)hashMap.get(action);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList(1));
                    hashMap.put(action, list);
                }
                list.add(keyStroke);
            }
        }
        return hashMap;
    }

    public synchronized boolean isLocallyDefined(KeyStroke keyStroke) {
        return this.bindings.containsKey(keyStroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            this.bindings.put(keyStroke, action);
            this.actions = null;
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActionForKeyStrokeMap(HashMap hashMap) {
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                this.bindings.put(k, hashMap.get(k));
            }
            this.actions = null;
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            this.bindings.remove(keyStroke);
            this.actions = null;
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindings() {
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            this.bindings.clear();
            this.actions = null;
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public Keymap getResolveParent() {
        return this.parent;
    }

    public void setResolveParent(Keymap keymap) {
        this.parent = keymap;
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public String toString() {
        return "Keymap[" + this.name + "]" + this.bindings;
    }

    void fireChangeEvent(ChangeEvent changeEvent) {
        NbTopManager.get().firePropertyChange("globalKeymap", null, null);
    }
}

