/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectStreamException;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.SwingUtilities;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.NbProjectOperation;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.Places;
import org.openide.TopManager;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public final class NbMainExplorer
extends CloneableTopComponent
implements DeferredPerformer.DeferredCommand {
    static final long serialVersionUID = 6021472310669753679L;
    private static MessageFormat formatExplorerTitle;
    private List prevRoots;
    private Map rootsToTCs;
    private Node currentRoot;
    private transient RootsListener rootsListener = new RootsListener();
    private transient PropertyChangeListener weakRootsL = WeakListener.propertyChange((PropertyChangeListener)this.rootsListener, (Object)TopManager.getDefault());
    private transient boolean listenerInitialized;
    public static final int MIN_HEIGHT = 150;
    public static final int DEFAULT_WIDTH = 350;
    private static Map moduleTabs;
    private static NbMainExplorer explorer;
    static /* synthetic */ Class class$org$netbeans$core$NbMainExplorer;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$openide$loaders$DataShadow;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerPanel;

    public NbMainExplorer() {
        TopManager.getDefault().addPropertyChangeListener(this.weakRootsL);
    }

    public HelpCtx getHelpCtx() {
        return ExplorerPanel.getHelpCtx((Node[])this.getActivatedNodes(), (HelpCtx)new HelpCtx(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer));
    }

    static synchronized ModuleTab findModuleTab(String string, ModuleTab moduleTab) {
        ModuleTab moduleTab2;
        if (moduleTabs == null) {
            moduleTabs = new HashMap(5);
        }
        if ((moduleTab2 = (ModuleTab)moduleTabs.get(string)) != null) {
            return moduleTab2;
        }
        if (moduleTab != null) {
            moduleTabs.put(string, moduleTab);
            return moduleTab;
        }
        ModuleTab moduleTab3 = new ModuleTab();
        moduleTabs.put(string, moduleTab3);
        return moduleTab3;
    }

    public void open(Workspace workspace) {
        WindowManagerImpl.deferredPerformer().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(workspace, true));
    }

    public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
        Workspace workspace = (Workspace)deferredContext.getData();
        if (workspace == null) {
            this.refreshRoots();
        } else {
            super.open(workspace);
            this.close(workspace);
            NbMainExplorer nbMainExplorer = NbMainExplorer.getExplorer();
            nbMainExplorer.openRoots(workspace);
        }
    }

    public void openRoots() {
        this.openRoots(TopManager.getDefault().getWindowManager().getCurrentWorkspace());
    }

    public void openRoots(Workspace workspace) {
        ExplorerTab explorerTab = MainTab.lastActivated;
        this.refreshRoots();
        Node[] nodeArray = NbMainExplorer.getRoots().toArray(new Node[0]);
        ExplorerTab explorerTab2 = null;
        int n = 0;
        while (n < nodeArray.length) {
            explorerTab2 = this.getRootPanel(nodeArray[n]);
            if (explorerTab2 != null) {
                explorerTab2.open(workspace);
            }
            ++n;
        }
        if (explorerTab == null) {
            explorerTab = this.getRootPanel(nodeArray[0]);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ModeImpl modeImpl;
            if (explorerTab != null && (modeImpl = (ModeImpl)workspace.findMode((TopComponent)explorerTab)) != null) {
                modeImpl.requestFocus((TopComponent)explorerTab);
            }
        } else if (explorerTab != null) {
            final MainTab mainTab = explorerTab;
            final Workspace workspace2 = workspace;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl modeImpl = (ModeImpl)workspace2.findMode((TopComponent)mainTab);
                    if (modeImpl != null) {
                        modeImpl.requestFocus((TopComponent)mainTab);
                    }
                }
            });
        }
    }

    final void refreshRoots() {
        Object object;
        Node node;
        Iterator iterator;
        Collection collection;
        Object object2;
        if (!this.listenerInitialized && (object2 = (IDESettings)IDESettings.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = NbMainExplorer.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings))) != null) {
            object2.addPropertyChangeListener(this.weakRootsL);
            this.listenerInitialized = true;
        }
        object2 = null;
        List list = NbMainExplorer.getRoots();
        if (this.prevRoots != null) {
            collection = new HashSet(this.prevRoots);
            ((AbstractSet)collection).removeAll(list);
            iterator = this.rootsToTCs.entrySet().iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                object = (Node)node.getKey();
                if (!((HashSet)collection).contains(object)) continue;
                if (NbProjectOperation.hasProjectDesktop() && NbProjectOperation.getProjectDesktop().getClass() == object.getClass()) {
                    object2 = (ProjectsTab)node.getValue();
                    continue;
                }
                NbMainExplorer.closeEverywhere((TopComponent)node.getValue());
            }
        } else {
            this.prevRoots();
        }
        collection = NbMainExplorer.whereOpened(this.rootsToTCs().values().toArray(new TopComponent[0]));
        iterator = list.iterator();
        while (iterator.hasNext()) {
            node = (Node)iterator.next();
            object = this.getRootPanel(node);
            if (object == null && (object = this.createTC(node)) != object2) {
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    ((ExplorerTab)object).open((Workspace)iterator2.next());
                }
            }
            if (!node.equals(NbProjectOperation.getProjectDesktop())) continue;
            ((ExplorerTab)object).scheduleValidation();
            object2 = null;
        }
        if (object2 != null) {
            NbMainExplorer.closeEverywhere((TopComponent)object2);
        }
        this.prevRoots = list;
    }

    private static void closeEverywhere(TopComponent topComponent) {
        Workspace[] workspaceArray = TopManager.getDefault().getWindowManager().getWorkspaces();
        int n = 0;
        while (n < workspaceArray.length) {
            if (topComponent.isOpened(workspaceArray[n])) {
                topComponent.close(workspaceArray[n]);
            }
            ++n;
        }
    }

    private static List whereOpened(TopComponent[] topComponentArray) {
        Workspace[] workspaceArray = TopManager.getDefault().getWindowManager().getWorkspaces();
        ArrayList<Workspace> arrayList = new ArrayList<Workspace>(workspaceArray.length);
        int n = 0;
        while (n < workspaceArray.length) {
            int n2 = 0;
            while (n2 < topComponentArray.length) {
                if (topComponentArray[n2].isOpened(workspaceArray[n])) {
                    arrayList.add(workspaceArray[n]);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public static List getRoots() {
        Places.Nodes nodes = TopManager.getDefault().getPlaces().nodes();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(nodes.repository());
        if (NbProjectOperation.hasProjectDesktop()) {
            linkedList.add(NbProjectOperation.getProjectDesktop());
        }
        linkedList.addAll(Arrays.asList(nodes.roots()));
        linkedList.add(nodes.environment());
        return linkedList;
    }

    private ExplorerTab createTC(Node node) {
        MainTab mainTab = null;
        Places.Nodes nodes = TopManager.getDefault().getPlaces().nodes();
        mainTab = node.equals(NbProjectOperation.getProjectDesktop()) ? ProjectsTab.getDefault() : (node.equals(nodes.repository()) ? RepositoryTab.getDefaultRepositoryTab() : (node.equals(nodes.environment()) ? MainTab.getDefaultMainTab() : NbMainExplorer.findModuleTab(node.getClass().getName(), null)));
        mainTab.setRootContext(node);
        this.rootsToTCs().put(node, mainTab);
        return mainTab;
    }

    private Map rootsToTCs() {
        if (this.rootsToTCs == null) {
            this.rootsToTCs = new HashMap(7);
        }
        return this.rootsToTCs;
    }

    private List prevRoots() {
        if (this.prevRoots == null) {
            this.prevRoots = new LinkedList();
        }
        return this.prevRoots;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        int n2 = 0;
        while (n2 < n) {
            objectInput.readObject();
            ++n2;
        }
        objectInput.readObject();
        objectInput.readBoolean();
        objectInput.readBoolean();
        objectInput.readInt();
        objectInput.readInt();
    }

    public final ExplorerTab getRootPanel(Node node) {
        return (ExplorerTab)this.rootsToTCs().get(node);
    }

    public static NbMainExplorer getExplorer() {
        if (explorer == null) {
            explorer = new NbMainExplorer();
        }
        return explorer;
    }

    private static Mode explorerMode(Workspace workspace) {
        Mode mode = workspace.findMode("explorer");
        if (mode == null) {
            String string = NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("CTL_ExplorerTitle");
            mode = workspace.createMode("explorer", string, (class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer).getResource("/org/netbeans/core/resources/frames/explorer.gif"));
        }
        return mode;
    }

    public static void main(String[] stringArray) throws Exception {
        NbMainExplorer nbMainExplorer = new NbMainExplorer();
        nbMainExplorer.open();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class RootsListener
    implements PropertyChangeListener {
        private RootsListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("places".equals(propertyChangeEvent.getPropertyName())) {
                WindowManagerImpl.deferredPerformer().putRequest((DeferredPerformer.DeferredCommand)NbMainExplorer.getExplorer(), new DeferredPerformer.DeferredContext(null, true));
            }
        }
    }

    public static class SettingsTab
    extends ExplorerTab {
        static final long serialVersionUID = 9087127908986061114L;

        protected TreeView initGui() {
            BeanTreeView beanTreeView = new BeanTreeView();
            SplittedPanel splittedPanel = new SplittedPanel();
            PropertySheetView propertySheetView = new PropertySheetView();
            propertySheetView.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSN_ExplorerPropertySheetView"));
            propertySheetView.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSD_ExplorerPropertySheetView"));
            splittedPanel.add((Component)beanTreeView, SplittedPanel.ADD_LEFT);
            splittedPanel.add((Component)propertySheetView, SplittedPanel.ADD_RIGHT);
            this.setLayout(new BorderLayout());
            this.add((Component)splittedPanel, "Center");
            return beanTreeView;
        }

        protected void updateTitle() {
        }

        public HelpCtx getHelpCtx() {
            HelpCtx helpCtx = super.getHelpCtx();
            if (helpCtx == null || helpCtx.equals((Object)new HelpCtx(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = NbMainExplorer.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel))) {
                return this.getExplorerManager().getRootContext().getHelpCtx();
            }
            return helpCtx;
        }
    }

    public static class ModuleTab
    extends MainTab {
        static final long serialVersionUID = 8089827754534653731L;

        protected void validateRootContext() {
            Class<?> clazz = this.getExplorerManager().getRootContext().getClass();
            Node[] nodeArray = TopManager.getDefault().getPlaces().nodes().roots();
            int n = 0;
            while (n < nodeArray.length) {
                if (clazz.equals(nodeArray[n].getClass())) {
                    this.setRootContext(nodeArray[n]);
                    this.registerRootContext(nodeArray[n]);
                    break;
                }
                ++n;
            }
        }

        public Object readResolve() throws ObjectStreamException {
            Class<?> clazz = this.getExplorerManager().getRootContext().getClass();
            ModuleTab moduleTab = "org.openide.nodes.AbstractNode".equals(clazz.getName()) && "Javadoc".equals(this.getName()) ? NbMainExplorer.findModuleTab("org.netbeans.modules.javadoc.search.JavaDocNode", this) : NbMainExplorer.findModuleTab(clazz.getName(), this);
            moduleTab.scheduleValidation();
            return moduleTab;
        }
    }

    public static class ProjectsTab
    extends RepositoryTab {
        static final long serialVersionUID = -8178367548546385799L;
        private static ProjectsTab DEFAULT;

        private ProjectsTab() {
        }

        public static synchronized ProjectsTab getDefault() {
            if (DEFAULT == null) {
                DEFAULT = new ProjectsTab();
                DEFAULT.scheduleValidation();
            }
            return DEFAULT;
        }

        protected void validateRootContext() {
            Node node = NbProjectOperation.getProjectDesktop();
            this.setRootContext(node);
            this.registerRootContext(node);
        }

        public void doSelectNode(DataObject dataObject) {
            DataFolder dataFolder = (DataFolder)this.getRootContext().getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NbMainExplorer.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (this.selectNode(dataObject, dataFolder)) {
                this.requestFocus();
            }
        }

        public Object readResolve() throws ObjectStreamException {
            ProjectsTab.getDefault().scheduleValidation();
            return ProjectsTab.getDefault();
        }
    }

    public static class RepositoryTab
    extends MainTab
    implements OperationListener {
        static final long serialVersionUID = 4233454980309064344L;
        private RequestProcessor.Task previousTask;
        private static RepositoryTab DEFAULT;

        public RepositoryTab() {
            DataLoaderPool dataLoaderPool = TopManager.getDefault().getLoaderPool();
            dataLoaderPool.addOperationListener(WeakListener.operation((OperationListener)this, (Object)dataLoaderPool));
        }

        public static synchronized RepositoryTab getDefaultRepositoryTab() {
            if (DEFAULT == null) {
                DEFAULT = new RepositoryTab();
                DEFAULT.scheduleValidation();
            }
            return DEFAULT;
        }

        public static RepositoryTab createRepositoryTab() {
            return (RepositoryTab)NbMainExplorer.getExplorer().createTC(NbPlaces.getDefault().nodes().repository());
        }

        public Object readResolve() throws ObjectStreamException {
            if (DEFAULT == null) {
                DEFAULT = this;
            }
            RepositoryTab.getDefaultRepositoryTab().scheduleValidation();
            return RepositoryTab.getDefaultRepositoryTab();
        }

        public void operationPostCreate(OperationEvent operationEvent) {
        }

        public void operationCopy(OperationEvent.Copy copy) {
        }

        public void operationMove(OperationEvent.Move move) {
        }

        public void operationDelete(OperationEvent operationEvent) {
        }

        public void operationRename(OperationEvent.Rename rename) {
        }

        public void operationCreateShadow(OperationEvent.Copy copy) {
            this.postTask(copy.getObject());
        }

        public void operationCreateFromTemplate(OperationEvent.Copy copy) {
            this.postTask(copy.getObject());
        }

        private void postTask(DataObject dataObject) {
            RequestProcessor.Task task = this.previousTask;
            if (task != null) {
                task.cancel();
            }
            this.previousTask = RequestProcessor.postRequest((Runnable)new Runnable(this, dataObject){
                private final /* synthetic */ DataObject val$obj;
                private final /* synthetic */ RepositoryTab this$0;
                {
                    this.this$0 = repositoryTab;
                    this.val$obj = dataObject;
                }

                public void run() {
                    RepositoryTab.access$702(this.this$0, null);
                    if (!this.val$obj.isValid()) {
                        return;
                    }
                    this.this$0.doSelectNode(this.val$obj);
                }
            }, (int)100);
        }

        public void doSelectNode(DataObject dataObject) {
            this.selectNode(dataObject, null);
        }

        protected boolean selectNode(DataObject dataObject, DataFolder dataFolder) {
            Stack<DataObject> stack = new Stack<DataObject>();
            while (dataObject != null && dataObject != dataFolder) {
                stack.push(dataObject);
                dataObject = dataObject.getFolder();
            }
            if (dataObject != null) {
                stack.push(dataObject);
            }
            Node node = this.getExplorerManager().getRootContext();
            while (!stack.isEmpty()) {
                Node node2 = RepositoryTab.findDataObject(node, (DataObject)stack.pop());
                if (node2 == null) {
                    return false;
                }
                node = node2;
            }
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new InternalError();
            }
            return true;
        }

        private static Node findDataObject(Node node, DataObject dataObject) {
            Node node2 = node.getChildren().findChild(dataObject.getNodeDelegate().getName());
            if (node2 != null) {
                return node2;
            }
            Node[] nodeArray = node.getChildren().getNodes();
            int n = 0;
            while (n < nodeArray.length) {
                DataShadow dataShadow = (DataShadow)nodeArray[n].getCookie(class$org$openide$loaders$DataShadow == null ? NbMainExplorer.class$("org.openide.loaders.DataShadow") : class$org$openide$loaders$DataShadow);
                if (dataShadow != null && dataObject == dataShadow.getOriginal()) {
                    return nodeArray[n];
                }
                if (dataObject == nodeArray[n].getCookie(class$org$openide$loaders$DataFolder == null ? NbMainExplorer.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder)) {
                    return nodeArray[n];
                }
                if (dataObject == nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? NbMainExplorer.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) {
                    return nodeArray[n];
                }
                ++n;
            }
            return null;
        }

        static /* synthetic */ RequestProcessor.Task access$702(RepositoryTab repositoryTab, RequestProcessor.Task task) {
            repositoryTab.previousTask = task;
            return repositoryTab.previousTask;
        }
    }

    public static class MainTab
    extends ExplorerTab {
        static final long serialVersionUID = 4233454980309064344L;
        private static MainTab lastActivated;
        private static MainTab DEFAULT;

        public static synchronized MainTab getDefaultMainTab() {
            if (DEFAULT == null) {
                DEFAULT = new MainTab();
                DEFAULT.scheduleValidation();
            }
            return DEFAULT;
        }

        public static MainTab createEnvironmentTab() {
            return (MainTab)NbMainExplorer.getExplorer().createTC(NbPlaces.getDefault().nodes().environment());
        }

        public Object readResolve() throws ObjectStreamException {
            if (DEFAULT == null) {
                DEFAULT = this;
            }
            MainTab.getDefaultMainTab().scheduleValidation();
            return MainTab.getDefaultMainTab();
        }

        public void open(Workspace workspace) {
            Workspace workspace2 = workspace == null ? TopManager.getDefault().getWindowManager().getCurrentWorkspace() : workspace;
            Mode mode = workspace2.findMode((TopComponent)this);
            if (mode == null) {
                NbMainExplorer.explorerMode(workspace2).dockInto((TopComponent)this);
            }
            super.open(workspace);
        }

        protected void updateTitle() {
        }

        protected void componentActivated() {
            super.componentActivated();
            lastActivated = this;
        }

        protected void validateRootContext() {
            super.validateRootContext();
            this.registerRootContext(this.getExplorerManager().getRootContext());
        }

        protected void registerRootContext(Node node) {
            NbMainExplorer nbMainExplorer = NbMainExplorer.getExplorer();
            nbMainExplorer.prevRoots().add(node);
            nbMainExplorer.rootsToTCs().put(node, this);
        }
    }

    public static class ExplorerTab
    extends ExplorerPanel
    implements DeferredPerformer.DeferredCommand {
        static final long serialVersionUID = -8202452314155464024L;
        private TreeView view = this.initGui();
        private PropertyChangeListener weakRcL;
        private PropertyChangeListener weakIdeL;
        private NodeListener weakNRcL;
        private NodeListener rcListener;
        private boolean valid = true;

        public ExplorerTab() {
            IDESettings iDESettings = (IDESettings)IDESettings.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = NbMainExplorer.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            ExplorerPanel.setConfirmDelete((boolean)iDESettings.getConfirmDelete());
            this.weakIdeL = WeakListener.propertyChange((PropertyChangeListener)this.rcListener(), (Object)((Object)iDESettings));
            this.view.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSN_ExplorerBeanTree"));
            this.view.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NbMainExplorer == null ? (class$org$netbeans$core$NbMainExplorer = NbMainExplorer.class$("org.netbeans.core.NbMainExplorer")) : class$org$netbeans$core$NbMainExplorer)).getString("ACSD_ExplorerBeanTree"));
        }

        protected TreeView initGui() {
            BeanTreeView beanTreeView = new BeanTreeView();
            this.setLayout(new BorderLayout());
            this.add((Component)beanTreeView);
            return beanTreeView;
        }

        public void open(Workspace workspace) {
            this.performCommand(null);
            super.open(workspace);
        }

        public void setRootContext(Node node) {
            Node node2 = this.getExplorerManager().getRootContext();
            if (this.weakRcL != null) {
                node2.removePropertyChangeListener(this.weakRcL);
            }
            if (this.weakNRcL != null) {
                node2.removeNodeListener(this.weakNRcL);
            }
            this.getExplorerManager().setRootContext(node);
            this.initializeWithRootContext(node);
        }

        void adjustComponentPersistence() {
            Node.Handle handle = this.getExplorerManager().getRootContext().getHandle();
            if (handle == null) {
                this.putClientProperty("PersistenceType", "Never");
            } else {
                this.putClientProperty("PersistenceType", "OnlyOpened");
            }
        }

        public Node getRootContext() {
            return this.getExplorerManager().getRootContext();
        }

        public Object readResolve() throws ObjectStreamException {
            this.scheduleValidation();
            return this;
        }

        public void performCommand(DeferredPerformer.DeferredContext deferredContext) {
            if (!this.valid) {
                this.valid = true;
                this.validateRootContext();
            }
        }

        protected void validateRootContext() {
            this.initializeWithRootContext(this.getExplorerManager().getRootContext());
        }

        protected void updateTitle() {
            this.setName(this.getExplorerManager().getRootContext().getDisplayName());
        }

        private NodeListener rcListener() {
            if (this.rcListener == null) {
                this.rcListener = new RootContextListener();
            }
            return this.rcListener;
        }

        private void initializeWithRootContext(Node node) {
            this.setIcon(node.getIcon(1));
            this.setToolTipText(node.getShortDescription());
            this.setName(node.getDisplayName());
            this.updateTitle();
            if (this.weakRcL == null) {
                this.weakRcL = WeakListener.propertyChange((PropertyChangeListener)this.rcListener(), (Object)node);
            }
            node.addPropertyChangeListener(this.weakRcL);
            if (this.weakNRcL == null) {
                this.weakNRcL = WeakListener.node((NodeListener)this.rcListener(), (Object)node);
            }
            node.addNodeListener(this.weakNRcL);
        }

        protected final void scheduleValidation() {
            this.valid = false;
            WindowManagerImpl.deferredPerformer().putRequest((DeferredPerformer.DeferredCommand)this, null);
        }

        public void setName(String string) {
            super.setName(string);
            if (this.view != null) {
                this.view.getAccessibleContext().setAccessibleName(string);
            }
        }

        public void setToolTipText(String string) {
            super.setToolTipText(string);
            if (this.view != null) {
                this.view.getAccessibleContext().setAccessibleDescription(string);
            }
        }

        private final class RootContextListener
        implements NodeListener {
            private RootContextListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getSource();
                if (object instanceof IDESettings) {
                    ExplorerPanel.setConfirmDelete((boolean)((IDESettings)((Object)object)).getConfirmDelete());
                    return;
                }
                Node node = (Node)object;
                if ("displayName".equals(string) || "name".equals(string)) {
                    ExplorerTab.this.setName(node.getDisplayName());
                } else if ("icon".equals(string)) {
                    ExplorerTab.this.setIcon(node.getIcon(1));
                } else if ("shortDescription".equals(string)) {
                    ExplorerTab.this.setToolTipText(node.getShortDescription());
                }
            }

            public void nodeDestroyed(NodeEvent nodeEvent) {
                ExplorerTab.this.setCloseOperation(0);
                ExplorerTab.this.close();
            }

            public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            }

            public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            }

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            }
        }
    }
}

