/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.core.Packages;
import org.netbeans.core.RootFolderNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

final class PackageChildren
extends Children.Keys
implements PropertyChangeListener {
    private static final DataFilter DATA_FILTER = new NoFolderFilter();
    private DataFilter dataFilter;
    private Packages packages;
    private PropertyChangeListener weakPCL;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public static Node createNode(DataFilter dataFilter) {
        return new AbstractNode((Children)new PackageChildren(dataFilter));
    }

    private PackageChildren(DataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    protected void addNotify() {
        this.packages = Packages.getDefault();
        this.weakPCL = WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.packages);
        this.packages.addPropertyChangeListener(this.weakPCL);
        this.packages.update(this);
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.packages.removePropertyChangeListener(this.weakPCL);
        this.packages = null;
        this.weakPCL = null;
    }

    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        if ("list".equals(propertyChangeEvent.getPropertyName())) {
            Packages packages = this.packages;
            if (packages != null) {
                packages.update(this);
            }
            return;
        }
        if ("name".equals(propertyChangeEvent.getPropertyName()) && this.isInitialized()) {
            Children.MUTEX.readAccess(new Runnable(){

                public void run() {
                    FileObject fileObject = (FileObject)propertyChangeEvent.getNewValue();
                    Node[] nodeArray = PackageChildren.this.getNodes();
                    int n = 0;
                    while (n < nodeArray.length) {
                        DataFolder dataFolder = (DataFolder)nodeArray[n].getCookie(class$org$openide$loaders$DataFolder == null ? PackageChildren.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                        if (dataFolder != null && PackageChildren.subfolder(fileObject, dataFolder.getPrimaryFile())) {
                            nodeArray[n].setDisplayName(dataFolder.getPrimaryFile().getPackageName('.'));
                        }
                        ++n;
                    }
                }
            });
        }
    }

    private static boolean subfolder(FileObject fileObject, FileObject fileObject2) {
        while (fileObject2 != null) {
            if (fileObject2.equals(fileObject)) {
                return true;
            }
            fileObject2 = fileObject2.getParent();
        }
        return false;
    }

    public void updatePackages(TreeSet treeSet) {
        if (this.dataFilter == DataFilter.ALL) {
            this.setKeys(treeSet);
        } else {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(treeSet.size());
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (!this.dataFilter.acceptDataObject(dataObject)) continue;
                    arrayList.add(fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            this.setKeys(arrayList);
        }
    }

    protected Node[] createNodes(Object object) {
        FileObject fileObject = (FileObject)object;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject instanceof DataFolder) {
                RootFolderNode rootFolderNode;
                DataFilter dataFilter;
                DataFolder dataFolder = (DataFolder)dataObject;
                DataFilter dataFilter2 = dataFilter = this.dataFilter == DataFilter.ALL ? DATA_FILTER : this.dataFilter;
                if (fileObject.isRoot()) {
                    rootFolderNode = new RootFolderNode(dataFolder, dataFolder.createNodeChildren(dataFilter));
                } else {
                    DataFolder dataFolder2 = dataFolder;
                    dataFolder2.getClass();
                    DataFolder.FolderNode folderNode = new DataFolder.FolderNode(dataFolder2, dataFolder.createNodeChildren(dataFilter));
                    folderNode.setDisplayName(dataFolder.getPrimaryFile().getPackageName('.'));
                    rootFolderNode = folderNode;
                }
                return new Node[]{rootFolderNode};
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return new Node[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class NoFolderFilter
    implements DataFilter {
        private NoFolderFilter() {
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return !(dataObject instanceof DataFolder);
        }
    }
}

