/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Keymap;
import org.netbeans.core.ActionsPanel;
import org.netbeans.core.ShortcutsEditor;
import org.netbeans.core.ShortcutsFolder;
import org.openide.DialogDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;

public class ShortcutsPanel
extends JPanel {
    private Keymap map;
    private Vector strokes;
    private ShortcutsEditor shortcutsEditor;
    private ActionsPanel addActionsPanel;
    private ActionsPanel editActionsPanel;
    private JScrollPane shortcutsScrollPane;
    private JButton addButton;
    private JTextArea shortcutTextArea;
    private JPanel buttonsPanel;
    private JList shortcutsList;
    private JButton removeButton;
    static /* synthetic */ Class class$org$netbeans$core$ShortcutsPanel;

    public ShortcutsPanel(ShortcutsEditor shortcutsEditor) {
        this.shortcutsEditor = shortcutsEditor;
        this.updateData();
        this.initComponents();
        this.initAccessibility();
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ShortcutsPanel == null ? (class$org$netbeans$core$ShortcutsPanel = ShortcutsPanel.class$("org.netbeans.core.ShortcutsPanel")) : class$org$netbeans$core$ShortcutsPanel));
        this.addButton.setMnemonic(resourceBundle.getString("ActionsPanel.shortcutAddButton.text_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(resourceBundle.getString("ActionsPanel.shortcutRemoveButton.text_Mnemonic").charAt(0));
        this.buttonsPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), resourceBundle.getString("ActionsPanel.ShortcutsTitle")), new EmptyBorder(new Insets(12, 12, 11, 11))));
        this.shortcutsList.setCellRenderer(new KeyStrokeRenderer());
        this.shortcutsList.setSelectedIndices(new int[0]);
        this.updateButtons();
    }

    private void initComponents() {
        this.shortcutsScrollPane = new JScrollPane();
        this.shortcutsList = new JList(this.strokes);
        this.buttonsPanel = new JPanel();
        this.shortcutTextArea = new JTextArea();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.shortcutsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ShortcutsPanel.this.shortcutsListValueChanged(listSelectionEvent);
            }
        });
        this.shortcutsScrollPane.setViewportView(this.shortcutsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.shortcutsScrollPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.shortcutTextArea.setWrapStyleWord(true);
        this.shortcutTextArea.setToolTipText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ACS_ShortcutsPanel.shortcutTextArea.text.a11yName"));
        this.shortcutTextArea.setLineWrap(true);
        this.shortcutTextArea.setEditable(false);
        this.shortcutTextArea.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsPanel.shortcutTextArea.text"));
        this.shortcutTextArea.setBackground(this.buttonsPanel.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.buttonsPanel.add((Component)this.shortcutTextArea, gridBagConstraints);
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutsPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/core/Bundle").getString("ShortcutsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutsPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        if (this.addActionsPanel == null) {
            this.addActionsPanel = new ActionsPanel(true, this.shortcutsEditor);
            this.addActionsPanel.setBorder(new EmptyBorder(12, 12, 0, 11));
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addActionsPanel, NbBundle.getBundle((Class)(class$org$netbeans$core$ShortcutsPanel == null ? (class$org$netbeans$core$ShortcutsPanel = ShortcutsPanel.class$("org.netbeans.core.ShortcutsPanel")) : class$org$netbeans$core$ShortcutsPanel)).getString("ShortcutsPanel.AddActionTitle"));
        Dialog dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.updateData();
            this.shortcutsList.setListData(this.strokes);
            this.shortcutsEditor.setModified(true);
        }
    }

    private void shortcutsListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.shortcutsList.getSelectedIndices();
        Object[] objectArray = this.shortcutsList.getSelectedValues();
        int n = 0;
        while (n < objectArray.length) {
            this.map.removeKeyStrokeBinding((KeyStroke)objectArray[n]);
            this.strokes.remove(objectArray[n]);
            ++n;
        }
        if (nArray.length == 1) {
            this.shortcutsList.setSelectedIndex(nArray[0]);
        } else {
            this.shortcutsList.setSelectedIndices(new int[0]);
        }
        this.shortcutsList.revalidate();
        this.shortcutsList.repaint();
        this.shortcutsEditor.setModified(true);
    }

    private void updateData() {
        this.map = TopManager.getDefault().getGlobalKeymap();
        KeyStroke[] keyStrokeArray = this.map.getBoundKeyStrokes();
        this.strokes = new Vector();
        int n = 0;
        while (n < keyStrokeArray.length) {
            this.strokes.addElement(keyStrokeArray[n]);
            ++n;
        }
        Collections.sort(this.strokes, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2;
                int n3 = ((KeyStroke)object).getKeyCode();
                if (n3 < (n2 = ((KeyStroke)object2).getKeyCode())) {
                    return -1;
                }
                if (n3 > n2) {
                    return 1;
                }
                int n4 = ((KeyStroke)object).getModifiers();
                if (n4 < (n = ((KeyStroke)object2).getModifiers())) {
                    return -1;
                }
                if (n4 > n) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void updateButtons() {
        this.removeButton.setEnabled(this.shortcutsList.getSelectedIndices().length > 0);
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$ShortcutsPanel == null ? (class$org$netbeans$core$ShortcutsPanel = ShortcutsPanel.class$("org.netbeans.core.ShortcutsPanel")) : class$org$netbeans$core$ShortcutsPanel));
        this.shortcutsList.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ShortcutsPanel.shortcutsList"));
        this.shortcutsList.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ShortcutsPanel.shortcutsList"));
        this.shortcutTextArea.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_ShortcutsPanel.shortcutTextArea.text.a11yName"));
        this.addButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ShortcutsPanel.addButton.text.a11yDesc"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ShortcutsPanel.removeButton.text.a11yDesc"));
    }

    protected void setFocusDefault() {
        this.shortcutsList.requestFocus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class KeyStrokeRenderer
    extends DefaultListCellRenderer {
        KeyStrokeRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText(" " + ShortcutsFolder.getKeyStrokeName((KeyStroke)object));
            return this;
        }
    }
}

