/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.netbeans.core.ui.ProductInformationPanel;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Splash
implements SwingConstants {
    static Reference splashRef;
    static Reference aboutRef;
    static /* synthetic */ Class class$org$netbeans$core$Splash;

    private static String getMainWindowTitle() {
        String string = System.getProperty("netbeans.buildnumber");
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.windows.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("CTL_MainWindow_Title"), string);
    }

    public static void showSplashDialog() {
        SplashDialog splashDialog = new SplashDialog();
        splashDialog.print(Splash.getMainWindowTitle());
        splashDialog.show();
    }

    public static SplashOutput showSplash() {
        Window window = Splash.createW();
        window.show();
        window.toFront();
        return (SplashOutput)((Object)window);
    }

    public static void hideSplash(SplashOutput splashOutput) {
        final Window window = (Window)((Object)splashOutput);
        ((SplashOutputInternal)((Object)splashOutput)).hideRequested();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                window.setVisible(false);
                window.dispose();
            }
        });
    }

    public static boolean isVisible(SplashOutput splashOutput) {
        return !((SplashOutputInternal)((Object)splashOutput)).isHideRequested();
    }

    private static Window createW() {
        boolean bl = false;
        if (Utilities.isWindows() || Utilities.getOperatingSystem() == 8 || Utilities.getOperatingSystem() == 1024) {
            bl = true;
        }
        if (Utilities.getOperatingSystem() == 16) {
            if (System.getProperty("env-kde_display") == null && System.getProperty("env-kdedir") == null) {
                bl = true;
            } else if (!System.getProperty("java.vm.vendor", "").startsWith("Sun")) {
                bl = true;
            } else if (!System.getProperty("java.vm.version", "").startsWith("1.3")) {
                bl = true;
            }
        }
        return bl ? new SplashWindow() : new SplashFrame();
    }

    public static final void center(Window window) {
        window.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        window.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    static Image getSplash() {
        Image image;
        if (splashRef == null || (image = (Image)splashRef.get()) == null) {
            image = Splash.loadSplash();
            splashRef = new WeakReference<Image>(image);
        }
        return image;
    }

    static Image getAbout() {
        Image image;
        if (aboutRef == null || (image = (Image)aboutRef.get()) == null) {
            image = Splash.loadAbout();
            aboutRef = new WeakReference<Image>(image);
        }
        return image;
    }

    private static Image loadSplash() {
        URL uRL = NbBundle.getLocalizedFile((String)"org.netbeans.core.resources.splash", (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    private static Image loadAbout() {
        try {
            URL uRL = NbBundle.getLocalizedFile((String)"org.netbeans.core.resources.about", (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }
        catch (MissingResourceException missingResourceException) {
            return Splash.loadSplash();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SplashDialog
    extends JDialog
    implements SplashOutput,
    SplashOutputInternal,
    ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new AboutComponent();
        private ProductInformationPanel infoPanel;
        private boolean hideRequested = false;

        public SplashDialog() {
            super(TopManager.getDefault().getWindowManager().getMainWindow(), true);
            JPanel jPanel = new JPanel();
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("CTL_About_Title"));
            jPanel.add((Component)this.splashComponent, "Center");
            jTabbedPane.addTab(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("CTL_About_Title"), jPanel);
            ProductInformationPanel productInformationPanel = new ProductInformationPanel();
            jTabbedPane.addTab(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("CTL_About_Detail"), productInformationPanel);
            this.getContentPane().add((Component)jTabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            jTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSN_AboutTabs"));
            jTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash)).getString("ACSD_AboutDialog"));
            Splash.center(this);
        }

        public void print(String string) {
            this.splashComponent.setText(string);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            this.dispose();
        }
    }

    static class SplashFrame
    extends JFrame
    implements SplashOutput,
    SplashOutputInternal {
        static final long serialVersionUID = 3200319077899134000L;
        private final SplashComponent splashComponent = new SplashComponent();
        private boolean hideRequested = false;

        public SplashFrame() {
            super(Splash.getMainWindowTitle());
            this.setDefaultCloseOperation(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getContentPane().add(this.splashComponent);
            Splash.center(this);
        }

        public void print(String string) {
            this.splashComponent.setText(string);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }
    }

    static class SplashWindow
    extends Window
    implements SplashOutput,
    SplashOutputInternal {
        static final long serialVersionUID = 4838519880359397841L;
        private final SplashComponent splashComponent = new SplashComponent();
        private boolean hideRequested = false;

        public SplashWindow() {
            super(new Frame());
            this.setLayout(new BorderLayout());
            this.add((Component)this.splashComponent, "Center");
            Splash.center(this);
        }

        public Dimension getPreferredSize() {
            int n = 520;
            int n2 = 316;
            try {
                n = Integer.parseInt(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("SPLASH_WIDTH"));
                n2 = Integer.parseInt(NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader()).getString("SPLASH_HEIGHT"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Dimension(n, n2);
        }

        public void print(String string) {
            this.splashComponent.setText(string);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }
    }

    static class AboutComponent
    extends SplashComponent {
        public AboutComponent() {
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            SplashComponent.image = new ImageIcon(Splash.getAbout()).getImage();
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("AboutTextBounds"), " ,");
                SplashComponent.view = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                Integer n = Integer.decode(resourceBundle.getString("AboutTextColor"));
                SplashComponent.color_text = new Color(n);
            }
            catch (Throwable throwable) {
                SplashComponent.view = new Rectangle(78, 60, 362, 20);
                SplashComponent.color_text = Color.white;
            }
        }
    }

    static class SplashComponent
    extends JComponent
    implements Accessible {
        private static final long serialVersionUID = -1162806313274828742L;
        private FontMetrics fm;
        static Rectangle view;
        static Color color_text;
        static Image image;
        private Rectangle dirty = new Rectangle();
        private String text;
        private Rectangle rect = new Rectangle();

        public SplashComponent() {
            Object object;
            image = new ImageIcon(Splash.getSplash()).getImage();
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.core.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$Splash == null ? (class$org$netbeans$core$Splash = Splash.class$("org.netbeans.core.Splash")) : class$org$netbeans$core$Splash).getClassLoader());
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashRunningTextBounds"), " ,");
            view = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            Integer n = Integer.decode(resourceBundle.getString("SplashRunningTextColor"));
            color_text = new Color(n);
            int n2 = 12;
            try {
                object = resourceBundle.getString("SplashRunningTextFontSize");
                n2 = Integer.parseInt((String)object);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            object = new Font("Dialog", 0, n2);
            this.setFont((Font)object);
            this.fm = this.getFontMetrics((Font)object);
        }

        public void setText(String string) {
            this.text = string;
            if (string == null) {
                this.repaint(this.dirty);
                return;
            }
            if (this.fm == null) {
                return;
            }
            this.adjustText(string);
            SwingUtilities.layoutCompoundLabel(this.fm, string, null, 3, 2, 3, 2, view, new Rectangle(), this.rect, 0);
            this.dirty = this.dirty.union(this.rect);
            this.repaint(this.dirty);
            this.dirty = new Rectangle(this.rect);
        }

        private void adjustText(String string) {
            String string2 = null;
            if (string == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            int n = this.fm.stringWidth(string);
            if (n > SplashComponent.view.width) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    String string4 = string2 == null ? string3 : string2 + " " + string3;
                    if (this.fm.stringWidth(string4 + "...") > SplashComponent.view.width) {
                        this.text = string2 + "...";
                        break;
                    }
                    string2 = string4;
                }
            } else {
                this.text = string;
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(color_text);
            graphics.drawImage(image, 0, 0, null);
            if (this.text == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, view, new Rectangle(), this.rect, 0);
            graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
        }

        public Dimension getPreferredSize() {
            return new Dimension(image.getWidth(null), image.getHeight(null));
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private static interface SplashOutputInternal {
        public void hideRequested();

        public boolean isHideRequested();
    }

    public static interface SplashOutput {
        public void print(String var1);
    }
}

