/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.execution;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.execution.DefaultSysProcess;
import org.netbeans.core.execution.ExecutionEvent;
import org.netbeans.core.execution.ExecutionListener;
import org.netbeans.core.execution.ExecutorTaskImpl;
import org.netbeans.core.execution.IOPermissionCollection;
import org.netbeans.core.execution.IOTable;
import org.netbeans.core.execution.OutputStreamWriter;
import org.netbeans.core.execution.ProcessNode;
import org.netbeans.core.execution.RunClassThread;
import org.netbeans.core.execution.SysIn;
import org.netbeans.core.execution.TaskIO;
import org.netbeans.core.execution.TaskThreadGroup;
import org.netbeans.core.execution.WindowTable;
import org.netbeans.core.execution.WriterPrintStream;
import org.openide.TopManager;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class ExecutionEngine
extends org.openide.execution.ExecutionEngine {
    public static final ThreadGroup base = new ThreadGroup("base");
    private int number = 1;
    public static final TaskIO systemIO = new TaskIO();
    private static IOTable taskIOs;
    private static WindowTable wtable;
    private boolean execNodeInited = false;
    private HashSet executionListeners = new HashSet();
    private static ExecutionEngine engineRef;
    private ArrayList runningTasks = new ArrayList(5);
    static final long serialVersionUID = 9072488605180080803L;

    public ExecutionEngine() {
        System.setIn(new SysIn());
        System.setOut(ExecutionEngine.createPrintStream(true));
        System.setErr(ExecutionEngine.createPrintStream(false));
    }

    public static ExecutionEngine getExecutionEngine() {
        return engineRef;
    }

    public Collection getRunningTasks() {
        return this.runningTasks;
    }

    public String getRunningTaskName(ExecutorTask executorTask) {
        if (!this.runningTasks.contains(executorTask) || !(executorTask instanceof DefaultSysProcess)) {
            return null;
        }
        return ((DefaultSysProcess)executorTask).getName();
    }

    private void initExecNode() {
        ProcessNode.getExecutionNode();
        this.execNodeInited = true;
        try {
            if (Utilities.isUnix()) {
                Class<?> clazz = Class.forName("java.lang.UNIXProcess");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            TopManager.getDefault().getErrorManager().notify(4096, (Throwable)classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(String string, Runnable runnable, InputOutput inputOutput) {
        if (!this.execNodeInited) {
            this.initExecNode();
        }
        TaskThreadGroup taskThreadGroup = new TaskThreadGroup(base, "exec_" + string + "_" + this.number);
        taskThreadGroup.setDaemon(true);
        ExecutorTaskImpl executorTaskImpl = new ExecutorTaskImpl();
        Object object = executorTaskImpl.lock;
        synchronized (object) {
            try {
                int n = this.number++;
                new RunClassThread(taskThreadGroup, string, n, inputOutput, this, executorTaskImpl, runnable);
                executorTaskImpl.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException.getMessage());
            }
        }
        return executorTaskImpl;
    }

    protected NbClassPath createLibraryPath() {
        List list = NbTopManager.get().getModuleSystem().getModuleJars();
        return new NbClassPath(list.toArray(new File[list.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExecutionListener(ExecutionListener executionListener) {
        HashSet hashSet = this.executionListeners;
        synchronized (hashSet) {
            this.executionListeners.add(executionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExecutionListener(ExecutionListener executionListener) {
        HashSet hashSet = this.executionListeners;
        synchronized (hashSet) {
            this.executionListeners.remove(executionListener);
        }
    }

    protected final PermissionCollection createPermissions(CodeSource codeSource, InputOutput inputOutput) {
        PermissionCollection permissionCollection = Policy.getPolicy().getPermissions(codeSource);
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        return new IOPermissionCollection(inputOutput, permissionCollection, threadGroup instanceof TaskThreadGroup ? (TaskThreadGroup)threadGroup : null);
    }

    protected final void fireExecutionStarted(ExecutionEvent executionEvent) {
        this.runningTasks.add(executionEvent.getProcess());
        Iterator iterator = ((HashSet)this.executionListeners.clone()).iterator();
        while (iterator.hasNext()) {
            ExecutionListener executionListener = (ExecutionListener)iterator.next();
            executionListener.startedExecution(executionEvent);
        }
    }

    protected final void fireExecutionFinished(ExecutionEvent executionEvent) {
        this.runningTasks.remove((Object)executionEvent.getProcess());
        Iterator iterator = ((HashSet)this.executionListeners.clone()).iterator();
        while (iterator.hasNext()) {
            ExecutionListener executionListener = (ExecutionListener)iterator.next();
            executionListener.finishedExecution(executionEvent);
        }
    }

    static void putWindow(Window window, TaskThreadGroup taskThreadGroup) {
        wtable.putTaskWindow(window, taskThreadGroup);
    }

    static void closeGroup(ThreadGroup threadGroup) {
        wtable.closeGroup(threadGroup);
    }

    static boolean hasWindows(ThreadGroup threadGroup) {
        return wtable.hasWindows(threadGroup);
    }

    static IOTable getTaskIOs() {
        if (taskIOs == null) {
            taskIOs = new IOTable(base, systemIO);
        }
        return taskIOs;
    }

    public static ThreadGroup findGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = null;
        while (threadGroup != null && threadGroup != base) {
            threadGroup2 = threadGroup;
            threadGroup = threadGroup.getParent();
        }
        return threadGroup == null ? null : threadGroup2;
    }

    static PrintStream createPrintStream(boolean bl) {
        return new WriterPrintStream(new SysOut(bl), bl);
    }

    static {
        wtable = new WindowTable();
        ExecutionEngine.systemIO.out = new OutputStreamWriter(System.out);
        ExecutionEngine.systemIO.err = new OutputStreamWriter(System.err);
        ExecutionEngine.systemIO.in = new InputStreamReader(System.in);
        engineRef = new ExecutionEngine();
    }

    static class SysOut
    extends OutputStream {
        boolean std;

        SysOut(boolean bl) {
            this.std = bl;
        }

        public void write(int n) throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().write(n);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(n);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            char[] cArray = new char[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                cArray[n3] = (char)byArray[n + n3];
            }
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().write(cArray, 0, n2);
            } else {
                ExecutionEngine.getTaskIOs().getErr().write(cArray, 0, n2);
            }
        }

        public void flush() throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().flush();
            } else {
                ExecutionEngine.getTaskIOs().getErr().flush();
            }
        }

        public void close() throws IOException {
            if (this.std) {
                ExecutionEngine.getTaskIOs().getOut().close();
            } else {
                ExecutionEngine.getTaskIOs().getErr().close();
            }
        }
    }
}

