/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.filesystems;

import java.io.IOException;
import java.io.InputStream;
import org.netbeans.core.filesystems.DefaultParser;
import org.netbeans.core.filesystems.MIMEComponent;
import org.netbeans.core.filesystems.Util;
import org.netbeans.core.filesystems.XMLEnvironmentProvider;
import org.netbeans.core.filesystems.XMLMIMEComponent;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MIMEResolverImpl
extends XMLEnvironmentProvider
implements Environment.Provider {
    private static final long serialVersionUID = 18975L;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    protected InstanceContent createInstanceContent(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)new Impl(fileObject));
        return instanceContent;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Type {
        private String[] exts;
        private String[] mimes;
        private String[] fatts;
        private String[] vals;
        private byte[] magic;
        private byte[] mask;

        private Type() {
        }

        public String toString() {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fast-check(");
            if (this.exts != null) {
                stringBuffer.append("exts:");
                n = 0;
                while (n < this.exts.length) {
                    stringBuffer.append(this.exts[n] + ", ");
                    ++n;
                }
            }
            if (this.mimes != null) {
                stringBuffer.append("mimes:");
                n = 0;
                while (n < this.mimes.length) {
                    stringBuffer.append(this.mimes[n] + ", ");
                    ++n;
                }
            }
            if (this.fatts != null) {
                stringBuffer.append("file-attributes:");
                n = 0;
                while (n < this.fatts.length) {
                    stringBuffer.append(this.fatts[n] + "='" + this.vals[n] + "', ");
                    ++n;
                }
            }
            if (this.magic != null) {
                stringBuffer.append("magic:" + XMLUtil.toHex((byte[])this.magic, (int)0, (int)this.magic.length));
            }
            if (this.mask != null) {
                stringBuffer.append("mask:" + XMLUtil.toHex((byte[])this.mask, (int)0, (int)this.mask.length));
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        private void addExt(String string) {
            this.exts = Util.addString(this.exts, string);
        }

        private void addMIME(String string) {
            this.mimes = Util.addString(this.mimes, string.toLowerCase());
        }

        private void addAttr(String string, String string2) {
            this.fatts = Util.addString(this.fatts, string);
            this.vals = Util.addString(this.vals, string2);
        }

        private boolean setMagic(byte[] byArray, byte[] byArray2) {
            if (byArray == null) {
                return true;
            }
            if (byArray2 != null && byArray.length != byArray2.length) {
                return false;
            }
            this.magic = byArray;
            if (byArray2 != null) {
                this.mask = byArray2;
                int n = 0;
                while (n < byArray2.length) {
                    int n2 = n;
                    this.magic[n2] = (byte)(this.magic[n2] & byArray2[n]);
                    ++n;
                }
            }
            return true;
        }

        private boolean accept(FileObject fileObject) throws IOException {
            int n;
            Object object;
            int n2;
            if (this.exts != null && fileObject.getExt() != null && Util.contains(this.exts, fileObject.getExt())) {
                return true;
            }
            if (this.mimes != null) {
                n2 = this.mimes.length - 1;
                while (n2 >= 0) {
                    object = FileUtil.getMIMEType((String)fileObject.getExt());
                    if (object != null) {
                        n = ((String)object).indexOf(59);
                        if (n2 >= 0) {
                            object = ((String)object).substring(0, n - 1);
                        }
                        if (((String)(object = ((String)object).toLowerCase())).equals(this.mimes[n2])) {
                            return true;
                        }
                        if (this.mimes[n2].startsWith("+") && ((String)object).endsWith(this.mimes[n2])) {
                            return true;
                        }
                    }
                    --n2;
                }
            }
            if (this.magic != null) {
                byte[] byArray = new byte[this.magic.length];
                object = fileObject.getInputStream();
                n = 0;
                int n3 = 0;
                while (n3 < this.magic.length) {
                    try {
                        int n4 = ((InputStream)object).read(byArray, n3, this.magic.length - n3);
                        if (n4 < 0) {
                            n = 1;
                        }
                        n3 += n4;
                    }
                    catch (IOException iOException) {
                        n = 1;
                        break;
                    }
                    if (n != 0) break;
                }
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n == 0) {
                    boolean bl = false;
                    int n5 = 0;
                    while (n5 < this.magic.length) {
                        if (this.mask != null) {
                            int n6 = n5;
                            byArray[n6] = (byte)(byArray[n6] & this.mask[n5]);
                        }
                        if (this.magic[n5] != byArray[n5]) {
                            bl = true;
                            break;
                        }
                        ++n5;
                    }
                    if (!bl) {
                        return true;
                    }
                }
            }
            if (this.fatts != null) {
                n2 = this.fatts.length - 1;
                while (n2 >= 0) {
                    object = fileObject.getAttribute(this.fatts[n2]);
                    if (object != null) {
                        if (this.vals[n2] == null) {
                            return true;
                        }
                        if (this.vals[n2].equals(object.toString())) {
                            return true;
                        }
                    }
                    --n2;
                }
            }
            return false;
        }
    }

    private static class FileElement {
        private Type fileCheck = new Type();
        private String mime = null;
        private MIMEComponent rule = null;

        private FileElement() {
        }

        private void setMIME(String string) {
            if ("null".equals(string)) {
                return;
            }
            this.mime = string;
        }

        private String resolve(FileObject fileObject) {
            try {
                if (this.fileCheck.accept(fileObject)) {
                    if (this.mime == null) {
                        return null;
                    }
                    if (this.rule == null) {
                        return this.mime;
                    }
                    if (this.rule.acceptFileObject(fileObject)) {
                        return this.mime;
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = MIMEResolverImpl.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                errorManager.notify(1, (Throwable)iOException);
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("FileElement(");
            stringBuffer.append(this.fileCheck + " ");
            stringBuffer.append(this.rule + " ");
            stringBuffer.append("Result:" + this.mime);
            return stringBuffer.toString();
        }
    }

    private static class DescParser
    extends DefaultParser {
        private FileElement[] template = null;
        private short file_state = 0;
        private MIMEComponent component = null;
        private String componentDelimiter = null;
        private static final short IN_ROOT = 1;
        private static final short IN_FILE = 2;
        private static final short IN_RESOLVER = 3;
        private static final short IN_COMPONENT = 4;
        private static final short IN_EXIT = 1;
        private static final String ROOT = "MIME-resolver";
        private static final String FILE = "file";
        private static final String MIME = "mime";
        private static final String EXT = "ext";
        private static final String RESOLVER = "resolver";
        private static final String FATTR = "fattr";
        private static final String NAME = "name";
        private static final String MAGIC = "magic";
        private static final String HEX = "hex";
        private static final String MASK = "mask";
        private static final String VALUE = "text";
        private static final String EXIT = "exit";
        private static final String XML_RULE_COMPONENT = "xml-rule";

        DescParser(FileObject fileObject) {
            super(fileObject);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!ROOT.equals(string3)) {
                        this.error();
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!FILE.equals(string3)) {
                        this.error();
                    }
                    if (this.template == null) {
                        this.template = new FileElement[]{new FileElement()};
                    } else {
                        FileElement[] fileElementArray = new FileElement[this.template.length + 1];
                        System.arraycopy(this.template, 0, fileElementArray, 1, this.template.length);
                        fileElementArray[0] = new FileElement();
                        this.template = fileElementArray;
                    }
                    this.state = (short)2;
                    break;
                }
                case 2: {
                    if (this.file_state == 1) {
                        this.error();
                    }
                    if (EXT.equals(string3)) {
                        String string4 = attributes.getValue(NAME);
                        if (string4 == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addExt(string4);
                        break;
                    }
                    if (MAGIC.equals(string3)) {
                        String string5 = attributes.getValue(HEX);
                        if (string5 == null) {
                            this.error();
                        }
                        String string6 = attributes.getValue(MASK);
                        char[] cArray = string5.toCharArray();
                        byte[] byArray = null;
                        try {
                            Object[] objectArray;
                            if (string6 != null) {
                                objectArray = string6.toCharArray();
                                byArray = XMLUtil.fromHex((char[])objectArray, (int)0, (int)objectArray.length);
                            }
                            objectArray = XMLUtil.fromHex((char[])cArray, (int)0, (int)cArray.length);
                            if (this.template[0].fileCheck.setMagic((byte[])objectArray, byArray)) break;
                            this.error();
                        }
                        catch (IOException iOException) {
                            this.error();
                        }
                        break;
                    }
                    if (MIME.equals(string3)) {
                        String string7 = attributes.getValue(NAME);
                        if (string7 == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addMIME(string7);
                        break;
                    }
                    if (FATTR.equals(string3)) {
                        String string8 = attributes.getValue(NAME);
                        if (string8 == null) {
                            this.error();
                        }
                        String string9 = attributes.getValue(VALUE);
                        this.template[0].fileCheck.addAttr(string8, string9);
                        break;
                    }
                    if (RESOLVER.equals(string3)) {
                        String string10;
                        if (this.template[0].fileCheck.exts == null && this.template[0].fileCheck.mimes == null && this.template[0].fileCheck.fatts == null && this.template[0].fileCheck.magic == null) {
                            this.error();
                        }
                        if ((string10 = attributes.getValue(MIME)) == null) {
                            this.error();
                        }
                        this.template[0].setMIME(string10);
                        this.state = (short)3;
                        break;
                    }
                    if (EXIT.equals(string3)) {
                        this.file_state = 1;
                        break;
                    }
                    this.error();
                    break;
                }
                case 3: {
                    if (!XML_RULE_COMPONENT.equals(string3)) break;
                    this.enterComponent(XML_RULE_COMPONENT, new XMLMIMEComponent());
                    this.component.startElement(string, string2, string3, attributes);
                    break;
                }
                case 4: {
                    this.component.startElement(string, string2, string3, attributes);
                    break;
                }
            }
        }

        private void enterComponent(String string, MIMEComponent mIMEComponent) {
            this.component = mIMEComponent;
            this.componentDelimiter = string;
            mIMEComponent.setDocumentLocator(this.getLocator());
            this.template[0].rule = mIMEComponent;
            this.state = (short)4;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (this.state) {
                case 2: {
                    if (!FILE.equals(string3)) break;
                    this.state = 1;
                    this.file_state = 0;
                    break;
                }
                case 3: {
                    if (!RESOLVER.equals(string3)) break;
                    this.state = (short)2;
                    break;
                }
                case 4: {
                    this.component.endElement(string, string2, string3);
                    if (!this.componentDelimiter.equals(string3)) break;
                    this.state = (short)3;
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.state == 4) {
                this.component.characters(cArray, n, n2);
            }
        }
    }

    static class Impl
    extends MIMEResolver
    implements InstanceCookie {
        private final FileObject data;
        private FileElement[] smell = null;
        private short state = 0;

        Impl(FileObject fileObject) {
            this.data = fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String findMIMEType(FileObject fileObject) {
            Impl impl = this;
            synchronized (impl) {
                if (this.state == 0) {
                    this.state = this.parseDesc();
                }
                if (this.state == -1) {
                    return null;
                }
            }
            int n = this.smell.length - 1;
            while (n >= 0) {
                String string = this.smell[n].resolve(fileObject);
                if (string != null) {
                    return string;
                }
                --n;
            }
            return null;
        }

        private short parseDesc() {
            this.smell = new FileElement[0];
            DescParser descParser = new DescParser(this.data);
            descParser.parse();
            this.smell = descParser.template;
            return descParser.state;
        }

        public Object instanceCreate() {
            return this;
        }

        public Class instanceClass() {
            return ((Object)((Object)this)).getClass();
        }

        public String instanceName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public String toString() {
            return "MIMEResolverImpl.Impl[" + this.data + ", " + this.smell + "]";
        }
    }
}

