/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.netbeans.core.modules.ProxyClassLoader;
import org.netbeans.core.modules.Util;

public class JarClassLoader
extends ProxyClassLoader {
    private Object[] sources;
    private URL[] urls;
    private ProtectionDomain[] pds;
    private int count;

    public JarClassLoader(List list, ClassLoader[] classLoaderArray) {
        super(classLoaderArray);
        this.count = list.size();
        this.sources = new Object[this.count];
        this.urls = new URL[this.count];
        this.pds = new ProtectionDomain[this.count];
        int n = 0;
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.sources[n] = e;
                this.urls[n] = e instanceof File ? ((File)e).toURL() : new URL("file:" + ((JarFile)e).getName());
                CodeSource codeSource = new CodeSource(this.urls[n], new Certificate[0]);
                this.pds[n] = new ProtectionDomain(codeSource, this.getPermissions(codeSource));
                ++n;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        return Policy.getPolicy().getPermissions(codeSource);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        if (manifest == null) {
            return this.definePackage(string, null, null, null, null, null, null, null);
        }
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        Attributes attributes2 = manifest.getMainAttributes();
        String string3 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_TITLE);
        String string4 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_TITLE);
        String string5 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_VERSION);
        String string6 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VERSION);
        String string7 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SPECIFICATION_VENDOR);
        String string8 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.IMPLEMENTATION_VENDOR);
        String string9 = JarClassLoader.getAttr(attributes, attributes2, Attributes.Name.SEALED);
        URL uRL2 = "true".equalsIgnoreCase(string9) ? uRL : null;
        return this.definePackage(string, string3, string5, string7, string4, string6, string8, uRL2);
    }

    private static String getAttr(Attributes attributes, Attributes attributes2, Attributes.Name name) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(name);
        }
        if (string == null && attributes2 != null) {
            string = attributes2.getValue(name);
        }
        return string;
    }

    protected Class simpleFindClass(String string, String string2) {
        Class clazz = null;
        int n = 0;
        while (n < this.count) {
            clazz = this.sources[n] instanceof JarFile ? this.findClassInJar(n, string, string2) : this.findClassInFolder(n, string, string2);
            if (clazz != null) {
                return clazz;
            }
            ++n;
        }
        return null;
    }

    private final Class findClassInJar(int n, String string, String string2) {
        ZipEntry zipEntry = ((JarFile)this.sources[n]).getEntry(string2);
        if (zipEntry != null) {
            try {
                return this.defineClass(string, n, zipEntry);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private final Class findClassInFolder(int n, String string, String string2) {
        File file = new File((File)this.sources[n], string2);
        if (file.exists()) {
            try {
                return this.defineClass(string, n, file);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    private final Class defineClass(String string, int n, File file) throws IOException {
        int n2 = string.lastIndexOf(46);
        String string2 = string.substring(0, n2);
        Package package_ = this.getPackage(string2);
        if (package_ != null) {
            if (package_.isSealed() && !package_.isSealed(this.urls[n2])) {
                throw new SecurityException("sealing violation");
            }
        } else {
            this.definePackage(string2, null, this.urls[n]);
        }
        int n3 = (int)file.length();
        byte[] byArray = new byte[n3];
        FileInputStream fileInputStream = new FileInputStream(file);
        int n4 = 0;
        while (n4 < n3) {
            n4 += ((InputStream)fileInputStream).read(byArray, n4, n3 - n4);
        }
        return this.defineClass(string, byArray, 0, n3, this.pds[n]);
    }

    private final Class defineClass(String string, int n, ZipEntry zipEntry) throws IOException {
        int n2 = string.lastIndexOf(46);
        String string2 = string.substring(0, n2);
        Package package_ = this.getPackage(string2);
        if (package_ != null) {
            if (package_.isSealed() && !package_.isSealed(this.urls[n2])) {
                throw new SecurityException("sealing violation");
            }
        } else {
            Manifest manifest = ((JarFile)this.sources[n]).getManifest();
            this.definePackage(string2, manifest, this.urls[n]);
        }
        int n3 = (int)zipEntry.getSize();
        byte[] byArray = new byte[n3];
        InputStream inputStream = ((JarFile)this.sources[n]).getInputStream(zipEntry);
        int n4 = 0;
        while (n4 < n3) {
            n4 += inputStream.read(byArray, n4, n3 - n4);
        }
        return this.defineClass(string, byArray, 0, n3, this.pds[n]);
    }

    protected URL findResource(String string) {
        int n = 0;
        while (n < this.sources.length) {
            Object object;
            Object object2 = this.sources[n];
            if (object2 instanceof JarFile) {
                object = ((JarFile)object2).getEntry(string);
                if (object != null) {
                    try {
                        return new URL("jar:file:" + ((JarFile)object2).getName() + "!/" + ((ZipEntry)object).getName());
                    }
                    catch (MalformedURLException malformedURLException) {
                        Util.err.log("malformed: jar:file:" + ((JarFile)object2).getName() + "!/" + ((ZipEntry)object).getName());
                    }
                }
            } else {
                object = new File((File)object2, string);
                if (((File)object).exists()) {
                    try {
                        return ((File)object).toURL();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            }
            ++n;
        }
        return null;
    }

    protected Enumeration simpleFindResources(String string) {
        Vector<URL> vector = new Vector<URL>(3);
        int n = 0;
        while (n < this.sources.length) {
            Object object;
            Object object2 = this.sources[n];
            if (object2 instanceof JarFile) {
                object = ((JarFile)object2).getEntry(string);
                if (object != null) {
                    try {
                        vector.add(new URL("jar:file:" + ((JarFile)object2).getName() + "!/" + ((ZipEntry)object).getName()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        Util.err.log("malformed: jar:file:" + ((JarFile)object2).getName() + "!/" + ((ZipEntry)object).getName());
                    }
                }
            } else {
                object = new File((File)object2, string);
                if (((File)object).exists()) {
                    try {
                        vector.add(((File)object).toURL());
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            }
            ++n;
        }
        return vector.elements();
    }
}

