/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.Beans;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.Util;
import org.openide.ServiceType;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;

public abstract class ManifestSection {
    private final Class superclazz;
    private final String name;
    private final String className;
    private Class clazz;
    private Object result;
    private Exception problem;
    private final Module module;
    static /* synthetic */ Class class$org$openide$util$SharedClassObject;
    static /* synthetic */ Class class$org$openide$util$actions$SystemAction;
    static /* synthetic */ Class class$org$openide$options$SystemOption;
    static /* synthetic */ Class class$org$openide$loaders$DataLoader;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;
    static /* synthetic */ Class class$org$openide$ServiceType;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem;
    static /* synthetic */ Class class$org$openide$nodes$Node;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExClipboard$Convertor;

    protected ManifestSection(String string, Module module, Class clazz) throws InvalidException {
        this.name = string;
        this.module = module;
        this.superclazz = clazz;
        try {
            this.className = Util.createPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InvalidException invalidException = new InvalidException(module, illegalArgumentException.toString());
            Util.err.annotate((Throwable)invalidException, (Throwable)illegalArgumentException);
            throw invalidException;
        }
    }

    public final Module getModule() {
        return this.module;
    }

    protected final ClassLoader getClassLoader() {
        return this.module.getClassLoader();
    }

    public final boolean isDefaultInstance() {
        return this.name.endsWith(".class");
    }

    public final Class getSectionClass() throws Exception {
        if (this.clazz != null) {
            return this.clazz;
        }
        if (this.problem != null) {
            throw this.problem;
        }
        if (this.isDefaultInstance()) {
            try {
                this.clazz = this.getClassLoader().loadClass(this.className);
                if (!this.superclazz.isAssignableFrom(this.clazz)) {
                    throw new ClassCastException("Class " + this.clazz.getName() + " is not a subclass of " + this.getSuperclass().getName());
                }
                if (this.clazz.getClassLoader() != this.getClassLoader()) {
                    Events events = this.module.getManager().getEvents();
                    events.log("wrongClassLoader", (Object)this.module, this.clazz, this.getClassLoader());
                }
                return this.clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Util.err.log("Loader for ClassNotFoundException: " + this.getClassLoader());
                Util.debugClassLoader(this.getClassLoader(), "\t");
                this.problem = classNotFoundException;
                throw this.problem;
            }
            catch (Exception exception) {
                this.problem = exception;
                throw this.problem;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.problem = new ClassNotFoundException(throwable.toString());
                Util.err.annotate((Throwable)this.problem, throwable);
                throw this.problem;
            }
        }
        this.clazz = this.getInstance().getClass();
        return this.clazz;
    }

    public String getSectionClassName() throws Exception {
        if (this.isDefaultInstance()) {
            return this.className;
        }
        return this.getSectionClass().getName();
    }

    protected final Object createInstance() throws Exception {
        if (!this.isDefaultInstance()) {
            try {
                Object object = Beans.instantiate(this.getClassLoader(), this.className);
                this.clazz = object.getClass();
                if (!this.superclazz.isAssignableFrom(this.clazz)) {
                    throw new ClassCastException("Class " + this.clazz.getName() + " is not a subclass of " + this.getSuperclass().getName());
                }
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Util.err.log("Loader for ClassNotFoundException: " + this.getClassLoader());
                Util.debugClassLoader(this.getClassLoader(), "\t");
                throw classNotFoundException;
            }
        }
        this.getSectionClass();
        if ((class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = ManifestSection.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(this.clazz)) {
            return SharedClassObject.findObject((Class)this.clazz, (boolean)true);
        }
        return this.clazz.newInstance();
    }

    public final Object getInstance() throws Exception {
        if (this.problem != null) {
            this.problem.fillInStackTrace();
            throw this.problem;
        }
        if (this.result == null) {
            try {
                this.result = this.createInstance();
            }
            catch (Exception exception) {
                this.problem = exception;
                throw this.problem;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.problem = new ClassNotFoundException(throwable.toString());
                Util.err.annotate((Throwable)this.problem, throwable);
                throw this.problem;
            }
        }
        return this.result;
    }

    public final Class getSuperclass() {
        return this.superclazz;
    }

    public void dispose() {
        this.result = null;
        this.problem = null;
        this.clazz = null;
    }

    public String toString() {
        return "ManifestSection[" + this.className + "]";
    }

    public static ManifestSection create(String string, Attributes attributes, Module module) throws InvalidException {
        String string2 = attributes.getValue("OpenIDE-Module-Class");
        if (string2 == null) {
            return null;
        }
        if (string2.equalsIgnoreCase("Action")) {
            return new ActionSection(string, attributes, module);
        }
        if (string2.equalsIgnoreCase("Option")) {
            return new OptionSection(string, attributes, module);
        }
        if (string2.equalsIgnoreCase("Loader")) {
            return new LoaderSection(string, attributes, module);
        }
        if (string2.equalsIgnoreCase("Filesystem")) {
            return new FileSystemSection(string, attributes, module);
        }
        if (string2.equalsIgnoreCase("Node")) {
            return new NodeSection(string, attributes, module);
        }
        if (string2.equalsIgnoreCase("Service")) {
            return new ServiceSection(string, attributes, module);
        }
        if (string2.equalsIgnoreCase("Debugger")) {
            return new DebuggerSection(string, attributes, module);
        }
        if (string2.equalsIgnoreCase("ClipboardConvertor")) {
            return new ClipboardConvertorSection(string, attributes, module);
        }
        throw new InvalidException(module, "Illegal manifest section type: " + string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class ClipboardConvertorSection
    extends ManifestSection {
        ClipboardConvertorSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, class$org$openide$util$datatransfer$ExClipboard$Convertor == null ? (class$org$openide$util$datatransfer$ExClipboard$Convertor = ManifestSection.class$("org.openide.util.datatransfer.ExClipboard$Convertor")) : class$org$openide$util$datatransfer$ExClipboard$Convertor);
        }
    }

    public static final class NodeSection
    extends ManifestSection {
        public static final String TYPE_ROOTS = "roots";
        public static final String TYPE_ENVIRONMENT = "environment";
        public static final String TYPE_SESSION = "session";
        private String type;

        NodeSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = ManifestSection.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node);
            this.type = attributes.getValue("Type");
            if (this.type == null) {
                this.type = TYPE_ENVIRONMENT;
            }
            this.type = this.type.toLowerCase();
            if (!(this.type.equalsIgnoreCase(TYPE_ROOTS) || this.type.equalsIgnoreCase(TYPE_ENVIRONMENT) || this.type.equalsIgnoreCase(TYPE_SESSION))) {
                throw new InvalidException(module, "Unrecognized node section type: " + this.type);
            }
        }

        public String getType() {
            return this.type;
        }
    }

    public static final class FileSystemSection
    extends ManifestSection {
        private final String locAttr;
        private final HelpCtx help;

        FileSystemSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = ManifestSection.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem);
            this.locAttr = string + "/Display-Name";
            String string2 = attributes.getValue("Help");
            this.help = string2 == null ? HelpCtx.DEFAULT_HELP : new HelpCtx(string2);
        }

        public String getName() {
            String string = (String)this.getModule().getLocalizedAttribute(this.locAttr);
            if (string == null) {
                return "<unnamed filesystem>";
            }
            return string;
        }

        public HelpCtx getHelpCtx() {
            return this.help;
        }

        public FileSystem createFileSystem() throws InstantiationException {
            try {
                return (FileSystem)this.createInstance();
            }
            catch (Exception exception) {
                InstantiationException instantiationException = new InstantiationException(exception.toString());
                Util.err.annotate((Throwable)instantiationException, (Throwable)exception);
                throw instantiationException;
            }
        }
    }

    public static final class ServiceSection
    extends ManifestSection {
        private final boolean deflt;

        ServiceSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = ManifestSection.class$("org.openide.ServiceType")) : class$org$openide$ServiceType);
            this.deflt = Boolean.valueOf(attributes.getValue("Default"));
        }

        public boolean isDefault() {
            return this.deflt;
        }

        public ServiceType createServiceType() throws InstantiationException {
            try {
                return (ServiceType)this.createInstance();
            }
            catch (Exception exception) {
                InstantiationException instantiationException = new InstantiationException(exception.toString());
                Util.err.annotate((Throwable)instantiationException, (Throwable)exception);
                throw instantiationException;
            }
        }
    }

    public static final class DebuggerSection
    extends ManifestSection {
        DebuggerSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = ManifestSection.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
        }
    }

    public static final class LoaderSection
    extends ManifestSection {
        private final String[] installAfter;
        private final String[] installBefore;

        LoaderSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, class$org$openide$loaders$DataLoader == null ? (class$org$openide$loaders$DataLoader = ManifestSection.class$("org.openide.loaders.DataLoader")) : class$org$openide$loaders$DataLoader);
            String string2;
            LinkedList<String> linkedList;
            StringTokenizer stringTokenizer;
            String string3 = attributes.getValue("Install-After");
            if (string3 != null) {
                stringTokenizer = new StringTokenizer(string3, ", ");
                linkedList = new LinkedList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("")) continue;
                    linkedList.add(string2);
                }
                this.installAfter = linkedList.toArray(new String[linkedList.size()]);
            } else {
                this.installAfter = null;
            }
            string3 = attributes.getValue("Install-Before");
            if (string3 != null) {
                stringTokenizer = new StringTokenizer(string3, ", ");
                linkedList = new LinkedList();
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equals("")) continue;
                    linkedList.add(string2);
                }
                this.installBefore = linkedList.toArray(new String[linkedList.size()]);
            } else {
                this.installBefore = null;
            }
        }

        public String[] getInstallAfter() {
            return this.installAfter;
        }

        public String[] getInstallBefore() {
            return this.installBefore;
        }
    }

    public static final class OptionSection
    extends ManifestSection {
        OptionSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, class$org$openide$options$SystemOption == null ? (class$org$openide$options$SystemOption = ManifestSection.class$("org.openide.options.SystemOption")) : class$org$openide$options$SystemOption);
        }
    }

    public static final class ActionSection
    extends ManifestSection {
        ActionSection(String string, Attributes attributes, Module module) throws InvalidException {
            super(string, module, class$org$openide$util$actions$SystemAction == null ? (class$org$openide$util$actions$SystemAction = ManifestSection.class$("org.openide.util.actions.SystemAction")) : class$org$openide$util$actions$SystemAction);
        }
    }
}

