/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.netbeans.core.modules.ChangeFirer;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleInstaller;
import org.netbeans.core.modules.ProxyClassLoader;
import org.netbeans.core.modules.Util;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

public final class ModuleManager {
    public static final String PROP_MODULES = "modules";
    public static final String PROP_ENABLED_MODULES = "enabledModules";
    public static final String PROP_CLASS_LOADER = "classLoader";
    private final HashSet modules = new HashSet(100);
    private final Map modulesByName = new HashMap(100);
    private final Map moduleProblems = new HashMap(100);
    private final ModuleInstaller installer;
    private SystemClassLoader classLoader = new SystemClassLoader(new ClassLoader[0]);
    private final Object classLoaderLock = "ModuleManager.classLoaderLock";
    private final Events ev;
    private final Mutex.Privileged MUTEX_PRIVILEGED = new Mutex.Privileged();
    private final Mutex MUTEX = new Mutex(this.MUTEX_PRIVILEGED);
    private ChangeFirer firer = new ChangeFirer(this);
    private final Set listeners = new HashSet(10);
    private final Util.ModuleLookup lookup = new Util.ModuleLookup();
    private static final Object PROBING_IN_PROCESS = new Object();

    public ModuleManager(ModuleInstaller moduleInstaller, Events events) {
        this.installer = moduleInstaller;
        this.ev = events;
    }

    final Events getEvents() {
        return this.ev;
    }

    public final Mutex mutex() {
        return this.MUTEX;
    }

    final Mutex.Privileged mutexPrivileged() {
        return this.MUTEX_PRIVILEGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if (Util.err.isLoggable(0)) {
            Util.err.log("ModuleManager.propertyChange: " + string + ": " + object + " -> " + object2);
        }
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            propertyChangeListenerArray = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < propertyChangeListenerArray.length) {
            propertyChangeListenerArray[n].propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    final void fireReloadable(Module module) {
        this.firer.change(new ChangeFirer.Change((Object)module, "reloadable", null, null));
    }

    public Lookup getModuleLookup() {
        return this.lookup;
    }

    final void fireModulesCreatedDeleted(Set set, Set set2) {
        Util.err.log("lookup created: " + set + " deleted: " + set2);
        this.lookup.changed();
    }

    public Set getModules() {
        return (Set)this.modules.clone();
    }

    public final Set getEnabledModules() {
        HashSet hashSet = new HashSet(this.modules);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (module.isEnabled()) continue;
            iterator.remove();
        }
        return hashSet;
    }

    public final Module get(String string) {
        return (Module)((Object)this.modulesByName.get(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            SystemClassLoader systemClassLoader = this.classLoader;
            return systemClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateClassLoader() {
        SystemClassLoader systemClassLoader;
        ClassLoader[] classLoaderArray;
        Object object = this.classLoaderLock;
        synchronized (object) {
            this.classLoader.destroy();
        }
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(this.modules.size() * 4 / 3 + 1);
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            classLoaderArray = (ClassLoader[])iterator.next();
            if (!classLoaderArray.isEnabled()) continue;
            hashSet.add(classLoaderArray.getClassLoader());
        }
        classLoaderArray = hashSet.toArray(new ClassLoader[hashSet.size()]);
        try {
            systemClassLoader = new SystemClassLoader(classLoaderArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.err.notify((Throwable)illegalArgumentException);
            systemClassLoader = new SystemClassLoader(new ClassLoader[0]);
        }
        Object object2 = this.classLoaderLock;
        synchronized (object2) {
            this.classLoader = systemClassLoader;
        }
        this.firer.change(new ChangeFirer.Change(this, PROP_CLASS_LOADER, null, null));
    }

    public Module create(File file, Object object, boolean bl, boolean bl2) throws IOException, DuplicateException {
        this.ev.log("startCreateRegularModule", file);
        Module module = new Module(this, this.ev, file, object, bl, bl2);
        this.ev.log("finishCreateRegularModule", file);
        this.subCreate(module);
        return module;
    }

    public Module createFixed(Manifest manifest, Object object, ClassLoader classLoader) throws InvalidException, DuplicateException {
        if (manifest == null || classLoader == null) {
            throw new IllegalArgumentException("null manifest or loader");
        }
        this.ev.log("startCreateBootModule", object);
        Module module = new Module(this, this.ev, manifest, object, classLoader);
        this.ev.log("finishCreateBootModule", object);
        this.subCreate(module);
        return module;
    }

    private void subCreate(Module module) throws DuplicateException {
        Util.err.log("created: " + (Object)((Object)module));
        Module module2 = this.get(module.getCodeNameBase());
        if (module2 != null) {
            throw new DuplicateException(module2, module);
        }
        this.modules.add(module);
        this.modulesByName.put(module.getCodeNameBase(), module);
        this.lookup.add(module);
        this.firer.created(module);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.clearProblemCache();
    }

    public void delete(Module module) throws IllegalArgumentException {
        if (module.isFixed()) {
            throw new IllegalArgumentException("fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("enabled module: " + (Object)((Object)module));
        }
        this.ev.log("deleteModule", (Object)module);
        this.modules.remove((Object)module);
        this.modulesByName.remove(module.getCodeNameBase());
        this.lookup.remove(module);
        this.firer.deleted(module);
        this.firer.change(new ChangeFirer.Change(this, PROP_MODULES, null, null));
        this.firer.change(new ChangeFirer.Change((Object)module, "valid", Boolean.TRUE, Boolean.FALSE));
        this.clearProblemCache();
    }

    public void reload(Module module) throws IllegalArgumentException, IOException {
        Util.err.log("reload: " + (Object)((Object)module));
        if (module.isFixed()) {
            throw new IllegalArgumentException("reload fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("reload enabled module: " + (Object)((Object)module));
        }
        try {
            module.reload();
        }
        catch (IOException iOException) {
            this.delete(module);
            throw iOException;
        }
        this.firer.change(new ChangeFirer.Change((Object)module, "manifest", null, null));
        this.moduleProblems.remove((Object)module);
        this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        this.clearProblemCache();
    }

    public final void enable(Module module) throws IllegalArgumentException, InvalidException {
        this.enable(Collections.singleton(module));
    }

    public final void disable(Module module) throws IllegalArgumentException {
        this.disable(Collections.singleton(module));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void enable(Set var1_1) throws IllegalArgumentException, InvalidException {
        block24: {
            Util.err.log("enable: " + var1_1);
            if (var1_1.isEmpty()) {
                return;
            }
            this.ev.log("perfStart", "ModuleManager.enable");
            var2_2 = this.simulateEnable(var1_1);
            this.ev.log("perfTick", "checked the required ordering and autoloads");
            Util.err.log("enable: toEnable=" + var2_2);
            var3_3 = new HashSet<E>(var2_2);
            if (!var3_3.containsAll(var1_1)) {
                var4_4 = new HashSet<E>(var1_1);
                var4_4.removeAll((Collection<?>)var3_3);
                throw new IllegalArgumentException("Not all requested modules can be enabled: " + var4_4);
            }
            var4_5 = var3_3.iterator();
            while (var4_5.hasNext()) {
                var5_8 /* !! */  = (Module)var4_5.next();
                if (var1_1.contains((Object)var5_8 /* !! */ ) || var5_8 /* !! */ .isAutoload()) continue;
                throw new IllegalArgumentException("Would also need to enable " + (Object)var5_8 /* !! */ );
            }
            Util.err.log("enable: verified dependencies");
            this.ev.log("perfTick", "verified dependencies");
            this.ev.log("startEnableModules", var1_1);
            var3_3 = new LinkedList<E>();
            var4_6 = false;
            var5_8 /* !! */  = null;
            try {
                var6_9 = var2_2.iterator();
                this.ev.log("perfStart", "module preparation");
                while (var6_9.hasNext()) {
                    var7_11 = (Module)var6_9.next();
                    var3_3.addFirst((Module)var7_11);
                    Util.err.log("enable: bringing up: " + var7_11);
                    try {
                        var8_13 = var7_11.getDependencies();
                        var9_16 = new HashSet<E>(var8_13.size() * 4 / 3 + 1);
                        var10_18 = var8_13.iterator();
                        while (var10_18.hasNext()) {
                            var11_20 = (Dependency)var10_18.next();
                            if (var11_20.getType() != 1) continue;
                            var12_21 = var11_20.getName();
                            var13_22 = var12_21.lastIndexOf(47);
                            if (var13_22 != -1) {
                                var12_21 = var12_21.substring(0, var13_22);
                            }
                            if ((var14_23 = this.get(var12_21)) == null) {
                                throw new IOException("Parent " + var12_21 + " not found!");
                            }
                            var9_16.add(var14_23);
                        }
                        var7_11.classLoaderUp((Set)var9_16);
                    }
                    catch (IOException var8_14) {
                        var4_6 = true;
                        var9_16 = new InvalidException(var8_14.toString());
                        Util.err.annotate((Throwable)var9_16, (Throwable)var8_14);
                        throw var9_16;
                    }
                    var7_11.setEnabled(true);
                    Util.err.log("enable: checking package dependencies for " + var7_11);
                    var8_13 = var7_11.getDependencies().iterator();
                    while (var8_13.hasNext()) {
                        var9_16 = (Dependency)var8_13.next();
                        if (var9_16.getType() != 2) continue;
                        if (!Util.checkPackageDependency((Dependency)var9_16, var7_11.getClassLoader())) {
                            var5_8 /* !! */  = var9_16;
                            throw new InvalidException((Module)var7_11, "Dependency failed on " + var9_16);
                        }
                        Util.err.log("Successful check for: " + var9_16);
                    }
                    this.installer.prepare((Module)var7_11);
                    this.ev.log("perfTick", "prepared " + var7_11.getCodeName());
                }
                this.ev.log("perfEnd", "module preparation");
                break block24;
            }
            catch (InvalidException var6_10) {
                var7_12 = var6_10.getModule();
                if (var7_12 == null) {
                    throw new IllegalStateException("Problem with no associated module: " + var6_10);
                }
                var8_15 = (Set)this.moduleProblems.get((Object)var7_12);
                if (var8_15 == null) {
                    throw new IllegalStateException("Were trying to install a module that had never been checked: " + (Object)var7_12);
                }
                if (!var8_15.isEmpty()) {
                    throw new IllegalStateException("Were trying to install a module that was known to be bad: " + (Object)var7_12);
                }
                if (var5_8 /* !! */  != null) {
                    var8_15.add(var5_8 /* !! */ );
                } else {
                    var8_15.add(var6_10);
                }
                this.clearProblemCache();
                this.firer.change(new ChangeFirer.Change((Object)var7_12, "problems", Collections.EMPTY_SET, Collections.singleton(var8_15.iterator().next())));
                Util.err.log("enable: will roll back from: " + var6_10);
                var9_17 = var3_3.iterator();
                ** while (var9_17.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                var10_19 = (Module)var9_17.next();
                var10_19.setEnabled(false);
                if (var4_6) {
                    var4_6 = false;
                    continue;
                }
                var10_19.classLoaderDown();
                continue;
            }
lbl99:
            // 1 sources

            throw var6_10;
        }
        if (this.classLoader != null) {
            Util.err.log("enable: adding to system classloader");
            var6_9 = new ArrayList<E>(var2_2.size());
            var7_11 = var2_2.iterator();
            while (var7_11.hasNext()) {
                var6_9.add(((Module)var7_11.next()).getClassLoader());
            }
            this.classLoader.append(var6_9.toArray(new ClassLoader[var6_9.size()]));
        } else {
            Util.err.log("enable: no class loader yet, not appending");
        }
        Util.err.log("enable: continuing to installation");
        this.installer.load(var2_2);
        Util.err.log("enable: firing changes");
        this.firer.change(new ChangeFirer.Change(this, "enabledModules", null, null));
        var3_3 = var2_2.iterator();
        while (var3_3.hasNext()) {
            var4_7 = (Module)var3_3.next();
            this.firer.change(new ChangeFirer.Change((Object)var4_7, "enabled", Boolean.FALSE, Boolean.TRUE));
            if (var4_7.isFixed()) continue;
            this.firer.change(new ChangeFirer.Change((Object)var4_7, "classLoader", null, null));
        }
        this.ev.log("finishEnableModules", var1_1);
    }

    public void disable(Set set) throws IllegalArgumentException {
        Module module;
        Util.err.log("disable: " + set);
        if (set.isEmpty()) {
            return;
        }
        List list = this.simulateDisable(set);
        Util.err.log("disable: toDisable=" + list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            if (set.contains((Object)module) || module.isAutoload()) continue;
            throw new IllegalArgumentException("Would also need to disable: " + (Object)((Object)module));
        }
        Util.err.log("disable: verified dependencies");
        this.ev.log("startDisableModules", set);
        this.installer.unload(list);
        iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            this.installer.dispose(module);
            module.setEnabled(false);
            module.classLoaderDown();
        }
        Util.err.log("disable: finished, will notify changes");
        this.firer.change(new ChangeFirer.Change(this, PROP_ENABLED_MODULES, null, null));
        this.invalidateClassLoader();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)((Object)iterator.next());
            this.firer.change(new ChangeFirer.Change((Object)module, "enabled", Boolean.TRUE, Boolean.FALSE));
            this.firer.change(new ChangeFirer.Change((Object)module, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishDisableModules", set);
    }

    public List simulateEnable(Set set) throws IllegalArgumentException {
        if (set.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet hashSet = new HashSet(set.size() * 2 + 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (module.isAutoload()) {
                throw new IllegalArgumentException("Cannot simulate enabling an autoload: " + (Object)((Object)module));
            }
            if (module.isEnabled()) {
                throw new IllegalArgumentException("Already enabled: " + (Object)((Object)module));
            }
            if (!module.isValid()) {
                throw new IllegalArgumentException("Not managed by me: " + (Object)((Object)module) + " in " + module.getJarFile());
            }
            this.maybeAddToEnableList(hashSet, module, true);
        }
        try {
            return Utilities.partialSort(new ArrayList(hashSet), (Comparator)Util.dependencyComparator(false), (boolean)false);
        }
        catch (Utilities.UnorderableException unorderableException) {
            IllegalStateException illegalStateException = new IllegalStateException(unorderableException.toString());
            Util.err.annotate((Throwable)illegalStateException, (Throwable)unorderableException);
            throw illegalStateException;
        }
    }

    private void maybeAddToEnableList(Set set, Module module, boolean bl) {
        if (!this.missingDependencies(module).isEmpty()) {
            if (!bl) {
                throw new IllegalStateException("Module was supposed to be OK: " + (Object)((Object)module));
            }
            return;
        }
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        Iterator iterator = module.getDependencies().iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (dependency.getType() != 1) continue;
            String string = dependency.getName();
            int n = string.lastIndexOf(47);
            String string2 = n == -1 ? string : string.substring(0, n);
            Module module2 = this.get(string2);
            if (module2 == null) {
                throw new IllegalStateException("Should have found module: " + string2);
            }
            if (module2.isEnabled()) continue;
            this.maybeAddToEnableList(set, module2, false);
        }
    }

    public List simulateDisable(Set set) throws IllegalArgumentException {
        Object object;
        if (set.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet hashSet = new HashSet(20);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Module)((Object)iterator.next());
            if (object.isAutoload()) {
                throw new IllegalArgumentException("Cannot disable autoload: " + (Object)object);
            }
            if (object.isFixed()) {
                throw new IllegalArgumentException("Cannot disable fixed module: " + (Object)object);
            }
            if (!object.isEnabled()) {
                throw new IllegalArgumentException("Already disabled: " + (Object)object);
            }
            this.addToDisableList(hashSet, (Module)((Object)object));
        }
        object = new HashSet(this.getEnabledModules());
        object.removeAll(hashSet);
        while (this.searchForUnusedAutoloads(hashSet, (Set)object)) {
        }
        try {
            return Utilities.partialSort(new ArrayList(hashSet), (Comparator)Util.dependencyComparator(true), (boolean)false);
        }
        catch (Utilities.UnorderableException unorderableException) {
            IllegalStateException illegalStateException = new IllegalStateException(unorderableException.toString());
            Util.err.annotate((Throwable)illegalStateException, (Throwable)unorderableException);
            throw illegalStateException;
        }
    }

    private void addToDisableList(Set set, Module module) {
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        Iterator iterator = this.modules.iterator();
        block0: while (iterator.hasNext()) {
            Module module2 = (Module)((Object)iterator.next());
            if (module2.isFixed() || !module2.isEnabled() || set.contains((Object)module2)) continue;
            Iterator iterator2 = module2.getDependencies().iterator();
            while (iterator2.hasNext()) {
                Dependency dependency = (Dependency)iterator2.next();
                if (dependency.getType() != 1 || !dependency.getName().equals(module.getCodeName())) continue;
                this.addToDisableList(set, module2);
                continue block0;
            }
        }
    }

    private boolean searchForUnusedAutoloads(Set set, Set set2) {
        boolean bl = false;
        Iterator iterator = set2.iterator();
        block0: while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (!module.isAutoload()) continue;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                Module module2 = (Module)((Object)iterator2.next());
                Iterator iterator3 = module2.getDependencies().iterator();
                while (iterator3.hasNext()) {
                    Dependency dependency = (Dependency)iterator3.next();
                    if (dependency.getType() == 1 && dependency.getName().equals(module.getCodeName())) continue block0;
                }
            }
            bl = true;
            iterator.remove();
            set.add(module);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set missingDependencies(Module module) {
        Map map = this.moduleProblems;
        synchronized (map) {
            Set set;
            HashSet<Object> hashSet = (HashSet<Object>)this.moduleProblems.get((Object)module);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                hashSet.add(PROBING_IN_PROCESS);
                this.moduleProblems.put(module, hashSet);
                set = module.getDependencies();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Dependency dependency = (Dependency)iterator.next();
                    if (dependency.getType() == 2) continue;
                    if (dependency.getType() == 1) {
                        int n;
                        String string;
                        String string2 = dependency.getName();
                        int n2 = string2.lastIndexOf(47);
                        if (n2 == -1) {
                            string = string2;
                            n = -1;
                        } else {
                            string = string2.substring(0, n2);
                            n = Integer.parseInt(string2.substring(n2 + 1));
                        }
                        Module module2 = this.get(string);
                        if (module2 == null) {
                            hashSet.add(dependency);
                            continue;
                        }
                        if (n != module2.getCodeNameRelease()) {
                            hashSet.add(dependency);
                            continue;
                        }
                        if (dependency.getComparison() == 2 && !Utilities.compareObjects((Object)dependency.getVersion(), (Object)module2.getImplementationVersion())) {
                            hashSet.add(dependency);
                            continue;
                        }
                        if (dependency.getComparison() == 1 && new SpecificationVersion(dependency.getVersion()).compareTo((Object)module2.getSpecificationVersion()) > 0) {
                            hashSet.add(dependency);
                            continue;
                        }
                        if (module2.isEnabled() || this.missingDependencies(module2).isEmpty()) continue;
                        hashSet.add(dependency);
                        continue;
                    }
                    if (Util.checkJavaOrIDEDependency(dependency)) continue;
                    hashSet.add(dependency);
                }
                hashSet.remove(PROBING_IN_PROCESS);
            }
            set = hashSet;
            return set;
        }
    }

    private void clearProblemCache() {
        Iterator iterator = this.moduleProblems.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Set set;
            Map.Entry entry = iterator.next();
            Module module = (Module)((Object)entry.getKey());
            if (module.isEnabled() || (set = (Set)entry.getValue()) == null) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Dependency dependency;
                Object e = iterator2.next();
                if (e instanceof InvalidException || (dependency = (Dependency)e).getType() != 1) continue block0;
            }
            iterator.remove();
            this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        }
    }

    public boolean shutDown() {
        List list;
        try {
            list = Utilities.partialSort(new ArrayList(this.getEnabledModules()), (Comparator)Util.dependencyComparator(true), (boolean)false);
        }
        catch (Utilities.UnorderableException unorderableException) {
            Util.err.notify((Throwable)unorderableException);
            return true;
        }
        if (!this.installer.closing(list)) {
            return false;
        }
        this.installer.close(list);
        this.firer.stopFiring();
        return true;
    }

    private static final class SystemClassLoader
    extends ProxyClassLoader {
        public SystemClassLoader(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
            super(classLoaderArray);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Collected system class loader");
        }
    }
}

