/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleHistory;
import org.netbeans.core.modules.ModuleInstaller;
import org.netbeans.core.modules.ModuleList;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.ModuleSystem;
import org.netbeans.core.modules.NbEvents;
import org.netbeans.core.modules.NbInstaller;
import org.netbeans.core.modules.TestModuleDeployer;
import org.netbeans.core.modules.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ModuleSystem {
    private final ModuleManager mgr;
    private final ModuleInstaller installer;
    private final ModuleList list;
    private final Events ev = new NbEvents();
    private boolean addedClassLoaderListener = false;
    private Set bootModules = null;
    private Set autoscanned;
    static /* synthetic */ Class class$org$netbeans$core$Help;
    static /* synthetic */ Class class$org$netbeans$core$modules$ModuleSystem;

    public static Lookup getModuleLookup() {
        return NbTopManager.get().getModuleSystem().getManager().getModuleLookup();
    }

    public static TestModuleDeployer getTestModuleDeployer() {
        return new TestModuleDeployerImpl();
    }

    public ModuleSystem(FileSystem fileSystem, File file, File file2) throws IOException {
        Object object;
        this.installer = new NbInstaller(this.ev);
        this.mgr = new ModuleManager(this.installer, this.ev);
        if (fileSystem.isReadOnly()) {
            this.list = null;
        } else {
            File file3;
            object = fileSystem.getRoot();
            FileObject fileObject = object.getFileObject("Modules");
            if (fileObject == null) {
                fileObject = object.createFolder("Modules");
            }
            ArrayList<ModuleList.AutoscanFolder> arrayList = new ArrayList<ModuleList.AutoscanFolder>(4);
            if (file != null && file.isDirectory()) {
                arrayList.add(new ModuleList.AutoscanFolder(file, "installation", false));
                file3 = new File(file, "autoload");
                if (file3.isDirectory()) {
                    arrayList.add(new ModuleList.AutoscanFolder(file3, "installation/autoload", true));
                }
            }
            if (file2 != null && file2.isDirectory()) {
                arrayList.add(new ModuleList.AutoscanFolder(file2, "user", false));
                file3 = new File(file2, "autoload");
                if (file3.isDirectory()) {
                    arrayList.add(new ModuleList.AutoscanFolder(file3, "user/autoload", true));
                }
            }
            this.list = new ModuleList(this.mgr, fileObject, arrayList, this.ev);
            ((NbInstaller)this.installer).registerList(this.list);
        }
        this.ev.log("createdModuleSystem");
        object = class$org$netbeans$core$Help == null ? (class$org$netbeans$core$Help = ModuleSystem.class$("org.netbeans.core.Help")) : class$org$netbeans$core$Help;
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public Events getEvents() {
        return this.ev;
    }

    public ClassLoader getSystemClassLoader() {
        if (!this.addedClassLoaderListener) {
            this.addedClassLoaderListener = true;
            class ListenerFirer
            implements PropertyChangeListener,
            Runnable {
                private final /* synthetic */ ModuleSystem this$0;

                ListenerFirer(ModuleSystem moduleSystem) {
                    this.this$0 = moduleSystem;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("classLoader".equals(propertyChangeEvent.getPropertyName())) {
                        RequestProcessor.postRequest((Runnable)this);
                    }
                }

                public void run() {
                    NbTopManager.get().fireSystemClassLoaderChange();
                    Util.err.log("fired change in system classloader");
                }
            }
            this.mgr.addPropertyChangeListener(new ListenerFirer(this));
        }
        return this.mgr.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getModuleJars() {
        ArrayList arrayList;
        this.mgr.mutexPrivileged().enterReadAccess();
        try {
            Iterator iterator = this.mgr.getEnabledModules().iterator();
            ArrayList arrayList2 = new ArrayList();
            while (iterator.hasNext()) {
                arrayList2.addAll(((Module)((Object)iterator.next())).getAllJars());
            }
            arrayList = arrayList2;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mgr.mutexPrivileged().exitReadAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitReadAccess();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadBootModules() {
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startLoadBootModules");
        try {
            try {
                this.bootModules = new HashSet(10);
                ClassLoader classLoader = (class$org$netbeans$core$modules$ModuleSystem == null ? (class$org$netbeans$core$modules$ModuleSystem = ModuleSystem.class$("org.netbeans.core.modules.ModuleSystem")) : class$org$netbeans$core$modules$ModuleSystem).getClassLoader();
                Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
                this.ev.log("perfTick", "got all manifests");
                while (true) {
                    Object var8_9;
                    InputStream inputStream;
                    block15: {
                        block14: {
                            if (!enumeration.hasMoreElements()) {
                                if (this.list == null) {
                                    this.mgr.enable(this.bootModules);
                                }
                                this.ev.log("perfTick", "added all classpath modules");
                                break;
                            }
                            URL uRL = enumeration.nextElement();
                            inputStream = uRL.openStream();
                            try {
                                Manifest manifest;
                                block17: {
                                    block16: {
                                        manifest = new Manifest(inputStream);
                                        Attributes attributes = manifest.getMainAttributes();
                                        if (attributes.getValue("OpenIDE-Module") == null || attributes.getValue("OpenIDE-Archive-Locale") != null) break block16;
                                        if (attributes.getValue("OpenIDE-Archive-Branding") == null) break block17;
                                    }
                                    var8_9 = null;
                                    break block14;
                                }
                                this.bootModules.add(this.mgr.createFixed(manifest, uRL, classLoader));
                                break block15;
                            }
                            catch (Throwable throwable) {
                                var8_9 = null;
                                inputStream.close();
                                throw throwable;
                            }
                        }
                        inputStream.close();
                        continue;
                    }
                    var8_9 = null;
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
                Object var10_12 = null;
                this.ev.log("finishLoadBootModules");
                this.mgr.mutexPrivileged().exitWriteAccess();
                return;
            }
            catch (DuplicateException duplicateException) {
                Util.err.notify((Throwable)duplicateException);
                Object var10_13 = null;
                this.ev.log("finishLoadBootModules");
                this.mgr.mutexPrivileged().exitWriteAccess();
                return;
            }
            Object var10_11 = null;
            this.ev.log("finishLoadBootModules");
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.ev.log("finishLoadBootModules");
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readList() {
        this.ev.log("perfStart", "ModuleSystem.readList");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.list.upgradeCompatibly();
            this.list.readInitial();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
        this.ev.log("perfEnd", "ModuleSystem.readList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForNewAndRestore() {
        this.ev.log("perfStart", "ModuleSystem.scanForNewAndRestore");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.autoscanned = this.list.scan();
            this.ev.log("perfTick", "list scanned");
            HashSet<Module> hashSet = new HashSet<Module>(this.bootModules);
            Iterator iterator = this.autoscanned.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)((Object)iterator.next());
                Object object = module.getHistory();
                if (!(object instanceof ModuleHistory) || !((ModuleHistory)object).isPreviouslyInstalled()) continue;
                Util.err.log("#17723 fix active for " + (Object)((Object)module));
                iterator.remove();
                hashSet.add(module);
            }
            this.list.trigger(hashSet);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
        this.ev.log("perfEnd", "ModuleSystem.scanForNewAndRestore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installNew() {
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            if (!this.autoscanned.isEmpty()) {
                this.ev.log("startAutoInstall", this.autoscanned);
                this.list.installNew(this.autoscanned);
                this.ev.log("finishAutoInstall", this.autoscanned);
            }
            this.autoscanned = null;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown() {
        boolean bl;
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            bl = this.mgr.shutDown();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployTestModule(File file) throws IOException {
        if (!file.isAbsolute()) {
            throw new IOException("Absolute paths only please");
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startDeployTestModule", file);
        System.err.println("Deploying test module " + file + "...");
        try {
            Module module;
            Module module2 = null;
            HashSet hashSet = new HashSet();
            Iterator iterator = this.mgr.getModules().iterator();
            while (iterator.hasNext()) {
                module = (Module)((Object)iterator.next());
                if (!file.equals(module.getJarFile()) || module.isReloadable()) continue;
                module.setReloadable(true);
                this.turnOffModule(module, hashSet);
                this.mgr.reload(module);
                module2 = module;
                break;
            }
            if (module2 == null) {
                try {
                    module2 = this.mgr.create(file, new ModuleHistory(), true, false);
                }
                catch (DuplicateException duplicateException) {
                    Module module3 = duplicateException.getOldModule();
                    System.err.println("Replacing old module in " + module3.getJarFile());
                    this.turnOffModule(module3, hashSet);
                    this.mgr.delete(module3);
                    try {
                        module2 = this.mgr.create(file, new ModuleHistory(), true, false);
                    }
                    catch (DuplicateException duplicateException2) {
                        IOException iOException = new IOException(duplicateException2.toString());
                        Util.err.annotate((Throwable)iOException, (Throwable)duplicateException2);
                        throw iOException;
                    }
                }
            }
            System.err.println("Enabling " + module2.getJarFile() + "...");
            if (!this.mgr.simulateEnable(Collections.singleton(module2)).contains((Object)module2)) {
                throw new IOException("Cannot enable " + module2.getJarFile() + "; problems: " + module2.getProblems());
            }
            this.mgr.enable(module2);
            if (!hashSet.isEmpty()) {
                System.err.println("Also re-enabling:");
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    module = (Module)((Object)iterator.next());
                    System.err.println("\t" + module.getDisplayName());
                    if (!module.isReloadable()) continue;
                    module.reload();
                }
                try {
                    this.mgr.enable(hashSet);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IOException(illegalArgumentException.toString());
                }
            }
            System.err.println("Done.");
            Object var10_11 = null;
            this.ev.log("finishDeployTestModule", file);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.ev.log("finishDeployTestModule", file);
            this.mgr.mutexPrivileged().exitWriteAccess();
            throw throwable;
        }
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOffModule(Module module, Set set) {
        if (!module.isEnabled()) {
            return;
        }
        Iterator iterator = this.mgr.simulateDisable(Collections.singleton(module)).iterator();
        while (iterator.hasNext()) {
            Module module2 = (Module)((Object)iterator.next());
            if (module2.isAutoload()) continue;
            set.add(module2);
        }
        try {
            System.err.println("Disabling " + module.getJarFile() + "...");
            this.mgr.disable(set);
            Object var6_5 = null;
            set.remove((Object)module);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            set.remove((Object)module);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class TestModuleDeployerImpl
    extends TestModuleDeployer {
        private TestModuleDeployerImpl() {
        }

        public void deployTestModule(File file) throws IOException {
            NbTopManager.get().getModuleSystem().deployTestModule(file);
        }
    }
}

