/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class NbLabelA11y
extends JLabel {
    private boolean isFocusable = false;
    private boolean isFocused = false;

    public NbLabelA11y() {
    }

    public NbLabelA11y(String string) {
        this();
        this.setText(string);
    }

    public NbLabelA11y(boolean bl) {
        this();
        this.setA11yFocus(bl);
    }

    public NbLabelA11y(boolean bl, String string, String string2) {
        this(bl);
        this.setA11yContext(string, string2);
    }

    public void setA11yContext(String string, String string2) {
        if (string == "" && this.getAccessibleContext().getAccessibleName() == null && this.getText() != "") {
            this.getAccessibleContext().setAccessibleName(this.getText());
        }
        if (string2 == "" && this.getAccessibleContext().getAccessibleDescription() == null && this.getToolTipText() != "") {
            this.getAccessibleContext().setAccessibleDescription(this.getToolTipText());
        }
        if (string != "") {
            this.getAccessibleContext().setAccessibleName(string);
        }
        if (string2 != "") {
            this.getAccessibleContext().setAccessibleDescription(string2);
        }
    }

    public void setA11yFocus(boolean bl) {
        this.isFocusable = bl;
        this.setRequestFocusEnabled(bl);
        if (bl) {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    NbLabelA11y.this.isFocused = true;
                    NbLabelA11y.this.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    NbLabelA11y.this.isFocused = false;
                    NbLabelA11y.this.repaint();
                }
            });
        }
        this.repaint();
    }

    public void setA11yAll(boolean bl, String string, String string2) {
        this.setA11yFocus(bl);
        this.setA11yContext(string, string2);
    }

    public boolean isFocusTraversable() {
        return this.isFocusable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            try {
                this.ui.update(graphics, this);
                Object var3_2 = null;
                graphics.dispose();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                graphics.dispose();
                throw throwable;
            }
        }
        if (this.isFocused) {
            Dimension dimension = this.getSize();
            graphics.setColor(UIManager.getColor("Button.focus"));
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }
}

