/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.actions.SystemExit;
import org.netbeans.core.ui.WorkplaceNode;
import org.netbeans.core.windows.JdkBug4524015Hack;
import org.netbeans.core.windows.StatusLine;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.WorkspaceSwitcher;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.TopManager;
import org.openide.awt.MenuBar;
import org.openide.awt.ToolbarPool;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class MainWindow
extends JFrame {
    static final long serialVersionUID = -1160791973145645501L;
    public static final String ABOUT_TO_SHOW = "aboutToShow";
    private static MainWindow instance;
    private static WindowManagerImpl wm;
    private static WorkspaceSwitcher ws;
    private HelpCtx mainWindowHelp;
    private MenuBar menuBar;
    private JPanel toolbars;
    private transient Node projectNode = null;
    private transient NodeListener projectNameListener = null;
    private DesktopPane desktopPane;
    private PropertyChangeSupport propSupport;
    static /* synthetic */ Class class$org$netbeans$core$windows$MainWindow;
    static /* synthetic */ Class class$org$netbeans$core$actions$SystemExit;

    private MainWindow() {
        JdkBug4524015Hack.install();
    }

    static MainWindow getDefault() {
        if (instance == null) {
            instance = new MainWindow();
            wm = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
        }
        return instance;
    }

    public static WorkspaceSwitcher getSwitcher() {
        return ws;
    }

    public void initialize() {
        if (Boolean.getBoolean("netbeans.windows.small_main_window")) {
            this.menuBar = new StatusMenuBar();
        } else {
            this.menuBar = new MenuBar(null);
            this.menuBar.setBorderPainted(false);
        }
        ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(NbBundle.getLocalizedFile((String)("org.netbeans.core.resources.frames.ide" + (Utilities.isLargeFrameIcons() ? "32" : "")), (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = MainWindow.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow).getClassLoader())));
        this.setIconImage(imageIcon.getImage());
        this.projectNameListener = new NodeAdapter(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                    MainWindow.this.updateTitle();
                }
            }
        };
        TopManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("places".equals(propertyChangeEvent.getPropertyName())) {
                    if (MainWindow.this.projectNode != null) {
                        MainWindow.this.projectNode.removeNodeListener(MainWindow.this.projectNameListener);
                    }
                    MainWindow.this.projectNode = TopManager.getDefault().getPlaces().nodes().projectDesktop();
                    if (MainWindow.this.projectNode != null) {
                        MainWindow.this.projectNode.addNodeListener(MainWindow.this.projectNameListener);
                    }
                    MainWindow.this.updateTitle();
                }
            }
        });
        this.projectNode = TopManager.getDefault().getPlaces().nodes().projectDesktop();
        if (this.projectNode != null) {
            this.projectNode.addNodeListener(this.projectNameListener);
        }
        this.updateTitle();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((SystemExit)SharedClassObject.findObject((Class)(class$org$netbeans$core$actions$SystemExit == null ? (class$org$netbeans$core$actions$SystemExit = MainWindow.class$("org.netbeans.core.actions.SystemExit")) : class$org$netbeans$core$actions$SystemExit), (boolean)true)).performAction();
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (MainWindow.this.mainWindowHelp == null) {
                    MainWindow.this.mainWindowHelp = new HelpCtx(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = MainWindow.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow);
                    HelpCtx.setHelpIDString((JComponent)MainWindow.this.getRootPane(), (String)MainWindow.this.mainWindowHelp.getHelpID());
                }
            }
        });
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = MainWindow.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow)).getString("ACSD_MainWindow"));
    }

    public void showWindow() {
        if (this.menuBar == null) {
            this.initialize();
        }
        this.menuBar.waitFinished();
        if (!Boolean.getBoolean("netbeans.windows.small_main_window")) {
            ToolbarPool toolbarPool = ToolbarPool.getDefault();
            toolbarPool.waitFinished();
            toolbarPool.setConfiguration("Standard");
            this.toolbars = new JPanel();
            this.toolbars.setLayout(new BorderLayout());
            this.toolbars.add((Component)toolbarPool, "Center");
            if (!Boolean.getBoolean("netbeans.windows.nostatusline")) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                ws = new WorkspaceSwitcher(wm);
                jPanel.add(ws.getComponent(), "West");
                JComponent jComponent = StatusLine.createLabel();
                jPanel.add((Component)jComponent, "Center");
                this.toolbars.add((Component)jPanel, "South");
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.doShowWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.doShowWindow();
                }
            });
        }
    }

    private void doShowWindow() {
        Rectangle rectangle;
        this.setJMenuBar((JMenuBar)this.menuBar);
        if (!Boolean.getBoolean("netbeans.windows.small_main_window")) {
            this.getContentPane().add((Component)this.toolbars, "North");
        }
        wm.getCurrentWorkspace();
        if (!wm.isMainPositioned()) {
            this.pack();
        } else {
            rectangle = this.getBounds();
            this.pack();
            this.setBounds(rectangle);
            this.validate();
        }
        this.firePropertyChange(ABOUT_TO_SHOW, null, null);
        rectangle = this.getBounds();
        this.show();
        this.getRootPane().requestDefaultFocus();
    }

    void updateTitle() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = System.getProperty("netbeans.buildnumber");
                if (MainWindow.this.projectNode == null || MainWindow.this.projectNode.equals((Object)WorkplaceNode.getDefault())) {
                    MainWindow.this.setTitle(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = MainWindow.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow), (String)"CTL_MainWindow_Title_Project", (Object)string, (Object)NbBundle.getMessage((Class)(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = MainWindow.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow), (String)"CTL_NoProject")));
                } else {
                    MainWindow.this.setTitle(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$MainWindow == null ? (class$org$netbeans$core$windows$MainWindow = MainWindow.class$("org.netbeans.core.windows.MainWindow")) : class$org$netbeans$core$windows$MainWindow), (String)"CTL_MainWindow_Title_Project", (Object)string, (Object)MainWindow.this.projectNode.getDisplayName()));
                }
            }
        });
    }

    Point getDesktopScreenLocation() {
        Point point = new Point(0, 0);
        if (this.toolbars != null) {
            point.y += this.toolbars.getSize().height;
        }
        SwingUtilities.convertPointToScreen(point, this.getContentPane());
        return point;
    }

    Dimension getDesktopSize() {
        Dimension dimension = this.getContentPane().getSize();
        if (this.toolbars != null) {
            dimension = new Dimension(dimension.width, dimension.height - this.toolbars.getSize().height);
        }
        return dimension;
    }

    public void validate() {
        super.validate();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        Dimension dimension3 = this.getMaximumSize();
        final Dimension dimension4 = new Dimension(Math.min(dimension3.width, Math.max(dimension.width, dimension2.width)), Math.min(dimension3.height, Math.max(dimension.height, dimension2.height)));
        if (!dimension4.equals(dimension)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.setSize(dimension4);
                }
            });
        }
    }

    public Dimension getPreferredSize() {
        if (WindowUtils.isMdi()) {
            return Utilities.getScreenSize();
        }
        return new Dimension(Utilities.getScreenSize().width, super.getPreferredSize().height);
    }

    public Dimension getMinimumSize() {
        if (WindowUtils.isMdi()) {
            return new Dimension(320, 320);
        }
        return new Dimension(320, super.getPreferredSize().height);
    }

    public Dimension getMaximumSize() {
        if (WindowUtils.isMdi()) {
            return super.getMaximumSize();
        }
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        TopComponent topComponent;
        DesktopPane desktopPane = null;
        if (WindowUtils.isMdi() && (topComponent = TopComponent.getRegistry().getActivated()) != null && !this.equals(SwingUtilities.windowForComponent((Component)topComponent)) && windowEvent.getID() == 205) {
            desktopPane = ((WorkspaceImpl)wm.getCurrentWorkspace()).desktopPane();
            desktopPane.setAutoFocusEnabled(false);
        }
        super.processWindowEvent(windowEvent);
        if (desktopPane != null) {
            desktopPane.setAutoFocusEnabled(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class StatusMenuBar
    extends MenuBar {
        public StatusMenuBar() {
            super(null);
        }

        public void removeAll() {
            super.removeAll();
        }

        public void validate() {
            int n = this.getComponentCount();
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (this.getComponent(n2) instanceof StatusLine) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                this.add(new StatusLine());
            }
            super.validate();
        }
    }
}

