/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public final class PersistenceManager {
    public static final String ROOT_FOLDER = "Windows";
    public static final String COMPS_FOLDER = "Components";
    public static final String WINDOWMANAGER_FOLDER = "WindowManager";
    public static final int FOR_READING = 1;
    public static final int FOR_WRITING = 2;
    public static final String PERSISTENCE_TYPE = "PersistenceType";
    public static final String NEVER_PERSISTENT = "Never";
    public static final String ONLY_OPENED_PERSISTENT = "OnlyOpened";
    private static final String DEFAULT_TC_NAME = "untitled_tc";
    private FileObject readingRootFolder;
    private FileObject writingRootFolder;
    private FileObject readingCompsFolder;
    private FileObject writingCompsFolder;
    private FileObject readingWMFolder;
    private FileObject writingWMFolder;
    private WeakHashMap createdTCPairs;
    private Map createdStringIDPairs;
    private Set invalidIds;
    private FileSystem writingFS;
    private FileSystem readingFS;
    private boolean readProcessed = false;
    private Set removalCandidates;
    private boolean isSaveInProgress;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$PersistenceManager;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;

    PersistenceManager() {
    }

    public void setRootFolder(int n, String string) {
        if (n == 2) {
            this.writingRootFolder = this.getFileSystem(n).findResource(string);
            this.clearCache(n);
        } else if (n == 1) {
            this.readingRootFolder = this.getFileSystem(n).findResource(string);
            this.clearCache(n);
        } else {
            throw new IllegalArgumentException("Wrong persistence mode.");
        }
    }

    public FileObject getRootFolder(int n) {
        try {
            if (n == 1) {
                if (this.readingRootFolder == null) {
                    this.readingRootFolder = this.getFileSystem(n).getRoot().getFileObject(ROOT_FOLDER);
                    if (this.readingRootFolder == null) {
                        throw new IOException("Root winsys folder Windowsdoesn't exist on " + this.getFileSystem(n));
                    }
                }
                return this.readingRootFolder;
            }
            if (n == 2) {
                if (this.writingRootFolder == null) {
                    this.writingRootFolder = FileUtil.createFolder((FileObject)this.getFileSystem(n).getRoot(), (String)ROOT_FOLDER);
                }
                return this.writingRootFolder;
            }
            throw new IllegalArgumentException("Wrong persistence mode.");
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_RootFolder"), ROOT_FOLDER);
            TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, string);
            TopManager.getDefault().getErrorManager().notify(65536, (Throwable)iOException);
            return null;
        }
    }

    public FileObject getComponentsFolder(int n) {
        try {
            if (n == 1) {
                if (this.readingCompsFolder == null) {
                    this.readingCompsFolder = this.getRootFolder(n).getFileObject(COMPS_FOLDER);
                    if (this.readingCompsFolder == null) {
                        throw new IOException("Root winsys folder Componentsdoesn't exist on " + this.getFileSystem(n));
                    }
                }
                return this.readingCompsFolder;
            }
            if (n == 2) {
                if (this.writingCompsFolder == null) {
                    this.writingCompsFolder = FileUtil.createFolder((FileObject)this.getRootFolder(n), (String)COMPS_FOLDER);
                }
                return this.writingCompsFolder;
            }
            throw new IllegalArgumentException("Wrong persistence mode.");
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_CompsFolder"), COMPS_FOLDER);
            TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, string);
            TopManager.getDefault().getErrorManager().notify(65536, (Throwable)iOException);
            return null;
        }
    }

    public FileObject getWindowManagerFolder(int n) {
        try {
            if (n == 1) {
                if (this.readingWMFolder == null) {
                    this.readingWMFolder = this.getRootFolder(n).getFileObject(WINDOWMANAGER_FOLDER);
                    if (this.readingWMFolder == null) {
                        throw new IOException("Root winsys folder WindowManagerdoesn't exist on " + this.getFileSystem(n));
                    }
                }
                return this.readingWMFolder;
            }
            if (n == 2) {
                if (this.writingWMFolder == null) {
                    this.writingWMFolder = FileUtil.createFolder((FileObject)this.getRootFolder(n), (String)WINDOWMANAGER_FOLDER);
                    StringBuffer stringBuffer = new StringBuffer(WINDOWMANAGER_FOLDER);
                    stringBuffer.append('.');
                    stringBuffer.append("wswmgr");
                    FileUtil.createData((FileObject)this.getRootFolder(n), (String)stringBuffer.toString());
                }
                return this.writingWMFolder;
            }
            throw new IllegalArgumentException("Wrong persistence mode.");
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_WindowManagerFolder"), WINDOWMANAGER_FOLDER);
            TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, string);
            TopManager.getDefault().getErrorManager().notify(65536, (Throwable)iOException);
            return null;
        }
    }

    public void cleanXML() throws IOException {
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
        Workspace[] workspaceArray = windowManagerImpl.getWorkspaces();
        int n = 0;
        while (n < workspaceArray.length) {
            Set set = workspaceArray[n].getModes();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXML() throws IOException {
        if (!this.readProcessed) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)this.getWindowManagerFolder(1));
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PersistenceManager.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            this.isSaveInProgress = true;
            if (saveCookie != null) {
                this.forceSaveOfTopComponents();
                saveCookie.save();
                this.cleanupComponents();
            } else {
                Throwable throwable = new Throwable("Window system could not be saved.");
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.log(4096, "No save cookie for window system.");
                errorManager.log(4096, "DataObject: " + dataObject);
                errorManager.log(4096, "FileObject: " + this.getWindowManagerFolder(1));
                errorManager.notify(throwable);
            }
            Object var6_5 = null;
            this.isSaveInProgress = false;
            WindowManagerImpl.getDefault().checkPersistenceErrors(false);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.isSaveInProgress = false;
            WindowManagerImpl.getDefault().checkPersistenceErrors(false);
            throw throwable;
        }
    }

    public boolean isSaveInProgress() {
        return this.isSaveInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXML() throws IOException, ClassNotFoundException {
        this.readProcessed = true;
        try {
            DataObject dataObject = DataObject.find((FileObject)this.getWindowManagerFolder(1));
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PersistenceManager.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (instanceCookie == null) {
                Object var4_3 = null;
                WindowManagerImpl.getDefault().checkPersistenceErrors(true);
                return;
            }
            instanceCookie.instanceCreate();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            WindowManagerImpl.getDefault().checkPersistenceErrors(true);
            throw throwable;
        }
        Object var4_4 = null;
        WindowManagerImpl.getDefault().checkPersistenceErrors(true);
    }

    public String lookupTCStringId(TopComponent topComponent) throws IOException {
        String string = (String)this.createdTCPairs().get(topComponent);
        if (this.isInvalidId(string)) {
            return this.restorePair(topComponent, string, true);
        }
        if (string != null) {
            return string;
        }
        return this.createNewPair(topComponent);
    }

    public String lookupIdWithoutCreation(TopComponent topComponent) throws IOException {
        String string = (String)this.createdTCPairs().get(topComponent);
        if (this.isInvalidId(string)) {
            string = this.restorePair(topComponent, string, false);
        }
        return string;
    }

    public TopComponent lookupTCInstance(String string) throws IOException {
        Object object;
        Object object2;
        WeakReference weakReference = (WeakReference)this.createdStringIDPairs().get(string);
        if (weakReference != null) {
            object2 = (TopComponent)weakReference.get();
            if (object2 != null) {
                return object2;
            }
            this.createdStringIDPairs().remove(string);
            this.removalCandidates().add(string);
        }
        object2 = null;
        String string2 = null;
        Object object3 = PersistenceManager.locateTCRef(this.getComponentsFolder(1), string);
        if (object3 != null) {
            object = object3 instanceof DataObject ? (DataObject)object3 : DataObject.find((FileObject)((FileObject)object3));
            InstanceCookie instanceCookie = (InstanceCookie)object.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PersistenceManager.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (instanceCookie != null) {
                try {
                    TopComponent topComponent = (TopComponent)instanceCookie.instanceCreate();
                    this.createdTCPairs().put(topComponent, string);
                    this.createdStringIDPairs().put(string, new WeakReference<TopComponent>(topComponent));
                    return topComponent;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object2 = classNotFoundException;
                }
                catch (ClassCastException classCastException) {
                    string2 = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_BrokenTCSetting"), string);
                    object2 = classCastException;
                }
            } else {
                string2 = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_BrokenTCSetting"), string);
            }
        }
        if (string2 == null) {
            string2 = MessageFormat.format(NbBundle.getBundle(this.getClass()).getString("EXC_FailedLocateTC"), string);
        }
        object = new IOException(string2);
        if (object2 != null) {
            TopManager.getDefault().getErrorManager().annotate((Throwable)object, (Throwable)object2);
        }
        throw object;
    }

    private static Object locateTCRef(FileObject fileObject, String string) throws IOException {
        DataFolder dataFolder;
        FileObject fileObject2 = fileObject.getFileObject(string, "settings");
        if (fileObject2 != null) {
            return fileObject2;
        }
        fileObject2 = fileObject.getFileObject(string, "ser");
        if (fileObject2 != null) {
            return fileObject2;
        }
        fileObject2 = fileObject.getFileObject(string, "xml");
        if (fileObject2 != null) {
            return fileObject2;
        }
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            dataFolder = DataObject.find((FileObject)fileObject2);
            if (!dataFolder.getName().equals(string)) continue;
            return dataFolder;
        }
        dataFolder = DataFolder.findFolder((FileObject)fileObject);
        enumeration = dataFolder.children();
        while (enumeration.hasMoreElements()) {
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (!dataObject.getName().equals(string)) continue;
            return dataObject;
        }
        return null;
    }

    public boolean isPersistent(TopComponent topComponent, String string, Workspace workspace) {
        String string2 = (String)topComponent.getClientProperty((Object)PERSISTENCE_TYPE);
        if (NEVER_PERSISTENT.equals(string2) || ONLY_OPENED_PERSISTENT.equals(string2) && !topComponent.isOpened(workspace)) {
            if (string != null) {
                this.removalCandidates().add(string);
            }
            return false;
        }
        return true;
    }

    private void cleanupComponents() {
        String string = null;
        Map map = this.createdStringIDPairs();
        String[] stringArray = map.keySet().toArray(new String[0]);
        Object var4_4 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (((WeakReference)map.get(stringArray[n])).get() == null) {
                this.createdStringIDPairs().remove(stringArray[n]);
                this.removalCandidates().add(stringArray[n]);
            }
            ++n;
        }
        FileObject fileObject = null;
        Iterator iterator = this.removalCandidates().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            fileObject = this.findTcRef(this.getWindowManagerFolder(1), string);
            if (fileObject != null) continue;
            try {
                Object object = PersistenceManager.locateTCRef(this.getComponentsFolder(1), string);
                if (object != null && object instanceof DataObject) {
                    ((DataObject)object).delete();
                    continue;
                }
                if (object == null) continue;
                DataObject.find((FileObject)((FileObject)object)).delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.removalCandidates().clear();
    }

    void forceSaveOfTopComponents() {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)this.getComponentsFolder(2));
        HashMap hashMap = new HashMap(this.createdStringIDPairs());
        TopComponent topComponent = null;
        Map.Entry entry = null;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            topComponent = (TopComponent)((WeakReference)entry.getValue()).get();
            if (topComponent == null) continue;
            try {
                InstanceDataObject.create((DataFolder)dataFolder, (String)((String)entry.getKey()), (Object)topComponent, null);
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify(16, (Throwable)iOException);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                String string = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$PersistenceManager == null ? PersistenceManager.class$("org.netbeans.core.windows.PersistenceManager") : class$org$netbeans$core$windows$PersistenceManager), (String)"EXC_CannotSaveTCSettings", (Object)topComponent.getName());
                TopManager.getDefault().getErrorManager().annotate(throwable, string);
                TopManager.getDefault().getErrorManager().notify(1, throwable);
            }
        }
    }

    private FileObject findTcRef(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getFileObject(string, "wstcref");
        if (fileObject2 != null) {
            return fileObject2;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        int n = 0;
        while (n < fileObjectArray.length) {
            if (fileObjectArray[n].isFolder() && (fileObject2 = this.findTcRef(fileObjectArray[n], string)) != null) {
                return fileObject2;
            }
            ++n;
        }
        return null;
    }

    private Set removalCandidates() {
        if (this.removalCandidates == null) {
            this.removalCandidates = new HashSet(20);
        }
        return this.removalCandidates;
    }

    private FileSystem getFileSystem(int n) {
        if (n == 2) {
            if (this.writingFS == null) {
                this.writingFS = Repository.getDefault().getDefaultFileSystem();
            }
            return this.writingFS;
        }
        if (n == 1) {
            if (this.readingFS == null) {
                this.readingFS = Repository.getDefault().getDefaultFileSystem();
            }
            return this.readingFS;
        }
        throw new IllegalArgumentException("Wrong persistence mode.");
    }

    private void clearCache(int n) {
        if (n == 2) {
            this.writingCompsFolder = null;
            this.writingWMFolder = null;
        } else if (n == 1) {
            this.readingCompsFolder = null;
            this.readingWMFolder = null;
        }
    }

    private static String convertString2ValidFileName(String string) {
        String string2 = string.replace('/', '_');
        string2 = string2.replace('\\', '_');
        string2 = string2.replace('[', '_');
        string2 = string2.replace(']', '_');
        string2 = string2.replace(' ', '_');
        return string2;
    }

    private static String escape(String string) throws IOException {
        try {
            Method method = (class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = PersistenceManager.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject).getDeclaredMethod("escapeAndCut", class$java$lang$String == null ? (class$java$lang$String = PersistenceManager.class$("java.lang.String")) : class$java$lang$String);
            method.setAccessible(true);
            return (String)method.invoke(null, (Object[])new String[]{string});
        }
        catch (Exception exception) {
            throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException("Escape support failed"), (Throwable)exception);
        }
    }

    private String createNewPair(TopComponent topComponent) throws IOException {
        String string;
        String string2;
        DataFolder dataFolder = DataFolder.findFolder((FileObject)this.getComponentsFolder(2));
        String string3 = topComponent.getName();
        if (string3 == null || string3.length() == 0) {
            string3 = DEFAULT_TC_NAME;
        }
        boolean bl = true;
        String string4 = string3;
        int n = 1;
        while (bl) {
            bl = false;
            string2 = PersistenceManager.escape(string4);
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)string2, (String)"settings");
            if ((this.invalidIds == null || !this.invalidIds.contains(string)) && string2.equals(string)) continue;
            bl = true;
            string4 = string3 + "_" + n;
            ++n;
        }
        string2 = InstanceDataObject.create((DataFolder)dataFolder, (String)string4, (Object)topComponent, null);
        string = string2.getPrimaryFile().getName();
        this.createdTCPairs().put(topComponent, string);
        this.createdStringIDPairs().put(string, new WeakReference<TopComponent>(topComponent));
        return string;
    }

    private String restorePair(TopComponent topComponent, String string, boolean bl) throws IOException {
        FileObject fileObject = this.getComponentsFolder(2).getFileObject(string, "settings");
        if (fileObject != null) {
            this.createdTCPairs().put(topComponent, string);
            this.createdStringIDPairs().put(string, new WeakReference<TopComponent>(topComponent));
            this.validateId(string);
            return string;
        }
        if (bl) {
            return this.createNewPair(topComponent);
        }
        return null;
    }

    private Map createdTCPairs() {
        if (this.createdTCPairs == null) {
            this.createdTCPairs = new WeakHashMap(30);
        }
        return this.createdTCPairs;
    }

    private Map createdStringIDPairs() {
        if (this.createdStringIDPairs == null) {
            this.createdStringIDPairs = Collections.synchronizedMap(new HashMap(30));
        }
        return this.createdStringIDPairs;
    }

    void resetTCPairs() {
        if (this.createdTCPairs != null) {
            this.invalidIds = new HashSet(this.createdTCPairs.values());
        }
        this.createdStringIDPairs = null;
    }

    private boolean isInvalidId(String string) {
        return this.invalidIds == null ? false : this.invalidIds.contains(string);
    }

    private void validateId(String string) {
        if (this.invalidIds != null) {
            this.invalidIds.remove(string);
            if (this.invalidIds.size() == 0) {
                this.invalidIds = null;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

