/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.util.WindowUtils;

final class StateManager
extends ComponentAdapter
implements PropertyChangeListener {
    public static final int READY = 32;
    public static final int SERIALIZING = 64;
    public static final int DESERIALIZING = 128;
    public static final int SWITCHING = 256;
    public static final int VISIBLE = 1;
    public static final int INVISIBLE = 2;
    public static final int NOT_PRESENT = 4;
    private int mainState;
    private int visibilityState;
    private HashSet listeners;
    private boolean initialized = false;

    StateManager() {
    }

    private void initialize() {
        this.mainState = 32;
        if (NbTopManager.get().isInteractive(1)) {
            MainWindow mainWindow = WindowManagerImpl.mainWindow();
            this.visibilityState = mainWindow.isVisible() ? 1 : 2;
            mainWindow.addComponentListener(this);
            mainWindow.addPropertyChangeListener("aboutToShow", this);
        } else {
            this.visibilityState = 4;
        }
    }

    public synchronized void addStateListener(StateListener stateListener) {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        if (this.listeners == null) {
            this.listeners = new HashSet(10);
        }
        this.listeners.add(stateListener);
    }

    public synchronized void removeStateListener(StateListener stateListener) {
        if (this.listeners != null) {
            this.listeners.remove(stateListener);
        }
    }

    public int getState() {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        return this.mainState | this.visibilityState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStateChanged(int n) {
        if (this.listeners == null) {
            return;
        }
        HashSet hashSet = null;
        StateManager stateManager = this;
        synchronized (stateManager) {
            hashSet = (HashSet)this.listeners.clone();
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((StateListener)iterator.next()).stateChanged(n);
        }
    }

    void setMainState(int n) {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
        if (n == this.mainState) {
            return;
        }
        this.mainState = n;
        this.fireStateChanged(this.mainState | this.visibilityState);
    }

    private void setVisibilityState(int n) {
        if (this.visibilityState == n) {
            return;
        }
        this.visibilityState = n;
        this.fireStateChanged(this.mainState | this.visibilityState);
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.setVisibilityState(2);
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.setVisibilityState(1);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        WindowManagerImpl.mainWindow().removePropertyChangeListener("aboutToShow", this);
        if (WindowUtils.isMdi()) {
            this.setVisibilityState(1);
        }
    }

    static interface StateListener {
        public void stateChanged(int var1);
    }
}

