/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.core.IDESettings;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.WindowTypesManager;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.TopManager;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.windows.Workspace;

public final class UIModeManager
implements PropertyChangeListener {
    public static final int SDI_MODE = 1;
    public static final int MDI_MODE = 2;
    public static final int DIALOG_SDI_MODE = 4;
    private Map uiModes2Frames;
    private Map names2Modes;
    private IDESettings ideSettings;
    private boolean inProgress;
    static /* synthetic */ Class class$org$netbeans$core$IDESettings;
    static /* synthetic */ Class class$org$netbeans$core$windows$UIModeManager;

    public void setUIMode(int n) {
        this.setUIMode(n, true, true);
    }

    public void setUIMode(int n, boolean bl) {
        this.setUIMode(n, bl, true);
    }

    public void setUIMode(int n, boolean bl, boolean bl2) {
        if (this.getUIMode() == n) {
            return;
        }
        this.inProgress = true;
        this.ideSettings.setUIMode(n);
        WindowTypesManager.setDefaultFrame((String)this.uiModes2Frames().get(new Integer(n)));
        if (bl) {
            this.updateAll(bl2);
        } else if (bl2) {
            this.changeModeFrameTypes();
        }
        this.inProgress = false;
    }

    public int getUIMode() {
        if (this.ideSettings == null) {
            this.ideSettings = (IDESettings)SystemOption.findObject((Class)(class$org$netbeans$core$IDESettings == null ? (class$org$netbeans$core$IDESettings = UIModeManager.class$("org.netbeans.core.IDESettings")) : class$org$netbeans$core$IDESettings), (boolean)true);
            String string = System.getProperty("netbeans.windows");
            if ("mdi".equalsIgnoreCase(string)) {
                this.setUIMode(2);
            } else if ("sdi".equalsIgnoreCase(string)) {
                this.setUIMode(1);
            } else {
                WindowTypesManager.setDefaultFrame((String)this.uiModes2Frames().get(new Integer(this.ideSettings.getUIMode())));
            }
            this.ideSettings.addPropertyChangeListener(this);
        }
        return this.ideSettings.getUIMode();
    }

    public void updateAll() {
        this.updateAll(true);
    }

    public void changeModeFrameTypes() {
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
        Workspace[] workspaceArray = windowManagerImpl.getWorkspacesNoLoad();
        if (workspaceArray == null) {
            return;
        }
        List list = null;
        ModeImpl modeImpl = null;
        int n = 0;
        while (n < workspaceArray.length) {
            list = ((WorkspaceImpl)workspaceArray[n]).getLoadedModeArray();
            int n2 = 0;
            while (n2 < list.size()) {
                modeImpl = (ModeImpl)list.get(n2);
                modeImpl.setFrameType(this.findFrameType(modeImpl));
                ++n2;
            }
            ++n;
        }
    }

    public final Map getModeNames() {
        if (this.names2Modes == null) {
            this.names2Modes = new HashMap(10);
            this.names2Modes.put(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$UIModeManager == null ? (class$org$netbeans$core$windows$UIModeManager = UIModeManager.class$("org.netbeans.core.windows.UIModeManager")) : class$org$netbeans$core$windows$UIModeManager)).getString("CTL_SdiMode"), new Integer(1));
            this.names2Modes.put(NbBundle.getBundle((Class)(class$org$netbeans$core$windows$UIModeManager == null ? (class$org$netbeans$core$windows$UIModeManager = UIModeManager.class$("org.netbeans.core.windows.UIModeManager")) : class$org$netbeans$core$windows$UIModeManager)).getString("CTL_MdiMode"), new Integer(2));
        }
        return this.names2Modes;
    }

    String findFrameType(ModeImpl modeImpl) {
        int n = this.getUIMode();
        Object object = modeImpl.getConstraints();
        String string = WindowUtils.convertFrameType(n, object);
        return string;
    }

    private void updateAll(boolean bl) {
        WindowManagerImpl windowManagerImpl = (WindowManagerImpl)TopManager.getDefault().getWindowManager();
        WorkspaceImpl workspaceImpl = (WorkspaceImpl)windowManagerImpl.getCurrentWorkspace();
        if (workspaceImpl == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.uiModeUpdater(workspaceImpl, bl).run();
        } else {
            SwingUtilities.invokeLater(this.uiModeUpdater(workspaceImpl, bl));
        }
    }

    public Runnable uiModeUpdater(final WorkspaceImpl workspaceImpl, final boolean bl) {
        return new Runnable(){

            public void run() {
                workspaceImpl.setVisible(false);
                if (bl) {
                    UIModeManager.this.changeModeFrameTypes();
                }
                WindowManagerImpl.mainWindow().pack();
                workspaceImpl.setVisible(true);
            }
        };
    }

    private Map uiModes2Frames() {
        if (this.uiModes2Frames == null) {
            this.uiModes2Frames = new HashMap(10);
            this.uiModes2Frames.put(new Integer(1), "org.netbeans.core.windows.frames.TopFrameTypeImpl");
            this.uiModes2Frames.put(new Integer(2), "org.netbeans.core.windows.frames.InternalFrameTypeImpl");
        }
        return this.uiModes2Frames;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ((string == null || "UIMode".equals(string)) && !this.inProgress) {
            WindowTypesManager.setDefaultFrame((String)this.uiModes2Frames().get(new Integer(this.getUIMode())));
            this.updateAll();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

