/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.PerimeterLayout;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.windows.TopComponent;

class WorkspaceBoundsManager {
    public static final int DEFAULT_MODE_WIDTH = 500;
    public static final int DEFAULT_MODE_HEIGHT = 350;
    private static Rectangle lastMainBounds;
    private WorkspaceImpl workspace;
    private WindowManagerImpl wm;
    private Dimension cascadeStep;
    private int cascadeStepsCount;
    private Point cascadePoint;
    private Point cascadingOrigin;

    WorkspaceBoundsManager(WorkspaceImpl workspaceImpl) {
        this.workspace = workspaceImpl;
        this.wm = WindowManagerImpl.getDefault();
    }

    public void copyFrom(WorkspaceBoundsManager workspaceBoundsManager) {
        this.cascadeStep = new Dimension(workspaceBoundsManager.getCascadeStep());
        this.cascadeStepsCount = workspaceBoundsManager.getCascadeStepsCount();
        Point point = workspaceBoundsManager.getCascadePoint();
        this.cascadePoint = point == null ? null : new Point(point);
    }

    public Point getCascadingOrigin() {
        if (this.cascadingOrigin == null) {
            this.cascadingOrigin = new Point(0, 0);
        }
        return this.cascadingOrigin;
    }

    public void setCascadingOrigin(Point point) {
        this.cascadingOrigin = point;
        this.recomputeCascadePoint();
    }

    public Dimension getCascadeStep() {
        if (this.cascadeStep == null) {
            this.cascadeStep = new Dimension(20, 20);
        }
        return this.cascadeStep;
    }

    public void setCascadeStep(Dimension dimension) {
        this.cascadeStep = dimension;
    }

    public int getCascadeStepsCount() {
        return this.cascadeStepsCount;
    }

    public void setCascadeStepsCount(int n) {
        this.cascadeStepsCount = n;
    }

    public Point getCascadePoint() {
        Frame frame = this.wm.getMainWindow();
        Rectangle rectangle = frame.getBounds();
        if (lastMainBounds == null) {
            lastMainBounds = rectangle;
        }
        if (this.cascadeStepsCount <= 0 || WindowUtils.isMdi()) {
            this.cascadePoint = null;
        }
        if (this.cascadePoint == null || !lastMainBounds.equals(rectangle) || rectangle.width == 0 && rectangle.height == 0) {
            this.recomputeCascadePoint();
            lastMainBounds = rectangle;
        }
        return this.cascadePoint;
    }

    void setCascadePoint(Point point) {
        this.cascadePoint = point;
    }

    public void correctBounds() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.wm.getOldScreenSize();
        if (dimension2 == null || dimension.equals(dimension2)) {
            return;
        }
        List list = this.workspace.getModeArray();
        ModeImpl modeImpl = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            modeImpl = (ModeImpl)iterator.next();
            Rectangle rectangle = modeImpl.getBounds();
            if (rectangle == null) continue;
            Rectangle rectangle2 = new Rectangle(rectangle);
            WindowUtils.convertRectangle(rectangle2, dimension2, dimension);
            if (!WindowUtils.isMdi()) {
                this.removeMainWindowOverlapping(rectangle2);
            }
            modeImpl.setBounds(rectangle2);
        }
    }

    public Rectangle getWorkingSpaceBounds() {
        Cloneable cloneable;
        MainWindow mainWindow = WindowManagerImpl.mainWindow();
        Rectangle rectangle = mainWindow.getBounds();
        if (WindowUtils.isMdi()) {
            cloneable = mainWindow.getDesktopSize();
            if (cloneable.width != 0 && cloneable.height != 0) {
                return new Rectangle(0, 0, cloneable.width, cloneable.height);
            }
        }
        rectangle.height = mainWindow.getPreferredSize().height;
        cloneable = null;
        int n = WindowUtils.getTaskbarHeight();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        cloneable = rectangle.y < dimension.height / 2 ? new Rectangle(0, rectangle.y + rectangle.height, dimension.width, dimension.height - n - (rectangle.y + rectangle.height)) : new Rectangle(0, 0, dimension.width, rectangle.y);
        return cloneable;
    }

    public void placeMode(ModeImpl modeImpl, TopComponent topComponent) {
        Dimension dimension;
        if (modeImpl.getBounds() != null) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        Point point = this.getCascadePoint();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        rectangle.x = point.x;
        rectangle.y = point.y;
        Dimension dimension3 = topComponent.getPreferredSize();
        if (dimension3 == null || dimension3.width == 0 && dimension3.height == 0) {
            rectangle.width = Math.min(500, dimension2.width - rectangle.x);
            rectangle.height = Math.min(350, dimension2.height - rectangle.y);
        } else {
            dimension = "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(modeImpl.getFrameType()) ? this.workspace.desktopPane().getComponentAt("CENTER").getSize() : dimension2;
            rectangle.width = Math.min(dimension3.width, dimension.width - rectangle.x);
            rectangle.height = Math.min(dimension3.height, dimension.height - rectangle.y);
        }
        dimension = this.getCascadeStep();
        ++this.cascadeStepsCount;
        modeImpl.setBounds(rectangle);
    }

    public Point getDesktopScreenLocation() {
        ModeImpl modeImpl;
        Point point = WindowManagerImpl.mainWindow().getDesktopScreenLocation();
        ModeImpl modeImpl2 = WindowUtils.findConstrainedMode(this.workspace, "WEST", true);
        int n = ((PerimeterLayout)this.workspace.desktopPane().getLayout()).getGap();
        if (modeImpl2 != null) {
            point.x += modeImpl2.getBounds().width + n;
        }
        if ((modeImpl = WindowUtils.findConstrainedMode(this.workspace, "NORTH", true)) != null) {
            point.y += modeImpl.getBounds().height + n;
        }
        return point;
    }

    private void removeMainWindowOverlapping(Rectangle rectangle) {
        Rectangle rectangle2 = this.wm.getOldMainWindowBounds();
        if (rectangle.y > rectangle2.y && rectangle.y < rectangle2.y + rectangle2.height) {
            rectangle.y = rectangle2.y + rectangle2.height;
        }
    }

    private void recomputeCascadePoint() {
        Rectangle rectangle = this.getWorkingSpaceBounds();
        Point point = this.getCascadingOrigin();
        Dimension dimension = this.getCascadeStep();
        if (this.cascadeStepsCount * dimension.width > rectangle.width / 2 || this.cascadeStepsCount * dimension.height > rectangle.height / 2) {
            this.cascadeStepsCount = 0;
        }
        this.cascadePoint = new Point(rectangle.x + point.x * rectangle.width / 100 + this.cascadeStepsCount * dimension.width, rectangle.y + point.y * rectangle.height / 100 + this.cascadeStepsCount * dimension.height);
    }
}

