/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceExplorerDialog;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.Workspace;

class WorkspaceExplorerPanel
extends JPanel {
    private WorkspaceExplorerDialog wed;
    protected DefaultMutableTreeNode top;
    private ImageIcon curIcon = null;
    private Image modeIcon = null;
    private int nodeOrder;
    private static String DEFAULT_FOLDER = "/org/openide/resources/defaultFolder.gif";
    private static String DEFAULT_OPEN_FOLDER = "/org/openide/resources/defaultOpenFolder.gif";
    private static String DEFAULT_WORKSPACE_ICON = "/org/netbeans/core/resources/workspaces.gif";
    private static String DEFAULT_MODE_ICON = "/org/netbeans/core/resources/window.gif";
    private static ResourceBundle bundle;
    private JScrollPane listScrollPane1;
    private JTree listOfActive;
    private JLabel modesInWorkspaces;
    static /* synthetic */ Class class$org$netbeans$core$windows$WorkspaceExplorerPanel;

    protected WorkspaceExplorerPanel(WorkspaceExplorerDialog workspaceExplorerDialog) {
        this.wed = workspaceExplorerDialog;
        this.initComponents();
        this.setPreferredSize(this.getPreferredSize());
        this.updateTreeScrollPane();
        this.listOfActive.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.listOfActive);
        this.listOfActive.setCellRenderer(new weTreeRenderer());
        this.listOfActive.addKeyListener(workspaceExplorerDialog.weKeyListener());
        this.listOfActive.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)WorkspaceExplorerPanel.this.listOfActive.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                if (defaultMutableTreeNode.isLeaf()) {
                    NodeInfo nodeInfo = (NodeInfo)object;
                } else {
                    NodeInfo nodeInfo = (NodeInfo)object;
                }
            }
        });
        this.modesInWorkspaces.setLabelFor(this.listOfActive);
    }

    private static Image giveMeIcon(String string) {
        return Utilities.loadImage((String)string);
    }

    public void requestFocus() {
        this.listOfActive.requestFocus();
    }

    private void updateTreeScrollPane() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(WorkspaceExplorerPanel.bundle().getString("CTL_rootOfWorkspaces"));
        this.createTreeContent(defaultMutableTreeNode);
        this.listOfActive = new JTree(defaultMutableTreeNode);
        this.listOfActive.setRootVisible(false);
        this.listScrollPane1.setViewportView(this.listOfActive);
        this.listOfActive.requestDefaultFocus();
        this.setSelectedObject();
    }

    private void setSelectedObject() {
        Workspace workspace = WindowManagerImpl.getDefault().getCurrentWorkspace();
        Workspace[] workspaceArray = WindowManagerImpl.getDefault().getWorkspaces();
        int n = 0;
        while (n < WindowManagerImpl.getDefault().getWorkspaces().length) {
            if (workspaceArray[n] == workspace) {
                this.listOfActive.setSelectionInterval(n, n);
            }
            ++n;
        }
    }

    protected void createTreeContent(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object var2_2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Workspace[] workspaceArray = WindowManagerImpl.getDefault().getWorkspaces();
        this.nodeOrder = 0;
        int n = 0;
        while (n < workspaceArray.length) {
            this.curIcon = new ImageIcon(WorkspaceExplorerPanel.giveMeIcon(DEFAULT_WORKSPACE_ICON));
            String string = Actions.cutAmpersand((String)workspaceArray[n].getDisplayName());
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(new NodeInfo(1, string, n + 1 + "." + WorkspaceExplorerPanel.bundle().getString("CTL_Workspace") + string, this.nodeOrder, n, 0, this.curIcon));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.createChildren(workspaceArray[n], defaultMutableTreeNode2, n);
            ++this.nodeOrder;
            ++n;
        }
    }

    void createChildren(Workspace workspace, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        ModeImpl[] modeImplArray = workspace.getModes().toArray(new ModeImpl[0]);
        int n2 = 0;
        while (n2 < modeImplArray.length) {
            if (!modeImplArray[n2].isOrphan()) {
                this.modeIcon = modeImplArray[n2].getIcon();
                this.curIcon = new ImageIcon(this.modeIcon != null ? this.modeIcon : WorkspaceExplorerPanel.giveMeIcon(DEFAULT_MODE_ICON));
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new NodeInfo(2, modeImplArray[n2].getDisplayName(), n2 + 1 + "." + WorkspaceExplorerPanel.bundle().getString("CTL_Mode") + modeImplArray[n2].getDisplayName(), this.nodeOrder, n, n2, this.curIcon));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                ++this.nodeOrder;
            }
            ++n2;
        }
    }

    DefaultMutableTreeNode getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.listOfActive.getLastSelectedPathComponent();
        return defaultMutableTreeNode;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    private void initComponents() {
        this.listScrollPane1 = new JScrollPane();
        this.listOfActive = new JTree();
        this.modesInWorkspaces = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(400, 300));
        this.setName(ResourceBundle.getBundle("org/netbeans/core/windows/Bundle").getString("CTL_WorkExplorer"));
        this.setMinimumSize(new Dimension(400, 300));
        this.listScrollPane1.setViewportView(this.listOfActive);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 12, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listScrollPane1, gridBagConstraints);
        this.modesInWorkspaces.setText(ResourceBundle.getBundle("org/netbeans/core/windows/Bundle").getString("LBL_ChooseWorkspace"));
        this.modesInWorkspaces.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 5, 10);
        this.add((Component)this.modesInWorkspaces, gridBagConstraints);
    }

    private void showOnStartupCheckBoxActionPerformed(ActionEvent actionEvent) {
    }

    protected static final ResourceBundle bundle() {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$windows$WorkspaceExplorerPanel == null ? (class$org$netbeans$core$windows$WorkspaceExplorerPanel = WorkspaceExplorerPanel.class$("org.netbeans.core.windows.WorkspaceExplorerPanel")) : class$org$netbeans$core$windows$WorkspaceExplorerPanel));
        }
        return bundle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class NodeInfo {
        public int nodeType;
        public String nodeName;
        public String nodeDesc;
        public int nodeOrder;
        public int nodeWorkspaceOrder;
        public int nodeModeOrder;
        public ImageIcon nodeIcon;

        protected NodeInfo(int n, String string, String string2, int n2, int n3, int n4, ImageIcon imageIcon) {
            this.nodeType = n;
            this.nodeName = string;
            this.nodeDesc = string2;
            this.nodeOrder = n2;
            this.nodeWorkspaceOrder = n3;
            this.nodeModeOrder = n4;
            this.nodeIcon = imageIcon;
        }

        public String toString() {
            return this.nodeName;
        }
    }

    private class weTreeRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon modeIcon;

        private weTreeRenderer() {
            this.setClosedIcon(new ImageIcon(this.getClass().getResource(DEFAULT_WORKSPACE_ICON)));
            this.setOpenIcon(new ImageIcon(this.getClass().getResource(DEFAULT_WORKSPACE_ICON)));
            this.modeIcon = new ImageIcon(this.getClass().getResource(DEFAULT_MODE_ICON));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(this.getNodeInfo((Object)object).nodeIcon);
            this.setToolTipText(this.getNodeInfo((Object)object).nodeDesc);
            return this;
        }

        protected NodeInfo getNodeInfo(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            NodeInfo nodeInfo = (NodeInfo)defaultMutableTreeNode.getUserObject();
            return nodeInfo;
        }
    }
}

