/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.LayoutResource;
import org.netbeans.core.windows.frames.LayoutResourceManager;

public class PerimeterLayout
implements LayoutManager,
LayoutResourceManager {
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    public static final String EAST = "EAST";
    public static final String WEST = "WEST";
    public static final String CENTER = "CENTER";
    public static final int FIRST_DOMINANT = 0;
    public static final int LAST_DOMINANT = 1;
    private static final int NORTHINDEX = 0;
    private static final int SOUTHINDEX = 1;
    private static final int EASTINDEX = 2;
    private static final int WESTINDEX = 3;
    private static final int CENTERINDEX = 4;
    private static final ArrayList sideNames = new ArrayList(5);
    private int gap = 4;
    private int minBreadth = 50;
    private Rectangle centerRect = null;
    private ArrayList sides = new ArrayList(5);
    private ArrayList dominance;
    private int dominancePolicy;

    public PerimeterLayout() {
        this.sides.add(null);
        this.sides.add(null);
        this.sides.add(null);
        this.sides.add(null);
        this.sides.add(null);
        this.dominance = new ArrayList(4);
        this.dominancePolicy = 0;
    }

    public PerimeterLayout(int n) {
        this();
        this.gap = n;
    }

    public void addLayoutComponent(String string, Component component) {
        int n = sideNames.indexOf(string);
        if (n != -1) {
            this.sides.set(n, component);
            if (n != 4 && !this.dominance.contains(component)) {
                switch (this.dominancePolicy) {
                    case 1: {
                        this.dominance.add(0, component);
                        break;
                    }
                    case 0: {
                        this.dominance.add(component);
                    }
                }
            }
            Dimension dimension = component.getSize();
            if (dimension.width <= 0 || dimension.height <= 0) {
                component.setSize(component.getPreferredSize());
            }
        } else {
            throw new IllegalArgumentException("invalid constraint: " + string + " " + n);
        }
    }

    public void removeLayoutComponent(Component component) {
        int n = this.sides.indexOf(component);
        if (n != -1) {
            this.sides.set(n, null);
            this.dominance.remove(component);
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return container.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Object object = container.getTreeLock();
        synchronized (object) {
            Cloneable cloneable;
            Dimension dimension2 = new Dimension(0, 0);
            Component component = null;
            component = this.getChild(4);
            if (component != null) {
                cloneable = component.getMinimumSize();
                dimension2.width += cloneable.width;
                dimension2.height += cloneable.height;
            }
            if ((component = this.getChild(2)) != null) {
                cloneable = component.getMinimumSize();
                dimension2.width += cloneable.width + this.gap;
                dimension2.height = Math.max(cloneable.height, dimension2.height);
            }
            if ((component = this.getChild(3)) != null) {
                cloneable = component.getMinimumSize();
                dimension2.width += cloneable.width + this.gap;
                dimension2.height = Math.max(cloneable.height, dimension2.height);
            }
            if ((component = this.getChild(0)) != null) {
                cloneable = component.getMinimumSize();
                dimension2.width = Math.max(cloneable.width, dimension2.width);
                dimension2.height += cloneable.height + this.gap;
            }
            if ((component = this.getChild(1)) != null) {
                cloneable = component.getMinimumSize();
                dimension2.width = Math.max(cloneable.width, dimension2.width);
                dimension2.height += cloneable.height + this.gap;
            }
            cloneable = container.getInsets();
            dimension2.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
            dimension2.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            dimension = dimension2;
        }
        return dimension;
    }

    private Component getChild(int n) {
        return (Component)this.sides.get(n);
    }

    public void layoutContainer(Container container) {
        this.centerRect = container.getBounds();
        this.centerRect.setLocation(0, 0);
        Insets insets = container.getInsets();
        this.centerRect.x -= insets.top;
        this.centerRect.y -= insets.left;
        this.centerRect.width -= insets.left + insets.right;
        this.centerRect.height -= insets.top + insets.bottom;
        Rectangle rectangle = (Rectangle)this.centerRect.clone();
        int n = 0;
        while (n < this.dominance.size()) {
            int n2 = this.sides.indexOf(this.dominance.get(n));
            this.setPeriCompBounds(this.centerRect, rectangle, n2);
            ++n;
        }
        Component component = (Component)this.sides.get(4);
        if (component != null) {
            component.setBounds(this.centerRect);
        } else if (!this.dominance.isEmpty()) {
            component = (Component)this.dominance.get(this.dominance.size() - 1);
            component.setBounds(component.getBounds().union(this.centerRect));
        }
        this.relayout(0, 0);
    }

    private void setPeriCompBounds(Rectangle rectangle, Rectangle rectangle2, int n) {
        boolean bl = n == 3 || n == 2;
        boolean bl2 = n == 1 || n == 2;
        Component component = (Component)this.sides.get(n);
        Rectangle rectangle3 = component.getBounds();
        if (bl) {
            this.flip(rectangle3);
            this.flip(rectangle);
            this.flip(rectangle2);
        }
        rectangle3.x = rectangle.x;
        rectangle3.width = rectangle.width;
        int n2 = rectangle.height;
        int n3 = this.minBreadth + this.gap;
        n2 -= this.dominance.size() > 1 ? n3 : 0;
        rectangle3.height = rectangle3.height > (n2 -= this.sides.get(4) == null ? 0 : n3) ? n2 : rectangle3.height;
        rectangle3.height = rectangle3.height < n3 ? n3 : rectangle3.height;
        rectangle3.y = bl2 ? rectangle2.height - rectangle3.height : 0;
        rectangle.y = bl2 ? rectangle.y : rectangle3.height + this.gap;
        rectangle.height -= rectangle3.height + this.gap;
        if (bl) {
            this.flip(rectangle3);
            this.flip(rectangle);
            this.flip(rectangle2);
        }
        component.setBounds(rectangle3);
    }

    private void flip(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.height;
        int n4 = rectangle.width;
        rectangle.setSize(n3, n4);
        rectangle.setLocation(n2, n);
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public int getMinimumBreadth() {
        return this.minBreadth;
    }

    public void setMinimumBreadth(int n) {
        this.minBreadth = n;
    }

    public void setDominant(Component component) {
        if (this.dominance.contains(component)) {
            this.dominance.add(0, this.dominance.remove(this.dominance.indexOf(component)));
        }
    }

    public void setDominant(String string) {
        int n = sideNames.indexOf(string);
        if (n > -1 && n < 4) {
            Component component = (Component)this.sides.get(n);
            if (component != null) {
                this.dominance.remove(component);
                this.dominance.add(0, component);
            }
        } else {
            throw new IllegalArgumentException("unknown constraint: " + n);
        }
    }

    public String getDominant() {
        int n = 0;
        Component component = (Component)this.dominance.get(0);
        n = 0;
        while (n < this.sides.size()) {
            if (this.sides.get(n) == component) {
                return (String)sideNames.get(n);
            }
            ++n;
        }
        return CENTER;
    }

    public void setDominancePolicy(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("invalid dominance policy " + n);
        }
        this.dominancePolicy = n;
    }

    public int getDominancePolicy() {
        return this.dominancePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDominance() {
        ArrayList arrayList = new ArrayList(this.dominance.size());
        PerimeterLayout perimeterLayout = this;
        synchronized (perimeterLayout) {
            int n = -1;
            Iterator iterator = this.dominance.iterator();
            while (iterator.hasNext()) {
                n = this.sides.indexOf(iterator.next());
                arrayList.add(sideNames.get(n));
            }
        }
        return arrayList;
    }

    public void relayout(int n, int n2) {
        if (this.sides.get(4) != null) {
            PerimeterLayout.relayoutWithGap(n, n2, this.sides.toArray(new Component[this.sides.size()]), this.getGap());
        }
    }

    private static void relayoutWithGap(int n, int n2, Component[] componentArray, int n3) {
        n += componentArray[3] == null ? 0 : n3;
        n2 += componentArray[0] == null ? 0 : n3;
        PerimeterLayout.relayoutComponent(n += componentArray[2] == null ? 0 : n3, n2 += componentArray[1] == null ? 0 : n3, componentArray[4]);
    }

    static void relayoutImpl(int n, int n2, Component[] componentArray) {
        if (componentArray == null || componentArray.length == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < componentArray.length) {
            PerimeterLayout.relayoutComponent(n, n2, componentArray[n3]);
            ++n3;
        }
    }

    private static void relayoutComponent(int n, int n2, Component component) {
        if (component instanceof LayoutResourceManager) {
            LayoutResourceManager layoutResourceManager = (LayoutResourceManager)((Object)component);
            layoutResourceManager.relayout(n, n2);
        } else if (component instanceof LayoutResource) {
            LayoutResource layoutResource = (LayoutResource)((Object)component);
            Rectangle rectangle = layoutResource.getRelativeBounds();
            Rectangle rectangle2 = component.getBounds();
            if (rectangle != null && rectangle2.equals(PerimeterLayout.computeBounds(rectangle, 0, 0, component))) {
                component.setBounds(PerimeterLayout.computeBounds(rectangle, n, n2, component));
            }
        } else if (component instanceof Container) {
            PerimeterLayout.relayoutImpl(n, n2, ((Container)component).getComponents());
        }
    }

    private static Rectangle computeBounds(Rectangle rectangle, int n, int n2, Component component) {
        Rectangle rectangle2 = PerimeterLayout.getWorkspaceBounds(component);
        Rectangle rectangle3 = new Rectangle();
        rectangle3.x = rectangle2.width * rectangle.x / 100 + rectangle2.x;
        rectangle3.y = rectangle2.height * rectangle.y / 100 + rectangle2.y;
        rectangle3.width = rectangle2.width * rectangle.width / 100;
        rectangle3.height = rectangle2.height * rectangle.height / 100;
        rectangle3.width -= n;
        rectangle3.height -= n2;
        rectangle3.width = Math.max(rectangle3.width, 0);
        rectangle3.height = Math.max(rectangle3.height, 0);
        return rectangle3;
    }

    private static Rectangle getWorkspaceBounds(Component component) {
        WorkspaceImpl workspaceImpl = (WorkspaceImpl)((LayoutResource)((Object)component)).getWorkspace();
        return workspaceImpl.getWorkingSpaceBounds();
    }

    static {
        sideNames.add(0, NORTH);
        sideNames.add(1, SOUTH);
        sideNames.add(2, EAST);
        sideNames.add(3, WEST);
        sideNames.add(4, CENTER);
    }
}

