/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.toolbars;

import org.netbeans.core.windows.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.toolbars.ToolbarConstraints;
import org.openide.awt.Toolbar;

public class ToolbarDnDListener
implements Toolbar.DnDListener {
    protected static final int BASIC_HEIGHT_2 = 19;
    protected static final int BASIC_HEIGHT_4 = 9;
    private ToolbarConstraints draggedToolbar;
    private ToolbarConfiguration configuration;

    public ToolbarDnDListener(ToolbarConfiguration toolbarConfiguration) {
        this.configuration = toolbarConfiguration;
    }

    protected void moveToolbar2EndHorizontally(ToolbarConstraints toolbarConstraints, int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            toolbarConstraints.moveLeft2End(-n);
        }
        if (n > 0) {
            toolbarConstraints.moveRight2End(n);
        }
    }

    protected void moveToolbarHorizontally(ToolbarConstraints toolbarConstraints, int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            toolbarConstraints.moveLeft(-n);
        }
        if (n > 0) {
            toolbarConstraints.moveRight(n);
        }
    }

    protected void moveToolbarVertically(ToolbarConstraints toolbarConstraints, int n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            this.moveUp(toolbarConstraints, -n);
        }
        if (n > 0) {
            this.moveDown(toolbarConstraints, n);
        }
    }

    protected void moveUp(ToolbarConstraints toolbarConstraints, int n) {
        if (n < 19) {
            return;
        }
        int n2 = toolbarConstraints.rowIndex();
        if (this.draggedToolbar.isAlone() && n2 == 0) {
            return;
        }
        int n3 = n2 - 1;
        toolbarConstraints.destroy();
        int n4 = 0;
        int n5 = this.configuration.getRowCount();
        int n6 = n3;
        while (n6 < n3 + toolbarConstraints.getRowCount()) {
            this.configuration.getRow(n6 + n4).addToolbar(toolbarConstraints, toolbarConstraints.getPosition());
            if (n5 != this.configuration.getRowCount()) {
                n5 = this.configuration.getRowCount();
                ++n4;
            }
            ++n6;
        }
        this.configuration.checkToolbarRows();
    }

    protected void moveDown(ToolbarConstraints toolbarConstraints, int n) {
        int n2 = toolbarConstraints.rowIndex();
        int n3 = 19;
        if (this.draggedToolbar.isAlone()) {
            if (n2 == this.configuration.getRowCount() - toolbarConstraints.getRowCount()) {
                return;
            }
            n3 = 9;
        }
        if (n < n3) {
            return;
        }
        int n4 = n2 + 1;
        toolbarConstraints.destroy();
        int n5 = n4;
        while (n5 < n4 + toolbarConstraints.getRowCount()) {
            this.configuration.getRow(n5).addToolbar(toolbarConstraints, toolbarConstraints.getPosition());
            ++n5;
        }
        this.configuration.checkToolbarRows();
    }

    public void dragToolbar(Toolbar.DnDEvent dnDEvent) {
        if (this.draggedToolbar == null) {
            this.draggedToolbar = this.configuration.getToolbarConstraints(dnDEvent.getName());
        }
        switch (dnDEvent.getType()) {
            case 3: {
                return;
            }
            case 2: {
                this.moveToolbar2EndHorizontally(this.draggedToolbar, dnDEvent.getDX());
                break;
            }
            case 1: {
                this.moveToolbarVertically(this.draggedToolbar, dnDEvent.getDY());
            }
        }
        if (dnDEvent.getType() == 1) {
            this.moveToolbarHorizontally(this.draggedToolbar, dnDEvent.getDX());
        }
        this.draggedToolbar.updatePosition();
        this.configuration.revalidateWindow();
    }

    public void dropToolbar(Toolbar.DnDEvent dnDEvent) {
        this.dragToolbar(dnDEvent);
        this.configuration.reflectChanges();
        this.draggedToolbar = null;
    }
}

