/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.toolbars;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.core.windows.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.toolbars.ToolbarConstraints;

public class ToolbarLayout
implements LayoutManager2,
Serializable {
    public static final int HGAP = 1;
    public static final int VGAP = 1;
    static final long serialVersionUID = 7489472539255790677L;
    ToolbarConfiguration toolbarConfig;
    HashMap componentMap;

    public ToolbarLayout(ToolbarConfiguration toolbarConfiguration) {
        this.toolbarConfig = toolbarConfiguration;
        this.componentMap = new HashMap();
    }

    public void addLayoutComponent(String string, Component component) {
        throw new IllegalArgumentException();
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof ToolbarConstraints)) {
            throw new IllegalArgumentException(ToolbarConfiguration.getBundleString("EXC_wrongConstraints"));
        }
        this.componentMap.put(component, object);
        ToolbarConstraints toolbarConstraints = (ToolbarConstraints)object;
        toolbarConstraints.setPreferredSize(component.getPreferredSize());
        component.setVisible(toolbarConstraints.isVisible());
    }

    public void removeLayoutComponent(Component component) {
        this.componentMap.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(insets.left + this.toolbarConfig.getPrefWidth() + insets.right, insets.top + this.toolbarConfig.getPrefHeight() + insets.bottom);
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            ToolbarConstraints toolbarConstraints;
            Component component;
            Insets insets = container.getInsets();
            int n = container.getWidth() - (insets.left + insets.right) - 1;
            Iterator iterator = this.componentMap.keySet().iterator();
            while (iterator.hasNext()) {
                component = (Component)iterator.next();
                toolbarConstraints = (ToolbarConstraints)this.componentMap.get(component);
                toolbarConstraints.updatePreferredSize(component.getPreferredSize());
            }
            iterator = this.componentMap.keySet().iterator();
            while (iterator.hasNext()) {
                component = (Component)iterator.next();
                toolbarConstraints = (ToolbarConstraints)this.componentMap.get(component);
                Rectangle rectangle = toolbarConstraints.getBounds();
                if (rectangle.x < n && rectangle.x + rectangle.width > n) {
                    rectangle.width = n - rectangle.x;
                } else if (rectangle.x > n + 1) {
                    toolbarConstraints.setPosition(n + 1);
                    toolbarConstraints.updatePosition();
                }
                component.setBounds(rectangle);
            }
        }
    }
}

