/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.WindowTypesManager;
import org.openide.TopManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public final class WindowUtils {
    private static final char OPEN = '[';
    private static final char CLOSE = ']';
    static /* synthetic */ Class class$org$netbeans$core$windows$util$WindowUtils;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;

    private WindowUtils() {
    }

    public static int getTaskbarHeight() {
        int n = 0;
        String string = System.getProperty("netbeans.taskbar.height");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n == 0 && Utilities.isWindows()) {
            n = 27;
        }
        return n;
    }

    public static void convertRectangle(Rectangle rectangle, Dimension dimension, Dimension dimension2) {
        if (dimension.equals(dimension2)) {
            return;
        }
        double d = (double)dimension2.width / (double)dimension.width;
        double d2 = (double)dimension2.height / (double)dimension.height;
        rectangle.x = (int)((double)rectangle.x * d);
        rectangle.y = (int)((double)rectangle.y * d2);
        rectangle.width = (int)((double)rectangle.width * d);
        rectangle.height = (int)((double)rectangle.height * d2);
    }

    public static final boolean isMdi() {
        return WindowManagerImpl.getDefault().uiModeManager().getUIMode() == 2;
    }

    public static ModeImpl findConstrainedMode(Workspace workspace, Object object) {
        return WindowUtils.findConstrainedMode(workspace, object, false);
    }

    public static ModeImpl findConstrainedMode(Workspace workspace, Object object, boolean bl) {
        List list = ((WorkspaceImpl)workspace).getLoadedModeArray();
        ModeImpl modeImpl = null;
        Object object2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            modeImpl = (ModeImpl)iterator.next();
            if (bl && modeImpl.getLoadedOpenedTopComponents().length <= 0) continue;
            object2 = modeImpl.getLoadedConstraints();
            if (!(object == null ? object2 == null : object.equals(object2))) continue;
            return modeImpl;
        }
        return null;
    }

    public static void changeModeConstraints(ModeImpl modeImpl, Object object) {
        WindowUtils.changeModeConstraints(modeImpl, object, false);
    }

    public static void changeModeConstraints(ModeImpl modeImpl, Object object, boolean bl) {
        ModeImpl modeImpl2;
        boolean bl2 = false;
        if (object != null && !"CENTER".equals(object) && (modeImpl2 = WindowUtils.findConstrainedMode(modeImpl.getWorkspace(), object)) != null && !modeImpl.equals(modeImpl2)) {
            if (bl) {
                modeImpl2 = modeImpl;
                bl2 = true;
            }
            modeImpl2.setConstraints(null);
            modeImpl2.setFrameType(WindowTypesManager.getDefaultFrame());
        }
        if (!bl2) {
            modeImpl.setConstraints(object);
        }
    }

    public static ModeImpl getActiveMode() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null) {
            return null;
        }
        WorkspaceImpl workspaceImpl = (WorkspaceImpl)TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        return (ModeImpl)workspaceImpl.findMode(topComponent);
    }

    public static boolean changeActiveMode(Object object, String string) {
        ModeImpl modeImpl = WindowUtils.getActiveMode();
        if (modeImpl == null) {
            return false;
        }
        boolean bl = modeImpl.isVisible();
        if (bl) {
            modeImpl.setVisible(false);
        }
        WindowUtils.changeModeConstraints(modeImpl, object);
        modeImpl.setFrameType(string);
        if (bl) {
            modeImpl.setVisible(true);
            WindowManagerImpl.mainWindow().getContentPane().validate();
        }
        return true;
    }

    public static JComponent createComponentProxy(JComponent jComponent, AWTEventProcessor aWTEventProcessor) {
        JRootPane jRootPane = new JRootPane();
        jRootPane.getContentPane().add(jComponent);
        GlassProxy glassProxy = new GlassProxy(jRootPane, jComponent, aWTEventProcessor);
        jRootPane.setGlassPane(glassProxy);
        glassProxy.setVisible(true);
        glassProxy.setOpaque(false);
        return jRootPane;
    }

    public static Dimension getMaximizedSize(Container container) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = null;
        if (Utilities.isWindows()) {
            Insets insets = container.getInsets();
            dimension2 = new Dimension(dimension.width + insets.left + insets.right, dimension.height + 2 * insets.bottom);
        } else {
            dimension2 = dimension;
        }
        return dimension2;
    }

    public static boolean hasObjectStreamField(ObjectInputStream.GetField getField, String string) {
        ObjectStreamField[] objectStreamFieldArray = getField.getObjectStreamClass().getFields();
        int n = 0;
        while (n < objectStreamFieldArray.length) {
            if (string.equals(objectStreamFieldArray[n].getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final URL getIconURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = NbBundle.getBundle((Class)(class$org$netbeans$core$windows$util$WindowUtils == null ? (class$org$netbeans$core$windows$util$WindowUtils = WindowUtils.class$("org.netbeans.core.windows.util.WindowUtils")) : class$org$netbeans$core$windows$util$WindowUtils)).getString("LOG_NoIcon");
            TopManager.getDefault().getErrorManager().log(16, MessageFormat.format(string2, string));
        }
        return uRL;
    }

    public static final String convertConstraint2Perim(String string) {
        if ("left".equals(string)) {
            return "WEST";
        }
        if ("right".equals(string)) {
            return "EAST";
        }
        if ("top".equals(string)) {
            return "NORTH";
        }
        if ("bottom".equals(string)) {
            return "SOUTH";
        }
        if ("center".equals(string)) {
            return "CENTER";
        }
        return null;
    }

    public static final String stringId2RefName(String string) {
        return string.substring(string.indexOf(47) + 1);
    }

    public static final String refName2StringId(String string) {
        return "wstopcomp/" + string;
    }

    public static final String convertConstraint2Xml(String string) {
        if ("WEST".equals(string)) {
            return "left";
        }
        if ("EAST".equals(string)) {
            return "right";
        }
        if ("NORTH".equals(string)) {
            return "top";
        }
        if ("SOUTH".equals(string)) {
            return "bottom";
        }
        if ("CENTER".equals(string)) {
            return "center";
        }
        return null;
    }

    public static final int parseUIType(String string) {
        if ("mdi".equals(string)) {
            return 2;
        }
        if ("sdi".equals(string)) {
            return 1;
        }
        return -1;
    }

    public static final ModuleInfo findModule(String string, String string2, String string3) {
        SpecificationVersion specificationVersion = null;
        int n = -1;
        try {
            if (string2 != null) {
                if (string3 == null) {
                    throw new NumberFormatException("Wrong module information in winsys config file, module " + string + ".\n" + " Specification version must be present if release number is specified.");
                }
                n = Integer.parseInt(string2);
                specificationVersion = new SpecificationVersion(string3);
            } else if (string3 != null) {
                throw new NumberFormatException("Wrong module information in winsys config file, module " + string + ".\n" + " Release number must not be null if specification version is specified.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            TopManager.getDefault().getErrorManager().notify(16, (Throwable)numberFormatException);
        }
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = WindowUtils.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo));
        Collection collection = result.allInstances();
        ModuleInfo moduleInfo = null;
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moduleInfo = (ModuleInfo)iterator.next();
            if (!moduleInfo.getCodeNameBase().equals(string)) continue;
            if (n < 0 || moduleInfo.getCodeNameRelease() > n) {
                return moduleInfo;
            }
            if (moduleInfo.getCodeNameRelease() != n || moduleInfo.getSpecificationVersion().compareTo((Object)specificationVersion) < 0) continue;
            return moduleInfo;
        }
        return null;
    }

    public static final String convertFrameType(int n, Object object) {
        if (n == 1) {
            return "org.netbeans.core.windows.frames.TopFrameTypeImpl";
        }
        if (n == 2) {
            if (object != null && !"CENTER".equals(object)) {
                return "org.netbeans.core.windows.frames.DesktopFrameTypeImpl";
            }
            return "org.netbeans.core.windows.frames.InternalFrameTypeImpl";
        }
        return null;
    }

    public static String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '/' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '<' || c == '>' || c == '?' || c == '*' || c == '|' || c == ' ' && n2 == n - 1 || c == '.' || c == '\"' || c < ' ' || c > '~' || c == '#') {
                stringBuffer.append('#');
                String string2 = Integer.toString(c, 16).toUpperCase();
                if (string2.length() < 4) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 3) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '#') {
                block6: {
                    if (n2 + 4 >= n) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break;
                        System.err.println("trailing garbage in instance name: " + string);
                        break;
                    }
                    try {
                        char[] cArray = new char[4];
                        string.getChars(n2 + 1, n2 + 5, cArray, 0);
                        stringBuffer.append((char)Integer.parseInt(new String(cArray), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                        numberFormatException.printStackTrace();
                    }
                }
                n2 += 4;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteOneFO(FileObject fileObject) {
        FileLock fileLock = null;
        if (!fileObject.isValid()) return;
        try {
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
                Object var4_3 = null;
                if (fileLock == null) return;
                fileLock.releaseLock();
                return;
            }
            Object var4_2 = null;
            if (fileLock == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileLock == null) throw throwable;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class GlassProxy
    extends JPanel {
        private JRootPane rootPane;
        private Component original;
        private AWTEventProcessor handler;

        public GlassProxy(JRootPane jRootPane, Component component, AWTEventProcessor aWTEventProcessor) {
            this.rootPane = jRootPane;
            this.original = component;
            this.handler = aWTEventProcessor;
            this.enableEvents(-1L);
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (this.handler.handleEvent(aWTEvent)) {
                return;
            }
            if (aWTEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                MouseEvent mouseEvent2 = new MouseEvent(this.rootPane, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                this.rootPane.dispatchEvent(mouseEvent2);
                Component component = this.original.getComponentAt(mouseEvent.getPoint());
                if (component != null) {
                    component.dispatchEvent(SwingUtilities.convertMouseEvent(this, mouseEvent, component));
                }
            } else {
                this.original.dispatchEvent(aWTEvent);
            }
        }
    }

    public static interface AWTEventProcessor {
        public boolean handleEvent(AWTEvent var1);
    }
}

