/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class FTP
extends Task {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int LIST_FILES = 3;
    protected static final int MK_DIR = 4;
    private String remotedir;
    private String server;
    private String userid;
    private String password;
    private File listing;
    private boolean binary = true;
    private boolean passive = false;
    private boolean verbose = false;
    private boolean newerOnly = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Vector dirCache = new Vector();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private int port = 21;
    private boolean skipFailedTransfers = false;
    private int skipped = 0;
    private boolean ignoreNoncriticalErrors = false;
    protected static final String[] ACTION_STRS = new String[]{"sending", "getting", "deleting", "listing", "making directory"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"sent", "retrieved", "deleted", "listed", "created directory"};

    public void setRemotedir(String dir) {
        this.remotedir = dir;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNewer(boolean newer) {
        this.newerOnly = newer;
    }

    public void setDepends(boolean depends) {
        this.newerOnly = depends;
    }

    public void setSeparator(String separator) {
        this.remoteFileSep = separator;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setAction(String action) throws BuildException {
        if (action.toLowerCase().equals("send") || action.toLowerCase().equals("put")) {
            this.action = 0;
        } else if (action.toLowerCase().equals("recv") || action.toLowerCase().equals("get")) {
            this.action = 1;
        } else if (action.toLowerCase().equals("del") || action.toLowerCase().equals("delete")) {
            this.action = 2;
        } else if (action.toLowerCase().equals("list")) {
            this.action = 3;
        } else if (action.toLowerCase().equals("mkdir")) {
            this.action = 4;
        } else {
            throw new BuildException("action " + action + " is not supported");
        }
    }

    public void setListing(File listing) throws BuildException {
        this.listing = listing;
    }

    public void setSkipFailedTransfers(boolean skipFailedTransfers) {
        this.skipFailedTransfers = skipFailedTransfers;
    }

    public void setIgnoreNoncriticalErrors(boolean ignoreNoncriticalErrors) {
        this.ignoreNoncriticalErrors = ignoreNoncriticalErrors;
    }

    protected void checkConfiguration() throws BuildException {
        if (this.server == null) {
            throw new BuildException("server attribute must be set!");
        }
        if (this.userid == null) {
            throw new BuildException("userid attribute must be set!");
        }
        if (this.password == null) {
            throw new BuildException("password attribute must be set!");
        }
        if (this.action == 3 && this.listing == null) {
            throw new BuildException("listing attribute must be set for list action!");
        }
        if (this.action == 4 && this.remotedir == null) {
            throw new BuildException("remotedir attribute must be set for mkdir action!");
        }
    }

    protected int transferFiles(FTPClient ftp, FileSet fs) throws IOException, BuildException {
        DirectoryScanner ds;
        if (this.action == 0) {
            ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
        } else {
            ds = new FTPDirectoryScanner(ftp);
            fs.setupDirectoryScanner((FileScanner)ds, ((ProjectComponent)this).project);
            ds.scan();
        }
        String[] dsfiles = ds.getIncludedFiles();
        String dir = null;
        if (ds.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        BufferedWriter bw = null;
        if (this.action == 3) {
            File pd = new File(this.listing.getParent());
            if (!pd.exists()) {
                pd.mkdirs();
            }
            bw = new BufferedWriter(new FileWriter(this.listing));
        }
        int i = 0;
        while (i < dsfiles.length) {
            switch (this.action) {
                case 0: {
                    this.sendFile(ftp, dir, dsfiles[i]);
                    break;
                }
                case 1: {
                    this.getFile(ftp, dir, dsfiles[i]);
                    break;
                }
                case 2: {
                    this.delFile(ftp, dsfiles[i]);
                    break;
                }
                case 3: {
                    this.listFile(ftp, bw, dsfiles[i]);
                    break;
                }
                default: {
                    throw new BuildException("unknown ftp action " + this.action);
                }
            }
            ++i;
        }
        if (this.action == 3) {
            bw.close();
        }
        return dsfiles.length;
    }

    protected void transferFiles(FTPClient ftp) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            if (fs != null) {
                this.transferFiles(ftp, fs);
            }
            ++i;
        }
        this.log(this.transferred + " files " + COMPLETED_ACTION_STRS[this.action]);
        if (this.skipped != 0) {
            this.log(this.skipped + " files were not successfully " + COMPLETED_ACTION_STRS[this.action]);
        }
    }

    protected String resolveFile(String file) {
        return file.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    /*
     * WARNING - void declaration
     */
    protected void createParents(FTPClient ftp, String filename) throws IOException, BuildException {
        String dirname;
        Vector<File> parents = new Vector<File>();
        File dir = new File(filename);
        while ((dirname = dir.getParent()) != null) {
            void var5_5;
            dir = new File((String)var5_5);
            parents.addElement(dir);
        }
        int i = parents.size() - 1;
        while (i >= 0) {
            dir = (File)parents.elementAt(i);
            if (!this.dirCache.contains(dir)) {
                this.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                ftp.makeDirectory(this.resolveFile(dir.getPath()));
                int result = ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)result) && result != 550 && result != 553 && !this.ignoreNoncriticalErrors) {
                    throw new BuildException("could not create directory: " + ftp.getReplyString());
                }
                this.dirCache.addElement(dir);
            }
            --i;
        }
    }

    protected boolean isUpToDate(FTPClient ftp, File localFile, String remoteFile) throws IOException, BuildException {
        this.log("checking date for " + remoteFile, 3);
        FTPFile[] files = ftp.listFiles(remoteFile);
        if (files == null || files.length == 0) {
            if (this.action == 0) {
                this.log("Could not date test remote file: " + remoteFile + "assuming out of date.", 3);
                return false;
            }
            throw new BuildException("could not date test remote file: " + ftp.getReplyString());
        }
        long remoteTimestamp = files[0].getTimestamp().getTime().getTime();
        long localTimestamp = localFile.lastModified();
        if (this.action == 0) {
            return remoteTimestamp > localTimestamp;
        }
        return localTimestamp > remoteTimestamp;
    }

    /*
     * Unable to fully structure code
     */
    protected void sendFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        block12: {
            instream = null;
            try {
                file = this.project.resolveFile(new File(dir, filename).getPath());
                if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block13;
                var9_6 = null;
                ** if (instream == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_8 = null;
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    instream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block13: {
                    return;
                }
                if (this.verbose) {
                    this.log("transferring " + file.getAbsolutePath());
                }
                instream = new BufferedInputStream(new FileInputStream(file));
                this.createParents(ftp, filename);
                ftp.storeFile(this.resolveFile(filename), instream);
                success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
                if (!success) {
                    s = "could not put file: " + ftp.getReplyString();
                    if (this.skipFailedTransfers) {
                        this.log(s, 1);
                        ++this.skipped;
                        break block12;
                    }
                    throw new BuildException(s);
                }
                this.log("File " + file.getAbsolutePath() + " copied to " + this.server, 3);
                ++this.transferred;
            }
        }
        var9_7 = null;
        if (instream != null) {
            try {
                instream.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void delFile(FTPClient ftp, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + filename);
        }
        if (!ftp.deleteFile(this.resolveFile(filename))) {
            String s = "could not delete file: " + ftp.getReplyString();
            if (!this.skipFailedTransfers) throw new BuildException(s);
            this.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.log("File " + filename + " deleted from " + this.server, 3);
            ++this.transferred;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void getFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        block13: {
            outstream = null;
            try {
                file = this.project.resolveFile(new File(dir, filename).getPath());
                if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block14;
                var9_6 = null;
                ** if (outstream == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_8 = null;
                if (outstream != null) {
                    try {
                        outstream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    outstream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block14: {
                    return;
                }
                if (this.verbose) {
                    this.log("transferring " + filename + " to " + file.getAbsolutePath());
                }
                if (!(pdir = new File(file.getParent())).exists()) {
                    pdir.mkdirs();
                }
                outstream = new BufferedOutputStream(new FileOutputStream(file));
                ftp.retrieveFile(this.resolveFile(filename), outstream);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    s = "could not get file: " + ftp.getReplyString();
                    if (this.skipFailedTransfers) {
                        this.log(s, 1);
                        ++this.skipped;
                        break block13;
                    }
                    throw new BuildException(s);
                }
                this.log("File " + file.getAbsolutePath() + " copied from " + this.server, 3);
                ++this.transferred;
            }
        }
        var9_7 = null;
        if (outstream != null) {
            try {
                outstream.close();
            }
            catch (IOException ex) {}
        }
    }

    protected void listFile(FTPClient ftp, BufferedWriter bw, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("listing " + filename);
        }
        FTPFile ftpfile = ftp.listFiles(this.resolveFile(filename))[0];
        bw.write(ftpfile.toString());
        bw.newLine();
        ++this.transferred;
    }

    protected void makeRemoteDir(FTPClient ftp, String dir) throws IOException, BuildException {
        if (this.verbose) {
            this.log("creating directory: " + dir);
        }
        if (!ftp.makeDirectory(dir)) {
            int rc = ftp.getReplyCode();
            if (!this.ignoreNoncriticalErrors || rc != 550 && rc != 553 && rc != 521) {
                throw new BuildException("could not create directory: " + ftp.getReplyString());
            }
            if (this.verbose) {
                this.log("directory already exists");
            }
        } else if (this.verbose) {
            this.log("directory created OK");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        this.checkConfiguration();
        FTPClient ftp = null;
        try {
            block17: {
                try {
                    this.log("Opening FTP connection to " + this.server, 3);
                    ftp = new FTPClient();
                    ftp.connect(this.server, this.port);
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("FTP connection failed: " + ftp.getReplyString());
                    }
                    this.log("connected", 3);
                    this.log("logging in to FTP server", 3);
                    if (!ftp.login(this.userid, this.password)) {
                        throw new BuildException("Could not login to FTP server");
                    }
                    this.log("login succeeded", 3);
                    if (this.binary) {
                        ftp.setFileType(2);
                        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                        }
                    }
                    if (this.passive) {
                        this.log("entering passive mode", 3);
                        ftp.enterLocalPassiveMode();
                        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            throw new BuildException("could not enter into passive mode: " + ftp.getReplyString());
                        }
                    }
                    if (this.action == 4) {
                        this.makeRemoteDir(ftp, this.remotedir);
                        break block17;
                    }
                    if (this.remotedir != null) {
                        this.log("changing the remote directory", 3);
                        ftp.changeWorkingDirectory(this.remotedir);
                        if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            throw new BuildException("could not change remote directory: " + ftp.getReplyString());
                        }
                        this.log(ACTION_STRS[this.action] + " files");
                        this.transferFiles(ftp);
                    }
                }
                catch (IOException ex) {
                    throw new BuildException("error during FTP transfer: " + ex);
                }
            }
            Object var4_2 = null;
            if (ftp == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (ftp == null) throw throwable;
            if (!ftp.isConnected()) throw throwable;
            try {
                this.log("disconnecting", 3);
                ftp.logout();
                ftp.disconnect();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        if (!ftp.isConnected()) return;
        try {}
        catch (IOException ex) {}
        this.log("disconnecting", 3);
        ftp.logout();
        ftp.disconnect();
        return;
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected FTPClient ftp = null;

        public FTPDirectoryScanner(FTPClient ftp) {
            this.ftp = ftp;
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new Vector();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new Vector();
            this.dirsIncluded = new Vector();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new Vector();
            try {
                String cwd = this.ftp.printWorkingDirectory();
                this.scandir(".", "", true);
                this.ftp.changeWorkingDirectory(cwd);
            }
            catch (IOException e) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)e);
            }
        }

        protected void scandir(String dir, String vpath, boolean fast) {
            try {
                if (!this.ftp.changeWorkingDirectory(dir)) {
                    return;
                }
                FTPFile[] newfiles = this.ftp.listFiles();
                if (newfiles == null) {
                    this.ftp.changeToParentDirectory();
                    return;
                }
                int i = 0;
                while (i < newfiles.length) {
                    FTPFile file = newfiles[i];
                    if (!file.getName().equals(".") && !file.getName().equals("..")) {
                        String name;
                        if (file.isDirectory()) {
                            name = file.getName();
                            if (this.isIncluded(name)) {
                                if (!this.isExcluded(name)) {
                                    this.dirsIncluded.addElement(name);
                                    if (fast) {
                                        this.scandir(name, vpath + name + File.separator, fast);
                                    }
                                } else {
                                    this.dirsExcluded.addElement(name);
                                }
                            } else {
                                this.dirsNotIncluded.addElement(name);
                                if (fast && this.couldHoldIncluded(name)) {
                                    this.scandir(name, vpath + name + File.separator, fast);
                                }
                            }
                            if (!fast) {
                                this.scandir(name, vpath + name + File.separator, fast);
                            }
                        } else if (file.isFile()) {
                            name = vpath + file.getName();
                            if (this.isIncluded(name)) {
                                if (!this.isExcluded(name)) {
                                    this.filesIncluded.addElement(name);
                                } else {
                                    this.filesExcluded.addElement(name);
                                }
                            } else {
                                this.filesNotIncluded.addElement(name);
                            }
                        }
                    }
                    ++i;
                }
                this.ftp.changeToParentDirectory();
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)e);
            }
        }
    }
}

