/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.java.Util;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;

public class ClassPathConfigurator {
    private static final boolean DEBUG = false;
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static ClassPathConfigurator classPathConfigurator = null;
    private HashMap fileSystemCache = new HashMap(10);
    private static final Object TAG_INVALID = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$java$ClassPathConfigurator;

    private ClassPathConfigurator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassPathConfigurator getInstance() {
        if (classPathConfigurator == null) {
            Class clazz = class$org$netbeans$modules$java$ClassPathConfigurator == null ? (class$org$netbeans$modules$java$ClassPathConfigurator = ClassPathConfigurator.class$("org.netbeans.modules.java.ClassPathConfigurator")) : class$org$netbeans$modules$java$ClassPathConfigurator;
            synchronized (clazz) {
                if (classPathConfigurator == null) {
                    classPathConfigurator = new ClassPathConfigurator();
                }
            }
        }
        return classPathConfigurator;
    }

    public Collection getFileSystems(NbClassPath nbClassPath) {
        if (nbClassPath == null) {
            return Collections.EMPTY_LIST;
        }
        String string = nbClassPath.getClassPath();
        if (string.length() >= 2 && string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return this.getFileSystems(string);
    }

    public Collection getFileSystems(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getCachedFileSystems(new StringTokenizer(string, PATH_SEPARATOR));
    }

    synchronized FileSystem createFileSystem(String string) throws IOException {
        Object object = null;
        boolean bl = true;
        if (this.fileSystemCache.containsKey(string)) {
            Object v = this.fileSystemCache.get(string);
            if (v == TAG_INVALID) {
                object = null;
                bl = false;
            } else {
                object = (FileSystem)((Reference)v).get();
            }
        }
        if (object == null) {
            try {
                object = this.isJarFile(string) ? this.getJarFileSystem(string) : this.getLocalFileSystem(string);
            }
            catch (IOException iOException) {
                if (bl) {
                    this.fileSystemCache.put(string, TAG_INVALID);
                    throw iOException;
                }
                return null;
            }
            this.fileSystemCache.put(string, new SoftReference<JarFileSystem>((JarFileSystem)object));
        }
        return object;
    }

    private Vector getCachedFileSystems(Enumeration enumeration) {
        Vector<FileSystem> vector = new Vector<FileSystem>();
        if (enumeration == null) {
            return vector;
        }
        String string = null;
        FileSystem fileSystem = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string == null || string.length() <= 0) continue;
            try {
                fileSystem = this.createFileSystem(string);
            }
            catch (IOException iOException) {
                Util.getErrorManager().log(1, "WARNING: " + string + " cannot be opened");
                Util.getErrorManager().log(1, iOException.toString());
            }
            if (fileSystem == null || vector.contains(fileSystem)) continue;
            vector.add(fileSystem);
        }
        return vector;
    }

    private JarFileSystem getJarFileSystem(String string) throws IOException {
        JarFileSystem jarFileSystem = new JarFileSystem();
        try {
            jarFileSystem.setJarFile(new File(string));
        }
        catch (PropertyVetoException propertyVetoException) {
            System.err.println("Unable to set Jar file " + string + ". " + propertyVetoException.getMessage());
        }
        jarFileSystem.setHidden(true);
        return jarFileSystem;
    }

    private LocalFileSystem getLocalFileSystem(String string) throws IOException {
        LocalFileSystem localFileSystem = new LocalFileSystem();
        try {
            localFileSystem.setRootDirectory(new File(string));
        }
        catch (PropertyVetoException propertyVetoException) {
            System.err.println("Unable to set Root directory " + string + ". " + propertyVetoException.getMessage());
        }
        localFileSystem.setHidden(true);
        return localFileSystem;
    }

    private boolean isJarFile(String string) {
        boolean bl = false;
        if (string != null) {
            bl = string.endsWith(ZIP_FILE_EXTENSION) || string.endsWith(JAR_FILE_EXTENSION);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

