/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.apache.regexp.CharacterArrayCharacterIterator;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.Parsing;
import org.netbeans.modules.java.Util;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.settings.JavaSettings;
import org.netbeans.modules.java.ui.JEditorToolbar;
import org.openide.TopManager;
import org.openide.actions.ToggleBreakpointAction;
import org.openide.cookies.SourceCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.text.CloneableEditor;
import org.openide.text.EditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class JavaEditor
extends EditorSupport {
    private static final String MAGIC_PREFIX = "//GEN-";
    private static String[] SECTION_MAGICS;
    private static final int LONGEST_ITEM = 10;
    private static final int T_LINE = 0;
    private static final int T_BEGIN = 1;
    private static final int T_END = 2;
    private static final int T_HEADER = 3;
    private static final int T_HEADEREND = 4;
    private static final int T_FIRST = 5;
    private static final int T_LAST = 6;
    HashMap sections = null;
    Timer timer = new Timer(0, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JavaEditor.this.changeTimeoutElapsed();
        }
    });
    static final byte NEW_LINE_N = 0;
    static final byte NEW_LINE_R = 1;
    static final byte NEW_LINE_RN = 2;
    byte newLineType;
    static final JavaSettings settings;
    Object parsedHook;
    private boolean documentSaved;
    private boolean reloading = false;
    private boolean componentsCreated = false;
    private static final Comparator SECTION_COMPARATOR;
    static /* synthetic */ Class class$org$netbeans$modules$java$settings$JavaSettings;
    static /* synthetic */ Class class$org$netbeans$modules$java$parser$JavaParser;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaEditor;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$openide$actions$ToggleBreakpointAction;

    public JavaEditor(MultiDataObject.Entry entry) {
        super(entry);
        this.timer.setInitialDelay(settings.getAutoParsingDelay());
        this.timer.setRepeats(false);
        final DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.change(documentEvent);
            }

            private void change(DocumentEvent documentEvent) {
                JavaEditor.this.documentSaved = false;
                JavaEditor.this.restartTimer(false);
            }
        };
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (JavaEditor.this.isDocumentLoaded()) {
                    JavaEditor.this.getDocument().addDocumentListener(documentListener);
                } else {
                    JavaEditor.this.notifyClose();
                }
            }
        });
    }

    private JavaDataObject getJavaDataObject() {
        return (JavaDataObject)this.getJavaEntry().getDataObject();
    }

    private JavaParser findParser() {
        return (JavaParser)this.getJavaDataObject().getCookie(class$org$netbeans$modules$java$parser$JavaParser == null ? (class$org$netbeans$modules$java$parser$JavaParser = JavaEditor.class$("org.netbeans.modules.java.parser.JavaParser")) : class$org$netbeans$modules$java$parser$JavaParser);
    }

    private void changeTimeoutElapsed() {
        JavaParser javaParser = this.findParser();
        if (javaParser == null) {
            return;
        }
        Task task = javaParser.parse(2, false, false);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                task.removeTaskListener((TaskListener)this);
                JavaEditor.this.notifyParsingDone();
            }
        });
    }

    void restartTimer(boolean bl) {
        if (bl && !this.timer.isRunning()) {
            return;
        }
        int n = settings.getAutoParsingDelay();
        if (n > 0) {
            this.timer.setInitialDelay(n);
            this.timer.restart();
        }
    }

    protected EditorSupport.Editor openAt(PositionRef positionRef) {
        EditorSupport.Editor editor = super.openAt(positionRef);
        editor.requestFocus();
        return editor;
    }

    protected void notifyClose() {
        this.clearSections();
        JavaDataObject javaDataObject = (JavaDataObject)this.getJavaEntry().getDataObject();
        if (!this.documentSaved) {
            this.documentSaved = true;
        }
        this.componentsCreated = false;
        this.parsedHook = null;
    }

    protected String messageToolTip() {
        FileObject fileObject = this.getJavaDataObject().getPrimaryFile();
        try {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = JavaEditor.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor), (String)"LAB_EditorToolTip_Valid", (Object[])new Object[]{fileObject.getPackageName('.'), fileObject.getName(), fileObject.getExt(), fileObject.getFileSystem().getDisplayName()});
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = JavaEditor.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor), (String)"LAB_EditorToolTip_Invalid", (Object[])new Object[]{fileObject.getPackageName('.'), fileObject.getName(), fileObject.getExt()});
        }
    }

    protected void notifyParsingDone() {
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        boolean bl = false;
        if (this.sections == null) {
            this.sections = new HashMap(10);
            bl = true;
        }
        if (bl) {
            GuardedReader guardedReader = new GuardedReader(inputStream, false, Util.getFileEncoding(this.entry.getFile()));
            editorKit.read(guardedReader, (Document)styledDocument, 0);
            this.fillSections(guardedReader, styledDocument);
            this.newLineType = guardedReader.getNewLineType();
        } else {
            editorKit.read(inputStream, (Document)styledDocument, 0);
        }
        final boolean bl2 = this.reloading;
        this.reloading = false;
        this.documentSaved = true;
        final JavaParser javaParser = this.findParser();
        if (javaParser == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Task task = javaParser.parse(2, bl2, false);
                JavaEditor.this.parsedHook = javaParser.getSourceImpl();
                task.isFinished();
                JavaDataObject javaDataObject = (JavaDataObject)JavaEditor.this.getJavaEntry().getDataObject();
            }
        });
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        Object object;
        NewLineOutputStream newLineOutputStream = new NewLineOutputStream(outputStream, this.newLineType);
        String string = Util.getFileEncoding(this.entry.getFile());
        if (this.sections != null && ((ArrayList)(object = new ArrayList(this.sections.values()))).size() > 0) {
            GuardedWriter guardedWriter = new GuardedWriter(newLineOutputStream, (ArrayList)object, string);
            editorKit.write(guardedWriter, (Document)styledDocument, 0, styledDocument.getLength());
            return;
        }
        object = string == null ? new OutputStreamWriter(newLineOutputStream) : new OutputStreamWriter((OutputStream)newLineOutputStream, string);
        editorKit.write((Writer)object, (Document)styledDocument, 0, styledDocument.getLength());
        this.documentSaved = true;
    }

    protected Task reloadDocumentTask() {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (styledDocument != null) {
            this.clearSections();
            NbDocument.unmarkGuarded((StyledDocument)styledDocument, (int)0, (int)styledDocument.getLength());
            this.reloading = true;
            return super.reloadDocumentTask();
        }
        return null;
    }

    public void saveDocument() throws IOException {
        this.saveDocument(true, true);
    }

    protected void saveDocumentIfNecessary(boolean bl) throws IOException {
        this.saveDocument(bl, false);
    }

    private void saveDocument(boolean bl, boolean bl2) throws IOException {
        if (bl2 || this.isModified()) {
            super.saveDocument();
        }
    }

    public SourceElement getSource() {
        JavaDataObject javaDataObject = (JavaDataObject)this.entry.getDataObject();
        return javaDataObject.getSource();
    }

    public Element sourceToText(org.openide.src.Element element) {
        return null;
    }

    public org.openide.src.Element textToSource(Element element) throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    public org.openide.src.Element findElement(int n) {
        JavaDataObject javaDataObject = (JavaDataObject)this.getJavaEntry().getDataObject();
        return null;
    }

    public SimpleSection createSimpleSection(PositionRef positionRef, String string) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(positionRef);
        return this.doCreateSimpleSection(positionRef, string);
    }

    public SimpleSection createSimpleSection(PositionBounds positionBounds, String string) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(positionBounds);
        return this.doCreateSimpleSection(positionBounds, string);
    }

    private void checkOverlap(PositionRef positionRef) {
        Iterator iterator = this.sections.values().iterator();
        while (iterator.hasNext()) {
            GuardedSection guardedSection = (GuardedSection)iterator.next();
            if (!guardedSection.contains(positionRef, false)) continue;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    public boolean testOverlap(PositionBounds positionBounds) {
        try {
            StyledDocument styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        try {
            this.checkOverlap(positionBounds, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    private void checkOverlap(PositionBounds positionBounds) throws IllegalArgumentException {
        this.checkOverlap(positionBounds, false);
    }

    private void checkOverlap(PositionBounds positionBounds, boolean bl) throws IllegalArgumentException {
        TreeSet treeSet = new TreeSet(new GuardedPositionComparator());
        treeSet.addAll(this.sections.values());
        Iterator iterator = treeSet.iterator();
        PositionRef positionRef = positionBounds.getBegin();
        PositionRef positionRef2 = positionBounds.getEnd();
        int n = positionRef.getOffset();
        int n2 = positionRef2.getOffset();
        Object var9_9 = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            GuardedSection guardedSection = (GuardedSection)iterator.next();
            if (guardedSection.contains(positionRef, bl) || guardedSection.contains(positionRef2, bl)) {
                throw new IllegalArgumentException("Sections overlap");
            }
            if (guardedSection.getBegin().getOffset() <= n) continue;
            if (guardedSection.getBegin().getOffset() >= n2) break;
            throw new IllegalArgumentException("Sections overlap");
        }
    }

    protected boolean notifyModified() {
        return super.notifyModified();
    }

    private SimpleSection doCreateSimpleSection(final PositionBounds positionBounds, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot load document");
        }
        final StyledDocument styledDocument2 = styledDocument;
        final SimpleSection[] simpleSectionArray = new SimpleSection[]{null};
        Util.ExceptionRunnable exceptionRunnable = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                simpleSectionArray[0] = new SimpleSection(string, JavaEditor.this.createBounds(positionBounds.getBegin().getOffset(), positionBounds.getEnd().getOffset(), false));
                JavaEditor.this.sections.put(simpleSectionArray[0].getName(), simpleSectionArray[0]);
                simpleSectionArray[0].markGuarded(styledDocument2);
            }
        };
        try {
            Util.runAtomic(styledDocument2, exceptionRunnable);
            this.notifyModified();
        }
        catch (Exception exception) {
            if (exception instanceof BadLocationException) {
                throw (BadLocationException)exception;
            }
            throw new IllegalArgumentException();
        }
        return simpleSectionArray[0];
    }

    private SimpleSection doCreateSimpleSection(final PositionRef positionRef, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        final StyledDocument styledDocument2 = styledDocument;
        final SimpleSection[] simpleSectionArray = new SimpleSection[]{null};
        Util.ExceptionRunnable exceptionRunnable = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                int n = positionRef.getOffset();
                styledDocument2.insertString(n, "\n \n", null);
                simpleSectionArray[0] = new SimpleSection(string, JavaEditor.this.createBounds(n + 1, n + 3, false));
                JavaEditor.this.sections.put(simpleSectionArray[0].getName(), simpleSectionArray[0]);
                simpleSectionArray[0].markGuarded(styledDocument2);
            }
        };
        try {
            Util.runAtomic(styledDocument2, exceptionRunnable);
            this.notifyModified();
        }
        catch (Exception exception) {
            if (exception instanceof BadLocationException) {
                throw (BadLocationException)exception;
            }
            throw new IllegalArgumentException();
        }
        return simpleSectionArray[0];
    }

    public SimpleSection createSimpleSectionAfter(GuardedSection guardedSection, String string) throws IllegalArgumentException, BadLocationException {
        PositionBounds positionBounds = guardedSection instanceof SimpleSection ? ((SimpleSection)guardedSection).bounds : ((InteriorSection)guardedSection).bottom;
        if (guardedSection == null || !guardedSection.valid) {
            throw new IllegalArgumentException("Invalid guarded block");
        }
        return this.doCreateSimpleSection(positionBounds.getEnd(), string);
    }

    public InteriorSection createInteriorSection(PositionRef positionRef, String string) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(positionRef);
        return this.doCreateInteriorSection(positionRef, string);
    }

    public InteriorSection createInteriorSectionAfter(GuardedSection guardedSection, String string) throws IllegalArgumentException, BadLocationException {
        PositionBounds positionBounds = guardedSection instanceof SimpleSection ? ((SimpleSection)guardedSection).bounds : ((InteriorSection)guardedSection).bottom;
        if (guardedSection == null || !guardedSection.valid) {
            throw new IllegalArgumentException("Invalid guarded block");
        }
        return this.doCreateInteriorSection(positionBounds.getEnd(), string);
    }

    public InteriorSection createInteriorSection(PositionBounds positionBounds, PositionBounds positionBounds2, String string) throws IllegalArgumentException, BadLocationException {
        this.checkOverlap(positionBounds);
        if (positionBounds.getBegin().getOffset() > positionBounds2.getEnd().getOffset() || positionBounds.getEnd().getOffset() < positionBounds2.getEnd().getOffset()) {
            throw new IllegalArgumentException("Interior is not nested.");
        }
        return this.doCreateInteriorSection(positionBounds, positionBounds2, string);
    }

    private InteriorSection doCreateInteriorSection(final PositionBounds positionBounds, final PositionBounds positionBounds2, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot load document");
        }
        final StyledDocument styledDocument2 = styledDocument;
        final InteriorSection[] interiorSectionArray = new InteriorSection[]{null};
        Util.ExceptionRunnable exceptionRunnable = new Util.ExceptionRunnable(){

            public void run() {
                interiorSectionArray[0] = new InteriorSection(string, JavaEditor.this.createBounds(positionBounds.getBegin().getOffset(), positionBounds2.getBegin().getOffset(), false), JavaEditor.this.createBounds(positionBounds2.getBegin().getOffset(), positionBounds2.getEnd().getOffset(), true), JavaEditor.this.createBounds(positionBounds2.getEnd().getOffset(), positionBounds.getEnd().getOffset(), false));
                JavaEditor.this.sections.put(interiorSectionArray[0].getName(), interiorSectionArray[0]);
                interiorSectionArray[0].markGuarded(styledDocument2);
            }
        };
        try {
            Util.runAtomic(styledDocument2, exceptionRunnable);
            this.notifyModified();
        }
        catch (Exception exception) {
            if (exception instanceof BadLocationException) {
                throw (BadLocationException)exception;
            }
            throw new IllegalArgumentException();
        }
        return interiorSectionArray[0];
    }

    private InteriorSection doCreateInteriorSection(final PositionRef positionRef, final String string) throws IllegalArgumentException, BadLocationException {
        StyledDocument styledDocument = null;
        try {
            styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException();
        }
        final StyledDocument styledDocument2 = styledDocument;
        final InteriorSection[] interiorSectionArray = new InteriorSection[]{null};
        Util.ExceptionRunnable exceptionRunnable = new Util.ExceptionRunnable(){

            public void run() throws Exception {
                int n = positionRef.getOffset();
                styledDocument2.insertString(n, "\n \n \n \n", null);
                interiorSectionArray[0] = new InteriorSection(string, JavaEditor.this.createBounds(n + 1, n + 3, false), JavaEditor.this.createBounds(n + 3, n + 5, true), JavaEditor.this.createBounds(n + 5, n + 7, false));
                JavaEditor.this.sections.put(interiorSectionArray[0].getName(), interiorSectionArray[0]);
                interiorSectionArray[0].markGuarded(styledDocument2);
            }
        };
        try {
            Util.runAtomic(styledDocument2, exceptionRunnable);
            this.notifyModified();
        }
        catch (Exception exception) {
            if (exception instanceof BadLocationException) {
                throw (BadLocationException)exception;
            }
            throw new IllegalArgumentException();
        }
        return interiorSectionArray[0];
    }

    public SimpleSection findSimpleSection(String string) {
        GuardedSection guardedSection = this.findSection(string);
        return guardedSection instanceof SimpleSection ? (SimpleSection)guardedSection : null;
    }

    public InteriorSection findInteriorSection(String string) {
        GuardedSection guardedSection = this.findSection(string);
        return guardedSection instanceof InteriorSection ? (InteriorSection)guardedSection : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuardedSection findSection(String string) {
        try {
            StyledDocument styledDocument = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                block6: {
                    if (this.sections == null) break block6;
                    GuardedSection guardedSection = (GuardedSection)this.sections.get(string);
                    return guardedSection;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGuardedSections() {
        try {
            StyledDocument styledDocument = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                block6: {
                    if (this.sections == null) break block6;
                    Iterator iterator = ((HashMap)this.sections.clone()).values().iterator();
                    return iterator;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.EMPTY_SET.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getGuardedSectionNames() {
        try {
            StyledDocument styledDocument = this.openDocument();
            JavaEditor javaEditor = this;
            synchronized (javaEditor) {
                block6: {
                    if (this.sections == null) break block6;
                    Iterator iterator = ((HashMap)this.sections.clone()).keySet().iterator();
                    return iterator;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.EMPTY_SET.iterator();
    }

    public PositionRef findFreePosition(PositionBounds positionBounds) {
        try {
            StyledDocument styledDocument = this.openDocument();
        }
        catch (IOException iOException) {
            return null;
        }
        PositionRef positionRef = positionBounds.getBegin();
        int n = positionRef.getOffset();
        TreeSet treeSet = new TreeSet(SECTION_COMPARATOR);
        treeSet.addAll(this.sections.values());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            GuardedSection guardedSection = (GuardedSection)iterator.next();
            PositionRef positionRef2 = guardedSection.getBegin();
            if (positionRef2.getOffset() > n) break;
            if (!guardedSection.contains(positionRef, false)) continue;
            PositionRef positionRef3 = guardedSection.getPositionAfter();
            if (positionRef3.getOffset() > positionBounds.getEnd().getOffset()) {
                return null;
            }
            return positionRef3;
        }
        return positionRef;
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        return this.createJavaEditorComponent();
    }

    JavaEditorComponent createJavaEditorComponent() {
        MultiDataObject multiDataObject = this.findDataObject();
        JavaEditorComponent javaEditorComponent = new JavaEditorComponent((DataObject)multiDataObject);
        this.componentsCreated = true;
        Workspace workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        Mode mode = workspace.findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)javaEditorComponent);
        }
        return javaEditorComponent;
    }

    MultiDataObject.Entry getJavaEntry() {
        return this.entry;
    }

    synchronized void clearSections() {
        if (this.sections != null) {
            Iterator iterator = ((HashMap)this.sections.clone()).values().iterator();
            while (iterator.hasNext()) {
                GuardedSection guardedSection = (GuardedSection)iterator.next();
                guardedSection.valid = false;
            }
            this.sections = null;
        }
    }

    PositionRef findUnguarded(PositionRef positionRef, boolean bl, boolean bl2) {
        Iterator iterator = this.getGuardedSections();
        while (iterator.hasNext()) {
            GuardedSection guardedSection = (GuardedSection)iterator.next();
            if (!guardedSection.contains(positionRef, bl)) continue;
            if (bl2) {
                return guardedSection.getPositionAfter();
            }
            return guardedSection.getPositionBefore();
        }
        return positionRef;
    }

    private void fillSections(GuardedReader guardedReader, StyledDocument styledDocument) {
        SectionDesc sectionDesc = null;
        Iterator iterator = guardedReader.list.iterator();
        while (iterator.hasNext()) {
            SectionDesc sectionDesc2 = (SectionDesc)iterator.next();
            GuardedSection guardedSection = null;
            switch (sectionDesc2.type) {
                case 0: {
                    guardedSection = new SimpleSection(sectionDesc2.name, this.createBounds(sectionDesc2.begin, sectionDesc2.end, false));
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    sectionDesc = sectionDesc2;
                    break;
                }
                case 4: {
                    if (sectionDesc != null && (sectionDesc.type == 3 || sectionDesc.type == 5) && sectionDesc2.name.equals(sectionDesc.name)) {
                        sectionDesc.end = sectionDesc2.end;
                        break;
                    }
                    sectionDesc = null;
                    break;
                }
                case 2: 
                case 6: {
                    if (sectionDesc != null && sectionDesc.name.equals(sectionDesc2.name)) {
                        if (sectionDesc.type == 1 && sectionDesc2.type == 2) {
                            guardedSection = new SimpleSection(sectionDesc2.name, this.createBounds(sectionDesc.begin, sectionDesc2.end, false));
                            break;
                        }
                        if (sectionDesc.type == 5 && sectionDesc2.type == 6 || sectionDesc.type == 3 && sectionDesc2.type == 2) {
                            guardedSection = new InteriorSection(sectionDesc2.name, this.createBounds(sectionDesc.begin, sectionDesc.end, false), this.createBounds(sectionDesc.end, sectionDesc2.begin, true), this.createBounds(sectionDesc2.begin, sectionDesc2.end, false));
                            break;
                        }
                    }
                    sectionDesc = null;
                }
            }
            if (guardedSection == null) continue;
            this.sections.put(guardedSection.getName(), guardedSection);
            sectionDesc = null;
            guardedSection.markGuarded(styledDocument);
        }
    }

    public PositionBounds createBounds(int n, int n2, boolean bl) {
        if (bl) {
            return new PositionBounds(this.createPositionRef(n, Position.Bias.Forward), this.createPositionRef(n2, Position.Bias.Backward));
        }
        return new PositionBounds(this.createPositionRef(n, Position.Bias.Backward), this.createPositionRef(n2, Position.Bias.Forward));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        StringBuffer stringBuffer = new StringBuffer(MAGIC_PREFIX);
        int n = stringBuffer.length();
        SECTION_MAGICS = new String[7];
        JavaEditor.SECTION_MAGICS[0] = stringBuffer.append("LINE:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[1] = stringBuffer.append("BEGIN:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[2] = stringBuffer.append("END:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[3] = stringBuffer.append("HEADER:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[4] = stringBuffer.append("HEADEREND:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[5] = stringBuffer.append("FIRST:").toString();
        stringBuffer.setLength(n);
        JavaEditor.SECTION_MAGICS[6] = stringBuffer.append("LAST:").toString();
        settings = (JavaSettings)JavaSettings.findObject((Class)(class$org$netbeans$modules$java$settings$JavaSettings == null ? (class$org$netbeans$modules$java$settings$JavaSettings = JavaEditor.class$("org.netbeans.modules.java.settings.JavaSettings")) : class$org$netbeans$modules$java$settings$JavaSettings), (boolean)true);
        SECTION_COMPARATOR = new GuardedPositionComparator();
    }

    private static class NewLineOutputStream
    extends OutputStream {
        OutputStream stream;
        byte newLineType;

        public NewLineOutputStream(OutputStream outputStream, byte by) {
            this.stream = outputStream;
            this.newLineType = by;
        }

        public void write(int n) throws IOException {
            if (n == 10) {
                switch (this.newLineType) {
                    case 1: {
                        this.stream.write(13);
                        break;
                    }
                    case 2: {
                        this.stream.write(13);
                    }
                    case 0: {
                        this.stream.write(10);
                    }
                }
            } else {
                this.stream.write(n);
            }
        }
    }

    static class GuardedWriter
    extends Writer {
        BufferedWriter writer;
        Iterator sections;
        SectionDesc current;
        int offsetCounter;
        boolean wasNewLine;

        GuardedWriter(OutputStream outputStream, ArrayList arrayList, String string) throws IOException {
            this.writer = string == null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : new BufferedWriter(new OutputStreamWriter(outputStream, string));
            this.offsetCounter = 0;
            this.sections = this.prepareSections(arrayList);
            this.nextSection();
            this.wasNewLine = false;
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                this.writeOneChar(cArray[n3 + n]);
                ++n3;
            }
        }

        public void close() throws IOException {
            this.writer.flush();
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        private Iterator prepareSections(ArrayList arrayList) {
            LinkedList<SectionDesc> linkedList = new LinkedList<SectionDesc>();
            Collections.sort(arrayList, new GuardedPositionComparator());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SectionDesc sectionDesc;
                GuardedSection guardedSection = (GuardedSection)iterator.next();
                if (guardedSection instanceof SimpleSection) {
                    sectionDesc = new SectionDesc(0);
                    sectionDesc.name = guardedSection.name;
                    sectionDesc.begin = ((SimpleSection)guardedSection).bounds.getBegin().getOffset();
                    sectionDesc.end = ((SimpleSection)guardedSection).bounds.getEnd().getOffset();
                    linkedList.add(sectionDesc);
                    continue;
                }
                sectionDesc = new SectionDesc(3);
                sectionDesc.begin = ((InteriorSection)guardedSection).header.getBegin().getOffset();
                sectionDesc.end = ((InteriorSection)guardedSection).header.getEnd().getOffset();
                sectionDesc.name = guardedSection.name;
                linkedList.add(sectionDesc);
                sectionDesc = new SectionDesc(2);
                sectionDesc.begin = ((InteriorSection)guardedSection).bottom.getBegin().getOffset();
                sectionDesc.end = ((InteriorSection)guardedSection).bottom.getEnd().getOffset();
                sectionDesc.name = guardedSection.name;
                linkedList.add(sectionDesc);
            }
            return linkedList.iterator();
        }

        void writeOneChar(int n) throws IOException {
            if (n == 13) {
                return;
            }
            if (this.current != null) {
                if (this.offsetCounter == this.current.begin) {
                    this.wasNewLine = false;
                }
                if (n == 10 && this.current.begin < this.offsetCounter) {
                    switch (this.current.type) {
                        case 0: {
                            if (!this.wasNewLine) {
                                if (this.offsetCounter + 1 >= this.current.end) {
                                    this.writeMagic(0, this.current.name);
                                    this.nextSection();
                                    break;
                                }
                                this.writeMagic(1, this.current.name);
                                this.wasNewLine = true;
                                break;
                            }
                            if (this.offsetCounter + 1 < this.current.end) break;
                            this.writeMagic(2, this.current.name);
                            this.nextSection();
                            break;
                        }
                        case 3: {
                            if (!this.wasNewLine) {
                                if (this.offsetCounter + 1 >= this.current.end) {
                                    this.writeMagic(5, this.current.name);
                                    this.nextSection();
                                    break;
                                }
                                this.writeMagic(5, this.current.name);
                                this.wasNewLine = true;
                                break;
                            }
                            if (this.offsetCounter + 1 < this.current.end) break;
                            this.writeMagic(4, this.current.name);
                            this.nextSection();
                            break;
                        }
                        case 2: {
                            this.writeMagic(6, this.current.name);
                            this.nextSection();
                        }
                    }
                }
            }
            this.writer.write(n);
            ++this.offsetCounter;
        }

        private void nextSection() {
            this.current = this.sections.hasNext() ? this.sections.next() : null;
        }

        private void writeMagic(int n, String string) throws IOException {
            this.writer.write(SECTION_MAGICS[n], 0, SECTION_MAGICS[n].length());
            this.writer.write(string, 0, string.length());
        }
    }

    static class GuardedReader
    extends Reader {
        Reader reader;
        char[] charBuff;
        char[] readBuff;
        int howmany;
        RE magicsAsRE;
        boolean justFilter;
        int position;
        LinkedList list;
        final int[] newLineTypes;

        GuardedReader(InputStream inputStream, boolean bl) throws IOException {
            this(inputStream, bl, null);
        }

        GuardedReader(InputStream inputStream, boolean bl, String string) throws IOException {
            this.reader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
            this.justFilter = bl;
            this.position = 0;
            this.list = new LinkedList();
            this.newLineTypes = new int[]{0, 0, 0};
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (this.charBuff == null) {
                this.readCharBuff();
                this.translateToCharBuff();
            }
            if (this.howmany <= 0) {
                return -1;
            }
            int n3 = Math.min(n2, this.howmany);
            System.arraycopy(this.charBuff, this.position, cArray, n, n3);
            this.howmany -= n3;
            this.position += n3;
            return n3;
        }

        final void readCharBuff() throws IOException {
            int n;
            char[] cArray = new char[2048];
            ArrayList<char[]> arrayList = new ArrayList<char[]>(20);
            while (true) {
                n = this.readFully(cArray);
                arrayList.add(cArray);
                if (n < 2048) break;
                cArray = new char[2048];
            }
            int n2 = arrayList.size() - 1;
            int n3 = n2 * 2048 + n;
            this.readBuff = new char[n3];
            this.charBuff = new char[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                char[] cArray2 = (char[])arrayList.get(n5);
                System.arraycopy(cArray2, 0, this.readBuff, n4, 2048);
                n4 += 2048;
                ++n5;
            }
            System.arraycopy(cArray, 0, this.readBuff, n4, n);
        }

        final int readFully(char[] cArray) throws IOException {
            int n = 0;
            int n2 = 0;
            while ((n2 += (n = this.reader.read(cArray, n2, cArray.length - n2))) < cArray.length && n > 0) {
            }
            return n2 + 1;
        }

        final void translateToCharBuff() {
            char c;
            this.position = 0;
            int n = 0;
            int n2 = this.readBuff.length - 1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = JavaEditor.MAGIC_PREFIX.length();
            while (n3 < n2) {
                int n7;
                CharacterArrayCharacterIterator characterArrayCharacterIterator;
                c = this.readBuff[n3];
                switch (c) {
                    case '\n': {
                        this.newLineTypes[0] = this.newLineTypes[0] + 1;
                        this.charBuff[n++] = 10;
                        n4 = n;
                        ++n3;
                        break;
                    }
                    case '\r': {
                        char c2 = this.readBuff[n3 + 1];
                        if (c2 != '\n') {
                            this.newLineTypes[1] = this.newLineTypes[1] + 1;
                            ++n3;
                        } else {
                            n3 += 2;
                            this.newLineTypes[2] = this.newLineTypes[2] + 1;
                        }
                        this.charBuff[n++] = 10;
                        n4 = n;
                        break;
                    }
                    default: {
                        this.charBuff[n++] = this.readBuff[n3++];
                    }
                }
                switch (n5) {
                    case 0: {
                        if (c == '/') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 1: {
                        if (c == '/') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 2: {
                        if (c == 'G') {
                            ++n5;
                            break;
                        }
                        if (c == '/') {
                            n5 = 2;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 3: {
                        if (c == 'E') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 4: {
                        if (c == 'N') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    case 5: {
                        if (c == '-') {
                            ++n5;
                            break;
                        }
                        n5 = 0;
                        break;
                    }
                    default: {
                        n5 = 0;
                    }
                }
                if (n5 != n6) continue;
                n5 = 0;
                RE rE = this.getMagicsAsRE();
                if (!rE.match((CharacterIterator)(characterArrayCharacterIterator = new CharacterArrayCharacterIterator(this.readBuff, n3, n7 = Math.min(10, this.readBuff.length - n3))), 0)) continue;
                String string = rE.getParen(0).toString();
                n -= JavaEditor.MAGIC_PREFIX.length();
                n3 += string.length();
                if (!this.justFilter) {
                    int n8 = GuardedReader.string2Type(string);
                    SectionDesc sectionDesc = new SectionDesc(n8);
                    int n9 = n + SECTION_MAGICS[n8].length();
                    sectionDesc.begin = n4;
                    sectionDesc.end = n + 1;
                    int n10 = this.toNewLine(n3);
                    sectionDesc.name = new String(this.readBuff, n3, n10);
                    this.list.add(sectionDesc);
                    n3 += n10;
                    continue;
                }
                n3 += this.toNewLine(n3);
            }
            if (n3 == n2) {
                c = this.readBuff[n3];
                switch (c) {
                    case '\n': {
                        this.newLineTypes[0] = this.newLineTypes[0] + 1;
                        this.charBuff[n++] = 10;
                        break;
                    }
                    case '\r': {
                        this.newLineTypes[1] = this.newLineTypes[1] + 1;
                        this.charBuff[n++] = 10;
                        break;
                    }
                    default: {
                        this.charBuff[n++] = this.readBuff[n3++];
                    }
                }
            }
            if (!this.justFilter && this.list.size() > 0) {
                SectionDesc sectionDesc = (SectionDesc)this.list.getLast();
                if (sectionDesc.end > n) {
                    sectionDesc.end = n;
                }
            }
            this.howmany = n;
            this.readBuff = null;
        }

        static int string2Type(String string) {
            StringBuffer stringBuffer = new StringBuffer(JavaEditor.MAGIC_PREFIX);
            stringBuffer.append(string);
            string = stringBuffer.toString();
            int n = SECTION_MAGICS.length;
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(SECTION_MAGICS[n2])) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        final int toNewLine(int n) {
            int n2 = n;
            int n3 = this.readBuff.length;
            while (n2 < n3) {
                char c;
                if ((c = this.readBuff[n2++]) != '\r' && c != '\n') continue;
                --n2;
                break;
            }
            return n2 - n;
        }

        final RE getMagicsAsRE() {
            if (this.magicsAsRE == null) {
                try {
                    RECompiler rECompiler = new RECompiler();
                    this.magicsAsRE = new RE(rECompiler.compile(this.makeOrRegexp()));
                }
                catch (RESyntaxException rESyntaxException) {
                    throw new IllegalStateException();
                }
            }
            return this.magicsAsRE;
        }

        final String makeOrRegexp() {
            StringBuffer stringBuffer = new StringBuffer(100);
            int n = JavaEditor.MAGIC_PREFIX.length();
            int n2 = SECTION_MAGICS.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(SECTION_MAGICS[n3].substring(n));
                stringBuffer.append('|');
                ++n3;
            }
            stringBuffer.append(SECTION_MAGICS[n2].substring(n));
            return stringBuffer.toString();
        }

        byte getNewLineType() {
            if (this.newLineTypes[0] > this.newLineTypes[1]) {
                return this.newLineTypes[0] > this.newLineTypes[2] ? (byte)0 : 2;
            }
            return this.newLineTypes[1] > this.newLineTypes[2] ? (byte)1 : 2;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class SectionDesc {
        int type;
        String name;
        int begin;
        int end;

        SectionDesc(int n) {
            this.type = n;
            this.name = null;
            this.begin = 0;
            this.end = 0;
        }
    }

    private static class GuardedPositionComparator
    implements Comparator {
        private GuardedPositionComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.getOffset(object) - this.getOffset(object2);
        }

        private int getOffset(Object object) {
            if (object instanceof SimpleSection) {
                return ((SimpleSection)object).bounds.getBegin().getOffset();
            }
            return ((InteriorSection)object).header.getBegin().getOffset();
        }
    }

    public final class InteriorSection
    extends GuardedSection {
        PositionBounds header;
        PositionBounds body;
        PositionBounds bottom;

        InteriorSection(String string, PositionBounds positionBounds, PositionBounds positionBounds2, PositionBounds positionBounds3) {
            super(string);
            this.header = positionBounds;
            this.body = positionBounds2;
            this.bottom = positionBounds3;
        }

        public boolean setBody(String string) {
            return this.setText(this.body, string, false);
        }

        public boolean setHeader(String string) {
            return this.setText(this.header, string, true);
        }

        public String getHeader() {
            if (!this.isValid()) {
                return null;
            }
            try {
                return this.header.getText();
            }
            catch (IOException iOException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public boolean setBottom(String string) {
            int n;
            boolean bl = string.endsWith("\n");
            int n2 = string.indexOf(10);
            if (n2 != (n = string.lastIndexOf(10)) || bl && n2 != -1) {
                if (bl) {
                    string = string.substring(0, string.length() - 1);
                }
                string = string.replace('\n', ' ');
            }
            return this.setText(this.bottom, string, true);
        }

        public String getBottom() throws IOException, BadLocationException {
            if (!this.isValid()) {
                return null;
            }
            try {
                return this.bottom.getText();
            }
            catch (IOException iOException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }

        public PositionRef getBegin() {
            return this.body.getBegin();
        }

        void deleteText() throws BadLocationException, IOException {
            this.header.setText("");
            this.body.setText("");
            this.bottom.setText("");
            this.deleteNewLineBeforeBlock(this.header.getBegin().getOffset());
        }

        void markGuarded(StyledDocument styledDocument) {
            this.markGuarded(styledDocument, this.header, true);
            this.markGuarded(styledDocument, this.bottom, true);
        }

        void unmarkGuarded(StyledDocument styledDocument) {
            this.markGuarded(styledDocument, this.header, false);
            this.markGuarded(styledDocument, this.bottom, false);
            JavaEditor.this.notifyModified();
        }

        public String getText() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(this.header.getText());
                stringBuffer.append(this.body.getText());
                stringBuffer.append(this.bottom.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stringBuffer.toString();
        }

        public boolean contains(PositionRef positionRef, boolean bl) {
            if (!bl) {
                return this.header.getBegin().getOffset() <= positionRef.getOffset() && this.bottom.getEnd().getOffset() >= positionRef.getOffset();
            }
            if (this.header.getBegin().getOffset() <= positionRef.getOffset() && this.header.getEnd().getOffset() >= positionRef.getOffset()) {
                return true;
            }
            return this.bottom.getBegin().getOffset() <= positionRef.getOffset() && this.bottom.getEnd().getOffset() >= positionRef.getOffset();
        }

        public PositionRef getPositionBefore() {
            return JavaEditor.this.createPositionRef(this.header.getBegin().getOffset(), Position.Bias.Forward);
        }

        public PositionRef getPositionAfter() {
            return JavaEditor.this.createPositionRef(this.bottom.getEnd().getOffset(), Position.Bias.Backward);
        }
    }

    public final class SimpleSection
    extends GuardedSection {
        PositionBounds bounds;

        SimpleSection(String string, PositionBounds positionBounds) {
            super(string);
            this.bounds = positionBounds;
        }

        public boolean setText(String string) {
            return this.setText(this.bounds, string, true);
        }

        void deleteText() throws BadLocationException, IOException {
            this.bounds.setText("");
            this.deleteNewLineBeforeBlock(this.bounds.getBegin().getOffset());
        }

        void markGuarded(StyledDocument styledDocument) {
            this.markGuarded(styledDocument, this.bounds, true);
        }

        void unmarkGuarded(StyledDocument styledDocument) {
            this.markGuarded(styledDocument, this.bounds, false);
            JavaEditor.this.notifyModified();
        }

        public PositionRef getBegin() {
            return this.bounds.getBegin();
        }

        public String getText() {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(this.bounds.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stringBuffer.toString();
        }

        public PositionRef getPositionAfter() {
            return JavaEditor.this.createPositionRef(this.bounds.getEnd().getOffset(), Position.Bias.Backward);
        }

        public boolean contains(PositionRef positionRef, boolean bl) {
            return this.bounds.getBegin().getOffset() <= positionRef.getOffset() && this.bounds.getEnd().getOffset() >= positionRef.getOffset();
        }

        public PositionRef getPositionBefore() {
            return JavaEditor.this.createPositionRef(this.bounds.getBegin().getOffset(), Position.Bias.Forward);
        }
    }

    public abstract class GuardedSection {
        String name;
        boolean valid;

        public String getName() {
            return this.name;
        }

        GuardedSection(String string) {
            this.name = string;
            this.valid = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setName(String string) throws PropertyVetoException {
            if (!this.name.equals(string)) {
                JavaEditor javaEditor = JavaEditor.this;
                synchronized (javaEditor) {
                    if (this.valid) {
                        if (JavaEditor.this.sections.get(string) != null) {
                            throw new PropertyVetoException("", new PropertyChangeEvent(this, "name", this.name, string));
                        }
                        JavaEditor.this.sections.remove(this.name);
                        this.name = string;
                        JavaEditor.this.sections.put(string, this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean deleteSection() {
            JavaEditor javaEditor = JavaEditor.this;
            synchronized (javaEditor) {
                if (!this.valid) return false;
                try {
                    JavaEditor.this.sections.remove(this.name);
                    this.unmarkGuarded(JavaEditor.this.getDocument());
                    this.deleteText();
                    this.valid = false;
                    return true;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSection() {
            JavaEditor javaEditor = JavaEditor.this;
            synchronized (javaEditor) {
                block4: {
                    if (this.valid) break block4;
                    boolean bl = false;
                    return bl;
                }
                JavaEditor.this.sections.remove(this.name);
                this.unmarkGuarded(JavaEditor.this.getDocument());
                this.valid = false;
                boolean bl = true;
                return bl;
            }
        }

        void deleteNewLineBeforeBlock(int n) {
            if (n > 1) {
                try {
                    PositionBounds positionBounds = JavaEditor.this.createBounds(n - 1, n, true);
                    String string = positionBounds.getText();
                    if (string.equals("\n")) {
                        positionBounds.setText("");
                    }
                }
                catch (IOException iOException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void openAt() {
            JavaEditor.this.openAt(this.getBegin());
        }

        protected boolean setText(PositionBounds positionBounds, String string, boolean bl) {
            if (!this.valid) {
                return false;
            }
            if (bl) {
                if (string.length() == 0) {
                    string = " \n";
                } else if (string.length() == 1) {
                    String string2 = string = string.equals("\n") ? " \n" : string + "\n";
                }
            }
            if (!string.endsWith("\n")) {
                string = string + "\n";
            }
            try {
                positionBounds.setText(string);
                return true;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        void markGuarded(StyledDocument styledDocument, PositionBounds positionBounds, boolean bl) {
            int n = positionBounds.getBegin().getOffset();
            int n2 = positionBounds.getEnd().getOffset();
            if (bl) {
                NbDocument.markGuarded((StyledDocument)styledDocument, (int)n, (int)(n2 - n));
            } else {
                NbDocument.unmarkGuarded((StyledDocument)styledDocument, (int)n, (int)(n2 - n));
            }
        }

        abstract void markGuarded(StyledDocument var1);

        abstract void unmarkGuarded(StyledDocument var1);

        abstract void deleteText() throws BadLocationException, IOException;

        public abstract PositionRef getBegin();

        public abstract String getText();

        public abstract boolean contains(PositionRef var1, boolean var2);

        public abstract PositionRef getPositionAfter();

        public abstract PositionRef getPositionBefore();
    }

    public static class JavaEditorComponent
    extends EditorSupport.Editor
    implements PropertyChangeListener {
        static final int SELECTED_NODES_DELAY = 1000;
        Timer timerSelNodes;
        JavaEditor support;
        CaretListener caretListener;
        Parsing.Listener parsingListener;
        Component toolBar;
        int lastCaretOffset = -1;
        static final long serialVersionUID = 6223349196427270209L;
        private transient RequestProcessor.Task selectionTask = null;

        public JavaEditorComponent() {
        }

        public JavaEditorComponent(DataObject dataObject) {
            super(dataObject);
            this.initialize();
        }

        void selectElementsAtOffset(int n) {
            Node[] nodeArray;
            SourceElement.Impl impl = this.support.findParser().getSourceImpl();
            if (impl == null) {
                return;
            }
            if (TopComponent.getRegistry().getActivated() != this || !this.support.getJavaDataObject().isValid()) {
                return;
            }
            SourceCookie.Editor editor = (SourceCookie.Editor)this.support.getJavaDataObject().getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = JavaEditor.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
            org.openide.src.Element element = editor.findElement(n);
            ElementNodeFactory elementNodeFactory = JavaDataObject.getExplorerFactory();
            Node node = null;
            if (element instanceof MethodElement) {
                node = elementNodeFactory.createMethodNode((MethodElement)element);
            } else if (element instanceof ClassElement) {
                node = elementNodeFactory.createClassNode((ClassElement)element);
            } else if (element instanceof ConstructorElement) {
                node = elementNodeFactory.createConstructorNode((ConstructorElement)element);
            } else if (element instanceof FieldElement) {
                node = elementNodeFactory.createFieldNode((FieldElement)element);
            } else if (element instanceof InitializerElement) {
                node = elementNodeFactory.createInitializerNode((InitializerElement)element);
            } else if (element instanceof SourceElement) {
                node = this.support.getJavaEntry().getDataObject().getNodeDelegate();
            }
            if (node != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = node;
            } else {
                nodeArray = new Node[]{};
            }
            this.setActivatedNodes(nodeArray);
        }

        protected void notifyParsingDone() {
            if (this.lastCaretOffset != -1) {
                this.selectElementsAtOffset(this.lastCaretOffset);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("showToolbar".equals(string)) {
                this.enableToolBar((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        public final void enableToolBar(boolean bl) {
            if (bl) {
                Component component = this.getToolBar();
                if (component == null) {
                    return;
                }
                if (this.isAncestorOf(this.toolBar)) {
                    this.toolBar.setVisible(true);
                } else {
                    this.add(this.toolBar, "North");
                    this.toolBar.setVisible(true);
                }
            } else if (this.toolBar != null) {
                this.toolBar.setVisible(false);
            }
        }

        private void initializeToolBar() {
            this.enableToolBar(settings.getShowToolbar());
        }

        protected Component createToolBar() {
            JToolBar jToolBar = JEditorToolbar.createToolBar("Editors/text/x-java/Toolbar");
            return jToolBar;
        }

        public SystemAction[] getSystemActions() {
            this.selectElementsAtOffset(this.lastCaretOffset);
            this.timerSelNodes.stop();
            return super.getSystemActions();
        }

        protected final Component getToolBar() {
            if (this.toolBar != null) {
                return this.toolBar;
            }
            this.toolBar = this.createToolBar();
            return this.toolBar;
        }

        private void initialize() {
            DataObject dataObject = this.obj;
            this.support = (JavaEditor)this.obj.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = JavaEditor.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor);
            this.timerSelNodes = new Timer(100, new ActionListener(this){
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = javaEditorComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Caret caret;
                    if (this.this$0.lastCaretOffset == -1 && JavaEditorComponent.access$501(this.this$0) != null && (caret = JavaEditorComponent.access$601(this.this$0).getCaret()) != null) {
                        this.this$0.lastCaretOffset = caret.getDot();
                    }
                    this.this$0.selectElementsAtOffset(this.this$0.lastCaretOffset);
                }
            });
            this.timerSelNodes.setInitialDelay(100);
            this.timerSelNodes.setRepeats(false);
            this.caretListener = new CaretListener(this){
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = javaEditorComponent;
                }

                public void caretUpdate(CaretEvent caretEvent) {
                    this.this$0.support.restartTimer(true);
                    this.this$0.restartTimerSelNodes(caretEvent.getDot());
                }
            };
            this.timerSelNodes.restart();
            this.parsingListener = new Parsing.Listener(this, dataObject){
                private final /* synthetic */ DataObject val$myJavaObject;
                private final /* synthetic */ JavaEditorComponent this$0;
                {
                    this.this$0 = javaEditorComponent;
                    this.val$myJavaObject = dataObject;
                }

                public void objectParsed(Parsing.Event event) {
                    if (event.getJavaDataObject() == this.val$myJavaObject) {
                        this.this$0.notifyParsingDone();
                    }
                }
            };
            this.initializeToolBar();
        }

        public void addNotify() {
            settings.addPropertyChangeListener(this);
            super.addNotify();
        }

        public void removeNotify() {
            super.removeNotify();
            settings.removePropertyChangeListener(this);
        }

        void restartTimerSelNodes(int n) {
            this.timerSelNodes.setInitialDelay(1000);
            this.timerSelNodes.restart();
            this.lastCaretOffset = n;
        }

        private JEditorPane getEditorPane() {
            return this.pane;
        }

        protected CloneableTopComponent createClonedObject() {
            return this.support.createJavaEditorComponent();
        }

        protected void componentActivated() {
            try {
                Debugger debugger = TopManager.getDefault().getDebugger();
                ((ToggleBreakpointAction)SystemAction.get((Class)(class$org$openide$actions$ToggleBreakpointAction == null ? (class$org$openide$actions$ToggleBreakpointAction = JavaEditor.class$("org.openide.actions.ToggleBreakpointAction")) : class$org$openide$actions$ToggleBreakpointAction))).setActionPerformer(new ActionPerformer(this, debugger){
                    private final /* synthetic */ Debugger val$debugger;
                    private final /* synthetic */ JavaEditorComponent this$0;
                    {
                        this.this$0 = javaEditorComponent;
                        this.val$debugger = debugger;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void performAction(SystemAction systemAction) {
                        int n = NbDocument.findLineNumber((StyledDocument)this.this$0.support.getDocument(), (int)JavaEditorComponent.access$700(this.this$0).getCaret().getDot());
                        Line line = this.this$0.support.getLineSet().getCurrent(n);
                        13 var4_4 = this;
                        synchronized (var4_4) {
                            Breakpoint breakpoint = this.val$debugger.findBreakpoint(line);
                            if (breakpoint == null) {
                                this.val$debugger.createBreakpoint(line);
                            } else {
                                breakpoint.remove();
                            }
                        }
                    }
                });
            }
            catch (DebuggerNotFoundException debuggerNotFoundException) {
                // empty catch block
            }
            this.getEditorPane().addCaretListener(this.caretListener);
            Parsing.addParsingListener(this.parsingListener);
            super.componentActivated();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void componentDeactivated() {
            ((ToggleBreakpointAction)SystemAction.get((Class)(class$org$openide$actions$ToggleBreakpointAction == null ? (class$org$openide$actions$ToggleBreakpointAction = JavaEditor.class$("org.openide.actions.ToggleBreakpointAction")) : class$org$openide$actions$ToggleBreakpointAction))).setActionPerformer(null);
            this.getEditorPane().removeCaretListener(this.caretListener);
            Parsing.removeParsingListener(this.parsingListener);
            JavaEditorComponent javaEditorComponent = this;
            synchronized (javaEditorComponent) {
                if (this.selectionTask != null) {
                    this.selectionTask.cancel();
                    this.selectionTask = null;
                }
            }
            super.componentDeactivated();
        }

        protected boolean closeLast() {
            if (!super.closeLast()) {
                return false;
            }
            this.support.componentsCreated = false;
            return true;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.initialize();
        }

        static /* synthetic */ JEditorPane access$501(JavaEditorComponent javaEditorComponent) {
            return ((CloneableEditor)javaEditorComponent).pane;
        }

        static /* synthetic */ JEditorPane access$601(JavaEditorComponent javaEditorComponent) {
            return ((CloneableEditor)javaEditorComponent).pane;
        }

        static /* synthetic */ JEditorPane access$700(JavaEditorComponent javaEditorComponent) {
            return javaEditorComponent.getEditorPane();
        }
    }
}

