/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codegen;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.codegen.CodeGenerator;
import org.netbeans.modules.java.codegen.ContainerImpl;
import org.netbeans.modules.java.codegen.ExceptionRunnable;
import org.netbeans.modules.java.codegen.SourceText;
import org.netbeans.modules.java.codegen.TextBinding;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.ElementProperties;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

abstract class ElementBinding
implements TextBinding,
ElementProperties {
    private Element el;
    protected PositionBounds wholeBounds;
    protected PositionBounds docBounds;
    protected PositionBounds headerBounds;
    protected PositionBounds bodyBounds;
    protected SourceText source;
    protected ContainerImpl containerRef;
    static Map setterCache;
    private static final boolean DEBUG = false;
    private static final String lineSeparator;
    private static final int lineSeparatorLength;
    private static final String LINEFEED = "\n";
    static final int CLASS_IGNORE = 0;
    static final int CLASS_HEADER = 1;
    static final int CLASS_BODY = 2;
    static final int CLASS_JAVADOC = 3;

    public ElementBinding(Element element, SourceText sourceText) {
        this.el = element;
        this.source = sourceText;
        sourceText.registerBinding(element, this);
    }

    public TextBinding.Container getContainer(String string) {
        return this.containerRef;
    }

    public void linkAfter(TextBinding textBinding) {
    }

    public Element getElement() {
        return this.el;
    }

    public PositionBounds getElementRange(boolean bl) {
        if (!bl || this.headerBounds == null) {
            return this.wholeBounds;
        }
        return new PositionBounds(this.headerBounds.getBegin(), this.wholeBounds.getEnd());
    }

    protected abstract Element cloneElement();

    public void create(PositionBounds positionBounds) throws SourceException {
        this.wholeBounds = positionBounds;
        this.regenerateWhole(this.el, true);
    }

    public PositionRef prepareInsert(ElementBinding elementBinding, boolean bl) throws SourceException {
        return bl ? this.wholeBounds.getEnd() : this.wholeBounds.getBegin();
    }

    public void insertAfter(ElementBinding elementBinding) throws SourceException {
        elementBinding.createAt(this.wholeBounds.getEnd());
    }

    public void create(ContainerImpl containerImpl, ElementBinding elementBinding, ElementBinding elementBinding2, PositionBounds positionBounds, boolean bl, boolean bl2) throws SourceException {
        PositionRef positionRef;
        PositionRef positionRef2 = elementBinding == null ? positionBounds.getBegin() : elementBinding.prepareInsert(this, true);
        PositionBounds positionBounds2 = new PositionBounds(positionRef2, positionRef = elementBinding2 == null ? positionBounds.getEnd() : elementBinding2.prepareInsert(this, false));
        PositionRef positionRef3 = this.source.findFreePosition(positionBounds2);
        if (positionRef3 == null) {
            throw new SourceException("No room for element");
        }
        this.createAt(positionRef3, bl, bl2);
        this.containerRef = containerImpl;
    }

    private void createAt(PositionRef positionRef, boolean bl, boolean bl2) throws SourceException {
        PositionBounds positionBounds = CodeGenerator.createNewLineBounds(positionRef, 0, bl, bl2);
        this.create(positionBounds);
    }

    private void createAt(PositionRef positionRef) throws SourceException {
        PositionBounds positionBounds = CodeGenerator.createNewLineBounds(positionRef, 0);
        this.create(positionBounds);
    }

    public void applyPropertyChange(Object object, String string, Object object2) throws SourceException {
        Method method;
        if (setterCache == null) {
            setterCache = new HashMap(29);
            method = null;
        } else {
            method = (Method)setterCache.get(string);
        }
        if (method == null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                int n = 0;
                while (n < propertyDescriptorArray.length) {
                    if (propertyDescriptorArray[n].getName().equals(string)) {
                        method = propertyDescriptorArray[n].getWriteMethod();
                    }
                    ++n;
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            if (method == null) {
                throw new SourceException("Cannot find setter for " + string);
            }
            setterCache.put(string, method);
        }
        try {
            method.invoke(object, object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void changeElementProperty(final PropertyChangeEvent propertyChangeEvent) throws SourceException {
        if (!this.source.isGeneratorEnabled()) {
            return;
        }
        this.source.runAtomic(this.el, new ExceptionRunnable(){

            public void run() throws Exception {
                ElementBinding.this.doChangeProperty(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
    }

    protected void doChangeProperty(String string, Object object, Object object2) throws Exception {
        int n = this.classifyProperty(string);
        if (n == 0) {
            return;
        }
        Element element = this.cloneElement();
        this.applyPropertyChange(element, string, object2);
        switch (n) {
            case 1: {
                this.regenerateHeader(element);
                break;
            }
            case 2: {
                this.regenerateBody(element);
                break;
            }
            case 3: {
                this.regenerateJavaDoc(element, this.getJavaDoc());
            }
        }
    }

    protected JavaDoc getJavaDoc() {
        throw new UnsupportedOperationException("Generic javadoc not supported!");
    }

    protected int classifyProperty(String string) {
        return 0;
    }

    public ElementBinding findBindingAt(int n) {
        if (this.wholeBounds.getBegin().getOffset() <= n && this.wholeBounds.getEnd().getOffset() > n) {
            return this;
        }
        return null;
    }

    protected void remove(boolean bl, boolean bl2) throws SourceException, IllegalStateException {
        try {
            CodeGenerator.clearBounds(this.wholeBounds, bl);
        }
        catch (Exception exception) {
            this.source.rethrowException(this.el, exception);
        }
    }

    protected void moveTo(ElementBinding elementBinding, ElementBinding elementBinding2) throws SourceException {
        PositionBounds positionBounds = this.wholeBounds;
        this.containerRef.insertChild(this, elementBinding, elementBinding2);
        try {
            CodeGenerator.clearBounds(positionBounds, false);
        }
        catch (BadLocationException badLocationException) {
            throw new SourceException.Protection(this.getElement());
        }
    }

    protected StyledDocument findDocument() throws SourceException.IO {
        return this.source.getDocument();
    }

    protected void regenerateHeader(Element element) throws SourceException {
        StyledDocument styledDocument = this.findDocument();
        this.source.runAtomic(this.el, new PartialGenerator(styledDocument, element, this.headerBounds, 4, 5));
    }

    protected void regenerateWhole(Element element, boolean bl) throws SourceException {
        StyledDocument styledDocument = this.findDocument();
        this.source.runAtomic(this.el, new PartialGenerator(styledDocument, element, bl));
    }

    protected void regenerateBody(Element element) throws SourceException {
        StyledDocument styledDocument = this.findDocument();
        this.source.runAtomic(this.el, new PartialGenerator(styledDocument, element, this.bodyBounds, 4, 5));
    }

    protected void regenerateJavaDoc(Element element, JavaDoc javaDoc) throws SourceException {
        StyledDocument styledDocument = this.findDocument();
        if (this.docBounds != null) {
            this.source.runAtomic(this.el, new PartialGenerator(styledDocument, element, this.docBounds, 2, 3));
        } else {
            this.source.runAtomic(this.el, new JavaDocGenerator((Document)styledDocument, element, javaDoc));
        }
    }

    public boolean canInsertAfter() {
        return true;
    }

    public void changeJavaDoc(JavaDoc javaDoc) throws SourceException {
        if (!this.source.isGeneratorEnabled()) {
            return;
        }
        this.regenerateJavaDoc(this.el, javaDoc);
    }

    public void updateBounds(int n, PositionBounds positionBounds) {
        switch (n) {
            case 0: {
                this.wholeBounds = positionBounds;
                break;
            }
            case 1: {
                this.docBounds = positionBounds;
                break;
            }
            case 3: {
                this.bodyBounds = positionBounds;
                break;
            }
            case 2: {
                this.headerBounds = positionBounds;
            }
        }
    }

    PositionRef getEndPosition() {
        StyledDocument styledDocument = this.source.getEditorSupport().getDocument();
        return this.source.createPos(styledDocument.getLength(), Position.Bias.Backward);
    }

    PositionBounds findContainerBounds(TextBinding.Container container) {
        throw new UnsupportedOperationException(this.toString());
    }

    public String toString() {
        return "Binding for " + this.getElement();
    }

    static String convertNewlines(String string) {
        if (lineSeparator == null) {
            return string;
        }
        int n = string.indexOf(lineSeparator);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        if (n > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        stringBuffer.append(LINEFEED);
        int n2 = n += lineSeparatorLength;
        while (n < cArray.length) {
            if ((n = string.indexOf(lineSeparator, n)) == -1) {
                stringBuffer.append(cArray, n2, cArray.length - n2);
                return stringBuffer.toString();
            }
            stringBuffer.append(cArray, n2, n - n2);
            stringBuffer.append(LINEFEED);
            n2 = n += lineSeparatorLength;
        }
        stringBuffer.append(cArray, n2, n - n2);
        return stringBuffer.toString();
    }

    static {
        String string = System.getProperty("line.separator");
        if (string == null || LINEFEED.equals(string)) {
            lineSeparator = null;
            lineSeparatorLength = -1;
        } else {
            lineSeparator = string;
            lineSeparatorLength = string.length();
        }
    }

    static class ElementPrinterImpl
    implements ElementPrinter {
        PrintWriter writer;
        String lastText = null;
        Element printedElement;
        int beginMark;
        int endMark;
        int status;

        ElementPrinterImpl(Writer writer) {
            this(writer, null, 0, 0);
            this.status = 1;
        }

        ElementPrinterImpl(Writer writer, Element element, int n, int n2) {
            this.writer = new PrintWriter(writer);
            this.printedElement = element;
            this.beginMark = n;
            this.endMark = n2;
            this.status = 0;
        }

        public boolean isBegin(Element element, int n) {
            return this.printedElement == null || element == this.printedElement && n == this.beginMark;
        }

        public boolean isEnd(Element element, int n) {
            return this.printedElement == element && n == this.endMark;
        }

        public void markNotify(Element element, int n) {
        }

        public String getString() {
            return this.writer.toString();
        }

        public void print(String string) throws ElementPrinterInterruptException {
            switch (this.status) {
                case 0: {
                    this.lastText = null;
                    return;
                }
                case 1: {
                    this.lastText = string = ElementBinding.convertNewlines(string);
                    this.writer.print(string);
                    break;
                }
                case 2: {
                    throw new ElementPrinterInterruptException();
                }
            }
        }

        public void println(String string) throws ElementPrinterInterruptException {
            this.print(string);
            this.print(ElementBinding.LINEFEED);
        }

        private void mark(Element element, int n) throws ElementPrinterInterruptException {
            switch (this.status) {
                case 0: {
                    if (!this.isBegin(element, n)) break;
                    this.markNotify(element, n);
                    this.status = 1;
                    break;
                }
                case 1: {
                    this.writer.flush();
                    this.markNotify(element, n);
                    if (!this.isEnd(element, n)) break;
                    this.status = 2;
                    this.writer.close();
                    throw new ElementPrinterInterruptException();
                }
                case 2: {
                    throw new ElementPrinterInterruptException();
                }
            }
        }

        public void markClass(ClassElement classElement, int n) throws ElementPrinterInterruptException {
            this.mark((Element)classElement, n);
        }

        public void markInitializer(InitializerElement initializerElement, int n) throws ElementPrinterInterruptException {
            this.mark((Element)initializerElement, n);
        }

        public void markField(FieldElement fieldElement, int n) throws ElementPrinterInterruptException {
            this.mark((Element)fieldElement, n);
        }

        public void markConstructor(ConstructorElement constructorElement, int n) throws ElementPrinterInterruptException {
            this.mark((Element)constructorElement, n);
        }

        public void markMethod(MethodElement methodElement, int n) throws ElementPrinterInterruptException {
            this.mark((Element)methodElement, n);
        }
    }

    class WholeElementPrinter
    extends ElementPrinterImpl {
        StringWriter stringWriter;
        CloneableEditorSupport editor;
        int[] positions;

        WholeElementPrinter(Writer writer, StringWriter stringWriter) {
            super(writer);
            this.stringWriter = stringWriter;
            this.editor = ElementBinding.this.source.getEditorSupport();
            this.positions = new int[8];
            Arrays.fill(this.positions, -1);
        }

        public void markNotify(Element element, int n) {
            if (this.lastText != null && this.lastText.endsWith(" ")) {
                String string = this.stringWriter.getBuffer().toString();
                int n2 = this.lastText.length();
                if (n2 > 0 && !string.endsWith(" ")) {
                    int n3 = 0;
                    int n4 = n2 - 1;
                    while (n4 >= 0) {
                        n3 = this.lastText.charAt(n4);
                        if (n3 != 32) break;
                        --n4;
                    }
                    if (n3 != 10) {
                        this.stringWriter.write(this.lastText, ++n4, n2 - n4);
                    }
                }
            }
            this.positions[n] = this.stringWriter.getBuffer().length();
            if (n == 1 && this.positions[7] != -1 && (element instanceof ConstructorElement || element instanceof InitializerElement)) {
                this.positions[7] = this.positions[1] - 1;
            }
        }

        void finish() {
            int n = ElementBinding.this.wholeBounds.getBegin().getOffset();
            if (this.positions[0] != -1 && this.positions[1] != -1) {
                ElementBinding.this.wholeBounds = this.createStableBounds(this.positions[0] + n, this.positions[1] + n);
            }
            if (this.positions[2] != -1 && this.positions[3] != -1) {
                ElementBinding.this.docBounds = this.createStableBounds(this.positions[2] + n, this.positions[3] + n);
            }
            if (this.positions[4] != -1 && this.positions[5] != -1) {
                ElementBinding.this.headerBounds = this.createStableBounds(this.positions[4] + n, this.positions[5] + n);
            }
            if (this.positions[6] != -1 && this.positions[7] != -1) {
                ElementBinding.this.bodyBounds = this.createBounds(this.positions[6] + n, this.positions[7] + n);
            }
        }

        private PositionBounds createStableBounds(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return null;
            }
            PositionRef positionRef = this.editor.createPositionRef(n, Position.Bias.Backward);
            PositionRef positionRef2 = this.editor.createPositionRef(n2, Position.Bias.Forward);
            return new PositionBounds(positionRef, positionRef2);
        }

        private PositionBounds createBounds(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return null;
            }
            PositionRef positionRef = this.editor.createPositionRef(n, Position.Bias.Backward);
            PositionRef positionRef2 = this.editor.createPositionRef(n2, Position.Bias.Forward);
            return new PositionBounds(positionRef, positionRef2);
        }
    }

    protected class PartialGenerator
    implements ExceptionRunnable {
        PositionBounds posBounds;
        int begin;
        int end;
        Document doc;
        Element el;
        boolean update;

        PartialGenerator(Document document, Element element, boolean bl) {
            this.update = bl;
            this.el = element;
            this.doc = document;
            this.begin = 0;
            this.end = 1;
            this.posBounds = ElementBinding.this.wholeBounds;
        }

        PartialGenerator(Document document, Element element, PositionBounds positionBounds, int n, int n2) {
            this.posBounds = positionBounds;
            this.begin = n;
            this.end = n2;
            this.doc = document;
            this.el = element;
        }

        public void run() throws Exception {
            PositionRef positionRef = this.posBounds.getBegin();
            StyledDocument styledDocument = ElementBinding.this.findDocument();
            StringWriter stringWriter = new StringWriter();
            Writer writer = CodeGenerator.findIndentWriter(styledDocument, positionRef.getOffset(), stringWriter);
            ElementPrinterImpl elementPrinterImpl = this.update ? new WholeElementPrinter(writer, stringWriter) : new ElementPrinterImpl(writer, this.el, this.begin, this.end);
            try {
                this.el.print((ElementPrinter)elementPrinterImpl);
            }
            catch (ElementPrinterInterruptException elementPrinterInterruptException) {
                // empty catch block
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {
                throw new InternalError(iOException.getMessage());
            }
            CodeGenerator.fillTextBounds(this.posBounds, stringWriter.toString());
            if (this.update) {
                ((WholeElementPrinter)elementPrinterImpl).finish();
            }
        }
    }

    protected class JavaDocGenerator
    extends PartialGenerator {
        JavaDoc content;

        JavaDocGenerator(Document document, Element element, JavaDoc javaDoc) {
            super(document, element, null, 2, 3);
            this.content = javaDoc;
        }

        public void run() throws Exception {
            String string = this.content.getRawText();
            if (string == null) {
                if (ElementBinding.this.docBounds != null) {
                    CodeGenerator.clearBounds(ElementBinding.this.docBounds, false);
                    ElementBinding.this.docBounds = null;
                }
            } else {
                this.posBounds = CodeGenerator.createNewLineBounds(ElementBinding.this.wholeBounds.getBegin(), 1);
                super.run();
                ElementBinding.this.docBounds = this.posBounds;
                ElementBinding.this.wholeBounds = new PositionBounds(this.posBounds.getBegin(), ElementBinding.this.wholeBounds.getEnd());
            }
        }
    }

    protected class RemovingRunnable
    implements ExceptionRunnable {
        protected RemovingRunnable() {
        }

        public void run() throws Exception {
            CodeGenerator.clearBounds(ElementBinding.this.wholeBounds, true);
        }
    }
}

