/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.codesync;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.java.JavaConnections;
import org.netbeans.modules.java.codesync.ClassDependencyImpl;
import org.netbeans.modules.java.codesync.Registrar;
import org.netbeans.modules.java.codesync.SynchronizeCodeCookie;
import org.netbeans.modules.java.model.LangModel;
import org.openide.cookies.ConnectionCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class SourceConnectionSupport
implements PropertyChangeListener,
Registrar,
ConnectionCookie.Listener,
SynchronizeCodeCookie {
    private static final String[] SKIP_REGISTRATION_PREFIXES = new String[]{"java.", "javax."};
    private static final boolean DEBUG = false;
    public static final int CONNECT_NOT = 0;
    public static final int CONNECT_CONFIRM = 1;
    public static final int CONNECT_AUTO = 2;
    public static final int CONNECT_DEFAULT = 1;
    SourceElement src;
    ClassDependencyImpl classDeps;
    Map dependencies;
    Node listenerNode;
    boolean initialized;
    int suspended;
    String supportID;
    LangModel model;
    int syncMode = -1;
    boolean relinkEnabled;
    boolean fullRefresh;
    Collection classList;
    public static final ConnectionCookie.Type DEPENDENCY_IMPLEMENTATION = JavaConnections.IMPLEMENTS;
    ClassElement[] NO_CLASSES = new ClassElement[0];
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$netbeans$modules$java$codesync$SourceConnectionSupport;
    static /* synthetic */ Class class$org$openide$cookies$ConnectionCookie;

    public SourceConnectionSupport(SourceElement sourceElement, LangModel langModel, String string) {
        this.src = sourceElement;
        this.supportID = string;
        this.model = langModel;
        this.suspended = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getString(String string) {
        if (bundle == null) {
            Class clazz = class$org$netbeans$modules$java$codesync$SourceConnectionSupport == null ? (class$org$netbeans$modules$java$codesync$SourceConnectionSupport = SourceConnectionSupport.class$("org.netbeans.modules.java.codesync.SourceConnectionSupport")) : class$org$netbeans$modules$java$codesync$SourceConnectionSupport;
            synchronized (clazz) {
                if (bundle == null) {
                    bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$java$codesync$SourceConnectionSupport == null ? (class$org$netbeans$modules$java$codesync$SourceConnectionSupport = SourceConnectionSupport.class$("org.netbeans.modules.java.codesync.SourceConnectionSupport")) : class$org$netbeans$modules$java$codesync$SourceConnectionSupport));
                }
            }
        }
        return bundle.getString(string);
    }

    private void initialize() {
        this.classDeps = new ClassDependencyImpl(this);
        this.model.addPostCommitListener(this.classDeps);
        this.src.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void checkState() {
        this.loadModel();
        if (!this.fullRefresh) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    SourceConnectionSupport.this.refreshLinks(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            boolean bl = this.suspended == 0;
            ++this.suspended;
            if (!bl || !this.initialized) {
                return;
            }
            if (this.classList != null) {
                Iterator iterator = this.classList.iterator();
                while (iterator.hasNext()) {
                    ClassElement classElement = (ClassElement)((Reference)iterator.next()).get();
                    if (classElement == null) continue;
                    classElement.removePropertyChangeListener((PropertyChangeListener)this.classDeps);
                }
                this.classList = null;
            }
            this.src.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public synchronized void resume(boolean bl) {
        if (--this.suspended == 0) {
            this.initialize();
            if (bl && this.src.getStatus() == 3) {
                this.refreshLinks(true);
            } else {
                this.initialized = false;
            }
        }
    }

    public void syncConnections() {
        boolean bl = this.relinkEnabled;
        this.relinkEnabled = true;
        if (!bl) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    SourceConnectionSupport.this.refreshLinks(false);
                }
            });
        }
    }

    protected boolean isSuspended() {
        return this.suspended > 0;
    }

    protected abstract void saveDependencies(String var1, String[] var2);

    protected abstract String[] readDependencyList();

    protected abstract String[] readDependencies(String var1);

    protected abstract Node.Handle createListenerHandle(Node var1);

    private void loadModel() {
        if (this.dependencies != null) {
            return;
        }
        String[] stringArray = this.readDependencyList();
        int n = stringArray == null || stringArray.length == 0 ? 7 : stringArray.length * 4 / 3;
        HashMap hashMap = new HashMap(n);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String[] stringArray2 = this.readDependencies(stringArray[n2]);
            if (stringArray2 != null && stringArray2.length != 0) {
                Identifier identifier = Identifier.create((String)stringArray[n2]);
                HashSet<String> hashSet = new HashSet<String>(stringArray2.length * 4 / 3);
                hashSet.addAll(Arrays.asList(stringArray2));
                hashMap.put(identifier, hashSet);
            }
            ++n2;
        }
        this.dependencies = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getListenerNode() {
        if (this.listenerNode != null) {
            return this.listenerNode;
        }
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            block5: {
                if (this.listenerNode == null) break block5;
                Node node = this.listenerNode;
                return node;
            }
            this.listenerNode = new ListenerNode();
        }
        return this.listenerNode;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() != this.src) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if ("status".equals(string)) {
            this.handleStatusChange((Integer)propertyChangeEvent.getOldValue(), (Integer)propertyChangeEvent.getNewValue());
            return;
        }
    }

    protected String getName() {
        return "[" + this.supportID + "] ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLinks(boolean bl) {
        Object object;
        Identifier identifier;
        Object object2;
        Object object3;
        int n;
        if (this.fullRefresh) {
            return;
        }
        this.loadModel();
        this.fullRefresh |= !bl;
        ClassElement[] classElementArray = this.src.getAllClasses();
        ArrayList<WeakReference<ClassElement>> arrayList = new ArrayList<WeakReference<ClassElement>>(classElementArray.length);
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            n = 0;
            while (n < classElementArray.length) {
                object3 = classElementArray[n];
                arrayList.add(new WeakReference<ClassElement>((ClassElement)object3));
                ++n;
            }
            this.classList = arrayList;
        }
        n = 0;
        while (n < classElementArray.length) {
            object3 = classElementArray[n];
            this.classDeps.refreshClass((ClassElement)object3, bl);
            ++n;
        }
        object3 = new Vector(this.dependencies.entrySet());
        LinkedList<Identifier> linkedList = null;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            identifier = (Identifier)object2.getKey();
            object = (Collection)object2.getValue();
            LinkedList<String> linkedList2 = null;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                ClassElement classElement = this.findRelativeClass(string);
                if (classElement != null && this.classDeps.dependsOn(classElement, identifier)) continue;
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList<String>();
                }
                linkedList2.add(string);
            }
            if (linkedList2 == null) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<Identifier>();
            }
            linkedList.add(identifier);
            linkedList.add((Identifier)linkedList2);
        }
        if (linkedList == null) {
            return;
        }
        object2 = linkedList.iterator();
        while (object2.hasNext()) {
            identifier = (Identifier)object2.next();
            object = ((Collection)object2.next()).iterator();
            while (object.hasNext()) {
                this.removeDependency((String)object.next(), identifier);
            }
        }
    }

    private void handleStatusChange(int n, int n2) {
        if (this.initialized || this.isSuspended() || n2 != 3) {
            return;
        }
        this.fullRefresh = false;
        this.refreshLinks(n == 0);
        this.initialized = true;
    }

    protected synchronized Node createListenerNode() {
        if (this.listenerNode != null) {
            return this.listenerNode;
        }
        this.listenerNode = new ListenerNode();
        return this.listenerNode;
    }

    private ClassElement findClass(Identifier identifier) {
        if (!this.relinkEnabled) {
            return null;
        }
        ClassElement classElement = ClassElement.forName((String)identifier.getFullName());
        return classElement;
    }

    private boolean eligibleToRegistration(Identifier identifier) {
        String string = identifier.getFullName();
        int n = 0;
        while (n < SKIP_REGISTRATION_PREFIXES.length) {
            if (string.startsWith(SKIP_REGISTRATION_PREFIXES[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void registerDependency(ClassElement classElement) {
        if (classElement == null || this.isSuspended()) {
            return;
        }
        ConnectionCookie connectionCookie = (ConnectionCookie)classElement.getCookie(class$org$openide$cookies$ConnectionCookie == null ? (class$org$openide$cookies$ConnectionCookie = SourceConnectionSupport.class$("org.openide.cookies.ConnectionCookie")) : class$org$openide$cookies$ConnectionCookie);
        if (connectionCookie == null) {
            return;
        }
        try {
            connectionCookie.register(DEPENDENCY_IMPLEMENTATION, this.getListenerNode());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void unregisterDependency(ClassElement classElement) {
        if (classElement == null || this.isSuspended()) {
            return;
        }
        ConnectionCookie connectionCookie = (ConnectionCookie)classElement.getCookie(class$org$openide$cookies$ConnectionCookie == null ? (class$org$openide$cookies$ConnectionCookie = SourceConnectionSupport.class$("org.openide.cookies.ConnectionCookie")) : class$org$openide$cookies$ConnectionCookie);
        if (connectionCookie == null) {
            return;
        }
        try {
            connectionCookie.unregister(DEPENDENCY_IMPLEMENTATION, this.getListenerNode());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getDependencies(Identifier identifier) {
        ArrayList arrayList;
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            arrayList = (ArrayList)this.dependencies.get(identifier);
            if (arrayList != null) {
                arrayList = new ArrayList(arrayList);
            }
        }
        if (arrayList == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        ArrayList<ClassElement> arrayList2 = new ArrayList<ClassElement>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ClassElement classElement = this.findRelativeClass(string);
            arrayList2.add(classElement);
        }
        return Collections.enumeration(arrayList2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDependency(ClassElement classElement, Identifier identifier) {
        HashSet<String> hashSet;
        String string = this.findRelativeName(classElement);
        boolean bl = false;
        this.checkState();
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            hashSet = (HashSet<String>)this.dependencies.get(identifier);
            if (hashSet == null) {
                hashSet = new HashSet<String>(7);
                this.dependencies.put(identifier, hashSet);
            }
            bl = hashSet.add(string);
        }
        if (bl) {
            this.saveDependencies(identifier.getFullName(), hashSet.toArray(new String[hashSet.size()]));
        }
        if (this.eligibleToRegistration(identifier)) {
            this.registerDependency(this.findClass(identifier));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDependency(String string, Identifier identifier) {
        Collection collection;
        boolean bl = false;
        this.checkState();
        SourceConnectionSupport sourceConnectionSupport = this;
        synchronized (sourceConnectionSupport) {
            collection = (Collection)this.dependencies.get(identifier);
            if (collection != null && collection.remove(string)) {
                bl = true;
            }
        }
        if (bl) {
            this.saveDependencies(identifier.getFullName(), collection.isEmpty() ? null : collection.toArray(new String[collection.size()]));
        }
        if (this.eligibleToRegistration(identifier)) {
            this.unregisterDependency(this.findClass(identifier));
        }
    }

    public void removeDependency(ClassElement classElement, Identifier identifier) {
        String string = this.findRelativeName(classElement);
        this.removeDependency(string, identifier);
    }

    private ClassElement findRelativeClass(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        Identifier identifier = Identifier.create((String)string2);
        ClassElement classElement = this.src.getClass(identifier);
        while (classElement != null && stringTokenizer.hasMoreTokens()) {
            identifier = Identifier.create((String)stringTokenizer.nextToken());
            classElement = classElement.getClass(identifier);
        }
        return classElement;
    }

    private String findRelativeName(ClassElement classElement) {
        String string = classElement.getName().getFullName();
        ClassElement classElement2 = classElement.getDeclaringClass();
        while (classElement2 != null) {
            classElement = classElement2;
            classElement2 = classElement.getDeclaringClass();
        }
        String string2 = classElement.getName().getQualifier();
        if ("".equals(string2)) {
            return string;
        }
        return string.substring(string2.length() + 1);
    }

    private void classChanged(ClassElement classElement, ClassElement classElement2, Collection collection, Collection collection2) {
        Identifier[] identifierArray = classElement.getInterfaces();
        Identifier[] identifierArray2 = classElement2.getInterfaces();
    }

    public void notify(ConnectionCookie.Event event) {
        Object object;
        if (!(event instanceof JavaConnections.Event)) {
            return;
        }
        JavaConnections.Change[] changeArray = ((JavaConnections.Event)event).getChanges();
        this.loadModel();
        if (!this.fullRefresh) {
            this.refreshLinks(false);
        }
        HashMap hashMap = new HashMap(17);
        HashMap hashMap2 = new HashMap(17);
        int n = 0;
        while (n < changeArray.length) {
            object = changeArray[n];
            int n2 = ((JavaConnections.Change)object).getChangeType();
            if (n2 == 16) {
                this.splitNewMethods(((JavaConnections.Change)object).getElements(), hashMap);
            } else if (n2 == 64) {
                this.splitMethodChange((JavaConnections.Change)object, hashMap2);
            }
            ++n;
        }
        object = this.src.getAllClasses();
        Object var7_8 = null;
        int n3 = 0;
        while (n3 < ((Object)object).length) {
            Object object2 = object[n3];
            Collection collection = (Collection)hashMap.get(object2);
            Collection collection2 = (Collection)hashMap2.get(object2);
            MemberElement memberElement = null;
            if (collection != null && !collection.isEmpty()) {
                memberElement = (MemberElement)collection.iterator().next();
            } else if (collection2 != null && !collection2.isEmpty()) {
                memberElement = (MemberElement)((JavaConnections.Change)collection2.iterator().next()).getNewElement();
            }
            if (memberElement != null) {
                this.classDeps.connectionNotify((ClassElement)object2, memberElement.getDeclaringClass(), collection == null ? null : Collections.enumeration(collection), collection2 == null ? null : Collections.enumeration(collection2));
            }
            ++n3;
        }
    }

    private void splitMethodChange(JavaConnections.Change change, Map map) {
        if (!(change.getNewElement() instanceof MethodElement)) {
            return;
        }
        MethodElement methodElement = (MethodElement)change.getNewElement();
        ClassElement classElement = methodElement.getDeclaringClass();
        Enumeration enumeration = this.getDependencies(classElement.getName());
        while (enumeration.hasMoreElements()) {
            ClassElement classElement2 = (ClassElement)enumeration.nextElement();
            LinkedList<JavaConnections.Change> linkedList = (LinkedList<JavaConnections.Change>)map.get(classElement2);
            if (linkedList == null) {
                linkedList = new LinkedList<JavaConnections.Change>();
                map.put(classElement2, linkedList);
            }
            linkedList.add(change);
        }
    }

    private void splitNewMethods(Element[] elementArray, Map map) {
        int n = 0;
        while (n < elementArray.length) {
            MethodElement methodElement;
            ClassElement classElement;
            if (elementArray[n] instanceof MethodElement && (classElement = (methodElement = (MethodElement)elementArray[n]).getDeclaringClass()) != null) {
                Identifier identifier = classElement.getName();
                Enumeration enumeration = this.getDependencies(identifier);
                while (enumeration.hasMoreElements()) {
                    ClassElement classElement2 = (ClassElement)enumeration.nextElement();
                    LinkedList<MethodElement> linkedList = (LinkedList<MethodElement>)map.get(classElement2);
                    if (linkedList == null) {
                        linkedList = new LinkedList<MethodElement>();
                        map.put(classElement2, linkedList);
                    }
                    linkedList.add(methodElement);
                }
            }
            ++n;
        }
    }

    protected void storeSynchronizationMode(int n) {
    }

    protected int readSynchronizationMode() {
        return 1;
    }

    public void setSynchronizationMode(ClassElement classElement, int n) {
        this.storeSynchronizationMode(n);
        this.syncMode = n;
    }

    public int getSynchronizationMode(ClassElement classElement) {
        if (this.syncMode == -1) {
            this.syncMode = this.readSynchronizationMode();
            return this.syncMode;
        }
        return this.syncMode;
    }

    public void synchronize() throws SourceException {
        this.checkState();
        ClassElement[] classElementArray = this.src.getAllClasses();
        int n = 0;
        while (n < classElementArray.length) {
            this.classDeps.synchronizeClass(classElementArray[n]);
            ++n;
        }
    }

    public SynchronizeCodeCookie createClassSyncCookie(ClassElement classElement) {
        return new ClassSyncImpl(classElement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ClassSyncImpl
    implements SynchronizeCodeCookie {
        ClassElement target;

        ClassSyncImpl(ClassElement classElement) {
            this.target = classElement;
        }

        public void synchronize() throws SourceException {
            SourceConnectionSupport.this.classDeps.synchronizeClass(this.target);
        }
    }

    private class ListenerNode
    extends AbstractNode {
        private Node.Handle myHandle;

        public ListenerNode() {
            super(Children.LEAF);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Node.Handle getHandle() {
            if (this.myHandle != null) {
                return this.myHandle;
            }
            ListenerNode listenerNode = this;
            synchronized (listenerNode) {
                if (this.myHandle == null) {
                    this.myHandle = SourceConnectionSupport.this.createListenerHandle((Node)this);
                }
            }
            return this.myHandle;
        }

        public Node.Cookie getCookie(Class clazz) {
            Node.Cookie cookie = super.getCookie(clazz);
            if (cookie != null) {
                return cookie;
            }
            if (clazz.isInstance(SourceConnectionSupport.this)) {
                return SourceConnectionSupport.this;
            }
            return null;
        }
    }
}

