/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.imptool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.imptool.BodyIdentifier;
import org.netbeans.modules.java.imptool.IdentifierNode;
import org.netbeans.modules.java.imptool.ImpDataSourceNode;
import org.netbeans.modules.java.imptool.ImpToolSettings;
import org.netbeans.modules.java.imptool.ImportLineNode;
import org.netbeans.modules.java.imptool.MethodParameterOwner;
import org.netbeans.modules.java.imptool.PackageNode;
import org.netbeans.modules.java.imptool.PackageResolver;
import org.netbeans.modules.java.imptool.SourceIdentifier;
import org.netbeans.modules.java.imptool.SourceImport;
import org.openide.TopManager;
import org.openide.cookies.SourceCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.text.PositionBounds;
import org.openide.util.SharedClassObject;

public class ImpDataSource {
    private HashMap sourceIDMap;
    private HashMap packageMap;
    private HashMap idNodes;
    private ImpToolSettings impSetting;
    private JavaDataObject dataObject;
    private PackageResolver packageResolver;
    private SourceCookie.Editor sourceEditor;
    private JavaEditor javaEditor;
    private SourceElement sourceElement;
    private String sourceFilePackageName;
    private int stage = 0;
    private static final int FQN_STAGE = 1;
    private static final int IMPORT_STAGE = 2;
    private static final int RESOLVE_STAGE = 3;
    private static final int COMMIT_STAGE = 4;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaEditor;
    static /* synthetic */ Class class$org$netbeans$modules$java$imptool$ImpToolSettings;

    ImpDataSource(JavaDataObject javaDataObject, Collection collection) {
        Object object;
        Iterator iterator = collection.iterator();
        this.dataObject = javaDataObject;
        this.sourceEditor = (SourceCookie.Editor)javaDataObject.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = ImpDataSource.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
        this.javaEditor = (JavaEditor)javaDataObject.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = ImpDataSource.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor);
        this.sourceElement = javaDataObject.getSource();
        this.sourceIDMap = new HashMap();
        this.packageMap = new HashMap();
        this.idNodes = new HashMap();
        this.impSetting = (ImpToolSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$java$imptool$ImpToolSettings == null ? (class$org$netbeans$modules$java$imptool$ImpToolSettings = ImpDataSource.class$("org.netbeans.modules.java.imptool.ImpToolSettings")) : class$org$netbeans$modules$java$imptool$ImpToolSettings), (boolean)true);
        ClassElement[] classElementArray = this.sourceElement.getAllClasses();
        Identifier identifier = this.sourceElement.getPackage();
        if (identifier != null) {
            this.sourceFilePackageName = identifier.getSourceName();
        }
        int n = 0;
        while (n < classElementArray.length) {
            FieldElement fieldElement;
            object = classElementArray[n];
            FieldElement[] fieldElementArray = object.getFields();
            ConstructorElement[] constructorElementArray = object.getConstructors();
            MethodElement[] methodElementArray = object.getMethods();
            Identifier identifier2 = object.getSuperclass();
            if (!this.isGuarded((org.openide.src.Element)object)) {
                if (identifier2 != null) {
                    this.addIdentifier(identifier2, 1, object);
                }
                this.addIdentifierFromArray(object.getInterfaces(), 2, (org.openide.src.Element)object);
            }
            int n2 = 0;
            while (n2 < fieldElementArray.length) {
                fieldElement = fieldElementArray[n2];
                if (!this.isGuarded((org.openide.src.Element)fieldElement)) {
                    this.addIdentifierFromType(fieldElement.getType(), fieldElement);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < constructorElementArray.length) {
                fieldElement = constructorElementArray[n2];
                if (!this.isGuarded((org.openide.src.Element)fieldElement)) {
                    this.addIdentifierFromMethodParams((ConstructorElement)fieldElement);
                    this.addIdentifierFromArray(fieldElement.getExceptions(), 3, (org.openide.src.Element)fieldElement);
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < methodElementArray.length) {
                fieldElement = methodElementArray[n2];
                if (!this.isGuarded((org.openide.src.Element)fieldElement)) {
                    this.addIdentifierFromMethodParams((ConstructorElement)fieldElement);
                    this.addIdentifierFromArray(fieldElement.getExceptions(), 3, (org.openide.src.Element)fieldElement);
                    this.addIdentifierFromType(fieldElement.getReturn(), fieldElement);
                }
                ++n2;
            }
            ++n;
        }
        while (iterator.hasNext()) {
            object = (BodyIdentifier)iterator.next();
            if (this.isGuardedIndetifier((BodyIdentifier)object)) continue;
            this.addIdentifier(((BodyIdentifier)object).getIdentifier(), 4, object);
        }
        Import[] importArray = this.sourceElement.getImports();
        n = 0;
        while (n < importArray.length) {
            object = new SourceImport(importArray[n]);
            ((SourceImport)object).setUsed(!this.impSetting.isRemoveImport());
            this.addImport((SourceImport)object);
            ++n;
        }
        if (this.impSetting.getResolveStrategy() == 1) {
            this.tryResolveIdetifiers();
        }
    }

    private void addIdentifierFromType(Type type, Object object) {
        if (type.isClass()) {
            this.addIdentifier(type.getTypeIdentifier(), 0, object);
        } else if (type.isArray()) {
            this.addIdentifierFromType(type.getElementType(), object);
        }
    }

    private void addIdentifierFromMethodParams(ConstructorElement constructorElement) {
        MethodParameter[] methodParameterArray = constructorElement.getParameters();
        int n = 0;
        while (n < methodParameterArray.length) {
            MethodParameterOwner methodParameterOwner = new MethodParameterOwner(constructorElement, n);
            this.addIdentifierFromType(methodParameterArray[n].getType(), methodParameterOwner);
            ++n;
        }
    }

    private void addIdentifierFromArray(Identifier[] identifierArray, int n, org.openide.src.Element element) {
        int n2 = 0;
        while (n2 < identifierArray.length) {
            this.addIdentifier(identifierArray[n2], n, element);
            ++n2;
        }
    }

    private void addIdentifier(Identifier identifier, int n, Object object) {
        SourceIdentifier sourceIdentifier = new SourceIdentifier(identifier, n, object);
        this.addObjectToMap(this.sourceIDMap, sourceIdentifier.getPackage(), sourceIdentifier.getName(), sourceIdentifier);
        if (identifier.getResolutionStatus() == 2) {
            String string = identifier.getSourceName();
            IdentifierNode identifierNode = (IdentifierNode)((Object)this.idNodes.get(string));
            if (identifierNode == null) {
                identifierNode = new IdentifierNode(sourceIdentifier);
                this.idNodes.put(string, identifierNode);
            } else {
                identifierNode.add(sourceIdentifier);
            }
        }
    }

    private void addImport(SourceImport sourceImport) {
        String string = sourceImport.getPackage();
        String string2 = sourceImport.isPackage() ? "*" : sourceImport.getName();
        this.addObjectToMap(this.packageMap, string, string2, sourceImport);
    }

    private void addObjectToMap(HashMap hashMap, String string, String string2, Object object) {
        ArrayList<Object> arrayList;
        HashMap<String, ArrayList<Object>> hashMap2 = (HashMap<String, ArrayList<Object>>)hashMap.get(string);
        if (hashMap2 == null) {
            hashMap2 = new HashMap<String, ArrayList<Object>>();
            hashMap.put(string, hashMap2);
        }
        if ((arrayList = (ArrayList<Object>)hashMap2.get(string2)) == null) {
            arrayList = new ArrayList<Object>();
            hashMap2.put(string2, arrayList);
        }
        arrayList.add(object);
    }

    ImpDataSourceNode createRootFQNNode() {
        Node[] nodeArray = new Node[]{};
        Children.Array array = new Children.Array();
        array.add(this.idNodes.values().toArray(nodeArray));
        this.stage = 1;
        return new ImpDataSourceNode(this, (Children)array, 0);
    }

    ImpDataSourceNode createRootImportNode() {
        Node[] nodeArray = new Node[]{};
        Children.Array array = new Children.Array();
        Iterator iterator = this.sourceIDMap.keySet().iterator();
        ArrayList<PackageNode> arrayList = new ArrayList<PackageNode>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null) continue;
            boolean bl = string.equals("java.lang") || string.equals(this.sourceFilePackageName);
            HashMap hashMap = (HashMap)this.sourceIDMap.get(string);
            Iterator iterator2 = hashMap.values().iterator();
            while (iterator2.hasNext()) {
                Collection collection = (Collection)iterator2.next();
                arrayList.add(new PackageNode(collection));
                if (bl) continue;
                this.setFQNDefaultFlagFor(collection);
            }
        }
        array.add(arrayList.toArray(nodeArray));
        this.stage = 2;
        return new ImpDataSourceNode(this, (Children)array, 1);
    }

    ImpDataSourceNode createRootResolveNode() {
        Children.Array array = new Children.Array();
        int n = 0;
        this.mergeSourceIDToPackages();
        Collection collection = this.packageMap.values();
        Iterator iterator = collection.iterator();
        Node[] nodeArray = new Node[collection.size()];
        while (iterator.hasNext()) {
            HashMap hashMap = (HashMap)iterator.next();
            nodeArray[n++] = ImportLineNode.createPackageNode(hashMap.values());
        }
        array.add(nodeArray);
        this.stage = 3;
        return new ImpDataSourceNode(this, (Children)array, 2);
    }

    void setPackageForArray(String string, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SourceIdentifier sourceIdentifier = (SourceIdentifier)iterator.next();
            this.setPackage(string, sourceIdentifier);
        }
    }

    private void setPackage(String string, SourceIdentifier sourceIdentifier) {
        HashMap hashMap = (HashMap)this.sourceIDMap.get(sourceIdentifier.getPackage());
        String string2 = sourceIdentifier.getName();
        if (hashMap == null) {
            throw new IllegalArgumentException("Package HashMap mismatch");
        }
        Collection collection = (Collection)hashMap.get(string2);
        if (collection == null) {
            throw new IllegalArgumentException("Name HashMap mismatch");
        }
        if (!collection.remove(sourceIdentifier)) {
            throw new IllegalArgumentException("Array mismatch");
        }
        if (collection.size() == 0) {
            hashMap.remove(string2);
        }
        sourceIdentifier.setPackage(string);
        this.addObjectToMap(this.sourceIDMap, string, string2, sourceIdentifier);
    }

    void setFQNFlagFor(Collection collection, int n) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SourceIdentifier sourceIdentifier = (SourceIdentifier)iterator.next();
            sourceIdentifier.setUseFQN(n);
        }
    }

    int getFQNFlagFor(Collection collection) {
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            SourceIdentifier sourceIdentifier = (SourceIdentifier)iterator.next();
            return sourceIdentifier.getUseFQN();
        }
        return 0;
    }

    void setFQNDefaultFlagFor(Collection collection) {
        int n = collection.size();
        int n2 = n > this.impSetting.getMaxFqn() ? 2 : 1;
        this.setFQNFlagFor(collection, n2);
    }

    void mergeSourceIDToPackages() {
        SourceImport sourceImport;
        HashMap hashMap;
        Object object;
        Iterator iterator = this.sourceIDMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.equals("java.lang") || string.equals(this.sourceFilePackageName)) continue;
            object = (HashMap)this.packageMap.get(string);
            hashMap = (HashMap)this.sourceIDMap.get(string);
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                Iterator iterator3 = ((Collection)hashMap.get(string2)).iterator();
                while (iterator3.hasNext()) {
                    ArrayList arrayList;
                    SourceIdentifier sourceIdentifier = (SourceIdentifier)iterator3.next();
                    if (sourceIdentifier.reallyUseFQN()) continue;
                    if (object != null && (arrayList = (ArrayList)((HashMap)object).get(string2)) != null && !arrayList.isEmpty()) {
                        sourceImport = (SourceImport)arrayList.get(0);
                        sourceImport.setUsed(true);
                        continue;
                    }
                    sourceImport = new SourceImport(string, string2);
                    sourceImport.setUsed(true);
                    this.addImport(sourceImport);
                }
            }
        }
        Iterator iterator4 = this.packageMap.keySet().iterator();
        while (iterator4.hasNext()) {
            object = (String)iterator4.next();
            hashMap = (HashMap)this.packageMap.get(object);
            if (hashMap.get("*") == null) {
                sourceImport = new SourceImport((String)object, "*");
                sourceImport.setUsed(false);
                this.addImport(sourceImport);
            }
            this.setUseDefaultFlagFor(hashMap);
        }
    }

    void setUseDefaultFlagFor(HashMap hashMap) {
        Iterator iterator = hashMap.values().iterator();
        int n = 0;
        SourceImport sourceImport = null;
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator.next();
            if (arrayList.isEmpty()) continue;
            SourceImport sourceImport2 = (SourceImport)arrayList.get(0);
            if (sourceImport2.isPackage()) {
                sourceImport = sourceImport2;
                continue;
            }
            if (!sourceImport2.isUse()) continue;
            ++n;
        }
        if (sourceImport != null) {
            if (n > this.impSetting.getSingleImports()) {
                sourceImport.setUse(true);
            } else {
                sourceImport.setUse(false);
            }
        }
    }

    void commitIdentifiers() throws SourceException, IOException, BadLocationException {
        Iterator iterator = this.sourceIDMap.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((HashMap)iterator.next()).values().iterator();
            while (iterator2.hasNext()) {
                ArrayList arrayList = (ArrayList)iterator2.next();
                int n = 0;
                while (n < arrayList.size()) {
                    ((SourceIdentifier)arrayList.get(n)).commit();
                    ++n;
                }
            }
        }
    }

    void commitImports() throws SourceException {
        Iterator iterator = this.packageMap.values().iterator();
        ArrayList arrayList = new ArrayList();
        Import[] importArray = new Import[]{};
        while (iterator.hasNext()) {
            HashMap hashMap = (HashMap)iterator.next();
            ArrayList arrayList2 = (ArrayList)hashMap.get("*");
            if (this.addImportToList(arrayList, arrayList2)) continue;
            Iterator iterator2 = hashMap.values().iterator();
            while (iterator2.hasNext()) {
                this.addImportToList(arrayList, (ArrayList)iterator2.next());
            }
        }
        importArray = arrayList.toArray(importArray);
        this.dataObject.getSource().setImports(importArray);
    }

    private void commitAllChanges() {
        final Exception[] exceptionArray = new Exception[]{null};
        this.dataObject.suspendSupports();
        try {
            this.sourceElement.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        ImpDataSource.this.commitIdentifiers();
                        ImpDataSource.this.commitImports();
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                    }
                }
            });
        }
        catch (SourceException sourceException) {
            exceptionArray[0] = sourceException;
        }
        this.dataObject.resumeSupports();
        if (exceptionArray[0] != null) {
            TopManager.getDefault().notifyException((Throwable)exceptionArray[0]);
        }
    }

    private boolean addImportToList(ArrayList arrayList, ArrayList arrayList2) {
        SourceImport sourceImport;
        if (arrayList2 != null && arrayList2.size() > 0 && (sourceImport = (SourceImport)arrayList2.get(0)).isUse()) {
            arrayList.add(sourceImport.getImport());
            return true;
        }
        return false;
    }

    private Collection getAllPackages() {
        String[] stringArray = this.impSetting.getResolvePlaces();
        HashSet hashSet = new HashSet(this.sourceIDMap.keySet());
        Set set = this.packageMap.keySet();
        hashSet.remove(null);
        set.remove(null);
        hashSet.addAll(set);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.length() > 0) {
                hashSet.add(string);
            }
            ++n;
        }
        return hashSet;
    }

    PackageResolver getPackageResolver() {
        if (this.packageResolver == null) {
            this.packageResolver = new PackageResolver(this.getAllPackages());
        }
        return this.packageResolver;
    }

    private void tryResolveIdetifiers() {
        HashMap hashMap = (HashMap)this.sourceIDMap.get(null);
        if (hashMap != null) {
            hashMap = (HashMap)hashMap.clone();
            Iterator iterator = hashMap.values().iterator();
            PackageResolver packageResolver = this.getPackageResolver();
            while (iterator.hasNext()) {
                ArrayList arrayList = (ArrayList)((ArrayList)iterator.next()).clone();
                int n = 0;
                while (n < arrayList.size()) {
                    SourceIdentifier sourceIdentifier = (SourceIdentifier)arrayList.get(n);
                    String string = packageResolver.getPackageForClass(sourceIdentifier.getName());
                    if (string != null) {
                        this.setPackage(string, sourceIdentifier);
                    }
                    ++n;
                }
            }
        }
    }

    void runSilentFromNextStage() {
        switch (this.stage + 1) {
            case 1: {
                this.createRootFQNNode();
            }
            case 2: {
                this.createRootImportNode();
            }
            case 3: {
                this.createRootResolveNode();
            }
            case 4: {
                this.commitAllChanges();
            }
        }
    }

    private boolean isGuarded(org.openide.src.Element element) {
        if (this.sourceEditor != null && this.javaEditor != null) {
            PositionBounds positionBounds;
            Element element2 = this.sourceEditor.sourceToText(element);
            int n = element2.getStartOffset();
            int n2 = element2.getEndOffset();
            if (!element2.isLeaf()) {
                Element element3 = element2.getElement(0);
                n2 = element3.getStartOffset() - 1;
            }
            return !this.javaEditor.testOverlap(positionBounds = this.javaEditor.createBounds(n, n2, true));
        }
        return false;
    }

    private boolean isGuardedIndetifier(BodyIdentifier bodyIdentifier) {
        if (this.javaEditor != null) {
            return !this.javaEditor.testOverlap(bodyIdentifier.getBounds());
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

