/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.model;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.model.Binding;
import org.netbeans.modules.java.model.BindingFactory;
import org.netbeans.modules.java.model.CallableImpl;
import org.netbeans.modules.java.model.ClassElementImpl;
import org.netbeans.modules.java.model.CommitListener;
import org.netbeans.modules.java.model.ConstructorElementImpl;
import org.netbeans.modules.java.model.DefaultInsertStrategy;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.EventQueue;
import org.netbeans.modules.java.model.ExceptionRunnable;
import org.netbeans.modules.java.model.FieldElementImpl;
import org.netbeans.modules.java.model.ImportImpl;
import org.netbeans.modules.java.model.InitializerElementImpl;
import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.model.MethodElementImpl;
import org.netbeans.modules.java.model.Positioner;
import org.netbeans.modules.java.model.SourceElementImpl;
import org.netbeans.modules.java.model.WrapperFactory;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class DefaultLangModel
implements LangModel,
LangModel.Updater {
    private static boolean initialized;
    private static Class CLASS_MEMBER_IMPL;
    private static Class CLASS_INITIALIZER_IMPL;
    static final Positioner DEFAULT_POSITIONER;
    private Object locked;
    private LangModel.Env env;
    private Object writerNotify;
    private Thread writingThread;
    private int readerCount;
    private Thread reader;
    private BindingFactory bindingFactory;
    private WrapperFactory wrapperFactory;
    private EventQueue eventQueue;
    private int writeLocks;
    private int masterLocks;
    private boolean transactionCommited;
    private boolean transactionConstrained;
    private boolean eventDispatch;
    Collection preCommitListeners;
    Collection postCommitListeners;
    LinkedList outputQueue;
    boolean firingEvents;
    static /* synthetic */ Class class$org$netbeans$modules$java$model$ElementImpl;

    public DefaultLangModel(LangModel.Env env) {
        this.env = env;
        this.writerNotify = new Object();
        this.eventQueue = new EventQueue(null);
    }

    private static void initializeClasses() {
        if (initialized) {
            return;
        }
        try {
            CLASS_MEMBER_IMPL = Class.forName("org.netbeans.modules.java.model.MemberElementImpl");
            CLASS_INITIALIZER_IMPL = Class.forName("org.netbeans.modules.java.model.InitializerElementImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        initialized = true;
    }

    public Object clone() {
        return null;
    }

    public ClassElementImpl createTopClass(SourceElement sourceElement) {
        ClassElementImpl classElementImpl = new ClassElementImpl(this);
        this.getWrapper().wrapClass(classElementImpl, (Element)sourceElement);
        classElementImpl.setParent((Element)sourceElement);
        return classElementImpl;
    }

    public ClassElementImpl createInnerClass(ClassElement classElement) {
        ClassElementImpl classElementImpl = new ClassElementImpl(this);
        this.getWrapper().wrapClass(classElementImpl, (Element)classElement);
        classElementImpl.setParent((Element)classElement);
        return classElementImpl;
    }

    public FieldElementImpl createField(ClassElement classElement) {
        FieldElementImpl fieldElementImpl = new FieldElementImpl(this);
        this.getWrapper().wrapField(fieldElementImpl, (Element)classElement);
        fieldElementImpl.setParent((Element)classElement);
        return fieldElementImpl;
    }

    public ConstructorElementImpl createConstructor(ClassElement classElement) {
        ConstructorElementImpl constructorElementImpl = new ConstructorElementImpl(this);
        this.getWrapper().wrapConstructor(constructorElementImpl, (Element)classElement);
        constructorElementImpl.setParent((Element)classElement);
        return constructorElementImpl;
    }

    public MethodElementImpl createMethod(ClassElement classElement) {
        MethodElementImpl methodElementImpl = new MethodElementImpl(this);
        this.getWrapper().wrapMethod(methodElementImpl, (Element)classElement);
        methodElementImpl.setParent((Element)classElement);
        return methodElementImpl;
    }

    public ImportImpl createImport(SourceElement sourceElement) {
        ImportImpl importImpl = new ImportImpl(this);
        this.getWrapper().wrapImport(importImpl, (Element)sourceElement);
        importImpl.setParent((Element)sourceElement);
        return importImpl;
    }

    public InitializerElementImpl createInitializer(ClassElement classElement) {
        InitializerElementImpl initializerElementImpl = new InitializerElementImpl(this);
        this.getWrapper().wrapInitializer(initializerElementImpl, (Element)classElement);
        initializerElementImpl.setParent((Element)classElement);
        return initializerElementImpl;
    }

    public SourceElementImpl createSource() {
        return new SourceElementImpl(this);
    }

    final Identifier resolveIdent(Element element, Identifier identifier) {
        return this.env.resolveTypeIdent(element, identifier);
    }

    final Type resolveType(Element element, Type type) {
        return this.env.resolveType(element, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreCommitListener(CommitListener commitListener) {
        DefaultLangModel defaultLangModel = this;
        synchronized (defaultLangModel) {
            if (this.preCommitListeners == null) {
                this.preCommitListeners = new LinkedList();
            }
        }
        Collection collection = this.preCommitListeners;
        synchronized (collection) {
            this.preCommitListeners.add(commitListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostCommitListener(CommitListener commitListener) {
        DefaultLangModel defaultLangModel = this;
        synchronized (defaultLangModel) {
            if (this.postCommitListeners == null) {
                this.postCommitListeners = new LinkedList();
            }
        }
        Collection collection = this.postCommitListeners;
        synchronized (collection) {
            this.postCommitListeners.add(commitListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreCommitListener(CommitListener commitListener) {
        if (this.preCommitListeners == null) {
            return;
        }
        Collection collection = this.preCommitListeners;
        synchronized (collection) {
            this.preCommitListeners.remove(commitListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePostCommitListener(CommitListener commitListener) {
        if (this.postCommitListeners == null) {
            return;
        }
        Collection collection = this.postCommitListeners;
        synchronized (collection) {
            this.postCommitListeners.remove(commitListener);
        }
    }

    final void notifyEventsDispatched(boolean bl) {
        this.eventDispatch = bl;
    }

    public final Object writeLock() {
        Object object = this.doWriteLock();
        if (this.masterLocks == -1) {
            this.createEventQueue();
        }
        return object;
    }

    private void createEventQueue() {
        this.eventQueue = new EventQueue(this.eventQueue);
    }

    final Object masterWriteLock() {
        Object object = this.doWriteLock();
        if (this.masterLocks > 0) {
            try {
                this.releaseWriteLock(object);
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
            throw new IllegalStateException("Nested master locks!!");
        }
        this.masterLocks = this.writeLocks;
        this.eventQueue = new EventQueue(this.eventQueue);
        return object;
    }

    public Object tryWriteLock() {
        return this.tryWriteLock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object tryWriteLock(boolean bl) {
        Object object = this.writerNotify;
        synchronized (object) {
            block4: {
                if (this.locked != null && this.writingThread != Thread.currentThread()) break block4;
                Object object2 = bl ? this.masterWriteLock() : this.writeLock();
                return object2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object doWriteLock() {
        Object object = this.writerNotify;
        synchronized (object) {
            block8: {
                if (this.writingThread != Thread.currentThread()) break block8;
                if (this.eventDispatch) {
                    throw new IllegalStateException("Modification from inside the event handler are banned");
                }
                ++this.writeLocks;
                Object object2 = this.locked;
                return object2;
            }
            if (this.locked != null) {
                try {
                    this.writerNotify.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Interrupted");
                }
            }
            this.transactionConstrained = true;
            ++this.writeLocks;
            this.locked = this.writerNotify;
            this.writingThread = Thread.currentThread();
            Object object3 = this.locked;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseWriteLock(Object object) throws SourceException {
        if (object == null) {
            throw new IllegalArgumentException("Invalid lock: " + object);
        }
        if (this.locked == null) {
            throw new IllegalStateException("Model not locked.");
        }
        Object object2 = this.writerNotify;
        synchronized (object2) {
            if (object != this.locked) {
                throw new IllegalArgumentException("Invalid unlock attempt.");
            }
        }
        EventQueue eventQueue = null;
        if (this.masterLocks == -1) {
            eventQueue = this.mergeEventQueues();
        } else if (this.masterLocks >= this.writeLocks) {
            eventQueue = this.mergeEventQueues();
            this.masterLocks = -1;
        }
        if (--this.writeLocks > 0) {
            return;
        }
        this.eventQueue = null;
        eventQueue.fixupChanges();
        this.firePreCommitEvents(eventQueue);
        this.enqueue(eventQueue);
        Object object3 = this.writerNotify;
        synchronized (object3) {
            this.writingThread = null;
            this.locked = null;
            this.writerNotify.notifyAll();
        }
        this.processOutputQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(EventQueue eventQueue) {
        if (this.outputQueue == null) {
            this.outputQueue = new LinkedList();
        }
        LinkedList linkedList = this.outputQueue;
        synchronized (linkedList) {
            this.outputQueue.addLast(eventQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processOutputQueue() {
        LinkedList linkedList;
        if (this.outputQueue == null) {
            return;
        }
        LinkedList linkedList2 = this.outputQueue;
        synchronized (linkedList2) {
            if (this.firingEvents) {
                return;
            }
            this.firingEvents = true;
        }
        try {
            while (true) {
                EventQueue eventQueue;
                LinkedList linkedList3 = this.outputQueue;
                synchronized (linkedList3) {
                    if (this.outputQueue.isEmpty()) {
                        // MONITOREXIT @DISABLED, blocks:[1, 6, 10, 13] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                        Object var6_4 = null;
                        linkedList = this.outputQueue;
                        break;
                    }
                    eventQueue = (EventQueue)this.outputQueue.removeFirst();
                }
                eventQueue.fireEvents();
                this.firePostCommitEvents(eventQueue);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            LinkedList linkedList4 = this.outputQueue;
            synchronized (linkedList4) {
                this.firingEvents = false;
                throw throwable;
            }
        }
        synchronized (linkedList) {
            this.firingEvents = false;
            return;
        }
    }

    private void firePreCommitEvents(EventQueue eventQueue) {
        this.fireCommitEvents(this.preCommitListeners, eventQueue);
    }

    private void firePostCommitEvents(EventQueue eventQueue) {
        this.fireCommitEvents(this.postCommitListeners, eventQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCommitEvents(Collection collection, EventQueue eventQueue) {
        Vector vector;
        if (collection == null || eventQueue == null || eventQueue.isEmpty()) {
            return;
        }
        Collection collection2 = collection;
        synchronized (collection2) {
            vector = new Vector(collection);
        }
        Set set = eventQueue.getRemovedElements();
        Set set2 = eventQueue.getCreatedElements();
        Map map = eventQueue.getChangedElements();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CommitListener commitListener = (CommitListener)iterator.next();
            commitListener.changesCommited(set2, set, map);
        }
    }

    private EventQueue mergeEventQueues() {
        EventQueue eventQueue = this.eventQueue.getParent();
        if (eventQueue != null) {
            if (this.transactionCommited) {
                this.eventQueue.mergeToParent();
            }
            this.eventQueue = eventQueue;
        }
        this.transactionCommited = false;
        return this.eventQueue;
    }

    public void commitChanges() {
        if (this.locked == null || this.writingThread != Thread.currentThread()) {
            throw new IllegalStateException("Sanity check: commit outside lock");
        }
        if (this.masterLocks > 0 && this.masterLocks < this.writeLocks) {
            return;
        }
        this.transactionCommited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomic(Runnable runnable) throws SourceException {
        Object object = this.writeLock();
        try {
            runnable.run();
            this.commitChanges();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseWriteLock(object);
            throw throwable;
        }
        this.releaseWriteLock(object);
    }

    protected boolean isConstrained() {
        return this.transactionConstrained;
    }

    protected final Node.Cookie findElementCookie(Element element, Class clazz) {
        return this.env.findCookie(element, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runUpdate(Runnable runnable, boolean bl) throws SourceException {
        Object object = this.tryWriteLock(true);
        if (object == null) {
            return false;
        }
        boolean bl2 = this.transactionConstrained;
        try {
            try {
                this.transactionConstrained = !bl;
                runnable.run();
                this.commitChanges();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SourceException("Unexpected implementation error");
            }
            Object var7_5 = null;
            this.transactionConstrained = bl2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.transactionConstrained = bl2;
            this.releaseWriteLock(object);
            return true;
        }
        this.releaseWriteLock(object);
        return true;
    }

    private void doRunAtomic(ExceptionRunnable exceptionRunnable) throws SourceException {
        try {
            exceptionRunnable.run();
        }
        catch (SourceException sourceException) {
            throw sourceException;
        }
        catch (Exception exception) {
            throw new SourceException("Unexpected implementation error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomic(ExceptionRunnable exceptionRunnable) throws SourceException {
        boolean bl = false;
        boolean bl2 = false;
        Object object = null;
        object = this.writeLock();
        try {
            this.doRunAtomic(exceptionRunnable);
            this.commitChanges();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseWriteLock(object);
            throw throwable;
        }
        this.releaseWriteLock(object);
    }

    public Object getManagementLock() {
        return this.writerNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readLock() {
        Object object = this.writerNotify;
        synchronized (object) {
            if (this.writingThread != null && this.writingThread == Thread.currentThread()) {
                ++this.readerCount;
                return;
            }
            try {
                this.writerNotify.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.locked == null) {
                this.locked = Thread.currentThread();
            }
            ++this.readerCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseReadLock() {
        Object object = this.writerNotify;
        synchronized (object) {
            if (--this.readerCount == 0 && this.writingThread == null) {
                this.locked = null;
                this.writerNotify.notifyAll();
            }
        }
    }

    protected EventQueue getEventQueue() {
        return this.eventQueue;
    }

    public boolean isWriteLocked() {
        return this.writingThread != null;
    }

    public ElementFactory.Item createImport(Import import_, int n, int n2) {
        return null;
    }

    public void notifyElementChanged(Element element, Element element2) {
        this.eventQueue.elementChanged(element, element2);
    }

    public void notifyElementCreated(Element element) {
        this.eventQueue.elementCreated(element);
    }

    public void notifyElementRemoved(Element element) {
        this.eventQueue.elementRemoved(element);
    }

    public void fireModelElementChange(ElementImpl elementImpl, PropertyChangeEvent propertyChangeEvent) {
        this.queuePropertyChange(elementImpl, propertyChangeEvent.getPropertyName(), propertyChangeEvent);
    }

    public void fireModelElementChange(Element.Impl impl, PropertyChangeEvent propertyChangeEvent) {
        this.queuePropertyChange((ElementImpl)impl, propertyChangeEvent.getPropertyName(), propertyChangeEvent);
    }

    protected BindingFactory getBindingFactory() {
        if (this.bindingFactory != null) {
            return this.bindingFactory;
        }
        this.bindingFactory = this.env.getBindingFactory();
        return this.bindingFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrapperFactory getWrapper() {
        if (this.wrapperFactory != null) {
            return this.wrapperFactory;
        }
        DefaultLangModel defaultLangModel = this;
        synchronized (defaultLangModel) {
            if (this.wrapperFactory == null) {
                this.wrapperFactory = this.env.getWrapperFactory();
            }
            WrapperFactory wrapperFactory = this.wrapperFactory;
            return wrapperFactory;
        }
    }

    private void queuePropertyChange(ElementImpl elementImpl, String string, PropertyChangeEvent propertyChangeEvent) {
        this.eventQueue.addPropertyChange(elementImpl, propertyChangeEvent);
    }

    private ElementImpl getElementImpl(Element element) {
        return (ElementImpl)element.getCookie(class$org$netbeans$modules$java$model$ElementImpl == null ? (class$org$netbeans$modules$java$model$ElementImpl = DefaultLangModel.class$("org.netbeans.modules.java.model.ElementImpl")) : class$org$netbeans$modules$java$model$ElementImpl);
    }

    public void updateMembers(Element element, String string, Element[] elementArray, int[] nArray, int[] nArray2) {
        if (element instanceof ClassElement) {
            ClassElementImpl classElementImpl = (ClassElementImpl)this.getElementImpl(element);
            classElementImpl.updateMembers(string, elementArray, nArray, nArray2);
        } else {
            SourceElementImpl sourceElementImpl = (SourceElementImpl)this.getElementImpl(element);
            sourceElementImpl.updateMembers(string, elementArray, nArray2);
        }
    }

    public void updateMemberOrder(Element element, String string, Element[] elementArray) {
        ClassElementImpl classElementImpl = (ClassElementImpl)this.getElementImpl(element);
        classElementImpl.updateMemberOrder(elementArray);
    }

    public void activate(Element element) {
        ElementImpl elementImpl = this.getElementImpl(element);
        elementImpl.notifyCreate();
    }

    public Binding getElementBinding(Element element) {
        ElementImpl elementImpl = this.getElementImpl(element);
        return elementImpl.getRawBinding();
    }

    public boolean isSameContext(Element element, Identifier identifier) {
        ElementImpl elementImpl = this.getElementImpl(element);
        if (elementImpl == null) {
            return false;
        }
        return elementImpl.checkIdentifierContext(identifier);
    }

    public Identifier createLocalIdentifier(Element element, Identifier identifier, int n) {
        ElementImpl elementImpl = this.getElementImpl(element);
        if (elementImpl == null) {
            throw new IllegalArgumentException("Unknown context class: " + element.getClass());
        }
        return elementImpl.createLocalIdentifier(identifier, n);
    }

    public Identifier createLocalIdentifier(Element element, String string, String string2, int n) {
        Identifier identifier = Identifier.create((String)string, (String)string2);
        return this.createLocalIdentifier(element, identifier, n);
    }

    public Element findElement(Element.Impl impl) {
        if (!(impl instanceof ElementImpl)) {
            return null;
        }
        return ((ElementImpl)impl).getElement();
    }

    public void firePropertyChange(Element element, PropertyChangeEvent propertyChangeEvent) {
        ElementImpl elementImpl = this.getElementImpl(element);
        if (elementImpl == null) {
            return;
        }
        elementImpl.firePropertyChangeEvent(propertyChangeEvent);
    }

    public void updateBody(Element element, String string) throws UnsupportedOperationException {
        ElementImpl elementImpl = this.getElementImpl(element);
        if (elementImpl instanceof CallableImpl) {
            ((CallableImpl)elementImpl).updateBody(string);
        } else if (elementImpl instanceof InitializerElementImpl) {
            ((InitializerElementImpl)elementImpl).updateBody(string);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void invalidateModel(SourceElement sourceElement) {
        block7: {
            SourceElementImpl sourceElementImpl = (SourceElementImpl)this.getElementImpl((Element)sourceElement);
            Object object = this.writeLock();
            if (sourceElementImpl != null) break block6;
            Object var5_4 = null;
            try {
                this.releaseWriteLock(object);
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
            {
                block6: {
                    return;
                }
                sourceElementImpl.notifyRemove();
                this.commitChanges();
            }
            Object var5_5 = null;
            try {
                this.releaseWriteLock(object);
            }
            catch (SourceException sourceException) {}
            break block7;
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.releaseWriteLock(object);
                }
                catch (SourceException sourceException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_POSITIONER = new DefaultInsertStrategy();
    }
}

