/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.parser.BaseElementInfo;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class MethodInfo
extends BaseElementInfo {
    Type retType;
    MethodParameter[] params;
    Identifier[] exceptions;
    boolean constructor;

    public MethodInfo(String string, int n) {
        super(string, n);
    }

    public Element createModelImpl(LangModel.Updater updater, Element element) {
        if (this.constructor) {
            return updater.createConstructor((ClassElement)element).getElement();
        }
        return updater.createMethod((ClassElement)element).getElement();
    }

    public void updateElement(LangModel.Updater updater, Element element) throws SourceException {
        super.updateElement(updater, element);
        super.updateBase(element);
        ConstructorElement constructorElement = (ConstructorElement)element;
        ClassElement classElement = constructorElement.getDeclaringClass();
        constructorElement.setParameters(this.mapParameters(updater, constructorElement));
        constructorElement.setExceptions(this.mapIdentifiers(updater, this.exceptions, (Element)classElement));
        this.updateJavaDoc((JavaDoc)constructorElement.getJavaDoc());
        updater.updateBody((Element)constructorElement, this.bodyContent);
        if (!this.constructor) {
            ((MethodElement)constructorElement).setReturn(this.createContextType(updater, (Element)classElement, this.retType));
        }
    }

    private MethodParameter[] mapParameters(LangModel.Updater updater, ConstructorElement constructorElement) {
        if (this.params.length == 0) {
            return this.params;
        }
        MethodParameter[] methodParameterArray = new MethodParameter[this.params.length];
        ClassElement classElement = constructorElement.getDeclaringClass();
        int n = 0;
        while (n < this.params.length) {
            methodParameterArray[n] = new MethodParameter(this.params[n].getName(), this.createContextType(updater, (Element)classElement, this.params[n].getType()), this.params[n].isFinal());
            ++n;
        }
        return methodParameterArray;
    }

    public static class Finder
    extends BaseElementInfo.NameFinder {
        private final boolean compareName;
        private final boolean compareTypes;

        public Finder(boolean bl, boolean bl2) {
            this.compareName = bl;
            this.compareTypes = bl2;
        }

        protected boolean matches(BaseElementInfo baseElementInfo, Element element) {
            MethodInfo methodInfo = (MethodInfo)baseElementInfo;
            ConstructorElement constructorElement = (ConstructorElement)element;
            if (this.compareName && !super.matches(baseElementInfo, element)) {
                return false;
            }
            return !this.compareTypes || this.compareTypes(methodInfo, constructorElement);
        }

        private boolean compareTypes(MethodInfo methodInfo, ConstructorElement constructorElement) {
            MethodParameter[] methodParameterArray = methodInfo.params;
            MethodParameter[] methodParameterArray2 = constructorElement.getParameters();
            if (methodParameterArray.length != methodParameterArray2.length) {
                return false;
            }
            int n = 0;
            while (n < methodParameterArray.length) {
                if (!this.compareTypes(methodParameterArray[n].getType(), methodParameterArray2[n].getType())) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private boolean compareTypes(Type type, Type type2) {
            return type.getSourceString().equals(type2.getSourceString());
        }
    }
}

