/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.ParserEngine;
import org.netbeans.modules.java.codegen.DocumentBinding;
import org.netbeans.modules.java.model.CommitListener;
import org.netbeans.modules.java.model.ElementImpl;
import org.netbeans.modules.java.model.LangModel;
import org.netbeans.modules.java.parser.DocumentModelUpdater;
import org.netbeans.modules.java.parser.JavaParser;
import org.netbeans.modules.java.parser.ParsableObjectRequest;
import org.netbeans.modules.java.parser.ParseObjectRequest;
import org.netbeans.modules.java.parser.ParseSourceRequest;
import org.netbeans.modules.java.parser.SourceImplProxy;
import org.netbeans.modules.java.parser.Util;
import org.openide.nodes.Node;
import org.openide.src.Element;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class ParsingSupport
implements JavaParser {
    private static final int READ_THRESHOLD = 2048;
    private PropertyChangeSupport propSupport;
    public static final String PROP_STATUS = "status";
    private static final boolean DEBUG = false;
    private boolean valid;
    private boolean updating;
    private boolean clean;
    private JavaParser.Env parsingEnv;
    private ParserEngine engine;
    private SourceException savedException;
    private SourceElement src;
    private Processor currentRequest;
    private Processor runningRequest;
    LangModel model;
    LangModel.Updater updater;
    private SourceImplProxy proxy;
    private Reference refImplementation;
    private int status;
    Collection changeList;
    private static ReferenceQueue refQueue;
    private static Map referenceSupportMap;
    DocumentBinding docBinding;
    static final Runnable EMPTY_RUNNABLE;
    static RequestProcessor PARSING_RP;
    protected static DataFinalizer finalizer;
    private static final int FINALIZE_TIMEOUT = 30000;
    static /* synthetic */ Class class$org$netbeans$modules$java$parser$ParsingSupport;

    public ParsingSupport(JavaParser.Env env, DocumentBinding documentBinding, LangModel.Updater updater, LangModel langModel) {
        this.initialize(env, documentBinding, updater, langModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(JavaParser.Env env, DocumentBinding documentBinding, LangModel.Updater updater, LangModel langModel) {
        this.docBinding = documentBinding;
        this.parsingEnv = env;
        this.updater = updater;
        this.model = langModel;
        this.valid = true;
        Class clazz = class$org$netbeans$modules$java$parser$ParsingSupport == null ? (class$org$netbeans$modules$java$parser$ParsingSupport = ParsingSupport.class$("org.netbeans.modules.java.parser.ParsingSupport")) : class$org$netbeans$modules$java$parser$ParsingSupport;
        synchronized (clazz) {
            if (referenceSupportMap == null) {
                referenceSupportMap = new HashMap(17);
                refQueue = new ReferenceQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Object object;
        if (this.changeList == null) {
            object = this;
            synchronized (object) {
                if (this.changeList == null) {
                    this.changeList = new LinkedList();
                }
            }
        }
        object = this.changeList;
        synchronized (object) {
            this.changeList.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeList == null) {
            return;
        }
        Collection collection = this.changeList;
        synchronized (collection) {
            this.changeList.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport == null) {
            ParsingSupport parsingSupport = this;
            synchronized (parsingSupport) {
                if (this.propSupport == null) {
                    this.propSupport = new PropertyChangeSupport(this);
                }
            }
        }
        this.propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Task parse(int n, boolean bl, boolean bl2) {
        ParseSourceRequest parseSourceRequest = new ParseSourceRequest();
        return this.parse(n, bl, bl2, parseSourceRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Task parse(int n, boolean bl, boolean bl2, ParsableObjectRequest parsableObjectRequest) {
        Processor processor;
        SourceElement.Impl impl = null;
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.currentRequest != null) {
                if (!PARSING_RP.isRequestProcessorThread()) {
                    this.currentRequest.enableErrors(bl2);
                    this.currentRequest.setPriority(n);
                    return this.currentRequest.getClientTask();
                }
                processor = this.currentRequest;
            } else {
                impl = this.getSourceImpl();
                if (impl != null && this.clean && !bl) {
                    return new FinishedTask(impl);
                }
                Processor processor2 = new Processor(n, this.parsingEnv, this.docBinding.getEditorSupport(), parsableObjectRequest);
                processor2.enableErrors(bl2);
                if (PARSING_RP != null && PARSING_RP.isRequestProcessorThread()) {
                    processor = processor2;
                } else {
                    this.addRequest(processor2, n);
                    return processor2.getClientTask();
                }
            }
        }
        processor.run();
        impl = this.getSourceImpl();
        return new FinishedTask(impl);
    }

    public void fireElementPropertyChange(Element element, PropertyChangeEvent propertyChangeEvent) {
        if (element == this.getSource()) {
            this.proxy.propertyChange(propertyChangeEvent);
        } else {
            this.updater.firePropertyChange(element, propertyChangeEvent);
        }
    }

    public ParserEngine getParserEngine() {
        return this.engine;
    }

    public void setParserEngine(ParserEngine parserEngine) {
        this.engine = parserEngine;
    }

    public Task prepare() {
        return this.parse(1, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceElement getSource() {
        if (this.src != null) {
            return this.src;
        }
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            block5: {
                if (this.src == null) break block5;
                SourceElement sourceElement = this.src;
                return sourceElement;
            }
            SourceElement sourceElement = this.src = this.createSourceProxy();
            return sourceElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (!this.valid) {
                return;
            }
            SourceElement.Impl impl = this.getSourceImpl();
            if (impl == null) {
                return;
            }
            this.valid = false;
        }
        this.updater.invalidateModel(this.getSource());
        ParsingSupport parsingSupport2 = this;
        synchronized (parsingSupport2) {
            if (!this.updating) {
                this.refImplementation = new WeakReference<Object>(null);
            }
        }
        this.changeStatus(0);
    }

    protected void changeStatus(int n) {
        int n2 = this.status;
        this.status = n;
        if (this.propSupport == null || !this.propSupport.hasListeners(null)) {
            return;
        }
        this.propSupport.firePropertyChange(PROP_STATUS, n2, n);
        this.fireStateChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChange() {
        ArrayList arrayList;
        if (this.changeList == null) {
            return;
        }
        Collection collection = this.changeList;
        synchronized (collection) {
            if (this.changeList.isEmpty()) {
                return;
            }
            arrayList = new ArrayList(this.changeList);
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
            catch (RuntimeException runtimeException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) continue;
                runtimeException.printStackTrace();
            }
        }
    }

    public SourceElement.Impl getSourceImpl() {
        Object var1_1 = this.refImplementation == null ? null : this.refImplementation.get();
        return var1_1;
    }

    public LangModel getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceElement.Impl findSourceImpl() throws SourceException {
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            block5: {
                SourceElement.Impl impl = this.getSourceImpl();
                if (impl == null) break block5;
                SourceElement.Impl impl2 = impl;
                return impl2;
            }
            Util.log("impl = null");
            if (this.savedException != null) {
                throw this.savedException;
            }
        }
        throw new SourceException("Cannot acquire source");
    }

    public void sourceChanged(int n, int n2) {
        Processor processor = this.currentRequest;
        this.clean = false;
        if (processor != null) {
            processor.sourceChanged();
        }
    }

    public SourceException getErrorCause() {
        return this.savedException;
    }

    private SourceElement createSourceProxy() {
        this.proxy = new SourceImplProxy(this);
        return new SourceElement((SourceElement.Impl)this.proxy);
    }

    Node.Cookie findCookieForSource(Class clazz) {
        if (this.src == null) {
            return null;
        }
        return this.parsingEnv.findCookie(this.getSource(), clazz);
    }

    public int getStatus() {
        int n = this.status;
        if (n != 3) {
            return n;
        }
        SourceElement.Impl impl = this.getSourceImpl();
        return impl == null ? 0 : 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceElement.Impl updateSourceModel(DocumentModelUpdater documentModelUpdater) throws SourceException {
        boolean bl;
        SourceElement.Impl impl;
        SourceElement.Impl impl2 = impl = this.getSourceImpl();
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (!this.valid) {
                throw new SourceException.IO("Source was deleted");
            }
            this.updating = true;
            Util.log("updating");
            bl = impl == null;
            if (bl) {
                impl = this.updater.createSource();
            }
        }
        try {
            SourceElement sourceElement = this.getSource();
            this.docBinding.enableGenerator(false);
            this.proxy.notifyInProgress(Thread.currentThread(), impl);
            if (bl) {
                impl.attachedToElement((Element)sourceElement);
                ((ElementImpl)impl).setBinding(this.docBinding.bindSource(sourceElement));
            }
            Util.log("Trying to update the model");
            documentModelUpdater.updateModel(this.updater, sourceElement, impl);
            if (impl2 == null) {
                this.updater.activate((Element)sourceElement);
            }
            Util.log("Update bindings");
            documentModelUpdater.updateBindings(this.docBinding);
            impl2 = impl;
            ParsingSupport parsingSupport2 = this;
            synchronized (parsingSupport2) {
                this.updating = false;
                if (!this.valid) {
                    throw new SourceException.IO("Source was deleted");
                }
            }
            Util.log("register data = " + impl2);
            this.registerData(impl2);
            Object var10_10 = null;
            this.docBinding.enableGenerator(true);
            this.proxy.setModelDelegate(impl2, bl);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.docBinding.enableGenerator(true);
            this.proxy.setModelDelegate(impl2, bl);
            throw throwable;
        }
        return impl2;
    }

    public Task addParsingRunnable(Runnable runnable, int n) {
        return PARSING_RP.post(runnable, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(Processor processor, int n) {
        ParsingSupport parsingSupport;
        if (PARSING_RP == null) {
            parsingSupport = this;
            synchronized (parsingSupport) {
                if (PARSING_RP == null) {
                    PARSING_RP = new RequestProcessor("Java source parsing");
                }
            }
        }
        parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.currentRequest != processor) {
                if (this.currentRequest != null) {
                    processor.chainRequest(this.currentRequest);
                }
                this.currentRequest = processor;
            }
            processor.setProcessorTask(PARSING_RP.post((Runnable)processor, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerData(SourceElement.Impl impl) {
        Class clazz = class$org$netbeans$modules$java$parser$ParsingSupport == null ? (class$org$netbeans$modules$java$parser$ParsingSupport = ParsingSupport.class$("org.netbeans.modules.java.parser.ParsingSupport")) : class$org$netbeans$modules$java$parser$ParsingSupport;
        synchronized (clazz) {
            if (finalizer == null) {
                finalizer = new DataFinalizer();
                RequestProcessor.postRequest((Runnable)finalizer, (int)30000, (int)1);
            }
        }
        Reference reference = finalizer.registerParsingInfo(this, impl, this.refImplementation);
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            this.refImplementation = reference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFinalized(Reference reference) {
        int n;
        ParsingSupport parsingSupport = this;
        synchronized (parsingSupport) {
            if (this.refImplementation != reference) {
                return;
            }
            this.refImplementation = null;
            n = this.status;
            this.status = 0;
        }
        if (this.propSupport == null) {
            return;
        }
        this.propSupport.firePropertyChange(PROP_STATUS, n, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        EMPTY_RUNNABLE = new Runnable(){

            public void run() {
            }
        };
    }

    private static class DataFinalizer
    implements Runnable {
        private Map mapSupportData = new HashMap(37);
        private ReferenceQueue finalizedQueue = new ReferenceQueue();

        DataFinalizer() {
        }

        public synchronized Reference registerParsingInfo(ParsingSupport parsingSupport, SourceElement.Impl impl, Object object) {
            if (object != null) {
                this.mapSupportData.remove(object);
            }
            WeakReference<SourceElement.Impl> weakReference = new WeakReference<SourceElement.Impl>(impl, this.finalizedQueue);
            this.mapSupportData.put(weakReference, new WeakReference<ParsingSupport>(parsingSupport));
            return weakReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Reference reference;
            while ((reference = this.finalizedQueue.poll()) != null) {
                ParsingSupport parsingSupport;
                Reference reference2;
                DataFinalizer dataFinalizer = this;
                synchronized (dataFinalizer) {
                    reference2 = (Reference)this.mapSupportData.get(reference);
                }
                if (reference2 == null || (parsingSupport = (ParsingSupport)reference2.get()) == null) continue;
                parsingSupport.notifyFinalized(reference);
            }
            RequestProcessor.postRequest((Runnable)this, (int)30000, (int)1);
        }
    }

    private class Processor
    implements Runnable,
    CommitListener,
    ParseObjectRequest {
        Processor chained;
        int priority;
        RequestProcessor.Task ownTask;
        boolean errorsOK;
        int stage;
        int resultStatus;
        ParsableObjectRequest request;
        T task;

        Processor(int n, JavaParser.Env env, CloneableEditorSupport cloneableEditorSupport, ParsableObjectRequest parsableObjectRequest) {
            this.request = parsableObjectRequest;
            this.task = new T();
            this.request.setEnvironment(env);
            this.request.setEditorSupport(cloneableEditorSupport);
        }

        protected void directRun() {
            do {
                this.run();
            } while (this.stage >= 0);
        }

        public void setPriority(int n) {
            if (this.priority > n) {
                return;
            }
            this.priority = n;
            if (this.ownTask.cancel()) {
                ParsingSupport.this.addRequest(this, n);
            }
        }

        public void enableErrors(boolean bl) {
            this.errorsOK |= bl;
        }

        public void chainRequest(Processor processor) {
            this.chained = processor;
        }

        public void setProcessorTask(RequestProcessor.Task task) {
            this.ownTask = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Util.log("processing request " + this + " stage " + this.stage);
            try {
                try {
                    switch (this.stage++) {
                        case 0: {
                            this.parseLockModel();
                            break;
                        }
                        case 1: {
                            this.updateModel();
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    ParsingSupport.this.savedException = new SourceException(throwable.getLocalizedMessage());
                    ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, throwable);
                    ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, "Parser error", false);
                    this.resultStatus = 1;
                    Object var3_2 = null;
                    --this.stage;
                }
                {
                }
                Object var3_1 = null;
                --this.stage;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                --this.stage;
                throw throwable;
            }
            Util.log("request " + this + " stage " + (this.stage + 1) + " end");
            if (this.stage > 0) {
                return;
            }
            if (this.resultStatus != -1) {
                this.complete();
                return;
            }
            this.request.notifyReschedule();
            Util.log("Rescheduling request");
            this.stage = 0;
            ParsingSupport.this.addRequest(this, this.priority);
        }

        private void updateModel() throws SourceException {
            ParsingSupport.this.model.removePreCommitListener(this);
            if (this.getSyntaxErrors() > 0 && !this.errorsOK && ParsingSupport.this.getSourceImpl() != null) {
                this.resultStatus = 2;
                return;
            }
            if (this.isValid()) {
                SourceElement.Impl impl = null;
                DocumentModelUpdater documentModelUpdater = this.request.getUpdater();
                if (documentModelUpdater != null) {
                    impl = ParsingSupport.this.updateSourceModel(documentModelUpdater);
                }
                this.resultStatus = impl == null ? 0 : (this.getSyntaxErrors() > 0 ? 2 : 3);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseLockModel() throws SourceException {
            ParsingSupport.this.model.addPreCommitListener(this);
            this.resultStatus = -1;
            ParsingSupport parsingSupport = ParsingSupport.this;
            synchronized (parsingSupport) {
                ParsingSupport.this.runningRequest = this;
                Util.log("Running request = " + this);
            }
            ParsingSupport.this.savedException = null;
            try {
                block7: {
                    try {
                        ParsingSupport.this.runningRequest = this;
                        this.process(ParsingSupport.this.getParserEngine());
                        if (!this.isValid()) break block7;
                        Util.log("Request " + this + " processed. Still valid");
                        this.stage = 1;
                        Util.log("trying to run update");
                        ParsingSupport.this.updater.runUpdate(this, true);
                    }
                    catch (IOException iOException) {
                        ParsingSupport.this.savedException = (SourceException)new SourceException.IO(iOException);
                        ParsingSupport.this.parsingEnv.annotateThrowable(ParsingSupport.this.savedException, iOException);
                        this.resultStatus = 1;
                        Object var4_5 = null;
                        ParsingSupport.this.model.removePreCommitListener(this);
                    }
                }
                Object var4_4 = null;
                ParsingSupport.this.model.removePreCommitListener(this);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ParsingSupport.this.model.removePreCommitListener(this);
                throw throwable;
            }
            ParsingSupport.this.runningRequest = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete() {
            ParsingSupport parsingSupport = ParsingSupport.this;
            synchronized (parsingSupport) {
                if (ParsingSupport.this.currentRequest == this) {
                    ParsingSupport.this.currentRequest = null;
                }
            }
            ParsingSupport.this.changeStatus(this.resultStatus);
            this.task.complete();
            if (this.chained != null) {
                this.chained.complete();
            }
            this.stage = -1;
        }

        public void changesCommited(Set set, Set set2, Map map) {
            this.request.modelChanged();
        }

        public void process(ParserEngine parserEngine) throws IOException {
            parserEngine.process(this);
        }

        public Task getClientTask() {
            return this.task;
        }

        public void sourceChanged() {
            this.request.sourceChanged();
        }

        public void setSyntaxErrors(int n) {
            this.request.setSyntaxErrors(n);
        }

        public void setSemanticErrors(int n) {
            this.request.setSemanticErrors(n);
        }

        public void notifyStart() {
            this.request.notifyStart();
        }

        public void notifyComplete() {
            this.request.notifyComplete();
        }

        public boolean isValid() {
            return this.request.isValid();
        }

        public boolean needsProcessing() {
            return this.request.needsProcessing();
        }

        public int getSyntaxErrors() {
            return this.request.getSyntaxErrors();
        }

        public ElementFactory getFactory() {
            return this.request.getFactory();
        }

        public char[] getSource() throws IOException {
            ParsingSupport.this.clean = true;
            return this.request.getSource();
        }

        public InputStream findCompiledClass(String string) {
            return this.request.findCompiledClass(string);
        }

        public Object getParserType() {
            return this.request.getParserType();
        }

        private class T
        extends Task {
            T() {
                super(EMPTY_RUNNABLE);
            }

            public void run() {
                Processor.this.directRun();
            }

            protected void complete() {
                super.notifyFinished();
            }
        }
    }

    private static class FinishedTask
    extends Task {
        private Object hook;

        public FinishedTask(Object object) {
            super(null);
            this.hook = object;
        }
    }
}

