/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.java.settings.JavaSynchronizationSettings;
import org.netbeans.modules.java.tools.ElementFilter;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ClassElementNode;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

public class InheritanceSupport {
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$java$tools$InheritanceSupport == null ? (class$org$netbeans$modules$java$tools$InheritanceSupport = InheritanceSupport.class$("org.netbeans.modules.java.tools.InheritanceSupport")) : class$org$netbeans$modules$java$tools$InheritanceSupport));
    public static final String PROP_CLASS = "class";
    public static final String PROP_INHERITED_CLASSES = "inheritedClasses";
    public static final String PROP_INHERITED_METHODS = "inheritedMethods";
    public static final String PROP_INTERFACES = "interfaces";
    private static final String JAVA_LANG_OBJECT_FQN = "java.lang.Object";
    private static Identifier JAVA_LANG_OBJECT = Identifier.create((String)"java.lang.Object");
    private static String NAME_ARRAY = bundle.getString("NAME_ArrayOfPrimitives");
    private static String NAME_PARAM = bundle.getString("NAME_Primitive");
    private static String NAME_OBJECT_VALUE = bundle.getString("NAME_javaLangValue");
    private static String NAME_OBJECT = bundle.getString("NAME_javaLangObject");
    private static String NAME_STRING = bundle.getString("NAME_javaLangString");
    private static String NAME_CLASS_VALUE = bundle.getString("NAME_javaLangClass");
    private static Map wellKnownClasses = new HashMap();
    ClassElement clazz;
    String clazzPackage;
    Map superInherited;
    Map allInherited;
    Map inheritedMethods;
    Map classInheritanceInfo;
    Map classCache = new HashMap(17);
    Set fakeSymbols = new HashSet(19);
    Set implementedInterfaces;
    Task hierarchyTask;
    Task methodTask;
    private PropertyChangeListener classPropertyListener;
    private PropertyChangeListener listenerHook;
    private static final Task FINISHED;
    private boolean superIsValid;
    private boolean interfacesAreValid;
    private boolean methodsAreValid;
    private static RequestProcessor wizardRP;
    private ArrayList listenerList = null;
    private static JavaSynchronizationSettings syncSettings;
    static /* synthetic */ Class class$org$netbeans$modules$java$tools$InheritanceSupport;
    static /* synthetic */ Class class$org$netbeans$modules$java$settings$JavaSynchronizationSettings;

    public InheritanceSupport() {
    }

    public InheritanceSupport(ClassElement classElement) {
        this.setSourceClass(classElement);
        this.prepareHierarchy();
    }

    public void setSourceClass(ClassElement classElement) {
        ClassElement classElement2 = this.clazz;
        this.clazz = classElement;
        this.clazzPackage = classElement.getName().getQualifier();
        this.listenerHook = new PropL();
        this.classPropertyListener = WeakListener.propertyChange((PropertyChangeListener)this.listenerHook, (Object)classElement);
        if (classElement2 != null) {
            classElement2.removePropertyChangeListener(this.classPropertyListener);
        }
        classElement.addPropertyChangeListener(this.classPropertyListener);
        this.prepareHierarchy();
    }

    public ClassElement getSourceClass() {
        return this.clazz;
    }

    public void setPackage(String string) {
        this.clazzPackage = string;
        this.invalidateInheritanceSupport();
    }

    public boolean isSamePackage(Identifier identifier) {
        return identifier.getQualifier().equals(this.clazzPackage);
    }

    public boolean isSamePackage(ClassElement classElement) {
        ClassElement classElement2;
        while ((classElement2 = classElement.getDeclaringClass()) != null) {
            classElement = classElement2;
        }
        return this.isSamePackage(classElement.getName());
    }

    private synchronized void resetSymbols() {
        this.classCache.values().removeAll(this.fakeSymbols);
        this.fakeSymbols.clear();
    }

    public synchronized Task prepareHierarchy() {
        if (this.hierarchyTask != null) {
            return this.hierarchyTask;
        }
        if (!this.superIsValid || !this.interfacesAreValid) {
            this.hierarchyTask = wizardRP.post((Runnable)new HierarchyProducer());
            return this.hierarchyTask;
        }
        return FINISHED;
    }

    public synchronized Task prepareMethods() {
        if (this.methodTask != null) {
            return this.methodTask;
        }
        if (!this.methodsAreValid) {
            this.methodTask = wizardRP.post((Runnable)new MethodListProducer());
            return this.methodTask;
        }
        return FINISHED;
    }

    public Map getInheritedFromSuper() {
        Map map = this.superInherited;
        if (map != null) {
            return map;
        }
        this.prepareHierarchy().waitFinished();
        return this.superInherited;
    }

    public Map getAllInherited() {
        Map map = this.allInherited;
        if (map != null) {
            return map;
        }
        this.prepareHierarchy().waitFinished();
        return this.allInherited;
    }

    public Collection getInheritedClasses() {
        return this.getAllInherited().values();
    }

    public Map getInheritedMethodMap() {
        Map map = this.inheritedMethods;
        if (map != null) {
            return map;
        }
        this.prepareMethods().waitFinished();
        return this.inheritedMethods;
    }

    public Collection getInheritedMethods() {
        return this.getInheritedMethodMap().values();
    }

    boolean isAccessibleMethod(MethodElement methodElement) {
        ClassElement classElement = methodElement.getDeclaringClass();
        int n = classElement.getModifiers();
        if ((n & 2) != 0 || (n & 7) == 0 && !this.isSamePackage(classElement.getName())) {
            return false;
        }
        n = methodElement.getModifiers();
        if ((n & 2) != 0) {
            return false;
        }
        if ((n & 5) != 0) {
            return true;
        }
        return this.isSamePackage(classElement.getName());
    }

    public boolean isAccessibleClass(ClassElement classElement) {
        return true;
    }

    private synchronized void invalidateInheritanceSupport() {
        this.superIsValid = false;
        this.invalidateDirectInheritance();
    }

    private synchronized void invalidateDirectInheritance() {
        this.interfacesAreValid = false;
        this.methodsAreValid = false;
        this.fireInheritanceChanged();
        this.prepareHierarchy();
    }

    public synchronized ClassElement getInterface(Identifier identifier, boolean bl) {
        return this.lookupClass(identifier, false, bl);
    }

    public synchronized ClassElement getClass(Identifier identifier, boolean bl) {
        return this.lookupClass(identifier, true, bl);
    }

    public Collection getOverridingMethods() {
        LinkedList<MethodElement> linkedList = new LinkedList<MethodElement>();
        List<MethodElement> list = Arrays.asList(this.clazz.getMethods());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MethodElement methodElement = (MethodElement)iterator.next();
            if (!this.overrides(methodElement)) continue;
            linkedList.add(methodElement);
        }
        return linkedList;
    }

    public boolean overrides(MethodElement methodElement) {
        MethodInfo methodInfo = (MethodInfo)this.getInheritedMethodMap().get(new MethodElement.Key(methodElement));
        if (methodInfo == null) {
            return false;
        }
        return methodInfo.declared.size() > (methodInfo.declared.contains(this.clazz.getName().getFullName()) ? 1 : 0);
    }

    private ClassElement lookupClassElement(Identifier identifier) {
        ClassElement classElement = ClassElement.forName((String)identifier.getFullName());
        if (classElement != null) {
            return classElement;
        }
        if (identifier.getResolutionStatus() != 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.clazzPackage);
        stringBuffer.append('.');
        stringBuffer.append(identifier.getName());
        classElement = ClassElement.forName((String)stringBuffer.toString());
        if (classElement != null) {
            return classElement;
        }
        classElement = ClassElement.forName((String)("java.lang." + identifier.getName()));
        return classElement;
    }

    private ClassElement lookupClass(Identifier identifier, boolean bl, boolean bl2) {
        ClassElement classElement = null;
        String string = identifier.getFullName();
        Reference reference = (Reference)this.classCache.get(string);
        if (reference != null) {
            classElement = (ClassElement)reference.get();
        }
        if (classElement != null) {
            return classElement;
        }
        classElement = this.lookupClassElement(identifier);
        if (classElement == null) {
            if (!bl2) {
                return null;
            }
            classElement = this.createElement(identifier, bl);
        }
        this.classCache.put(identifier.getFullName(), new SoftReference<ClassElement>(classElement));
        return classElement;
    }

    private ClassElement createElement(Identifier identifier, boolean bl) {
        ClassElement classElement = new ClassElement();
        try {
            classElement.setClassOrInterface(bl);
            classElement.setName(identifier);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        return classElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildSuperHierarchy() {
        ClassElement classElement;
        HashMap<String, ClassElement> hashMap = new HashMap<String, ClassElement>(17);
        HashSet hashSet = new HashSet();
        HashMap<String, ClassInfo> hashMap2 = new HashMap<String, ClassInfo>(23);
        this.superIsValid = true;
        if (this.clazz.getSuperclass() != null) {
            classElement = this.getClass(this.clazz.getSuperclass(), true);
            hashMap.put(this.clazz.getSuperclass().getFullName(), classElement);
            this.addInheritedClasses(classElement, hashMap, hashSet, hashMap2);
            InheritanceSupport inheritanceSupport = this;
            synchronized (inheritanceSupport) {
                this.implementedInterfaces = new HashSet<Identifier>(Arrays.asList(this.clazz.getInterfaces()));
            }
        } else {
            hashMap = new HashMap();
        }
        if (this.clazz.isClassOrInterface() && !hashMap.containsKey(JAVA_LANG_OBJECT_FQN)) {
            classElement = this.getClass(JAVA_LANG_OBJECT, true);
            hashMap.put(JAVA_LANG_OBJECT_FQN, classElement);
            hashMap2.put(JAVA_LANG_OBJECT_FQN, new ClassInfo(classElement));
        }
        this.superInherited = hashMap;
        this.classInheritanceInfo = hashMap2;
        return hashMap;
    }

    private Map buildDirectHierarchy() {
        Map map = this.buildSuperHierarchy();
        HashMap<String, ClassElement> hashMap = new HashMap<String, ClassElement>(map.size());
        HashSet hashSet = new HashSet();
        hashMap.putAll(map);
        Identifier[] identifierArray = this.clazz.getInterfaces();
        this.interfacesAreValid = true;
        int n = 0;
        while (n < identifierArray.length) {
            if (!map.containsKey(identifierArray[n].getFullName())) {
                ClassElement classElement = this.getInterface(identifierArray[n], true);
                hashMap.put(identifierArray[n].getFullName(), classElement);
                this.addInheritedClasses(classElement, hashMap, hashSet, this.classInheritanceInfo);
            }
            ++n;
        }
        this.allInherited = hashMap;
        this.fireInheritanceChanged();
        return hashMap;
    }

    ClassInfo addInheritedClasses(ClassElement classElement, Map map, Set set, Map map2) {
        Object object;
        ClassElement classElement2;
        Identifier identifier = classElement.getSuperclass();
        String string = null;
        if (!this.superIsValid) {
            return new ClassInfo(classElement);
        }
        ClassInfo classInfo = new ClassInfo(classElement);
        map2.put(classElement.getName().getFullName(), classInfo);
        if (identifier != null && !identifier.getFullName().equals("") && !map.containsKey(string = identifier.getFullName()) && !set.contains(string) && (classElement2 = this.getClass(identifier, true)) != null && this.isAccessibleClass(classElement)) {
            set.add(string);
            classInfo.addSuperclass(identifier);
            object = this.addInheritedClasses(classElement2, map, set, map2);
            map.put(string, classElement2);
            classInfo.addSuperclasses(((ClassInfo)object).getSuperclasses());
        }
        if ((object = classElement.getInterfaces()) != null && ((Identifier[])object).length > 0) {
            int n = 0;
            while (n < ((Identifier[])object).length) {
                identifier = object[n];
                string = identifier.getFullName();
                if (!map.containsKey(string) && !set.contains(string) && (classElement2 = this.getInterface(identifier, true)) != null && this.isAccessibleClass(classElement2)) {
                    map.put(string, classElement2);
                    classInfo.addSuperclass(identifier);
                    classInfo.addSuperclasses(this.addInheritedClasses(classElement2, map, set, map2).getSuperclasses());
                }
                ++n;
            }
        }
        return classInfo;
    }

    private void addMethods(ClassElement classElement, Map map, Set set) {
        boolean bl;
        MethodElement methodElement;
        MethodElement[] methodElementArray = classElement.getMethods();
        if (!this.isAccessibleClass(classElement)) {
            return;
        }
        int n = 0;
        while (n < methodElementArray.length) {
            methodElement = methodElementArray[n];
            int n2 = methodElement.getModifiers();
            if (!Modifier.isPrivate(n2) && ((n2 & 7) != 0 || this.isSamePackage(classElement.getName()))) {
                bl = Modifier.isAbstract(n2) || !classElement.isClassOrInterface();
                MethodElement.Key key = new MethodElement.Key(methodElementArray[n]);
                if (!map.containsKey(key)) {
                    map.put(key, new MethodInfo(methodElementArray[n], key, classElement));
                } else {
                    ((MethodInfo)map.get(key)).addClass(classElement, bl);
                }
            }
            ++n;
        }
        set.add(classElement.getName().getFullName());
        methodElement = classElement.getSuperclass();
        if (methodElement == null && !classElement.getName().equals((Object)ClassElement.ROOT_OBJECT)) {
            methodElement = ClassElement.ROOT_OBJECT;
        }
        if (methodElement != null && !set.contains(methodElement.getFullName())) {
            ClassElement classElement2 = this.getClass((Identifier)methodElement, true);
            this.addMethods(classElement2, map, set);
        }
        Identifier[] identifierArray = classElement.getInterfaces();
        bl = false;
        while (bl < identifierArray.length) {
            if (!set.contains(identifierArray[bl].getFullName())) {
                ClassElement classElement3 = this.getInterface(identifierArray[bl], true);
                this.addMethods(classElement3, map, set);
            }
            bl += 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMethodList() {
        InheritanceSupport inheritanceSupport;
        HashSet hashSet = new HashSet(17);
        HashMap hashMap = new HashMap(23);
        this.addMethods(this.clazz, hashMap, hashSet);
        Identifier[] identifierArray = this.clazz.getInterfaces();
        int n = 0;
        while (n < identifierArray.length) {
            if (!hashSet.contains(identifierArray[n].getFullName())) {
                inheritanceSupport = this.getInterface(identifierArray[n], true);
                this.addMethods((ClassElement)inheritanceSupport, hashMap, hashSet);
            }
            ++n;
        }
        inheritanceSupport = this;
        synchronized (inheritanceSupport) {
            this.methodsAreValid = true;
            this.inheritedMethods = hashMap;
        }
    }

    public synchronized void addHierarchyListener(HierarchyListener hierarchyListener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList();
        }
        this.listenerList.add(hierarchyListener);
    }

    public synchronized void removeHierarchyListener(HierarchyListener hierarchyListener) {
        this.listenerList.remove(hierarchyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInheritanceChanged() {
        Collection collection;
        Map map = this.allInherited;
        InheritanceSupport inheritanceSupport = this;
        synchronized (inheritanceSupport) {
            if (this.listenerList == null) {
                return;
            }
            collection = (Collection)this.listenerList.clone();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            HierarchyListener hierarchyListener = (HierarchyListener)iterator.next();
            hierarchyListener.inheritedClassesComputed(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInheritanceComputed() {
        Collection collection;
        InheritanceSupport inheritanceSupport = this;
        synchronized (inheritanceSupport) {
            if (this.listenerList == null) {
                return;
            }
            collection = (Collection)this.listenerList.clone();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            HierarchyListener hierarchyListener = (HierarchyListener)iterator.next();
            hierarchyListener.inheritanceChanged();
        }
    }

    public Node createClassElementNode(ClassElement classElement, Children children, boolean bl) {
        return new ClassElementNode(classElement, children, bl);
    }

    public static MethodElement completeParameters(MethodElement methodElement, boolean bl) {
        MethodParameter[] methodParameterArray = methodElement.getParameters();
        HashSet<String> hashSet = new HashSet<String>();
        if (methodParameterArray == null || methodParameterArray.length == 0) {
            return methodElement;
        }
        int n = 0;
        while (n < methodParameterArray.length) {
            MethodParameter methodParameter = methodParameterArray[n];
            if (methodParameter.getName() == null || methodParameter.getName().toString().equals("")) {
                String string;
                if (!bl) {
                    methodElement = (MethodElement)methodElement.clone();
                    methodParameterArray = methodElement.getParameters();
                    methodParameter = methodParameterArray[n];
                    bl = true;
                }
                if (hashSet.contains(string = InheritanceSupport.createName(methodParameter.getType()))) {
                    string = string + n;
                } else {
                    hashSet.add(string);
                }
                methodParameter.setName(string);
            }
            if (methodParameter.isFinal()) {
                if (!bl) {
                    methodElement = (MethodElement)methodElement.clone();
                    methodParameterArray = methodElement.getParameters();
                    methodParameter = methodParameterArray[n];
                    bl = true;
                }
                methodParameter.setFinal(false);
            }
            ++n;
        }
        return methodElement;
    }

    private static String createName(Type type) {
        boolean bl = false;
        if (type.isArray()) {
            bl = true;
            while ((type = type.getElementType()).isArray()) {
            }
        }
        if (type.isPrimitive()) {
            if (bl) {
                return NAME_ARRAY;
            }
            return NAME_PARAM;
        }
        String string = type.getClassName().getFullName();
        if (wellKnownClasses.containsKey(string)) {
            return (String)wellKnownClasses.get(string);
        }
        String string2 = type.getClassName().getName();
        int n = string2.length() - 1;
        while (n > 0) {
            if (Character.isTitleCase(string2.charAt(n))) break;
            --n;
        }
        String string3 = n < string2.length() - 1 ? Character.toLowerCase(string2.charAt(n)) + string2.substring(n + 1) : string2.toLowerCase();
        if (Utilities.isJavaIdentifier((String)string3)) {
            return string3;
        }
        return MessageFormat.format(bundle.getString("NAME_typeParam"), string3);
    }

    public MethodElement overrideMethod(MethodElement methodElement) throws SourceException {
        return this.overrideMethod(methodElement, false);
    }

    public MethodElement overrideMethod(MethodElement methodElement, boolean bl) throws SourceException {
        return InheritanceSupport.overrideMethod(this.getSourceClass(), methodElement, bl, this.isImplemented(methodElement));
    }

    public static MethodElement overrideMethod(ClassElement classElement, MethodElement methodElement, boolean bl, boolean bl2) throws SourceException {
        MethodElement methodElement2 = InheritanceSupport.completeParameters((MethodElement)methodElement.clone(), true);
        int n = methodElement2.getModifiers() & 0xFFFFFADF;
        if (methodElement.getDeclaringClass() != null && !methodElement.getDeclaringClass().isClassOrInterface()) {
            n |= 1;
        }
        methodElement2.setModifiers(n);
        if (!bl) {
            methodElement2.setBody("\n");
        } else {
            methodElement2.setBody(InheritanceSupport.createSuperCall(methodElement2, bl2));
        }
        classElement.addMethod(methodElement2);
        MethodParameter[] methodParameterArray = methodElement2.getParameters();
        Type[] typeArray = new Type[methodParameterArray.length];
        int n2 = 0;
        while (n2 < typeArray.length) {
            typeArray[n2] = methodParameterArray[n2].getType();
            ++n2;
        }
        MethodElement methodElement3 = classElement.getMethod(methodElement2.getName(), typeArray);
        return methodElement3;
    }

    protected static String createSuperCall(MethodElement methodElement, boolean bl) {
        String string;
        if (syncSettings == null) {
            syncSettings = (JavaSynchronizationSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$java$settings$JavaSynchronizationSettings == null ? (class$org$netbeans$modules$java$settings$JavaSynchronizationSettings = InheritanceSupport.class$("org.netbeans.modules.java.settings.JavaSynchronizationSettings")) : class$org$netbeans$modules$java$settings$JavaSynchronizationSettings), (boolean)true);
        }
        if (bl) {
            MethodParameter[] methodParameterArray = methodElement.getParameters();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < methodParameterArray.length) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(methodParameterArray[n].getName());
                ++n;
            }
            String string2 = Type.VOID.equals((Object)methodElement.getReturn()) ? bundle.getString("FMT_CallSuper") : bundle.getString("FMT_ReturnCallSuper");
            string = MessageFormat.format(string2, methodElement.getReturn(), methodElement.getName(), stringBuffer);
        } else {
            string = syncSettings.getGenerateReturnAsString(methodElement.getReturn());
        }
        return string;
    }

    ClassInfo getClassInfo(ClassElement classElement) {
        ClassInfo classInfo = (ClassInfo)this.classInheritanceInfo.get(classElement.getName().getFullName());
        if (classInfo == null) {
            return new ClassInfo(classElement);
        }
        return classInfo;
    }

    MethodInfo getMethodInfo(MethodElement methodElement) {
        MethodElement.Key key = new MethodElement.Key(methodElement);
        MethodInfo methodInfo = (MethodInfo)this.getInheritedMethodMap().get(key);
        if (methodInfo == null) {
            return new MethodInfo(methodElement, key, null);
        }
        return methodInfo;
    }

    boolean isImplemented(MethodElement methodElement) {
        MethodInfo methodInfo = this.getMethodInfo(methodElement);
        ClassElement classElement = methodInfo.getDefinition();
        if (classElement == null) {
            return false;
        }
        return classElement != this.clazz;
    }

    boolean isDeclaredFirst(MethodElement methodElement, ClassElement classElement) {
        Set set = this.getClassInfo(classElement).getSuperclasses();
        Set set2 = this.getMethodInfo(methodElement).getDeclarations();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            if (!set.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private void collectClassMethods(ClassElement classElement, HashMap hashMap, ElementFilter.Method method) {
        MethodElement[] methodElementArray = classElement.getMethods();
        int n = 0;
        while (n < methodElementArray.length) {
            MethodElement methodElement = methodElementArray[n];
            MethodElement.Key key = new MethodElement.Key(methodElement);
            if (!hashMap.containsKey(key) && method.accept(methodElement)) {
                hashMap.put(key, methodElement);
            }
            ++n;
        }
    }

    private void collectClassMethods(ClassElement classElement, HashMap hashMap, ElementFilter.Method method, boolean bl, Set set) {
        ClassElement classElement2;
        String string = classElement.getName().getFullName();
        if (set.contains(string)) {
            return;
        }
        set.add(string);
        this.collectClassMethods(classElement, hashMap, method);
        Identifier identifier = classElement.getSuperclass();
        if (!bl) {
            return;
        }
        if (identifier != null && !"".equals(identifier.getFullName())) {
            classElement2 = this.getClass(identifier, true);
            this.collectClassMethods(classElement2, hashMap, method, bl, set);
        }
        Identifier[] identifierArray = classElement.getInterfaces();
        int n = 0;
        while (n < identifierArray.length) {
            identifier = identifierArray[n];
            if (!classElement.isInterface() || !JAVA_LANG_OBJECT.equals((Object)identifier.getFullName())) {
                classElement2 = this.getInterface(identifier, true);
                this.collectClassMethods(classElement2, hashMap, method, bl, set);
            }
            ++n;
        }
    }

    Collection collectMethods(Collection collection, boolean bl, ElementFilter.Method method) {
        return this.createMethodMap(collection, bl, method).values();
    }

    public Map createMethodMap(Collection collection, boolean bl, ElementFilter.Method method) {
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap(17);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.collectClassMethods((ClassElement)iterator.next(), hashMap, method, bl, hashSet);
        }
        return hashMap;
    }

    public boolean isOverridable(MethodElement methodElement) {
        if (!this.isAccessibleMethod(methodElement)) {
            return false;
        }
        int n = methodElement.getModifiers();
        return !Modifier.isFinal(n) && !Modifier.isStatic(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        wellKnownClasses.put(JAVA_LANG_OBJECT_FQN, NAME_OBJECT);
        wellKnownClasses.put("java.lang.String", NAME_STRING);
        wellKnownClasses.put("java.lang.Float", NAME_OBJECT_VALUE);
        wellKnownClasses.put("java.lang.Double", NAME_OBJECT_VALUE);
        wellKnownClasses.put("java.lang.Long", NAME_OBJECT_VALUE);
        wellKnownClasses.put("java.lang.Class", NAME_CLASS_VALUE);
        FINISHED = Task.EMPTY;
        wizardRP = new RequestProcessor("JavaWizard query");
    }

    private class PropL
    implements PropertyChangeListener {
        private PropL() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Identifier identifier;
            String string;
            String string2 = propertyChangeEvent.getPropertyName();
            if (string2.equals("superclass")) {
                InheritanceSupport.this.invalidateInheritanceSupport();
            } else if (string2.equals(InheritanceSupport.PROP_INTERFACES)) {
                if (this.checkInterfaces(InheritanceSupport.this.clazz.getInterfaces())) {
                    InheritanceSupport.this.invalidateDirectInheritance();
                }
            } else if ("name".equals(string2) && !(string = (identifier = (Identifier)propertyChangeEvent.getNewValue()).getQualifier()).equals(InheritanceSupport.this.clazzPackage)) {
                InheritanceSupport.this.setPackage(string);
            }
        }

        private boolean checkInterfaces(Identifier[] identifierArray) {
            int n = 0;
            if (InheritanceSupport.this.implementedInterfaces == null) {
                return identifierArray.length != 0;
            }
            int n2 = 0;
            while (n2 < identifierArray.length) {
                if (!InheritanceSupport.this.implementedInterfaces.contains(identifierArray[n2])) {
                    return true;
                }
                ++n;
                ++n2;
            }
            return n != InheritanceSupport.this.implementedInterfaces.size();
        }
    }

    public static interface HierarchyListener
    extends EventListener {
        public void inheritanceChanged();

        public void inheritedClassesComputed(Map var1);

        public void inheritedMethodsComputed(Collection var1);
    }

    private class HierarchyProducer
    implements Runnable {
        private HierarchyProducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            while (true) {
                if (!InheritanceSupport.this.superIsValid) {
                    InheritanceSupport.this.buildSuperHierarchy();
                    bl = true;
                }
                if (!InheritanceSupport.this.interfacesAreValid) {
                    InheritanceSupport.this.buildDirectHierarchy();
                    bl = true;
                }
                InheritanceSupport inheritanceSupport = InheritanceSupport.this;
                synchronized (inheritanceSupport) {
                    if (InheritanceSupport.this.superIsValid && InheritanceSupport.this.interfacesAreValid) {
                        InheritanceSupport.this.hierarchyTask = null;
                        if (bl) {
                            InheritanceSupport.this.prepareMethods();
                        }
                        return;
                    }
                }
            }
        }
    }

    private class MethodListProducer
    implements Runnable {
        private MethodListProducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!InheritanceSupport.this.methodsAreValid) {
                InheritanceSupport.this.buildMethodList();
            }
            InheritanceSupport inheritanceSupport = InheritanceSupport.this;
            synchronized (inheritanceSupport) {
                InheritanceSupport.this.methodTask = null;
            }
        }
    }

    private class MethodInfo {
        private MethodElement.Key key;
        public MethodElement method;
        public Set declared;
        public ClassElement defined;
        public boolean overriden;

        MethodInfo(MethodElement methodElement, MethodElement.Key key, ClassElement classElement) {
            this.key = key;
            this.method = methodElement;
            this.declared = new HashSet(17);
            if (classElement != null) {
                this.addClass(classElement, Modifier.isAbstract(methodElement.getModifiers()) || !classElement.isClassOrInterface());
            }
        }

        private void addClass(ClassElement classElement, boolean bl) {
            this.declared.add(classElement.getName().getFullName());
            if (!bl && this.defined == null) {
                this.defined = classElement;
            }
        }

        public MethodElement.Key getKey() {
            return this.key;
        }

        public Set getDeclarations() {
            return this.declared;
        }

        public ClassElement getDefinition() {
            return this.defined;
        }
    }

    private class ClassInfo {
        Set allInherited;
        ClassElement element;

        ClassInfo(ClassElement classElement) {
            this.element = classElement;
        }

        void addSuperclasses(Collection collection) {
            if (this.allInherited == null) {
                this.allInherited = new HashSet(collection.size());
            }
            this.allInherited.addAll(collection);
        }

        void addSuperclass(Identifier identifier) {
            if (this.allInherited == null) {
                this.allInherited = new HashSet(7);
            }
            this.allInherited.add(identifier);
        }

        Set getSuperclasses() {
            if (this.allInherited == null) {
                this.allInherited = new HashSet();
            }
            return this.allInherited;
        }
    }
}

