/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Modifier;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;

public class AccessLevelPanel
extends JPanel {
    public static final String PROP_ACCESS_LEVEL = "accessLevel";
    private JComboBox accessCombo;
    private JLabel accessLabel;

    public AccessLevelPanel(int n, int n2) {
        this.initComponents();
        this.initAccessibility();
        this.setAllowedAccessLevel(n);
        this.setAccessLevel(n2);
        this.accessLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Access_Level_Mnemonic").charAt(0));
    }

    public void setAllowedAccessLevel(int n) {
        this.accessCombo.addItem("<default>");
        if (Modifier.isPublic(n)) {
            this.accessCombo.addItem("public");
        }
        if (Modifier.isPrivate(n)) {
            this.accessCombo.addItem("private");
        }
        if (Modifier.isProtected(n)) {
            this.accessCombo.addItem("protected");
        }
    }

    public void setAccessLevel(int n) {
        String string = Modifier.toString(n);
        this.accessCombo.setSelectedItem("".equals(string) ? "<default>" : string);
    }

    public int getAccessLevel() {
        return this.toBin(this.accessCombo.getSelectedItem());
    }

    private int toBin(Object object) {
        if ("public".equals(object)) {
            return 1;
        }
        if ("private".equals(object)) {
            return 2;
        }
        if ("protected".equals(object)) {
            return 4;
        }
        return 0;
    }

    private void initAccessibility() {
        this.accessLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Access_LevelA11yDesc"));
        this.accessCombo.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_Access_LevelComboBoxA11yName"));
    }

    private void initComponents() {
        this.accessLabel = new JLabel();
        this.accessCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.accessLabel.setText(JavaWizardIterator.getString("LBL_Access_Level"));
        this.accessLabel.setLabelFor(this.accessCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.accessLabel, gridBagConstraints);
        this.accessCombo.setToolTipText(JavaWizardIterator.getString("ACS_Access_LevelComboBoxA11yDesc"));
        this.accessCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AccessLevelPanel.this.changeAccessLevel(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.accessCombo, gridBagConstraints);
    }

    private void changeAccessLevel(ItemEvent itemEvent) {
        super.firePropertyChange(PROP_ACCESS_LEVEL, null, null);
    }
}

