/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.ui.wizard.AccessLevelPanel;
import org.netbeans.modules.java.ui.wizard.ClassTypePanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.ModifierEditor;
import org.netbeans.modules.java.ui.wizard.Util;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.SourceException;
import org.openide.util.HelpCtx;

public class ClassCustomizer
extends JPanel
implements PropertyChangeListener {
    private ClassElement clazz;
    private static final String[] COMMON_TYPES = new String[]{"java.lang.Object", "java.awt.Component", "javax.swing.JComponent", "javax.swing.JPanel"};
    private boolean superclassChangeWarning = false;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel packageLabel;
    private JTextField packageField;
    private JLabel classDeclarationLabel;
    private JTextField classDeclarationField;
    private JPanel leftPanel;
    private JLabel superClassLabel;
    private JComboBox superclassCombo;
    private JLabel interfacesLabel;
    private AccessLevelPanel accessLevelPanel;
    private ClassTypePanel classTypePanel;
    private PropertyPanel interfacesPanel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$InterfaceModifierEditor;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$ClassModifierEditor;

    public ClassCustomizer(ClassElement classElement) {
        this.initComponents();
        this.initAccessibility();
        this.interfacesPanel = new PropertyPanel((Object)new ClassElement(), "interfaces", 4);
        this.interfacesPanel.setToolTipText(JavaWizardIterator.getString("HINT_ClassInterfaces"));
        this.interfacesLabel.setLabelFor((Component)this.interfacesPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        this.leftPanel.add((Component)this.interfacesPanel, gridBagConstraints);
        this.nameLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Class_Name_Mnemonic").charAt(0));
        this.packageLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Package_Mnemonic").charAt(0));
        this.superClassLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Superclass_Mnemonic").charAt(0));
        this.classDeclarationLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Class_Declaration_Mnemonic").charAt(0));
        this.interfacesLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Interfaces_Implemented_Mnemonic").charAt(0));
    }

    private void initAccessibility() {
        this.nameLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_ClassNameA11yDesc"));
        this.nameField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_ClassNameTextFieldA11yName"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_PackageA11yDesc"));
        this.packageField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_PackageTextFieldA11yName"));
        this.classDeclarationLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Class_DeclarationA11yDesc"));
        this.classDeclarationField.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_Class_DeclarationTextFieldA11yName"));
        this.superClassLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_SuperclassA11yDesc"));
        this.superclassCombo.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_SuperclassComboBoxA11yName"));
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.packageLabel = new JLabel();
        this.packageField = new JTextField();
        this.classDeclarationLabel = new JLabel();
        this.classDeclarationField = new JTextField();
        this.leftPanel = new JPanel();
        this.superClassLabel = new JLabel();
        this.superclassCombo = new JComboBox<String>(COMMON_TYPES);
        this.interfacesLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_InheritanceWizardPanel"));
        this.nameLabel.setText(JavaWizardIterator.getString("LBL_Name"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setToolTipText(JavaWizardIterator.getString("ACS_ClassNameTextFieldA11yDesc"));
        this.nameField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.nameField, gridBagConstraints);
        this.packageLabel.setText(JavaWizardIterator.getString("LBL_Package"));
        this.packageLabel.setLabelFor(this.packageField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.packageLabel, gridBagConstraints);
        this.packageField.setToolTipText(JavaWizardIterator.getString("ACS_PackageTextFieldA11yDesc"));
        this.packageField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.packageField, gridBagConstraints);
        this.classDeclarationLabel.setText(JavaWizardIterator.getString("LBL_Class_Declaration"));
        this.classDeclarationLabel.setLabelFor(this.classDeclarationField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.classDeclarationLabel, gridBagConstraints);
        this.classDeclarationField.setToolTipText(JavaWizardIterator.getString("ACS_Class_DeclarationTextFieldA11yDesc"));
        this.classDeclarationField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.classDeclarationField, gridBagConstraints);
        this.leftPanel.setLayout(new GridBagLayout());
        this.superClassLabel.setText(JavaWizardIterator.getString("LBL_Superclass"));
        this.superClassLabel.setLabelFor(this.superclassCombo);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints2.anchor = 17;
        this.leftPanel.add((Component)this.superClassLabel, gridBagConstraints2);
        this.superclassCombo.setToolTipText(JavaWizardIterator.getString("ACS_SuperclassComboBoxA11yDesc"));
        this.superclassCombo.setEditable(true);
        this.superclassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassCustomizer.this.superclassComboActionPerformed(actionEvent);
            }
        });
        this.superclassCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ClassCustomizer.this.superclassComboFocusLost(focusEvent);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints2.weightx = 1.0;
        this.leftPanel.add((Component)this.superclassCombo, gridBagConstraints2);
        this.interfacesLabel.setText(JavaWizardIterator.getString("LBL_Interfaces_Implemented"));
        this.interfacesLabel.setLabelFor((Component)this.interfacesPanel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints2.anchor = 17;
        this.leftPanel.add((Component)this.interfacesLabel, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.leftPanel, gridBagConstraints);
    }

    private void superclassComboFocusLost(FocusEvent focusEvent) {
        this.updateSuperclass();
    }

    private void superclassComboActionPerformed(ActionEvent actionEvent) {
        this.updateSuperclass();
    }

    private void updateSuperclass() throws IllegalArgumentException {
        Identifier identifier = this.clazz.getSuperclass();
        String string = identifier == null ? "" : identifier.getFullName();
        Object object = this.superclassCombo.getSelectedItem();
        if (object == null) {
            this.superclassCombo.setSelectedItem(string);
            return;
        }
        String string2 = object.toString();
        if (!this.superclassChangeWarning) {
            if (identifier != null && ClassElement.ROOT_OBJECT.equals((Object)identifier) && this.warnSuperclassChange()) {
                this.superclassCombo.setSelectedItem(identifier);
                return;
            }
            this.superclassChangeWarning = true;
        }
        boolean bl = false;
        try {
            if (!string.equals(string2)) {
                if (!"".equals(string2) && !Util.isValidTypeIdentifier(string2)) {
                    String string3 = MessageFormat.format(Util.getString("FMTERR_InvalidIdentifier"), string2);
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal superclass name");
                    TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), string3, null, null);
                    TopManager.getDefault().getErrorManager().notify((Throwable)illegalArgumentException);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ClassCustomizer.this.superclassCombo.requestFocus();
                        }
                    });
                } else {
                    try {
                        Identifier identifier2 = string2.equals("") ? null : Identifier.create((String)string2);
                        this.clazz.setSuperclass(identifier2);
                        bl = true;
                    }
                    catch (SourceException sourceException) {
                        TopManager.getDefault().notifyException((Throwable)sourceException);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)JavaWizardIterator.getString("ERR_InvalidClassIdentifier"), 0));
        }
        if (!bl) {
            this.superclassCombo.setSelectedItem(string);
        }
    }

    private void updateClassDeclaration() {
        String string = this.clazz.getName().isQualified() ? this.clazz.getName().getQualifier() : JavaWizardIterator.getString("TXT_DefaultPackageName");
        this.packageField.setText(string);
        this.nameField.setText(this.clazz.getName().getSourceName());
        String string2 = Modifier.toString(this.clazz.getModifiers());
        if (string2.length() > 0) {
            string2 = string2 + " ";
        }
        string2 = this.clazz.isClass() ? string2 + "class " : string2 + "interface ";
        string2 = string2 + this.clazz.getName();
        if (this.clazz.getSuperclass() != null) {
            string2 = string2 + " extends " + this.clazz.getSuperclass().getName();
        }
        if (this.clazz.getInterfaces().length > 0) {
            string2 = string2 + (this.clazz.isClass() ? " implements " : " extends ");
            string2 = string2 + this.interfacesPanel.getPropertyEditor().getAsText();
        }
        this.classDeclarationField.setText(string2);
    }

    private boolean warnSuperclassChange() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("name".equals(string) || "superclass".equals(string) || "modifiers".equals(string) || "interfaces".equals(string)) {
            this.updateClassDeclaration();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.clazz != null) {
            this.clazz.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.clazz != null) {
            this.clazz.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void setObject(ClassElement classElement) {
        PropertyPanel propertyPanel;
        PropertyEditor propertyEditor;
        if (this.clazz == classElement) {
            return;
        }
        if (this.clazz != null) {
            this.clazz.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.clazz = classElement;
        if (this.clazz != null) {
            this.clazz.addPropertyChangeListener((PropertyChangeListener)this);
            this.updateClassDeclaration();
        }
        this.superclassCombo.setEnabled(classElement.isClass());
        String string = classElement.isInterface() || classElement.getSuperclass() == null ? "" : classElement.getSuperclass().getFullName();
        this.superclassCombo.setSelectedItem(string);
        this.interfacesPanel.setModel((PropertyModel)new DefaultPropertyModel((Object)classElement, "interfaces"));
        this.interfacesPanel.setChangeImmediate(false);
        this.interfacesPanel.getPropertyEditor().setValue(classElement.getInterfaces());
        if (this.accessLevelPanel != null) {
            this.remove(this.accessLevelPanel);
        }
        if (this.classTypePanel != null) {
            this.remove(this.classTypePanel);
        }
        if ((propertyEditor = (propertyPanel = new PropertyPanel((PropertyModel)new TempPropertyModel(classElement, "modifiers", classElement.isInterface()), 2)).getPropertyEditor()) instanceof ModifierEditor) {
            this.accessLevelPanel = ((ModifierEditor)propertyEditor).getAccessLevelPanel();
            this.classTypePanel = (ClassTypePanel)((ModifierEditor)propertyEditor).getModifierPanel();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.classTypePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints.weightx = 1.0;
        this.leftPanel.add((Component)this.accessLevelPanel, gridBagConstraints);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class InterfaceModifierEditor
    extends ModifierEditor {
        public InterfaceModifierEditor() {
            super(new AccessLevelPanel(1, 0), new ClassTypePanel(true));
        }
    }

    public static class ClassModifierEditor
    extends ModifierEditor {
        public ClassModifierEditor() {
            super(new AccessLevelPanel(1, 0), new ClassTypePanel(false));
        }
    }

    static class TempPropertyModel
    extends DefaultPropertyModel {
        boolean inter;

        public TempPropertyModel(Object object, String string, boolean bl) throws IllegalArgumentException {
            super(object, string);
            this.inter = bl;
        }

        public Class getPropertyEditorClass() {
            Class clazz = this.inter ? (class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$InterfaceModifierEditor == null ? (class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$InterfaceModifierEditor = ClassCustomizer.class$("org.netbeans.modules.java.ui.wizard.ClassCustomizer$InterfaceModifierEditor")) : class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$InterfaceModifierEditor) : (class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$ClassModifierEditor == null ? (class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$ClassModifierEditor = ClassCustomizer.class$("org.netbeans.modules.java.ui.wizard.ClassCustomizer$ClassModifierEditor")) : class$org$netbeans$modules$java$ui$wizard$ClassCustomizer$ClassModifierEditor);
            return clazz;
        }
    }
}

