/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import org.netbeans.modules.java.ui.wizard.AccessLevelPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public abstract class ModifierEditor
extends PropertyEditorSupport
implements PropertyChangeListener,
EnhancedCustomPropertyEditor {
    public static final String PROP_MODIFIER = "modifier";
    private static final String[] MODIFIER_NAMES = new String[]{"abstract", "final", "static", "synchronized", "transient", "volatile", "native"};
    private static final int[] MODIFIER_VALUES = new int[]{1024, 16, 8, 32, 128, 64, 256};
    private static final int MODIFIER_COUNT = MODIFIER_VALUES.length;
    private static final String[] ACCESS_NAMES = new String[]{"<default>", "private", "protected", "public"};
    private static final int[] ACCESS_VALUES = new int[]{0, 2, 4, 1};
    private static final int ACCESS_MASK = 7;
    private AccessLevelPanel accessLevelPanel;
    private ModifierPanel modifierPanel;
    private JPanel customEditor;

    public ModifierEditor(AccessLevelPanel accessLevelPanel, ModifierPanel modifierPanel) {
        this.accessLevelPanel = accessLevelPanel;
        this.modifierPanel = modifierPanel;
        accessLevelPanel.addPropertyChangeListener(this);
        modifierPanel.addPropertyChangeListener(this);
    }

    public AccessLevelPanel getAccessLevelPanel() {
        return this.accessLevelPanel;
    }

    public ModifierPanel getModifierPanel() {
        return this.modifierPanel;
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.accessLevelPanel.setAccessLevel(7 & (Integer)object);
        this.modifierPanel.setTypeModifier((Integer)object);
    }

    public String getJavaInitializationString() {
        return this.getValue().toString();
    }

    public Object getValue() {
        return new Integer(this.accessLevelPanel.getAccessLevel() | this.modifierPanel.getTypeModifier());
    }

    public String getAsText() {
        return Modifier.toString((Integer)this.getValue());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n = 0;
        int n2 = (Integer)this.getValue();
        int n3 = this.modifierPanel.getMask();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            boolean bl = false;
            int n4 = 0;
            while (n4 < MODIFIER_COUNT) {
                if ((MODIFIER_VALUES[n4] & n3) != 0 && string2.equals(MODIFIER_NAMES[n4])) {
                    if (MODIFIER_VALUES[n4] == 16 && (n & 0x400) != 0 || MODIFIER_VALUES[n4] == 1024 && (n & 0x10) != 0) break;
                    n |= MODIFIER_VALUES[n4];
                    bl = true;
                    break;
                }
                ++n4;
            }
            if ((n & 7) == 0) {
                int n5 = 1;
                while (n5 <= 3) {
                    if ((ACCESS_VALUES[n5] & n3) != 0 && string2.equals(ACCESS_NAMES[n5])) {
                        n |= ACCESS_VALUES[n5];
                        bl = true;
                        break;
                    }
                    ++n5;
                }
            }
            if (bl) continue;
            throw new IllegalArgumentException();
        }
        if (n2 != n) {
            this.setValue(new Integer(n));
            this.firePropertyChange();
        }
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.customEditor = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 11, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            this.customEditor.add((Component)this.accessLevelPanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.customEditor.add(this.modifierPanel.getComponent(), gridBagConstraints);
        }
        return this.customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getValue();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("typeModifier".equals(propertyChangeEvent.getPropertyName())) {
            this.firePropertyChange();
        } else if ("accessLevel".equals(propertyChangeEvent.getPropertyName())) {
            this.firePropertyChange();
        }
    }

    public static interface ModifierPanel {
        public static final String PROP_TYPE_MODIFIER = "typeModifier";

        public void setTypeModifier(int var1);

        public int getTypeModifier();

        public int getMask();

        public Component getComponent();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

