/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MacroDialogSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;

public class ActionFactory {
    static /* synthetic */ Class class$org$netbeans$editor$ActionFactory$RemoveSelectionAction;
    static /* synthetic */ Class class$org$netbeans$editor$ActionFactory$FormatAction;

    private ActionFactory() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class AnnotationsCyclingAction
    extends BaseAction {
        public AnnotationsCyclingAction() {
            super("annotations-cycling");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                    int n = Utilities.getLineOffset(baseDocument, caret.getDot());
                    AnnotationDesc annotationDesc = baseDocument.getAnnotations().activateNextAnnotation(n);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public static class ToggleLineNumbersAction
    extends BaseAction {
        static final long serialVersionUID = -3502499718130556526L;
        private JCheckBoxMenuItem item = null;

        public ToggleLineNumbersAction() {
            super("toggle-line-numbers");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.toggleLineNumbers();
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            if (this.item != null) {
                return this.item;
            }
            this.item = new JCheckBoxMenuItem(LocaleSupport.getString("line-numbers-menuitem"), this.isLineNumbersVisible());
            this.item.addItemListener(new ItemListener(this){
                private final /* synthetic */ ToggleLineNumbersAction this$0;
                {
                    this.this$0 = toggleLineNumbersAction;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    this.this$0.actionPerformed(null, null);
                }
            });
            return this.item;
        }

        protected boolean isLineNumbersVisible() {
            return false;
        }

        protected void toggleLineNumbers() {
        }
    }

    public static class GenerateGutterPopupAction
    extends BaseAction {
        static final long serialVersionUID = -3502499718130556525L;

        public GenerateGutterPopupAction() {
            super("generate-gutter-popup");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }

        public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            try {
                return editorUI.getDocument().getAnnotations().createMenu(Utilities.getKit(jTextComponent), Utilities.getLineOffset(editorUI.getDocument(), jTextComponent.getCaret().getDot()));
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    public static class InsertDateTimeAction
    extends BaseAction {
        static final long serialVersionUID = 2865619897402L;

        public InsertDateTimeAction() {
            super("insert-date-time", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                    Date date = new Date();
                    String string = simpleDateFormat.format(date);
                    baseDocument.insertString(caret.getDot(), string, null);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ScrollDownAction
    extends BaseAction {
        public ScrollDownAction() {
            super("scroll-down");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                Rectangle rectangle = editorUI.getExtentBounds();
                rectangle.y -= editorUI.getLineHeight();
                editorUI.scrollRectToVisible(rectangle, 2);
            }
        }
    }

    public static class ScrollUpAction
    extends BaseAction {
        public ScrollUpAction() {
            super("scroll-up");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                Rectangle rectangle = editorUI.getExtentBounds();
                rectangle.y += editorUI.getLineHeight();
                editorUI.scrollRectToVisible(rectangle, 2);
            }
        }
    }

    public static class JumpListPrevComponentAction
    extends BaseAction {
        static final long serialVersionUID = 2032230534727849525L;

        public JumpListPrevComponentAction() {
            super("jump-list-prev-component");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JumpList.jumpPrevComponent(jTextComponent);
            }
        }
    }

    public static class JumpListNextComponentAction
    extends BaseAction {
        static final long serialVersionUID = -2059070050865876892L;

        public JumpListNextComponentAction() {
            super("jump-list-next-component");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JumpList.jumpNextComponent(jTextComponent);
            }
        }
    }

    public static class JumpListPrevAction
    extends BaseAction {
        static final long serialVersionUID = 7174907031986424265L;

        public JumpListPrevAction() {
            super("jump-list-prev");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JumpList.jumpPrev(jTextComponent);
            }
        }
    }

    public static class JumpListNextAction
    extends BaseAction {
        static final long serialVersionUID = 6891721278404990446L;

        public JumpListNextAction() {
            super("jump-list-next");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JumpList.jumpNext(jTextComponent);
            }
        }
    }

    public static class SelectNextParameterAction
    extends BaseAction {
        static final long serialVersionUID = 8045372985336370934L;

        public SelectNextParameterAction() {
            super("select-next-parameter", 34);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = caret.getDot();
                int n2 = -1;
                try {
                    int n3;
                    if (n > 0 && baseDocument.getChars(n - 1, 1)[0] == ',') {
                        n2 = n;
                    }
                    if (n < baseDocument.getLength()) {
                        n3 = baseDocument.getChars(n, 1)[0];
                        if (n3 == 44) {
                            n2 = n + 1;
                        } else if (n3 == 41) {
                            caret.setDot(n + 1);
                        }
                    }
                    if (n2 >= 0 && (n3 = baseDocument.find(new FinderFactory.CharArrayFwdFinder(new char[]{',', ')'}), n2, -1)) >= 0) {
                        jTextComponent.select(n2, n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class SelectIdentifierAction
    extends BaseAction {
        static final long serialVersionUID = -7288216961333147873L;

        public SelectIdentifierAction() {
            super("select-identifier", 2);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    if (caret.isSelectionVisible()) {
                        caret.setSelectionVisible(false);
                    } else {
                        int[] nArray = Utilities.getIdentifierBlock((BaseDocument)jTextComponent.getDocument(), caret.getDot());
                        if (nArray != null) {
                            caret.setDot(nArray[0]);
                            caret.moveDot(nArray[1]);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class LastNonWhiteAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 4503533041729712917L;

        public LastNonWhiteAction(String string, boolean bl) {
            super(string, 30);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowLastNonWhite((BaseDocument)jTextComponent.getDocument(), caret.getDot());
                    if (n >= 0) {
                        if (this.select) {
                            caret.moveDot(n);
                        } else {
                            caret.setDot(n);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class FirstNonWhiteAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5888439539790901158L;

        public FirstNonWhiteAction(String string, boolean bl) {
            super(string, 30);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowFirstNonWhite((BaseDocument)jTextComponent.getDocument(), caret.getDot());
                    if (n >= 0) {
                        if (this.select) {
                            caret.moveDot(n);
                        } else {
                            caret.setDot(n);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class FormatAction
    extends BaseAction {
        static final long serialVersionUID = -7666172828961171865L;

        public FormatAction() {
            super("format", 14);
            this.putValue("helpID", (class$org$netbeans$editor$ActionFactory$FormatAction == null ? (class$org$netbeans$editor$ActionFactory$FormatAction = ActionFactory.class$("org.netbeans.editor.ActionFactory$FormatAction")) : class$org$netbeans$editor$ActionFactory$FormatAction).getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block14: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    GuardedDocument guardedDocument = baseDocument instanceof GuardedDocument ? (GuardedDocument)baseDocument : null;
                    baseDocument.atomicLock();
                    try {
                        block13: {
                            try {
                                Position position;
                                int n;
                                int n2 = Utilities.getLineOffset(baseDocument, caret.getDot());
                                if (caret.isSelectionVisible()) {
                                    n = jTextComponent.getSelectionStart();
                                    position = baseDocument.createPosition(jTextComponent.getSelectionEnd());
                                } else {
                                    n = 0;
                                    position = baseDocument.createPosition(baseDocument.getLength());
                                }
                                int n3 = n;
                                if (guardedDocument != null) {
                                    n3 = guardedDocument.getGuardedBlockChain().adjustToBlockEnd(n3);
                                }
                                while (n3 < position.getOffset()) {
                                    int n4 = position.getOffset();
                                    if (guardedDocument != null && (n4 = guardedDocument.getGuardedBlockChain().adjustToNextBlockStart(n3)) == -1) {
                                        n4 = position.getOffset();
                                    }
                                    int n5 = baseDocument.getFormatter().reformat(baseDocument, n3, n4);
                                    n3 += n5;
                                    if (guardedDocument == null) continue;
                                    n3 = guardedDocument.getGuardedBlockChain().adjustToBlockEnd(n3);
                                }
                                n3 = Utilities.getRowStartFromLineOffset(baseDocument, n2);
                                if (n3 < 0) break block13;
                                caret.setDot(n3);
                            }
                            catch (GuardedException guardedException) {
                                jTextComponent.getToolkit().beep();
                                Object var13_15 = null;
                                baseDocument.atomicUnlock();
                                break block14;
                            }
                            catch (BadLocationException badLocationException) {
                                if (System.getProperty("netbeans.debug.exceptions") != null) {
                                    badLocationException.printStackTrace();
                                }
                                Object var13_16 = null;
                                baseDocument.atomicUnlock();
                            }
                        }
                        Object var13_14 = null;
                        baseDocument.atomicUnlock();
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        baseDocument.atomicUnlock();
                        throw throwable;
                    }
                }
            }
        }
    }

    public static class AdjustCaretAction
    extends BaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 3223383913531191066L;

        public AdjustCaretAction(String string, int n) {
            super(string);
            this.percentFromWindowTop = n;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Utilities.getEditorUI(jTextComponent).adjustCaret(this.percentFromWindowTop);
            }
        }
    }

    public static class AdjustWindowAction
    extends BaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 8864278998999643292L;

        public AdjustWindowAction(String string, int n) {
            super(string);
            this.percentFromWindowTop = n;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Utilities.getEditorUI(jTextComponent).adjustWindow(this.percentFromWindowTop);
            }
        }
    }

    public static class ShiftLineAction
    extends BaseAction {
        boolean right;
        static final long serialVersionUID = -5124732597493699582L;

        public ShiftLineAction(String string, boolean bl) {
            super(string, 10);
            this.right = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                    if (caret.isSelectionVisible()) {
                        baseDocument.getFormatter().changeBlockIndent(baseDocument, jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd(), this.right ? 1 : -1);
                    } else {
                        baseDocument.getFormatter().shiftLine(baseDocument, caret.getDot(), this.right);
                    }
                }
                catch (GuardedException guardedException) {
                    jTextComponent.getToolkit().beep();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public static class WordMatchAction
    extends BaseAction {
        private boolean direction;
        static final long serialVersionUID = 595571114685133170L;

        public WordMatchAction(String string, boolean bl) {
            super(string, 14);
            this.direction = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (caret.isSelectionVisible()) {
                    jTextComponent.replaceSelection(null);
                }
                int n = caret.getDot();
                String string = editorUI.getWordMatch().getMatchWord(n, this.direction);
                String string2 = editorUI.getWordMatch().getPreviousWord();
                if (string != null) {
                    baseDocument.atomicLock();
                    try {
                        try {
                            int n2 = n;
                            if (string2 != null && string2.length() > 0) {
                                baseDocument.remove(n2 -= string2.length(), string2.length());
                            }
                            baseDocument.insertString(n2, string, null);
                        }
                        catch (BadLocationException badLocationException) {
                            jTextComponent.getToolkit().beep();
                            Object var11_12 = null;
                            baseDocument.atomicUnlock();
                        }
                        Object var11_11 = null;
                        baseDocument.atomicUnlock();
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        baseDocument.atomicUnlock();
                        throw throwable;
                    }
                }
            }
        }
    }

    public static class RedoAction
    extends BaseAction {
        static final long serialVersionUID = 6048125996333769202L;

        public RedoAction() {
            super("redo", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            Document document = jTextComponent.getDocument();
            UndoableEdit undoableEdit = (UndoableEdit)document.getProperty("undo-manager");
            if (jTextComponent != null && undoableEdit != null) {
                try {
                    undoableEdit.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class UndoAction
    extends BaseAction {
        static final long serialVersionUID = 8628586205035497612L;

        public UndoAction() {
            super("undo", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            Document document = jTextComponent.getDocument();
            UndoableEdit undoableEdit = (UndoableEdit)document.getProperty("undo-manager");
            if (jTextComponent != null && undoableEdit != null) {
                try {
                    undoableEdit.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleHighlightSearchAction
    extends BaseAction {
        static final long serialVersionUID = 4603809175771743200L;

        public ToggleHighlightSearchAction() {
            super("toggle-highlight-search", 32);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Boolean bl = (Boolean)FindSupport.getFindSupport().getFindProperty("find-highlight-search");
                bl = bl == null || bl == false ? Boolean.TRUE : Boolean.FALSE;
                FindSupport.getFindSupport().putFindProperty("find-highlight-search", bl);
            }
        }
    }

    public static class FindSelectionAction
    extends BaseAction {
        static final long serialVersionUID = -5601618936504699565L;

        public FindSelectionAction() {
            super("find-selection");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                FindSupport findSupport = FindSupport.getFindSupport();
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                HashMap<String, Object> hashMap = new HashMap<String, Object>(findSupport.getFindProperties());
                String string = null;
                if (caret.isSelectionVisible()) {
                    string = jTextComponent.getSelectedText();
                    hashMap.put("find-whole-words", Boolean.FALSE);
                } else {
                    try {
                        string = Utilities.getIdentifier((BaseDocument)jTextComponent.getDocument(), n);
                        hashMap.put("find-whole-words", Boolean.TRUE);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                if (string != null) {
                    int n2 = string.indexOf(10);
                    if (n2 >= 0) {
                        string = string.substring(0, n2);
                    }
                    hashMap.put("find-what", string);
                    findSupport.putFindProperties(hashMap);
                    findSupport.find(null, false);
                }
            }
        }
    }

    public static class FindPreviousAction
    extends BaseAction {
        static final long serialVersionUID = -43746947902694926L;

        public FindPreviousAction() {
            super("find-previous", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                FindSupport.getFindSupport().find(null, true);
            }
        }
    }

    public static class FindNextAction
    extends BaseAction {
        static final long serialVersionUID = 6878814427731642684L;

        public FindNextAction() {
            super("find-next", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                FindSupport.getFindSupport().find(null, false);
            }
        }
    }

    public static class ChangeCaseAction
    extends BaseAction {
        int changeCaseMode;
        static final long serialVersionUID = 5680212865619897402L;

        public ChangeCaseAction(String string, int n) {
            super(string, 30);
            this.changeCaseMode = n;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    if (caret.isSelectionVisible()) {
                        int n = jTextComponent.getSelectionStart();
                        int n2 = jTextComponent.getSelectionEnd();
                        Utilities.changeCase(baseDocument, n, n2 - n, this.changeCaseMode);
                        caret.setSelectionVisible(false);
                        caret.setDot(n2);
                    } else {
                        int n = caret.getDot();
                        Utilities.changeCase(baseDocument, n, 1, this.changeCaseMode);
                        caret.setDot(n + 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class AbbrevResetAction
    extends BaseAction {
        static final long serialVersionUID = -2807497346060448395L;

        public AbbrevResetAction() {
            super("abbrev-reset", 4);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }
    }

    public static class AbbrevExpandAction
    extends BaseAction {
        static final long serialVersionUID = -2124569510083544403L;

        public AbbrevExpandAction() {
            super("abbrev-expand", 26);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = ((BaseTextUI)jTextComponent.getUI()).getEditorUI();
                try {
                    editorUI.getAbbrev().checkAndExpand(actionEvent);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class StopMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StopMacroRecordingAction() {
            super("stop-macro-recording", 64);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                String string = this.stopRecording(jTextComponent);
                if (string == null) {
                    jTextComponent.getToolkit().beep();
                } else {
                    BaseKit baseKit = Utilities.getKit(jTextComponent);
                    MacroDialogSupport macroDialogSupport = new MacroDialogSupport(baseKit.getClass());
                    macroDialogSupport.setBody(string);
                    macroDialogSupport.showMacroDialog();
                }
            }
        }
    }

    public static class StartMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StartMacroRecordingAction() {
            super("start-macro-recording", 64);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && !this.startRecording(jTextComponent)) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class RunMacroAction
    extends BaseAction {
        static final long serialVersionUID = 1L;
        static HashSet runningActions = new HashSet();
        private String macroName;

        public RunMacroAction(String string) {
            super("macro-" + string);
            this.macroName = string;
        }

        protected void error(JTextComponent jTextComponent, String string) {
            Utilities.setStatusText(jTextComponent, LocaleSupport.getString(string, "Error in macro: " + string));
            Toolkit.getDefaultToolkit().beep();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent var1_1, JTextComponent var2_2) {
            block20: {
                block19: {
                    block24: {
                        block23: {
                            block22: {
                                if (!RunMacroAction.runningActions.add(this.macroName)) {
                                    this.error(var2_2, "loop");
                                    return;
                                }
                                if (var2_2 == null) {
                                    return;
                                }
                                var3_3 = Utilities.getKit(var2_2);
                                if (var3_3 == null) {
                                    return;
                                }
                                var4_4 = (Map)Settings.getValue(var3_3.getClass(), "macro-map");
                                var5_5 = (String)var4_4.get(this.macroName);
                                if (var5_5 == null) {
                                    this.error(var2_2, "macro-not-found");
                                    RunMacroAction.runningActions.remove(this.macroName);
                                    return;
                                }
                                var6_6 = new StringBuffer();
                                var7_7 = var5_5.toCharArray();
                                var8_8 = var7_7.length;
                                var9_9 = (BaseDocument)var2_2.getDocument();
                                try {
                                    var9_9.atomicLock();
                                    var10_10 = 0;
lbl23:
                                    // 2 sources

                                    while (true) {
                                        if (var10_10 >= var8_8) {
                                            break block19;
                                        }
                                        if (Character.isWhitespace(var7_7[var10_10])) break block20;
                                        if (var7_7[var10_10] != '\"') {
                                            block21: {
                                                var6_6.setLength(0);
                                                while (true) {
                                                    if (var10_10 >= var8_8 || Character.isWhitespace(var7_7[var10_10])) {
                                                        var11_13 = var3_3.getActionByName(var6_6.toString());
                                                        if (var11_13 == null) break block21;
                                                        var12_14 = new ActionEvent(var2_2, 0, "");
                                                        if (!(var11_13 instanceof BaseAction)) break;
                                                        ((BaseAction)var11_13).updateComponent(var2_2);
                                                        ((BaseAction)var11_13).actionPerformed((ActionEvent)var12_14, var2_2);
                                                        break block20;
                                                    }
                                                    if ((var11_12 = var7_7[var10_10++]) == '\\') {
                                                        if (var10_10 >= var8_8) {
                                                            this.error(var2_2, "macro-malformed");
                                                            break block22;
                                                        }
                                                        if ((var11_12 = var7_7[var10_10++]) != '\\' && !Character.isWhitespace(var11_12)) {
                                                            this.error(var2_2, "macro-malformed");
                                                            break block23;
                                                        }
                                                    }
                                                    var6_6.append(var11_12);
                                                }
                                                var11_13.actionPerformed((ActionEvent)var12_14);
                                                break block20;
                                            }
                                            this.error(var2_2, "macro-unknown-action");
                                            break block24;
                                        }
                                        ** GOTO lbl115
                                        break;
                                    }
                                }
                                catch (Throwable var14_23) {
                                    var15_22 = null;
                                    var9_9.atomicUnlock();
                                    RunMacroAction.runningActions.remove(this.macroName);
                                    throw var14_23;
                                }
                            }
                            var15_18 = null;
                            var9_9.atomicUnlock();
                            RunMacroAction.runningActions.remove(this.macroName);
                            return;
                        }
                        var15_19 = null;
                        var9_9.atomicUnlock();
                        RunMacroAction.runningActions.remove(this.macroName);
                        return;
                    }
                    var15_20 = null;
                    var9_9.atomicUnlock();
                    RunMacroAction.runningActions.remove(this.macroName);
                    return;
                }
                var15_21 = null;
                var9_9.atomicUnlock();
                RunMacroAction.runningActions.remove(this.macroName);
                return;
lbl-1000:
                // 1 sources

                {
                    var11_11 = var7_7[var10_10];
                    if (var11_11 == '\\') {
                        if (++var10_10 >= var8_8) {
                            this.error(var2_2, "macro-malformed");
                            var15_16 = null;
                            var9_9.atomicUnlock();
                            RunMacroAction.runningActions.remove(this.macroName);
                            return;
                        }
                        var11_11 = var7_7[var10_10];
                        if (var11_11 != '\"' && var11_11 != '\\') {
                            this.error(var2_2, "macro-malformed");
                            var15_17 = null;
                            var9_9.atomicUnlock();
                            RunMacroAction.runningActions.remove(this.macroName);
                            return;
                        }
                    }
                    if ((var12_14 = var2_2.getKeymap().getDefaultAction()) == null) continue;
                    var13_15 = new ActionEvent(var2_2, 0, new String(new char[]{var11_11}));
                    if (var12_14 instanceof BaseAction) {
                        ((BaseAction)var12_14).updateComponent(var2_2);
                        ((BaseAction)var12_14).actionPerformed(var13_15, var2_2);
                        continue;
                    }
                    var12_14.actionPerformed(var13_15);
lbl115:
                    // 4 sources

                    ** while (++var10_10 < var8_8 && var7_7[var10_10] != '\"')
                }
            }
            ++var10_10;
            ** while (true)
        }
    }

    public static class GotoNextBookmarkAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5169554640178645108L;

        public GotoNextBookmarkAction(String string, boolean bl) {
            super("bookmark-next", 30);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = baseDocument.getNextBookmark(caret.getDot(), true);
                    if (n >= 0) {
                        if (this.select) {
                            caret.moveDot(n);
                        } else {
                            caret.setDot(n);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleBookmarkAction
    extends BaseAction {
        static final long serialVersionUID = -8438899482709646741L;

        public ToggleBookmarkAction() {
            super("bookmark-toggle");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    baseDocument.toggleBookmark(caret.getDot());
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleTypingModeAction
    extends BaseAction {
        static final long serialVersionUID = -2431132686507799723L;

        public ToggleTypingModeAction() {
            super("toggle-typing-mode");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                Boolean bl = (Boolean)editorUI.getProperty("overwriteMode");
                bl = bl == null || bl == false ? Boolean.TRUE : Boolean.FALSE;
                editorUI.putProperty("overwriteMode", bl);
            }
        }
    }

    public static class RemoveSelectionAction
    extends BaseAction {
        static final long serialVersionUID = -1419424594746686573L;

        public RemoveSelectionAction() {
            super("remove-selection", 30);
            this.putValue("helpID", (class$org$netbeans$editor$ActionFactory$RemoveSelectionAction == null ? (class$org$netbeans$editor$ActionFactory$RemoveSelectionAction = ActionFactory.class$("org.netbeans.editor.ActionFactory$RemoveSelectionAction")) : class$org$netbeans$editor$ActionFactory$RemoveSelectionAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection(null);
            }
        }
    }

    public static class RemoveLineAction
    extends BaseAction {
        static final long serialVersionUID = -536315497241419877L;

        public RemoveLineAction() {
            super("remove-line", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(jTextComponent, n);
                    int n3 = Utilities.getRowEnd(jTextComponent, n);
                    n3 = Math.min(n3 + 1, baseDocument.getLength());
                    baseDocument.remove(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveLineBeginAction
    extends BaseAction {
        static final long serialVersionUID = 9193117196412195554L;

        public RemoveLineBeginAction() {
            super("remove-line-begin", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(baseDocument, n);
                    if (n == n2) {
                        if (n > 0) {
                            baseDocument.remove(n - 1, 1);
                        }
                    } else {
                        char[] cArray = baseDocument.getChars(n2, n - n2);
                        if (Analyzer.isWhitespace(cArray, 0, cArray.length)) {
                            baseDocument.remove(n2, n - n2);
                        } else {
                            int n3 = Utilities.getRowFirstNonWhite(baseDocument, n2);
                            if (n3 >= 0 && n3 < n) {
                                baseDocument.remove(n3, n - n3);
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveWordAction
    extends BaseAction {
        static final long serialVersionUID = 9193117196412195554L;

        public RemoveWordAction() {
            super("remove-word", 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                try {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(baseDocument, n);
                    int n3 = Utilities.getPreviousWord(jTextComponent, n);
                    n3 = n == n2 ? n3 : Math.max(n2, n3);
                    baseDocument.remove(n3, n - n3);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveTabAction
    extends BaseAction {
        static final long serialVersionUID = -1537748600593395706L;

        public RemoveTabAction() {
            super("remove-tab", 22);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                if (caret.isSelectionVisible()) {
                    try {
                        baseDocument.getFormatter().changeBlockIndent(baseDocument, jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd(), -1);
                    }
                    catch (GuardedException guardedException) {
                        jTextComponent.getToolkit().beep();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    try {
                        int n = Utilities.getRowStart(baseDocument, caret.getDot());
                        int n2 = Utilities.getRowFirstNonWhite(baseDocument, caret.getDot());
                        int n3 = Utilities.getRowEnd(baseDocument, caret.getDot());
                        if (n2 == -1 || n2 >= caret.getDot()) {
                            baseDocument.getFormatter().changeBlockIndent(baseDocument, n, n3, -1);
                        }
                    }
                    catch (GuardedException guardedException) {
                        jTextComponent.getToolkit().beep();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            }
        }
    }
}

