/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.Utilities;

public abstract class BaseAction
extends TextAction {
    public static final String POPUP_MENU_TEXT = "PopupMenuText";
    public static final String LOCALE_DESC_PREFIX = "desc-";
    public static final String LOCALE_POPUP_PREFIX = "popup-";
    public static final int SELECTION_REMOVE = 1;
    public static final int MAGIC_POSITION_RESET = 2;
    public static final int ABBREV_RESET = 4;
    public static final int UNDO_MERGE_RESET = 8;
    public static final int WORD_MATCH_RESET = 16;
    public static final int CLEAR_STATUS_TEXT = 32;
    public static final int NO_RECORDING = 64;
    public static final int SAVE_POSITION = 128;
    protected int updateMask;
    private static boolean recording;
    private static StringBuffer macroBuffer;
    private static StringBuffer textBuffer;
    static final long serialVersionUID = -4255521122272110786L;

    public BaseAction(String string) {
        this(string, 0);
    }

    public BaseAction(String string, int n) {
        super(string);
        this.updateMask = n;
        String string2 = LOCALE_DESC_PREFIX + string;
        String string3 = LocaleSupport.getString(string2);
        if (string3 == null) {
            string3 = LocaleSupport.getString(string, string);
        }
        this.putValue("ShortDescription", string3);
        string2 = LOCALE_POPUP_PREFIX + string;
        String string4 = LocaleSupport.getString(string2, string3);
        this.putValue(POPUP_MENU_TEXT, string4);
    }

    protected void settingsChange(SettingsChangeEvent settingsChangeEvent, Class clazz) {
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        if (recording && 0 == (this.updateMask & 0x40)) {
            this.recordAction(jTextComponent, actionEvent);
        }
        this.updateComponent(jTextComponent);
        this.actionPerformed(actionEvent, jTextComponent);
    }

    private void recordAction(JTextComponent jTextComponent, ActionEvent actionEvent) {
        if (this == jTextComponent.getKeymap().getDefaultAction()) {
            textBuffer.append(this.getFilteredActionCommand(actionEvent.getActionCommand()));
        } else {
            if (textBuffer.length() > 0) {
                if (macroBuffer.length() > 0) {
                    macroBuffer.append(' ');
                }
                macroBuffer.append(this.encodeText(textBuffer.toString()));
                textBuffer.setLength(0);
            }
            if (macroBuffer.length() > 0) {
                macroBuffer.append(' ');
            }
            String string = (String)this.getValue("Name");
            macroBuffer.append(this.encodeActionName(string));
        }
    }

    private String getFilteredActionCommand(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char c = string.charAt(0);
        if (c >= ' ' && c != '\u007f') {
            return string;
        }
        return "";
    }

    boolean startRecording(JTextComponent jTextComponent) {
        if (recording) {
            return false;
        }
        recording = true;
        macroBuffer.setLength(0);
        textBuffer.setLength(0);
        Utilities.setStatusText(jTextComponent, LocaleSupport.getString("macro-recording"));
        return true;
    }

    String stopRecording(JTextComponent jTextComponent) {
        if (!recording) {
            return null;
        }
        if (textBuffer.length() > 0) {
            if (macroBuffer.length() > 0) {
                macroBuffer.append(' ');
            }
            macroBuffer.append(this.encodeText(textBuffer.toString()));
        }
        String string = macroBuffer.toString();
        recording = false;
        Utilities.setStatusText(jTextComponent, "");
        return string;
    }

    private String encodeText(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer("\"");
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == '\"' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.append('\"').toString();
    }

    private String encodeActionName(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (Character.isWhitespace(c) || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public abstract void actionPerformed(ActionEvent var1, JTextComponent var2);

    public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
        return null;
    }

    public String getPopupMenuText(JTextComponent jTextComponent) {
        String string = (String)this.getValue(POPUP_MENU_TEXT);
        if (string == null) {
            string = (String)this.getValue("Name");
        }
        return string;
    }

    public void updateComponent(JTextComponent jTextComponent) {
        this.updateComponent(jTextComponent, this.updateMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComponent(JTextComponent jTextComponent, int n) {
        if (jTextComponent != null && jTextComponent.getDocument() instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            boolean bl = false;
            try {
                block16: {
                    if ((n & 1) != 0) {
                        bl = true;
                        baseDocument.extWriteLock();
                        Caret caret = jTextComponent.getCaret();
                        if (caret != null && caret.isSelectionVisible()) {
                            int n2;
                            int n3 = caret.getDot();
                            if (n3 < (n2 = caret.getMark())) {
                                int n4 = n3;
                                n3 = n2;
                                n2 = n4;
                            }
                            try {
                                jTextComponent.getDocument().remove(n2, n3 - n2);
                            }
                            catch (BadLocationException badLocationException) {
                                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block16;
                                badLocationException.printStackTrace();
                            }
                        }
                    }
                }
                if ((n & 2) != 0 && jTextComponent.getCaret() != null) {
                    jTextComponent.getCaret().setMagicCaretPosition(null);
                }
                if ((n & 4) != 0) {
                    ((BaseTextUI)jTextComponent.getUI()).getEditorUI().getAbbrev().reset();
                }
                if ((n & 8) != 0) {
                    baseDocument.resetUndoMerge();
                }
                if ((n & 0x10) != 0) {
                    ((BaseTextUI)jTextComponent.getUI()).getEditorUI().getWordMatch().clear();
                }
                if ((n & 0x20) != 0) {
                    Utilities.clearStatusText(jTextComponent);
                }
                if ((n & 0x80) != 0) {
                    JumpList.checkAddEntry(jTextComponent);
                }
                Object var10_10 = null;
                if (bl) {
                    baseDocument.extWriteUnlock();
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (bl) {
                    baseDocument.extWriteUnlock();
                }
                throw throwable;
            }
        }
    }

    static {
        macroBuffer = new StringBuffer();
        textBuffer = new StringBuffer();
    }
}

