/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;

public class BaseKit
extends DefaultEditorKit {
    public static final String annotationsCyclingAction = "annotations-cycling";
    public static final String selectionPageUpAction = "selection-page-up";
    public static final String selectionPageDownAction = "selection-page-down";
    public static final String removeTabAction = "remove-tab";
    public static final String removeSelectionAction = "remove-selection";
    public static final String toggleBookmarkAction = "bookmark-toggle";
    public static final String gotoNextBookmarkAction = "bookmark-next";
    public static final String abbrevExpandAction = "abbrev-expand";
    public static final String abbrevResetAction = "abbrev-reset";
    public static final String removeWordAction = "remove-word";
    public static final String removeLineBeginAction = "remove-line-begin";
    public static final String removeLineAction = "remove-line";
    public static final String toggleTypingModeAction = "toggle-typing-mode";
    public static final String toUpperCaseAction = "to-upper-case";
    public static final String toLowerCaseAction = "to-lower-case";
    public static final String switchCaseAction = "switch-case";
    public static final String findNextAction = "find-next";
    public static final String findPreviousAction = "find-previous";
    public static final String toggleHighlightSearchAction = "toggle-highlight-search";
    public static final String findSelectionAction = "find-selection";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String wordMatchNextAction = "word-match-next";
    public static final String wordMatchPrevAction = "word-match-prev";
    public static final String shiftLineRightAction = "shift-line-right";
    public static final String shiftLineLeftAction = "shift-line-left";
    public static final String adjustWindowCenterAction = "adjust-window-center";
    public static final String adjustWindowTopAction = "adjust-window-top";
    public static final String adjustWindowBottomAction = "adjust-window-bottom";
    public static final String adjustCaretCenterAction = "adjust-caret-center";
    public static final String adjustCaretTopAction = "adjust-caret-top";
    public static final String adjustCaretBottomAction = "adjust-caret-bottom";
    public static final String formatAction = "format";
    public static final String firstNonWhiteAction = "first-non-white";
    public static final String lastNonWhiteAction = "last-non-white";
    public static final String selectionFirstNonWhiteAction = "selection-first-non-white";
    public static final String selectionLastNonWhiteAction = "selection-last-non-white";
    public static final String selectIdentifierAction = "select-identifier";
    public static final String selectNextParameterAction = "select-next-parameter";
    public static final String jumpListNextAction = "jump-list-next";
    public static final String jumpListPrevAction = "jump-list-prev";
    public static final String jumpListNextComponentAction = "jump-list-next-component";
    public static final String jumpListPrevComponentAction = "jump-list-prev-component";
    public static final String scrollUpAction = "scroll-up";
    public static final String scrollDownAction = "scroll-down";
    public static final String macroActionPrefix = "macro-";
    public static final String startMacroRecordingAction = "start-macro-recording";
    public static final String stopMacroRecordingAction = "stop-macro-recording";
    public static final String lineFirstColumnAction = "caret-line-first-column";
    public static final String insertDateTimeAction = "insert-date-time";
    public static final String selectionLineFirstColumnAction = "selection-line-first-column";
    public static final String generateGutterPopupAction = "generate-gutter-popup";
    public static final String toggleLineNumbersAction = "toggle-line-numbers";
    private static final int KIT_CNT_PREALLOC = 57;
    static final long serialVersionUID = -8570495408376659348L;
    static Map kits = new HashMap(57);
    static Map kitKeymaps = new HashMap(57);
    static Map kitActions = new HashMap(57);
    static Map kitActionMaps = new HashMap(57);
    static SettingsChangeListener settingsListener = new SettingsChangeListener(){

        public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
            boolean bl;
            String string = settingsChangeEvent != null ? settingsChangeEvent.getSettingName() : null;
            boolean bl2 = bl = string == null || "custom-action-list".equals(string) || "macro-map".equals(string);
            if (bl || "key-bindings".equals(string)) {
                kitKeymaps.clear();
            }
            if (bl) {
                kitActions.clear();
                kitActionMaps.clear();
            } else {
                Iterator iterator = kitActions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    BaseKit.updateActionSettings((Action[])entry.getValue(), settingsChangeEvent, (Class)entry.getKey());
                }
            }
        }
    };
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;
    static /* synthetic */ Class class$org$netbeans$editor$Settings;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit$CutAction;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit$CopyAction;
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit$PasteAction;

    private static void updateActionSettings(Action[] actionArray, SettingsChangeEvent settingsChangeEvent, Class clazz) {
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n] instanceof BaseAction) {
                ((BaseAction)actionArray[n]).settingsChange(settingsChangeEvent, clazz);
            }
            ++n;
        }
    }

    public static synchronized BaseKit getKit(Class clazz) {
        BaseKit baseKit;
        if (clazz == null) {
            Class clazz2 = clazz = class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        }
        if ((baseKit = (BaseKit)kits.get(clazz)) == null) {
            block6: {
                try {
                    baseKit = (BaseKit)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        illegalAccessException.printStackTrace();
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block6;
                    instantiationException.printStackTrace();
                }
            }
            kits.put(clazz, baseKit);
        }
        return baseKit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseKit() {
        Class clazz = class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseKit.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit;
        synchronized (clazz) {
            if (kits.get(this.getClass()) == null) {
                kits.put(this.getClass(), this);
            }
        }
    }

    public Object clone() {
        return this;
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public Caret createCaret() {
        return new BaseCaret();
    }

    public Document createDefaultDocument() {
        return new BaseDocument(this.getClass(), true);
    }

    public Syntax createSyntax(Document document) {
        return new Syntax();
    }

    public Syntax createFormatSyntax(Document document) {
        return this.createSyntax(document);
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new SyntaxSupport(baseDocument);
    }

    public Formatter createFormatter() {
        return new Formatter(this.getClass());
    }

    protected BaseTextUI createTextUI() {
        return new BaseTextUI();
    }

    protected EditorUI createEditorUI() {
        return new EditorUI();
    }

    protected EditorUI createPrintEditorUI(BaseDocument baseDocument) {
        return new EditorUI(baseDocument);
    }

    public Class getFocusableComponentClass(JTextComponent jTextComponent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiKeymap getKeymap() {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = BaseKit.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            Settings.KitAndValue[] kitAndValueArray;
            Settings.KitAndValue[] kitAndValueArray2 = (Settings.KitAndValue[])kitKeymaps.get(this.getClass());
            if (kitAndValueArray2 == null) {
                kitAndValueArray2 = new MultiKeymap("Keymap for " + this.getClass());
                kitAndValueArray = Settings.getValueHierarchy(this.getClass(), "key-bindings");
                int n = kitAndValueArray.length - 1;
                while (n >= 0) {
                    List list = (List)kitAndValueArray[n].value;
                    JTextComponent.KeyBinding[] keyBindingArray = new JTextComponent.KeyBinding[list.size()];
                    list.toArray(keyBindingArray);
                    kitAndValueArray2.load(keyBindingArray, this.getActionMap());
                    --n;
                }
                kitKeymaps.put(this.getClass(), kitAndValueArray2);
            }
            kitAndValueArray = kitAndValueArray2;
            return kitAndValueArray;
        }
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).read(reader, n);
        } else {
            super.read(reader, document, n);
        }
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).write(writer, n, n2);
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public static Map actionsToMap(Action[] actionArray) {
        HashMap<String, Action> hashMap = new HashMap<String, Action>();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            String string = (String)action.getValue("Name");
            hashMap.put(string != null ? string : "", action);
            ++n;
        }
        return hashMap;
    }

    public static Action[] mapToActions(Map map) {
        Action[] actionArray = new Action[map.size()];
        int n = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            actionArray[n++] = (Action)iterator.next();
        }
        return actionArray;
    }

    public void install(JEditorPane jEditorPane) {
        BaseTextUI baseTextUI = this.createTextUI();
        jEditorPane.setUI(baseTextUI);
        String string = "netbeans.editor.noinputmethods";
        String string2 = System.getProperty(string);
        boolean bl = string2 != null ? !Boolean.getBoolean(string) : SettingsUtil.getBoolean(this.getClass(), "input-methods-enabled", true);
        jEditorPane.enableInputMethods(bl);
        this.executeInstallActions(jEditorPane);
    }

    protected void executeInstallActions(JEditorPane jEditorPane) {
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.getClass(), "kit-install-action-name-list");
        int n = kitAndValueArray.length - 1;
        while (n >= 0) {
            List list = (List)kitAndValueArray[n].value;
            if ((list = this.translateActionNameList(list)) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Action action = (Action)iterator.next();
                    action.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
                }
            }
            --n;
        }
    }

    public void deinstall(JEditorPane jEditorPane) {
        this.executeDeinstallActions(jEditorPane);
        jEditorPane.setUI(null);
    }

    protected void executeDeinstallActions(JEditorPane jEditorPane) {
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.getClass(), "kit-deinstall-action-name-list");
        int n = kitAndValueArray.length - 1;
        while (n >= 0) {
            List list = (List)kitAndValueArray[n].value;
            if ((list = this.translateActionNameList(list)) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Action action = (Action)iterator.next();
                    action.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
                }
            }
            --n;
        }
    }

    protected void initDocument(BaseDocument baseDocument) {
    }

    protected Action[] createActions() {
        return new Action[]{new DefaultKeyTypedAction(), new InsertContentAction(), new InsertBreakAction(), new InsertTabAction(), new DeleteCharAction("delete-previous", false), new DeleteCharAction("delete-next", true), new ReadOnlyAction(), new WritableAction(), new CutAction(), new CopyAction(), new PasteAction(), new BeepAction(), new UpAction("caret-up", false), new UpAction("selection-up", true), new PageUpAction("page-up", false), new PageUpAction(selectionPageUpAction, true), new DownAction("caret-down", false), new DownAction("selection-down", true), new PageDownAction(selectionPageDownAction, true), new PageDownAction("page-down", false), new ForwardAction("caret-forward", false), new ForwardAction("selection-forward", true), new BackwardAction("caret-backward", false), new BackwardAction("selection-backward", true), new BeginLineAction(lineFirstColumnAction, false, true), new BeginLineAction(selectionLineFirstColumnAction, true, true), new BeginLineAction("caret-begin-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("caret-end-line", false), new EndLineAction("selection-end-line", true), new BeginAction("caret-begin", false), new BeginAction("selection-begin", true), new EndAction("caret-end", false), new EndAction("selection-end", true), new NextWordAction("caret-next-word", false), new NextWordAction("selection-next-word", true), new PreviousWordAction("caret-previous-word", false), new PreviousWordAction("selection-previous-word", true), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("caret-end-word", false), new EndWordAction("selection-end-word", true), new SelectWordAction(), new SelectLineAction(), new SelectAllAction(), new ActionFactory.RemoveTabAction(), new ActionFactory.RemoveWordAction(), new ActionFactory.RemoveLineBeginAction(), new ActionFactory.RemoveLineAction(), new ActionFactory.RemoveSelectionAction(), new ActionFactory.ToggleTypingModeAction(), new ActionFactory.ToggleBookmarkAction(), new ActionFactory.GotoNextBookmarkAction(gotoNextBookmarkAction, false), new ActionFactory.AbbrevExpandAction(), new ActionFactory.AbbrevResetAction(), new ActionFactory.ChangeCaseAction(toUpperCaseAction, 0), new ActionFactory.ChangeCaseAction(toLowerCaseAction, 1), new ActionFactory.ChangeCaseAction(switchCaseAction, 2), new ActionFactory.FindNextAction(), new ActionFactory.FindPreviousAction(), new ActionFactory.FindSelectionAction(), new ActionFactory.ToggleHighlightSearchAction(), new ActionFactory.UndoAction(), new ActionFactory.RedoAction(), new ActionFactory.WordMatchAction(wordMatchNextAction, true), new ActionFactory.WordMatchAction(wordMatchPrevAction, false), new ActionFactory.ShiftLineAction(shiftLineLeftAction, false), new ActionFactory.ShiftLineAction(shiftLineRightAction, true), new ActionFactory.AdjustWindowAction(adjustWindowTopAction, 0), new ActionFactory.AdjustWindowAction(adjustWindowCenterAction, 50), new ActionFactory.AdjustWindowAction(adjustWindowBottomAction, 100), new ActionFactory.AdjustCaretAction(adjustCaretTopAction, 0), new ActionFactory.AdjustCaretAction(adjustCaretCenterAction, 50), new ActionFactory.AdjustCaretAction(adjustCaretBottomAction, 100), new ActionFactory.FormatAction(), new ActionFactory.FirstNonWhiteAction(firstNonWhiteAction, false), new ActionFactory.FirstNonWhiteAction(selectionFirstNonWhiteAction, true), new ActionFactory.LastNonWhiteAction(lastNonWhiteAction, false), new ActionFactory.LastNonWhiteAction(selectionLastNonWhiteAction, true), new ActionFactory.SelectIdentifierAction(), new ActionFactory.SelectNextParameterAction(), new ActionFactory.JumpListPrevAction(), new ActionFactory.JumpListNextAction(), new ActionFactory.JumpListPrevComponentAction(), new ActionFactory.JumpListNextComponentAction(), new ActionFactory.ScrollUpAction(), new ActionFactory.ScrollDownAction(), new ActionFactory.StartMacroRecordingAction(), new ActionFactory.StopMacroRecordingAction(), new ActionFactory.InsertDateTimeAction(), new ActionFactory.GenerateGutterPopupAction(), new ActionFactory.ToggleLineNumbersAction(), new ActionFactory.AnnotationsCyclingAction()};
    }

    protected Action[] getCustomActions() {
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.getClass(), "custom-action-list");
        if (kitAndValueArray.length == 0) {
            return null;
        }
        if (kitAndValueArray.length == 1) {
            List list = (List)kitAndValueArray[0].value;
            return list.toArray(new Action[list.size()]);
        }
        ArrayList arrayList = new ArrayList();
        int n = kitAndValueArray.length - 1;
        while (n >= 0) {
            arrayList.addAll((List)kitAndValueArray[n].value);
            --n;
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    protected Action[] getMacroActions() {
        Class<?> clazz = this.getClass();
        Map map = (Map)Settings.getValue(clazz, "macro-map");
        if (map == null) {
            return null;
        }
        ArrayList<ActionFactory.RunMacroAction> arrayList = new ArrayList<ActionFactory.RunMacroAction>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(new ActionFactory.RunMacroAction(string));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Action[] getActions() {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = BaseKit.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            Action[] actionArray;
            Class<?> clazz2 = this.getClass();
            Action[] actionArray2 = (Action[])kitActions.get(clazz2);
            if (actionArray2 == null) {
                Action[] actionArray3;
                actionArray = this.createActions();
                BaseKit.updateActionSettings(actionArray, null, clazz2);
                Map map = BaseKit.actionsToMap(actionArray);
                Action[] actionArray4 = this.getCustomActions();
                if (actionArray4 != null) {
                    BaseKit.updateActionSettings(actionArray4, null, clazz2);
                    map.putAll(BaseKit.actionsToMap(actionArray4));
                }
                if ((actionArray3 = this.getMacroActions()) != null) {
                    BaseKit.updateActionSettings(actionArray3, null, clazz2);
                    map.putAll(BaseKit.actionsToMap(actionArray3));
                }
                kitActionMaps.put(clazz2, map);
                actionArray2 = BaseKit.mapToActions(map);
                kitActions.put(clazz2, actionArray2);
                this.updateActions();
            }
            actionArray = actionArray2;
            return actionArray;
        }
    }

    Map getActionMap() {
        Map map = (Map)kitActionMaps.get(this.getClass());
        if (map == null) {
            this.getActions();
            map = (Map)kitActionMaps.get(this.getClass());
        }
        return map;
    }

    protected void updateActions() {
    }

    public Action getActionByName(String string) {
        return string != null ? (Action)this.getActionMap().get(string) : null;
    }

    public List translateActionNameList(List list) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Action action = this.getActionByName((String)iterator.next());
                if (action == null) continue;
                arrayList.add(action);
            }
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Settings.addSettingsChangeListener(settingsListener);
    }

    public static class SelectAllAction
    extends KitCompoundAction {
        static final long serialVersionUID = -3502499718130556524L;

        public SelectAllAction() {
            super("select-all", new String[]{"caret-begin", "selection-end"});
        }
    }

    public static class SelectLineAction
    extends KitCompoundAction {
        static final long serialVersionUID = -7407681863035740281L;

        public SelectLineAction() {
            super("select-line", new String[]{BaseKit.lineFirstColumnAction, "selection-end-line", "selection-forward"});
        }
    }

    public static class SelectWordAction
    extends KitCompoundAction {
        static final long serialVersionUID = 7678848538073016357L;

        public SelectWordAction() {
            super("select-word", new String[]{"caret-begin-word", "selection-end-word"});
        }
    }

    public static class EndWordAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 3812523676620144633L;

        public EndWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getWordEnd(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginWordAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 3991338381212491110L;

        public BeginWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getWordStart(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class PreviousWordAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5465143382669785799L;

        public PreviousWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getPreviousWord(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class NextWordAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5909906947175434032L;

        public NextWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = caret.getDot();
                    n = Utilities.getNextWord(jTextComponent, n);
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class EndAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 8547506353130203657L;

        public EndAction(String string, boolean bl) {
            super(string, 190);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                int n = jTextComponent.getDocument().getLength();
                if (this.select) {
                    caret.moveDot(n);
                } else {
                    caret.setDot(n);
                }
            }
        }
    }

    public static class BeginAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 3463563396210234361L;

        public BeginAction(String string, boolean bl) {
            super(string, 190);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                int n = 0;
                if (this.select) {
                    caret.moveDot(n);
                } else {
                    caret.setDot(n);
                }
            }
        }
    }

    public static class EndLineAction
    extends BaseAction {
        protected boolean select;
        static final long serialVersionUID = 5216077634055190170L;

        public EndLineAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowEnd(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    Rectangle rectangle = jTextComponent.modelToView(n);
                    Point point = new Point(0x3FFFFFFF, rectangle.y);
                    caret.setMagicCaretPosition(point);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginLineAction
    extends BaseAction {
        protected boolean select;
        boolean homeKeyColumnOne;
        static final long serialVersionUID = 3269462923524077779L;

        public BeginLineAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
            this.homeKeyColumnOne = false;
        }

        public BeginLineAction(String string, boolean bl, boolean bl2) {
            this(string, bl);
            this.homeKeyColumnOne = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                try {
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(baseDocument, n, 0);
                    if (this.homeKeyColumnOne) {
                        n = n2;
                    } else {
                        int n3 = Utilities.getRowFirstNonWhite(baseDocument, n2);
                        if (n3 < 0) {
                            n3 = Utilities.getRowEnd(baseDocument, n2);
                        }
                        n = n == n2 ? n3 : (n <= n3 ? n2 : n3);
                    }
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BackwardAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -3048379822817847356L;

        public BackwardAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n;
                    if (!this.select && caret.isSelectionVisible()) {
                        n = jTextComponent.getSelectionStart();
                        if (n != caret.getDot()) {
                            ++n;
                        }
                    } else {
                        n = caret.getDot();
                    }
                    int n2 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, null, 7, null);
                    if (this.select) {
                        caret.moveDot(n2);
                    } else if (caret instanceof BaseCaret) {
                        BaseCaret baseCaret = (BaseCaret)caret;
                        baseCaret.setDot(n2, baseCaret, 1);
                    } else {
                        caret.setDot(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class PageDownAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 8942534850985048862L;

        public PageDownAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    Rectangle rectangle = ((BaseTextUI)jTextComponent.getUI()).modelToView(jTextComponent, n);
                    Point point = caret.getMagicCaretPosition();
                    if (point == null) {
                        point = new Point(rectangle.x, rectangle.y);
                        caret.setMagicCaretPosition(point);
                    } else {
                        point.y = rectangle.y;
                    }
                    EditorUI editorUI = ((BaseTextUI)jTextComponent.getUI()).getEditorUI();
                    Rectangle rectangle2 = editorUI.getExtentBounds();
                    int n2 = Math.max(rectangle.height, 1);
                    int n3 = rectangle2.y / n2 * n2;
                    int n4 = rectangle2.height / n2;
                    int n5 = n4 * n2;
                    rectangle.y = Math.max(n3 + n5, 0);
                    rectangle.height = rectangle2.height;
                    point.y = Math.max(point.y + n5, 0);
                    int n6 = jTextComponent.viewToModel(point);
                    editorUI.scrollRectToVisible(rectangle, 0);
                    if (this.select) {
                        caret.moveDot(n6);
                    } else if (caret instanceof BaseCaret) {
                        BaseCaret baseCaret = (BaseCaret)caret;
                        baseCaret.setDot(n6, baseCaret, 1);
                    } else {
                        caret.setDot(n6);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ForwardAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 8007293230193334414L;

        public ForwardAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n;
                    if (!this.select && caret.isSelectionVisible()) {
                        n = jTextComponent.getSelectionEnd();
                        if (n != caret.getDot()) {
                            --n;
                        }
                    } else {
                        n = caret.getDot();
                    }
                    int n2 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, null, 3, null);
                    if (this.select) {
                        caret.moveDot(n2);
                    } else {
                        caret.setDot(n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class PageUpAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -3107382148581661079L;

        public PageUpAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = caret.getDot();
                    Rectangle rectangle = ((BaseTextUI)jTextComponent.getUI()).modelToView(jTextComponent, n);
                    Point point = caret.getMagicCaretPosition();
                    if (point == null) {
                        point = new Point(rectangle.x, rectangle.y);
                        caret.setMagicCaretPosition(point);
                    } else {
                        point.y = rectangle.y;
                    }
                    EditorUI editorUI = ((BaseTextUI)jTextComponent.getUI()).getEditorUI();
                    Rectangle rectangle2 = editorUI.getExtentBounds();
                    int n2 = Math.max(rectangle.height, 1);
                    int n3 = (rectangle2.y + n2 - 1) / n2 * n2;
                    int n4 = rectangle2.height / n2;
                    int n5 = n4 * n2;
                    rectangle.y = Math.max(n3 - n5, 0);
                    rectangle.height = rectangle2.height;
                    point.y = Math.max(point.y - n5, 0);
                    int n6 = jTextComponent.viewToModel(point);
                    editorUI.scrollRectToVisible(rectangle, 0);
                    if (this.select) {
                        caret.moveDot(n6);
                    } else {
                        caret.setDot(n6);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class DownAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5635702355125266822L;

        public DownAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block8: {
                if (jTextComponent != null) {
                    try {
                        Rectangle rectangle;
                        Caret caret = jTextComponent.getCaret();
                        int n = caret.getDot();
                        Point point = caret.getMagicCaretPosition();
                        if (point == null) {
                            rectangle = jTextComponent.modelToView(n);
                            point = new Point(rectangle.x, rectangle.y);
                            caret.setMagicCaretPosition(point);
                        }
                        try {
                            n = Utilities.getPositionBelow(jTextComponent, n, point.x);
                            if (this.select) {
                                caret.moveDot(n);
                                break block8;
                            }
                            if (caret instanceof BaseCaret) {
                                rectangle = (BaseCaret)caret;
                                ((BaseCaret)rectangle).setDot(n, rectangle, 1);
                                break block8;
                            }
                            caret.setDot(n);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class UpAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 4621760742646981563L;

        public UpAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block8: {
                if (jTextComponent != null) {
                    try {
                        Rectangle rectangle;
                        Caret caret = jTextComponent.getCaret();
                        int n = caret.getDot();
                        Point point = caret.getMagicCaretPosition();
                        if (point == null) {
                            rectangle = jTextComponent.modelToView(n);
                            point = new Point(rectangle.x, rectangle.y);
                            caret.setMagicCaretPosition(point);
                        }
                        try {
                            n = Utilities.getPositionAbove(jTextComponent, n, point.x);
                            if (this.select) {
                                caret.moveDot(n);
                                break block8;
                            }
                            if (caret instanceof BaseCaret) {
                                rectangle = (BaseCaret)caret;
                                ((BaseCaret)rectangle).setDot(n, rectangle, 1);
                                break block8;
                            }
                            caret.setDot(n);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class BeepAction
    extends BaseAction {
        static final long serialVersionUID = -4474054576633223968L;

        public BeepAction() {
            super("beep");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PasteAction
    extends BaseAction {
        static final long serialVersionUID = 5839791453996432149L;

        public PasteAction() {
            super("paste-from-clipboard", 28);
            this.putValue("helpID", (class$org$netbeans$editor$BaseKit$PasteAction == null ? (class$org$netbeans$editor$BaseKit$PasteAction = BaseKit.class$("org.netbeans.editor.BaseKit$PasteAction")) : class$org$netbeans$editor$BaseKit$PasteAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.paste();
            }
        }
    }

    public static class CopyAction
    extends BaseAction {
        static final long serialVersionUID = -5119779005431986964L;

        public CopyAction() {
            super("copy-to-clipboard", 28);
            this.setEnabled(false);
            this.putValue("helpID", (class$org$netbeans$editor$BaseKit$CopyAction == null ? (class$org$netbeans$editor$BaseKit$CopyAction = BaseKit.class$("org.netbeans.editor.BaseKit$CopyAction")) : class$org$netbeans$editor$BaseKit$CopyAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    public static class CutAction
    extends BaseAction {
        static final long serialVersionUID = 6377157040901778853L;

        public CutAction() {
            super("cut-to-clipboard", 28);
            this.setEnabled(false);
            this.putValue("helpID", (class$org$netbeans$editor$BaseKit$CutAction == null ? (class$org$netbeans$editor$BaseKit$CutAction = BaseKit.class$("org.netbeans.editor.BaseKit$CutAction")) : class$org$netbeans$editor$BaseKit$CutAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.cut();
            }
        }
    }

    public static class WritableAction
    extends BaseAction {
        static final long serialVersionUID = -5982547952800937954L;

        public WritableAction() {
            super("set-writable");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.setEditable(true);
            }
        }
    }

    public static class ReadOnlyAction
    extends BaseAction {
        static final long serialVersionUID = 9204335480208463193L;

        public ReadOnlyAction() {
            super("set-read-only");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
            }
        }
    }

    public static class DeleteCharAction
    extends BaseAction {
        boolean nextChar;
        static final long serialVersionUID = -4321971925753148556L;

        public DeleteCharAction(String string, boolean bl) {
            super(string, 22);
            this.nextChar = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Document document = jTextComponent.getDocument();
                    Caret caret = jTextComponent.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                    } else if (this.nextChar) {
                        document.remove(n, 1);
                    } else {
                        document.remove(n - 1, 1);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class InsertStringAction
    extends BaseAction {
        String text;
        static final long serialVersionUID = -2755852016584693328L;

        public InsertStringAction(String string, String string2) {
            super(string, 22);
            this.text = string2;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection(this.text);
            }
        }
    }

    public static class InsertContentAction
    extends BaseAction {
        static final long serialVersionUID = 5647751370952797218L;

        public InsertContentAction() {
            super("insert-content", 22);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && actionEvent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                String string = actionEvent.getActionCommand();
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class KitCompoundAction
    extends BaseAction {
        private String[] actionNames;
        static final long serialVersionUID = 8415246475764264835L;

        public KitCompoundAction(String string, String[] stringArray) {
            this(string, 0, stringArray);
        }

        public KitCompoundAction(String string, int n, String[] stringArray) {
            super(string, n);
            this.actionNames = stringArray;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            BaseKit baseKit;
            if (jTextComponent != null && (baseKit = Utilities.getKit(jTextComponent)) != null) {
                int n = 0;
                while (n < this.actionNames.length) {
                    Action action = baseKit.getActionByName(this.actionNames[n]);
                    if (action != null) {
                        if (action instanceof BaseAction) {
                            ((BaseAction)action).actionPerformed(actionEvent, jTextComponent);
                        } else {
                            action.actionPerformed(actionEvent);
                        }
                    }
                    ++n;
                }
            }
        }
    }

    public static class CompoundAction
    extends BaseAction {
        Action[] actions;
        static final long serialVersionUID = 1649688300969753758L;

        public CompoundAction(String string, Action[] actionArray) {
            this(string, 0, actionArray);
        }

        public CompoundAction(String string, int n, Action[] actionArray) {
            super(string, n);
            this.actions = actionArray;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                int n = 0;
                while (n < this.actions.length) {
                    Action action = this.actions[n];
                    if (action instanceof BaseAction) {
                        ((BaseAction)action).actionPerformed(actionEvent, jTextComponent);
                    } else {
                        action.actionPerformed(actionEvent);
                    }
                    ++n;
                }
            }
        }
    }

    public static class InsertTabAction
    extends BaseAction {
        static final long serialVersionUID = -3379768531715989243L;

        public InsertTabAction() {
            super("insert-tab", 22);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                if (caret.isSelectionVisible()) {
                    try {
                        baseDocument.getFormatter().changeBlockIndent(baseDocument, jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd(), 1);
                    }
                    catch (GuardedException guardedException) {
                        jTextComponent.getToolkit().beep();
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    int n;
                    int n2 = caret.getDot();
                    try {
                        n = baseDocument.op.getVisColFromPos(n2);
                    }
                    catch (BadLocationException badLocationException) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            badLocationException.printStackTrace();
                        }
                        n = 0;
                    }
                    try {
                        int n3;
                        int n4 = Utilities.getRowIndent(baseDocument, n2, false);
                        if (n4 == -1) {
                            n4 = 0;
                        }
                        if ((n3 = Utilities.getRowIndent(baseDocument, n2)) == -1) {
                            n3 = n4 > n ? n4 : Utilities.getNextTabColumn(baseDocument, n2);
                            baseDocument.getFormatter().changeRowIndent(baseDocument, n2, n3);
                        } else {
                            baseDocument.getFormatter().insertTabString(baseDocument, n2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class InsertBreakAction
    extends BaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public InsertBreakAction() {
            super("insert-break", 22);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection("");
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                n = baseDocument.getFormatter().indentNewLine(baseDocument, n);
                caret.setDot(n);
            }
        }
    }

    public static class DefaultKeyTypedAction
    extends BaseAction {
        static final long serialVersionUID = 3069164318144463899L;

        public DefaultKeyTypedAction() {
            super("default-typed", 162);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && actionEvent != null) {
                boolean bl;
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                int n = actionEvent.getModifiers();
                boolean bl2 = (n & 2) != 0;
                boolean bl3 = bl = (n & 8) != 0;
                if (bl && !bl2 || bl2 && !bl) {
                    return;
                }
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() == 1) {
                    block11: {
                        char c = string.charAt(0);
                        if (c >= ' ' && c != '\u007f') {
                            editorUI.getWordMatch().clear();
                            try {
                                boolean bl4 = editorUI.getAbbrev().checkAndExpand(c, actionEvent);
                                if (!bl4) break block11;
                                if (caret.isSelectionVisible()) {
                                    jTextComponent.replaceSelection(string);
                                    break block11;
                                }
                                int n2 = caret.getDot();
                                Boolean bl5 = (Boolean)editorUI.getProperty("overwriteMode");
                                if (bl5 != null && bl5.booleanValue() && n2 < baseDocument.getLength() && baseDocument.getChars(n2, 1)[0] != '\n') {
                                    baseDocument.atomicLock();
                                    try {
                                        baseDocument.remove(n2, 1);
                                        baseDocument.insertString(n2, string, null);
                                        Object var15_15 = null;
                                        baseDocument.atomicUnlock();
                                        break block11;
                                    }
                                    catch (Throwable throwable) {
                                        Object var15_16 = null;
                                        baseDocument.atomicUnlock();
                                        throw throwable;
                                    }
                                }
                                baseDocument.insertString(n2, string, null);
                            }
                            catch (BadLocationException badLocationException) {
                                jTextComponent.getToolkit().beep();
                            }
                        }
                    }
                    this.checkIndent(jTextComponent, string);
                }
            }
        }

        protected void checkIndent(JTextComponent jTextComponent, String string) {
        }
    }
}

