/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BasePosition;
import org.netbeans.editor.DocCache;
import org.netbeans.editor.DocCacheSupport;
import org.netbeans.editor.DocMarks;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.MemCacheSupport;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSeg;

class DocOp
implements AbstractDocument.Content {
    private static final int CACHE_LEN = 5;
    private static final String WRONG_POSITION = "Wrong position ";
    private static final String DOC_LEN = ". Document length is ";
    private int MARK_DISTANCE;
    private int MAX_MARK_DISTANCE;
    private int MIN_MARK_DISTANCE;
    private int SYNTAX_UPDATE_BATCH_SIZE;
    private DocCache cache;
    private DocCacheSupport cacheSupport;
    DocMarks marks;
    private BaseDocument doc;
    private int docLen;
    private FinderFactory.EOLFwdFinder eolFwdFinder;
    private FinderFactory.BOLBwdFinder bolBwdFinder;
    private FinderFactory.BEOLLineFwdFinder beolLineFwdFinder;
    private FinderFactory.BEOLPosFwdFinder beolPosFwdFinder;
    private FinderFactory.VisColPosFwdFinder visColPosFwdFinder;
    private FinderFactory.PosVisColFwdFinder posVisColFwdFinder;
    private CacheEntry[] lineCache;
    private Mark endMark;
    MarkFactory.SyntaxMark eolMark;
    private int updatedAreaEnd;
    private SyntaxUpdateRenderer suRenderer;
    private MarkFactory.SyntaxMark leftUpdateMark;
    int statCacheHit;
    int statCacheMiss;
    static /* synthetic */ Class class$org$netbeans$editor$MarkFactory$SyntaxMark;
    static /* synthetic */ Class class$org$netbeans$editor$MarkFactory$LineMark;

    DocOp() {
        block5: {
            this.updatedAreaEnd = -1;
            this.marks = new DocMarks();
            this.marks.startMark.setOp(this);
            this.cacheSupport = new MemCacheSupport();
            this.cache = new DocCache(this.cacheSupport, 2048, true);
            this.lineCache = new CacheEntry[5];
            int n = 0;
            while (n < 5) {
                this.lineCache[n] = new CacheEntry();
                ++n;
            }
            this.bolBwdFinder = new FinderFactory.BOLBwdFinder();
            this.eolFwdFinder = new FinderFactory.EOLFwdFinder();
            this.beolLineFwdFinder = new FinderFactory.BEOLLineFwdFinder();
            this.beolPosFwdFinder = new FinderFactory.BEOLPosFwdFinder();
            this.visColPosFwdFinder = new FinderFactory.VisColPosFwdFinder();
            this.posVisColFwdFinder = new FinderFactory.PosVisColFwdFinder();
            try {
                this.endMark = this.insertMark(this.docLen, false);
                this.eolMark = new MarkFactory.SyntaxMark(){

                    protected void removeUpdateAction(int n, int n2) {
                    }
                };
                this.insertMark(this.eolMark, this.docLen);
            }
            catch (BadLocationException badLocationException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    badLocationException.printStackTrace();
                }
            }
            catch (InvalidMarkException invalidMarkException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block5;
                invalidMarkException.printStackTrace();
            }
        }
        this.suRenderer = new SyntaxUpdateRenderer();
    }

    void setDocument(BaseDocument baseDocument) {
        this.doc = baseDocument;
        this.MARK_DISTANCE = (Integer)baseDocument.getProperty("mark-distance");
        this.MAX_MARK_DISTANCE = (Integer)baseDocument.getProperty("max-mark-distance");
        this.MIN_MARK_DISTANCE = (Integer)baseDocument.getProperty("min-mark-distance");
        this.SYNTAX_UPDATE_BATCH_SIZE = (Integer)baseDocument.getProperty("syntax-update-batch-size");
    }

    public synchronized Position createPosition(int n) throws BadLocationException {
        boolean bl;
        boolean bl2 = bl = n == 0;
        if (n == this.docLen + 1) {
            n = this.docLen;
        }
        return new BasePosition(this, n, bl ? Position.Bias.Backward : Position.Bias.Forward);
    }

    public synchronized Position createPosition(int n, Position.Bias bias) throws BadLocationException {
        return new BasePosition(this, n, bias);
    }

    public synchronized int length() {
        return this.docLen;
    }

    public String getString(int n, int n2) throws BadLocationException {
        return new String(this.getChars(n, n2));
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        segment.array = this.getChars(n, n2);
        segment.offset = 0;
        segment.count = n2;
    }

    synchronized char[] getChars(int n, int n2) throws BadLocationException {
        return this.cache.read(n, n2, null);
    }

    synchronized void getChars(int n, char[] cArray, int n2, int n3) throws BadLocationException {
        this.cache.read(n, cArray, n2, n3, null);
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        ModifyUndoEdit modifyUndoEdit = new ModifyUndoEdit(false, n, string);
        this.insertEdit(modifyUndoEdit);
        return modifyUndoEdit;
    }

    public UndoableEdit insert(int n, char[] cArray) throws BadLocationException {
        ModifyUndoEdit modifyUndoEdit = new ModifyUndoEdit(false, n, cArray);
        this.insertEdit(modifyUndoEdit);
        return modifyUndoEdit;
    }

    synchronized void insertEdit(ModifyUndoEdit modifyUndoEdit) throws BadLocationException {
        int n = modifyUndoEdit.getOffset();
        this.checkEOLMark(n);
        if (modifyUndoEdit.isTextValid()) {
            this.cache.insertString(n, modifyUndoEdit.getText(), null);
        } else {
            this.cache.insert(n, modifyUndoEdit.getChars(), null);
        }
        this.insertUpdate(modifyUndoEdit);
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        ModifyUndoEdit modifyUndoEdit = new ModifyUndoEdit(true, n, this.getChars(n, n2));
        this.removeEdit(modifyUndoEdit);
        return modifyUndoEdit;
    }

    synchronized void removeEdit(ModifyUndoEdit modifyUndoEdit) throws BadLocationException {
        this.checkEOLMark(modifyUndoEdit.getOffset());
        this.cache.remove(modifyUndoEdit.getOffset(), modifyUndoEdit.getLength(), null);
        this.removeUpdate(modifyUndoEdit);
    }

    synchronized int find(Finder finder, int n, int n2) throws BadLocationException {
        return this.cache.find(finder, n, n2, null);
    }

    synchronized void insertMark(Mark mark, int n) throws BadLocationException, InvalidMarkException {
        if (n < 0 || n > this.docLen) {
            throw new BadLocationException(WRONG_POSITION + n + DOC_LEN + this.docLen, n);
        }
        this.insertMark(mark, n, this.getLineImpl(n));
    }

    void insertMark(Mark mark, int n, int n2) throws BadLocationException, InvalidMarkException {
        mark.offset = n;
        mark.line = n2;
        this.marks.insert(mark);
        mark.setOp(this);
    }

    void directCacheWrite(int n, char[] cArray, int n2, int n3) throws BadLocationException {
        this.cacheSupport.write(n, cArray, n2, n3);
    }

    void initCacheContent(char[] cArray, int n, int n2) {
        this.cache.initCacheContent(cArray, n, n2);
    }

    Mark insertMark(int n, boolean bl) throws BadLocationException {
        Mark mark;
        block2: {
            mark = new Mark(bl);
            try {
                this.insertMark(mark, n);
            }
            catch (InvalidMarkException invalidMarkException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                invalidMarkException.printStackTrace();
            }
        }
        return mark;
    }

    synchronized void moveMark(Mark mark, int n) throws BadLocationException, InvalidMarkException {
        if (n < 0 || n > this.docLen) {
            throw new BadLocationException(WRONG_POSITION + n + DOC_LEN + this.docLen, n);
        }
        mark.remove();
        this.insertMark(mark, n);
    }

    synchronized Mark getOffsetMark(int n, Class clazz) {
        return this.marks.getOffsetMark(n, clazz);
    }

    synchronized void renderMarks(DocMarks.Renderer renderer) {
        this.marks.render(renderer);
    }

    synchronized int getBOL(int n) throws BadLocationException {
        return this.getBOLImpl(n);
    }

    synchronized boolean isBOL(int n) throws BadLocationException {
        return n == this.getBOLImpl(n);
    }

    synchronized int getEOL(int n) throws BadLocationException {
        return this.getEOLImpl(n);
    }

    synchronized int getEOLNL(int n) throws BadLocationException {
        int n2 = this.getEOLImpl(n);
        if (n2 < this.docLen) {
            return n2++;
        }
        return n2;
    }

    synchronized boolean isEOL(int n) throws BadLocationException {
        return n == this.getEOLImpl(n);
    }

    synchronized int getBOLFromLine(int n) {
        return this.getBOLFromLineImpl(n);
    }

    synchronized int getEOLFromLine(int n) {
        int n2 = this.getBOLFromLineImpl(n);
        if (n2 < 0) {
            return 0;
        }
        try {
            return this.getEOLImpl(n2);
        }
        catch (BadLocationException badLocationException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                badLocationException.printStackTrace();
            }
            return -1;
        }
    }

    synchronized int getBOLRelLine(int n, int n2) throws BadLocationException {
        int n3 = this.getLineImpl(n);
        return this.getBOLFromLineImpl(n3 += n2);
    }

    synchronized int getEOLRelLine(int n, int n2) throws BadLocationException {
        int n3 = this.getLineImpl(n);
        n = this.getBOLFromLineImpl(n3 += n2);
        if (n < 0) {
            return n;
        }
        try {
            return this.getEOLImpl(n);
        }
        catch (BadLocationException badLocationException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                badLocationException.printStackTrace();
            }
            return -1;
        }
    }

    synchronized int getLine(int n) throws BadLocationException {
        return this.getLineImpl(n);
    }

    synchronized int getLineCount() {
        int n;
        try {
            n = this.endMark.getLine() + 1;
        }
        catch (InvalidMarkException invalidMarkException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                invalidMarkException.printStackTrace();
            }
            return 0;
        }
        return n;
    }

    synchronized int getOffsetFromVisCol(int n, int n2) throws BadLocationException {
        if (n <= 0) {
            return n2;
        }
        this.visColPosFwdFinder.setVisCol(n);
        this.visColPosFwdFinder.setTabSize(this.doc.getTabSize());
        int n3 = this.cache.find(this.visColPosFwdFinder, n2, -1, null);
        return n3 != -1 ? n3 : this.getEOLImpl(n2);
    }

    synchronized int getVisColFromPos(int n) throws BadLocationException {
        int n2 = this.getBOLImpl(n);
        this.posVisColFwdFinder.setTabSize(this.doc.getTabSize());
        this.cache.find(this.posVisColFwdFinder, n2, n, null);
        return this.posVisColFwdFinder.getVisCol();
    }

    private int getBOLImpl(int n) throws BadLocationException {
        if (n <= 0) {
            if (n == 0) {
                return 0;
            }
            throw new BadLocationException(WRONG_POSITION + n + DOC_LEN + this.length(), n);
        }
        int n2 = 0;
        while (n2 < 5) {
            if (n >= this.lineCache[n2].bol && n <= this.lineCache[n2].eol) {
                this.cacheMoveFirst(n2);
                ++this.statCacheHit;
                return this.lineCache[0].bol;
            }
            ++n2;
        }
        ++this.statCacheMiss;
        return this.cache.find(this.bolBwdFinder, n, 0, null) + 1;
    }

    private int getEOLImpl(int n) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException(WRONG_POSITION + n + DOC_LEN + this.length(), n);
        }
        int n2 = 0;
        while (n2 < 5) {
            if (n >= this.lineCache[n2].bol && n <= this.lineCache[n2].eol) {
                this.cacheMoveFirst(n2);
                ++this.statCacheHit;
                return this.lineCache[0].eol;
            }
            ++n2;
        }
        ++this.statCacheMiss;
        return (n = this.cache.find(this.eolFwdFinder, n, -1, null)) != -1 ? n : this.docLen;
    }

    private int getBOLFromLineImpl(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = 0;
        while (n2 < 5) {
            if (n == this.lineCache[n2].line) {
                this.cacheMoveFirst(n2);
                ++this.statCacheHit;
                return this.lineCache[0].bol;
            }
            ++n2;
        }
        ++this.statCacheMiss;
        this.cacheMoveFirst(4);
        return this.cacheLoadLine(n);
    }

    private int getLineImpl(int n) throws BadLocationException {
        if (n < 0 || n > this.docLen) {
            throw new BadLocationException(WRONG_POSITION + n + DOC_LEN + this.length(), n);
        }
        int n2 = 0;
        while (n2 < 5) {
            if (n >= this.lineCache[n2].bol && n <= this.lineCache[n2].eol) {
                this.cacheMoveFirst(n2);
                ++this.statCacheHit;
                return this.lineCache[0].line;
            }
            ++n2;
        }
        ++this.statCacheMiss;
        this.cacheMoveFirst(4);
        return this.cacheLoadLineByPos(n);
    }

    private int adjustNextBOL(int n, boolean bl) throws BadLocationException {
        if (bl && n == this.getBOLImpl(n)) {
            return n;
        }
        if ((n = this.getEOLImpl(n)) < this.docLen) {
            ++n;
        }
        return n;
    }

    MarkFactory.SyntaxMark getLeftSyntaxMark(int n) {
        return (MarkFactory.SyntaxMark)this.marks.getLeftMark(n, class$org$netbeans$editor$MarkFactory$SyntaxMark == null ? (class$org$netbeans$editor$MarkFactory$SyntaxMark = DocOp.class$("org.netbeans.editor.MarkFactory$SyntaxMark")) : class$org$netbeans$editor$MarkFactory$SyntaxMark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void update(boolean bl, ModifyUndoEdit modifyUndoEdit) {
        int n = modifyUndoEdit.getOffset();
        SyntaxSeg.invalidate(this.doc, n);
        SyntaxSeg.Slot slot = SyntaxSeg.getFreeSlot();
        Syntax syntax = this.doc.getFreeSyntax();
        try {
            try {
                int n2;
                if (bl) {
                    Mark mark;
                    block12: {
                        n2 = 0;
                        while (true) {
                            if ((mark = this.getOffsetMark(n, class$org$netbeans$editor$MarkFactory$SyntaxMark == null ? DocOp.class$("org.netbeans.editor.MarkFactory$SyntaxMark") : class$org$netbeans$editor$MarkFactory$SyntaxMark)) == this.eolMark) {
                                n2 = 1;
                            }
                            if (mark == null) {
                                if (n2 != 0) {
                                    break;
                                }
                                break block12;
                            }
                            mark.remove();
                        }
                        this.insertMark(this.eolMark, n);
                    }
                    while ((mark = this.getOffsetMark(n, class$org$netbeans$editor$MarkFactory$LineMark == null ? DocOp.class$("org.netbeans.editor.MarkFactory$LineMark") : class$org$netbeans$editor$MarkFactory$LineMark)) != null) {
                        mark.remove();
                    }
                }
                this.cacheUpdate(bl, modifyUndoEdit);
                this.leftUpdateMark = this.getLeftSyntaxMark(n - 1);
                n2 = this.leftUpdateMark != null ? this.leftUpdateMark.getOffset() : 0;
                this.updateEvenly();
                this.prepareSyntax(slot, syntax, this.leftUpdateMark, n2, 0, false);
                this.suRenderer.slot = slot;
                this.suRenderer.syntax = syntax;
                this.suRenderer.undoEdit = modifyUndoEdit;
                this.suRenderer.remove = bl;
                this.marks.render(this.suRenderer);
            }
            catch (InvalidMarkException invalidMarkException) {
                invalidMarkException.printStackTrace();
                Object var9_11 = null;
                this.doc.releaseSyntax(syntax);
                SyntaxSeg.releaseSlot(slot);
                return;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                Object var9_12 = null;
                this.doc.releaseSyntax(syntax);
                SyntaxSeg.releaseSlot(slot);
                return;
            }
            Object var9_10 = null;
            this.doc.releaseSyntax(syntax);
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.doc.releaseSyntax(syntax);
            SyntaxSeg.releaseSlot(slot);
            throw throwable;
        }
        SyntaxSeg.releaseSlot(slot);
    }

    synchronized void invalidateSyntaxMarks() {
        this.marks.render(new DocMarks.Renderer(){

            protected void render() {
                Mark[] markArray = this.getMarkArray();
                int n = this.getMarkArrayLength();
                int n2 = 0;
                while (n2 < n) {
                    if (markArray[n2] instanceof MarkFactory.SyntaxMark) {
                        ((MarkFactory.SyntaxMark)markArray[n2]).setStateInfo(null);
                    }
                    n2 = this.getNextIndex(n2);
                }
            }
        });
        this.updatedAreaEnd = 0;
    }

    void initialReadUpdate() {
        this.docLen = this.cache.getDocLength();
        this.invalidateCache();
        this.updatedAreaEnd = 0;
    }

    synchronized void insertUpdate(ModifyUndoEdit modifyUndoEdit) {
        this.docLen += modifyUndoEdit.getLength();
        this.marks.update(modifyUndoEdit.getOffset(), 0, modifyUndoEdit.getLength(), modifyUndoEdit.getLFCount());
        this.update(false, modifyUndoEdit);
    }

    synchronized void removeUpdate(ModifyUndoEdit modifyUndoEdit) {
        this.docLen -= modifyUndoEdit.getLength();
        this.marks.update(modifyUndoEdit.getOffset(), modifyUndoEdit.getLine(), -modifyUndoEdit.getLength(), -modifyUndoEdit.getLFCount());
        this.update(true, modifyUndoEdit);
    }

    private void updateEvenly() {
        this.marks.render(new DocMarks.Renderer(){

            protected void render() {
                block14: {
                    int n;
                    int n2;
                    int n3;
                    block13: {
                        int n4 = -1;
                        n3 = 0;
                        if (DocOp.this.leftUpdateMark != null) {
                            n4 = this.getMarkIndex(DocOp.this.leftUpdateMark);
                            n3 = this.getMarkOffset(DocOp.this.leftUpdateMark);
                        }
                        Mark[] markArray = this.getMarkArray();
                        int n5 = this.getMarkArrayLength();
                        n2 = 0;
                        int n6 = this.getNextIndex(n4);
                        boolean bl = false;
                        while (n6 < n5) {
                            Mark mark = markArray[n6];
                            n2 = this.getMarkOffset(mark) - n3;
                            if (mark.getClass() == (class$org$netbeans$editor$MarkFactory$SyntaxMark == null ? DocOp.class$("org.netbeans.editor.MarkFactory$SyntaxMark") : class$org$netbeans$editor$MarkFactory$SyntaxMark) && mark != DocOp.this.eolMark) {
                                bl = true;
                                break;
                            }
                            n6 = this.getNextIndex(n6);
                        }
                        if (!bl) {
                            n2 = DocOp.this.length() - n3;
                        }
                        if (n2 < DocOp.this.MIN_MARK_DISTANCE && bl) {
                            try {
                                markArray[n6].remove();
                            }
                            catch (InvalidMarkException invalidMarkException) {
                                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block13;
                                invalidMarkException.printStackTrace();
                            }
                        }
                    }
                    if (n2 > DocOp.this.MAX_MARK_DISTANCE && (n = n2 / DocOp.this.MARK_DISTANCE) > 0) {
                        int n7 = n3 + (n2 - (n - 1) * DocOp.this.MARK_DISTANCE) / 2;
                        try {
                            int n8 = 0;
                            while (n8 < n) {
                                MarkFactory.SyntaxMark syntaxMark = new MarkFactory.SyntaxMark();
                                DocOp.this.insertMark(syntaxMark, n7 + n8 * DocOp.this.MARK_DISTANCE);
                                ++n8;
                            }
                        }
                        catch (InvalidMarkException invalidMarkException) {
                            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                invalidMarkException.printStackTrace();
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block14;
                            badLocationException.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkEOLMark(int n) {
        block7: {
            try {
                int n2 = this.adjustNextBOL(n, false);
                if (this.eolMark.getOffset() == n2) break block7;
                SyntaxSeg.Slot slot = SyntaxSeg.getFreeSlot();
                Syntax syntax = this.doc.getFreeSyntax();
                if (this.updatedAreaEnd >= 0) {
                    this.prepareSyntax(slot, syntax, this.getLeftSyntaxMark(this.docLen), this.docLen, 0, false);
                }
                MarkFactory.SyntaxMark syntaxMark = this.getLeftSyntaxMark(n2 - 1);
                try {
                    this.prepareSyntax(slot, syntax, syntaxMark, n2, 0, false);
                    this.moveMark(this.eolMark, n2);
                    this.eolMark.updateStateInfo(syntax);
                    Object var7_8 = null;
                    this.doc.releaseSyntax(syntax);
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    this.doc.releaseSyntax(syntax);
                    SyntaxSeg.releaseSlot(slot);
                    throw throwable;
                }
                SyntaxSeg.releaseSlot(slot);
                {
                }
            }
            catch (BadLocationException badLocationException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    badLocationException.printStackTrace();
                }
            }
            catch (InvalidMarkException invalidMarkException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block7;
                invalidMarkException.printStackTrace();
            }
        }
    }

    void prepareSyntax(final SyntaxSeg.Slot slot, final Syntax syntax, MarkFactory.SyntaxMark syntaxMark, final int n, int n2, boolean bl, boolean bl2) throws BadLocationException {
        int n3;
        int n4;
        if (this.updatedAreaEnd >= 0 && this.updatedAreaEnd < n + n2) {
            final MarkFactory.SyntaxMark syntaxMark2 = this.getLeftSyntaxMark(this.updatedAreaEnd);
            n4 = 0;
            int n5 = 0;
            Syntax.StateInfo stateInfo = null;
            if (syntaxMark2 != null) {
                block8: {
                    try {
                        n4 = syntaxMark2.getOffset();
                    }
                    catch (InvalidMarkException invalidMarkException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block8;
                        invalidMarkException.printStackTrace();
                    }
                }
                stateInfo = syntaxMark2.getStateInfo();
                n5 = stateInfo.getPreScan();
            }
            n3 = n4 - n5;
            int n6 = n - n3;
            final int n7 = Math.min(n2 + this.SYNTAX_UPDATE_BATCH_SIZE, this.docLen - n);
            slot.load(this.doc, n3, n6 + n7);
            syntax.load(stateInfo, slot.array, slot.offset + n5, n6 - n5, n == this.docLen, n4);
            final int n8 = n4;
            this.marks.render(new DocMarks.Renderer(){

                public void render() {
                    int n6 = this.getMarkArrayLength();
                    int n2 = syntaxMark2 != null ? this.getNextIndex(this.getMarkIndex(syntaxMark2)) : this.getNextIndex(-1);
                    int n32 = n8;
                    Mark[] markArray = this.getMarkArray();
                    int n4 = n32;
                    while (n2 < n6) {
                        Mark mark = markArray[n2];
                        int n5 = n2;
                        n2 = this.getNextIndex(n2);
                        n32 = this.getMarkOffset(mark);
                        if (n32 > n + n7) {
                            n2 = n5;
                            break;
                        }
                        if (!(mark instanceof MarkFactory.SyntaxMark)) continue;
                        MarkFactory.SyntaxMark syntaxMark = (MarkFactory.SyntaxMark)mark;
                        syntax.relocate(slot.array, slot.offset + n4 - n3, n32 - n4, n32 == DocOp.this.docLen, n32);
                        while (syntax.nextToken() != null) {
                        }
                        syntaxMark.updateStateInfo(syntax);
                        DocOp.this.updatedAreaEnd = n32;
                        n4 = n32;
                    }
                    while (n2 < n6) {
                        if (markArray[n2] instanceof MarkFactory.SyntaxMark) break;
                        n2 = this.getNextIndex(n2);
                    }
                    if (n2 >= n6) {
                        DocOp.this.updatedAreaEnd = -1;
                    }
                }
            });
        }
        int n9 = 0;
        n4 = 0;
        Syntax.StateInfo stateInfo = null;
        if (syntaxMark != null) {
            block9: {
                try {
                    n9 = syntaxMark.getOffset();
                }
                catch (InvalidMarkException invalidMarkException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block9;
                    invalidMarkException.printStackTrace();
                }
            }
            stateInfo = syntaxMark.getStateInfo();
            n4 = stateInfo.getPreScan();
        }
        int n10 = n9 - n4;
        n3 = n - n10;
        slot.load(this.doc, n10, n3 + n2);
        syntax.load(stateInfo, slot.array, slot.offset + n4, n3 - n4, bl2 ? false : n >= this.docLen, n);
        while (syntax.nextToken() != null) {
        }
        syntax.relocate(slot.array, slot.offset + n3, n2, bl2 ? false : bl || n + n2 >= this.docLen, n + n2);
    }

    void prepareSyntax(SyntaxSeg.Slot slot, Syntax syntax, MarkFactory.SyntaxMark syntaxMark, int n, int n2, boolean bl) throws BadLocationException {
        this.prepareSyntax(slot, syntax, syntaxMark, n, n2, bl, false);
    }

    private int cacheLoadLine(int n) {
        int n2;
        int n3;
        if (n == 0) {
            try {
                int n4 = this.cache.find(this.eolFwdFinder, 0, -1, null);
                if (n4 == -1) {
                    n4 = this.docLen;
                }
                this.lineCache[0].fill(0, n4, 0);
            }
            catch (BadLocationException badLocationException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    badLocationException.printStackTrace();
                }
                return -1;
            }
            return 0;
        }
        try {
            Mark mark = this.marks.getMarkFromLine(n - 1);
            n3 = mark.getOffset();
            n2 = mark.getLine();
        }
        catch (InvalidMarkException invalidMarkException) {
            return this.cacheLoadLine(n);
        }
        try {
            this.beolLineFwdFinder.fwdLines = n - n2;
            n3 = this.cache.find(this.beolLineFwdFinder, n3, -1, null);
            int n5 = this.beolLineFwdFinder.bolPos;
            if (n5 == -1) {
                return -1;
            }
            if (n3 == -1) {
                n3 = this.docLen;
            }
            this.lineCache[0].fill(n5, n3, n);
            return n5;
        }
        catch (BadLocationException badLocationException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                badLocationException.printStackTrace();
            }
            return -1;
        }
    }

    private int cacheLoadLineByPos(int n) throws BadLocationException {
        int n2;
        int n3;
        int n4;
        try {
            Mark mark = this.marks.getLeftMark(n, null);
            n4 = mark.getOffset();
            n3 = mark.getLine();
        }
        catch (InvalidMarkException invalidMarkException) {
            return this.cacheLoadLineByPos(n);
        }
        this.beolPosFwdFinder.tgtPos = n;
        n4 = this.cache.find(this.beolPosFwdFinder, n4, -1, null);
        if (n4 == -1) {
            n4 = this.docLen;
        }
        if ((n2 = this.beolPosFwdFinder.bolPos) == -1) {
            n2 = n > 0 ? this.cache.find(this.bolBwdFinder, n, 0, null) + 1 : 0;
        }
        int n5 = n3 + this.beolPosFwdFinder.line;
        this.lineCache[0].fill(n2, n4, n5);
        return n5;
    }

    private void cacheMoveFirst(int n) {
        if (n == 0) {
            return;
        }
        CacheEntry cacheEntry = this.lineCache[n];
        System.arraycopy(this.lineCache, 0, this.lineCache, 1, n);
        this.lineCache[0] = cacheEntry;
    }

    private void invalidateCache() {
        int n = 0;
        while (n < 5) {
            this.lineCache[n].invalidate();
            ++n;
        }
    }

    private void cacheUpdate(boolean bl, ModifyUndoEdit modifyUndoEdit) {
        int n = modifyUndoEdit.getOffset();
        int n2 = modifyUndoEdit.getLength();
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < 5) {
            CacheEntry cacheEntry = this.lineCache[n5];
            if (cacheEntry.line != -1) {
                if (!bl) {
                    if (n >= cacheEntry.bol) {
                        if (n <= cacheEntry.eol) {
                            int n6 = modifyUndoEdit.getFirstLFOffset();
                            cacheEntry.eol = n6 == -1 ? (cacheEntry.eol += n2) : n6;
                        }
                    } else {
                        cacheEntry.update(n2, modifyUndoEdit.getLFCount());
                    }
                } else if (n + n2 >= cacheEntry.bol) {
                    if (n <= cacheEntry.eol) {
                        cacheEntry.line = modifyUndoEdit.getLine();
                        if (n + n2 > cacheEntry.eol) {
                            if (n4 == -1) {
                                block24: {
                                    try {
                                        n4 = this.cache.find(this.eolFwdFinder, n, -1, null);
                                    }
                                    catch (BadLocationException badLocationException) {
                                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block24;
                                        badLocationException.printStackTrace();
                                    }
                                }
                                if (n4 == -1) {
                                    n4 = this.docLen;
                                }
                            }
                            cacheEntry.eol = n4;
                            if (n < cacheEntry.bol) {
                                block25: {
                                    if (n3 == -1) {
                                        try {
                                            n3 = this.cache.find(this.bolBwdFinder, n, 0, null) + 1;
                                        }
                                        catch (BadLocationException badLocationException) {
                                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block25;
                                            badLocationException.printStackTrace();
                                        }
                                    }
                                }
                                cacheEntry.bol = n3;
                            }
                        } else {
                            cacheEntry.eol -= n2;
                            if (n < cacheEntry.bol) {
                                block26: {
                                    if (n3 == -1) {
                                        try {
                                            n3 = this.cache.find(this.bolBwdFinder, n, 0, null) + 1;
                                        }
                                        catch (BadLocationException badLocationException) {
                                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block26;
                                            badLocationException.printStackTrace();
                                        }
                                    }
                                }
                                cacheEntry.bol = n3;
                            }
                        }
                    }
                } else {
                    cacheEntry.update(-n2, -modifyUndoEdit.getLFCount());
                }
            }
            ++n5;
        }
    }

    public String cacheToString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 5) {
            stringBuffer.append("\ncache[" + n + "]: " + this.lineCache[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "length()=" + this.length() + ", cache.getDocLength()=" + this.cache.getDocLength() + "\nstatCacheHit=" + this.statCacheHit + ", statCacheMiss=" + this.statCacheMiss + ", Line cache hit ratio=" + (double)Math.round(1000.0 * (double)this.statCacheHit / (double)(this.statCacheHit + this.statCacheMiss)) / 10.0 + this.cacheToString();
    }

    public String markPlanesToString(Class[] classArray, char[] cArray) {
        return "";
    }

    public String infoToString() {
        return "\n------------------------------ Statistics ------------------------------\ncacheSupport: statCharsRead=" + this.cacheSupport.statCharsRead + ", statCharsWritten=" + this.cacheSupport.statCharsWritten + "\nCache: " + this.cache + "\nMarks: " + this.marks + "\nDocOp: " + this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ModifyUndoEdit
    extends AbstractUndoableEdit {
        boolean remove;
        private int offset;
        private char[] chars;
        private String text;
        private int lfCount = -1;
        private int line;
        private int syntaxUpdateOffset;

        ModifyUndoEdit(boolean bl, int n, char[] cArray) {
            this.remove = bl;
            this.offset = n;
            this.chars = cArray;
            try {
                this.line = DocOp.this.getLine(n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        ModifyUndoEdit(boolean bl, int n, String string) {
            this.remove = bl;
            this.offset = n;
            this.text = string;
            try {
                this.line = DocOp.this.getLine(n);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        boolean isInsert() {
            return !this.remove;
        }

        boolean isRemove() {
            return this.remove;
        }

        final int getOffset() {
            return this.offset;
        }

        int getLength() {
            return this.chars != null ? this.chars.length : this.text.length();
        }

        String getText() {
            if (this.text == null) {
                this.text = new String(this.chars);
            }
            return this.text;
        }

        char[] getChars() {
            if (this.chars == null) {
                this.chars = this.text.toCharArray();
            }
            return this.chars;
        }

        boolean isTextValid() {
            return this.text != null;
        }

        int getLFCount() {
            if (this.lfCount == -1) {
                this.lfCount = this.chars != null ? Analyzer.getLFCount(this.chars) : Analyzer.getLFCount(this.text);
            }
            return this.lfCount;
        }

        int getFirstLFOffset() {
            if (this.getLFCount() <= 0) {
                return -1;
            }
            int n = this.chars != null ? Analyzer.findFirstLFOffset(this.chars, 0, this.chars.length) : Analyzer.findFirstLFOffset(this.text);
            if (n >= 0) {
                n += this.offset;
            }
            return n;
        }

        int getLine() {
            return this.line;
        }

        int getSyntaxUpdateOffset() {
            return this.syntaxUpdateOffset;
        }

        void setSyntaxUpdateOffset(int n) {
            this.syntaxUpdateOffset = n;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                if (this.remove) {
                    DocOp.this.insertEdit(this);
                } else {
                    DocOp.this.removeEdit(this);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                if (this.remove) {
                    DocOp.this.removeEdit(this);
                } else {
                    DocOp.this.insertEdit(this);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private static class CacheEntry {
        int bol = -1;
        int eol = -1;
        int line = -1;

        private CacheEntry() {
        }

        void fill(int n, int n2, int n3) {
            this.bol = n;
            this.eol = n2;
            this.line = n3;
        }

        void update(int n, int n2) {
            this.bol += n;
            this.eol += n;
            this.line += n2;
        }

        void invalidate() {
            this.line = -1;
            this.eol = -1;
            this.bol = -1;
        }

        public String toString() {
            return "line=" + this.line + ", bol=" + this.bol + ", eol=" + this.eol;
        }
    }

    class SyntaxUpdateRenderer
    extends DocMarks.Renderer {
        ModifyUndoEdit undoEdit;
        boolean remove;
        SyntaxSeg.Slot slot;
        Syntax syntax;

        SyntaxUpdateRenderer() {
        }

        public void render() {
            block16: {
                int n;
                int n2 = this.getMarkArrayLength();
                int n3 = 0;
                Mark[] markArray = this.getMarkArray();
                int n4 = -1;
                if (DocOp.this.leftUpdateMark != null) {
                    try {
                        n = this.getNextIndex(this.getMarkIndex(DocOp.this.leftUpdateMark));
                        n3 = DocOp.this.leftUpdateMark.getOffset();
                    }
                    catch (InvalidMarkException invalidMarkException) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            invalidMarkException.printStackTrace();
                        }
                        n = this.getNextIndex(-1);
                    }
                } else {
                    n = this.getNextIndex(-1);
                }
                int n5 = n3;
                if (!this.remove) {
                    n5 = this.undoEdit.getOffset() + this.undoEdit.getLength();
                }
                try {
                    this.slot.load(DocOp.this.doc, n3 - this.syntax.getPreScan(), n5 - n3 + this.syntax.getPreScan());
                    int n6 = n3;
                    while (n < n2) {
                        Mark mark = markArray[n];
                        n = this.getNextIndex(n);
                        n3 = this.getMarkOffset(mark);
                        if (!(mark instanceof MarkFactory.SyntaxMark)) continue;
                        MarkFactory.SyntaxMark syntaxMark = (MarkFactory.SyntaxMark)mark;
                        int n7 = this.syntax.getPreScan();
                        int n8 = n6 - n7;
                        int n9 = n3 - n8;
                        if (!this.slot.isAreaInside(DocOp.this.doc, n8, n9)) {
                            int n10 = Math.min(DocOp.this.docLen - n8, Math.max(n9, DocOp.this.SYNTAX_UPDATE_BATCH_SIZE));
                            this.slot.load(DocOp.this.doc, n8, n10);
                        }
                        this.slot.load(DocOp.this.doc, n8, n9);
                        this.syntax.relocate(this.slot.array, this.slot.offset + n7, n9 - n7, n3 == DocOp.this.docLen, n3);
                        while (this.syntax.nextToken() != null) {
                        }
                        if (this.syntax.compareState(syntaxMark.getStateInfo()) == 0) {
                            if (n4 < 0) {
                                n4 = n3;
                            }
                            if (n3 >= n5 && syntaxMark != DocOp.this.eolMark) {
                                break;
                            }
                        } else {
                            n4 = -1;
                            syntaxMark.updateStateInfo(this.syntax);
                        }
                        n6 = n3;
                    }
                    if (n4 < 0) {
                        n4 = DocOp.this.docLen;
                    }
                    this.undoEdit.setSyntaxUpdateOffset(DocOp.this.adjustNextBOL(n4, true));
                }
                catch (BadLocationException badLocationException) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block16;
                    badLocationException.printStackTrace();
                }
            }
        }
    }
}

