/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DocMarks;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSeg;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

class DrawEngine {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.draw");
    private static final boolean debugFragment = Boolean.getBoolean("netbeans.debug.editor.draw.fragment");
    private static final int DEFAULT_DRAW_MARK_RENDERER_SIZE = 20;
    private static DrawEngine drawEngine;
    private static final char[] SPACE;

    private DrawEngine() {
    }

    public static DrawEngine getDrawEngine() {
        if (drawEngine == null) {
            drawEngine = new DrawEngine();
        }
        return drawEngine;
    }

    private void initLineNumbering(DrawInfo drawInfo) {
        block11: {
            boolean bl = drawInfo.lineNumbering = drawInfo.editorUI.lineNumberVisible && drawInfo.drawGraphics.supportsLineNumbers();
            if (drawInfo.lineNumbering) {
                Color color;
                Color color2;
                block10: {
                    try {
                        drawInfo.startLineNumber = Utilities.getLineOffset(drawInfo.doc, drawInfo.startOffset) + 1;
                    }
                    catch (BadLocationException badLocationException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block10;
                        badLocationException.printStackTrace();
                    }
                }
                drawInfo.lineNumberColoring = drawInfo.editorUI.getColoring("line-number");
                drawInfo.lineNumberColoring = drawInfo.lineNumberColoring == null ? drawInfo.defaultColoring : drawInfo.lineNumberColoring.apply(drawInfo.defaultColoring);
                Font font = drawInfo.lineNumberColoring.getFont();
                if (font == null) {
                    font = drawInfo.defaultColoring.getFont();
                }
                if ((color2 = drawInfo.lineNumberColoring.getBackColor()) == null) {
                    color2 = drawInfo.defaultColoring.getBackColor();
                }
                if ((color = drawInfo.lineNumberColoring.getForeColor()) == null) {
                    color = drawInfo.defaultColoring.getForeColor();
                }
                drawInfo.lineNumberChars = new char[Math.max(drawInfo.editorUI.lineNumberMaxDigitCount, 1)];
                if (drawInfo.graphics == null) {
                    drawInfo.syncedLineNumbering = true;
                } else {
                    try {
                        int n = Utilities.getLineOffset(drawInfo.doc, drawInfo.endOffset) + 1;
                        drawInfo.lineStartOffsets = new int[n - drawInfo.startLineNumber + 2];
                    }
                    catch (BadLocationException badLocationException) {
                        if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block11;
                        badLocationException.printStackTrace();
                    }
                }
            }
        }
    }

    private void initInfo(DrawInfo drawInfo) throws BadLocationException {
        int n;
        drawInfo.x = drawInfo.startX;
        drawInfo.y = drawInfo.startY;
        drawInfo.lineHeight = drawInfo.editorUI.getLineHeight();
        drawInfo.defaultColoring = drawInfo.editorUI.getDefaultColoring();
        drawInfo.tabSize = drawInfo.doc.getTabSize();
        drawInfo.fragmentOffset = drawInfo.startOffset;
        drawInfo.graphics = drawInfo.drawGraphics.getGraphics();
        if (drawInfo.graphics != null) {
            if (drawInfo.editorUI.renderingHints != null) {
                ((Graphics2D)drawInfo.graphics).setRenderingHints(drawInfo.editorUI.renderingHints);
            }
            if (drawInfo.editorUI.textLimitLineVisible) {
                n = drawInfo.startX + drawInfo.editorUI.textLimitWidth * drawInfo.editorUI.defaultSpaceWidth;
                drawInfo.graphics.setColor(drawInfo.editorUI.textLimitLineColor);
                Rectangle rectangle = drawInfo.graphics.getClipBounds();
                drawInfo.graphics.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            }
        }
        this.initLineNumbering(drawInfo);
        drawInfo.foreColor = drawInfo.defaultColoring.getForeColor();
        drawInfo.backColor = drawInfo.defaultColoring.getBackColor();
        drawInfo.font = drawInfo.defaultColoring.getFont();
        drawInfo.bol = true;
        drawInfo.drawGraphics.init(drawInfo);
        drawInfo.drawGraphics.setDefaultBackColor(drawInfo.defaultColoring.getBackColor());
        drawInfo.drawGraphics.setLineHeight(drawInfo.lineHeight);
        drawInfo.drawGraphics.setLineAscent(drawInfo.editorUI.getLineAscent());
        drawInfo.drawGraphics.setX(drawInfo.x);
        drawInfo.drawGraphics.setY(drawInfo.y);
        drawInfo.layers = drawInfo.editorUI.getDrawLayerList().currentLayers();
        n = drawInfo.layers.length;
        drawInfo.layerActives = new boolean[n];
        drawInfo.layerActivityChangeOffsets = new int[n];
        int n2 = 0;
        while (n2 < n) {
            drawInfo.layers[n2].init(drawInfo);
            ++n2;
        }
        drawInfo.doc.op.renderMarks(drawInfo);
        drawInfo.drawMarkOffset = Integer.MAX_VALUE;
        if (drawInfo.rangeMarkCount > 0) {
            drawInfo.drawMark = drawInfo.rangeDrawMarkArray[drawInfo.drawMarkIndex];
            drawInfo.drawMarkOffset = drawInfo.rangeOffsetArray[drawInfo.drawMarkIndex++];
            if (drawInfo.drawMarkOffset < drawInfo.updateOffset) {
                drawInfo.updateOffset = drawInfo.drawMarkOffset;
                drawInfo.drawMarkUpdate = true;
            }
        }
        drawInfo.doc.op.prepareSyntax(drawInfo.slot, drawInfo.syntax, drawInfo.doc.op.getLeftSyntaxMark(drawInfo.startOffset), drawInfo.startOffset, drawInfo.endTokenMarkOffset - drawInfo.startOffset, false);
        drawInfo.slotArray = drawInfo.slot.array;
        drawInfo.buffer = drawInfo.slotArray;
        drawInfo.bufferStartOffset = drawInfo.startOffset - drawInfo.syntax.getOffset();
        drawInfo.drawGraphics.setBuffer(drawInfo.slotArray);
        drawInfo.continueDraw = true;
    }

    private void handleBOL(DrawInfo drawInfo) {
        if (drawInfo.lineNumbering) {
            if (drawInfo.syncedLineNumbering) {
                drawInfo.foreColor = drawInfo.lineNumberColoring.getForeColor();
                drawInfo.backColor = drawInfo.lineNumberColoring.getBackColor();
                drawInfo.font = drawInfo.lineNumberColoring.getFont();
                drawInfo.strikeThroughColor = null;
                drawInfo.underlineColor = null;
                int n = drawInfo.startLineNumber + drawInfo.lineIndex;
                int n2 = drawInfo.layers.length;
                int n3 = 0;
                while (n3 < n2) {
                    n = drawInfo.layers[n3].updateLineNumberContext(n, drawInfo);
                    ++n3;
                }
                int n4 = Math.max(drawInfo.lineNumberChars.length - 1, 0);
                do {
                    drawInfo.lineNumberChars[n4--] = (char)(48 + n % 10);
                } while ((n /= 10) != 0 && n4 >= 0);
                while (n4 >= 0) {
                    drawInfo.lineNumberChars[n4--] = 32;
                }
                int n5 = drawInfo.x - drawInfo.editorUI.lineNumberWidth;
                if (drawInfo.editorUI.lineNumberMargin != null) {
                    n5 += drawInfo.editorUI.lineNumberMargin.left;
                }
                drawInfo.drawGraphics.setX(n5);
                drawInfo.drawGraphics.setBuffer(drawInfo.lineNumberChars);
                drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.setFont(drawInfo.font);
                drawInfo.drawGraphics.drawChars(0, drawInfo.lineNumberChars.length, drawInfo.editorUI.lineNumberWidth, drawInfo.strikeThroughColor, drawInfo.underlineColor);
                if (drawInfo.drawGraphics.getGraphics() == null) {
                    drawInfo.drawGraphics.setBuffer(SPACE);
                    drawInfo.drawGraphics.drawChars(0, 1, drawInfo.editorUI.lineNumberDigitWidth, null, null);
                }
                drawInfo.drawGraphics.setX(drawInfo.x);
                drawInfo.drawGraphics.setBuffer(drawInfo.slotArray);
            } else {
                drawInfo.lineStartOffsets[drawInfo.lineIndex] = drawInfo.fragmentOffset;
            }
        }
        ++drawInfo.lineIndex;
    }

    private void handleEOL(DrawInfo drawInfo) {
        drawInfo.drawGraphics.eol();
        drawInfo.widestWidth = Math.max(drawInfo.widestWidth, drawInfo.x);
        drawInfo.visualColumn = 0;
        drawInfo.x = drawInfo.startX;
        drawInfo.y += drawInfo.lineHeight;
        drawInfo.drawGraphics.setX(drawInfo.x);
        drawInfo.drawGraphics.setY(drawInfo.y);
    }

    private void updateOffsetReached(DrawInfo drawInfo) {
        if (drawInfo.drawMarkUpdate) {
            int n = drawInfo.layers.length;
            int n2 = 0;
            while (n2 < n) {
                DrawLayer drawLayer = drawInfo.layers[n2];
                if (drawLayer.getName().equals(drawInfo.drawMark.layerName) && (drawInfo.drawMark.isDocumentMark() || drawInfo.editorUI == drawInfo.drawMark.getEditorUI())) {
                    int n3;
                    drawInfo.layerActives[n2] = drawLayer.isActive(drawInfo, drawInfo.drawMark);
                    drawInfo.layerActivityChangeOffsets[n2] = n3 = drawLayer.getNextActivityChangeOffset(drawInfo);
                    if (n3 > drawInfo.fragmentOffset && n3 < drawInfo.layerUpdateOffset) {
                        drawInfo.layerUpdateOffset = n3;
                    }
                }
                ++n2;
            }
            if (drawInfo.drawMarkIndex < drawInfo.rangeMarkCount) {
                drawInfo.drawMark = drawInfo.rangeDrawMarkArray[drawInfo.drawMarkIndex];
                drawInfo.drawMarkOffset = drawInfo.rangeOffsetArray[drawInfo.drawMarkIndex++];
            } else {
                drawInfo.drawMark = null;
                drawInfo.drawMarkOffset = Integer.MAX_VALUE;
            }
        } else {
            drawInfo.layerUpdateOffset = Integer.MAX_VALUE;
            int n = drawInfo.layers.length;
            int n4 = 0;
            while (n4 < n) {
                int n5 = drawInfo.layerActivityChangeOffsets[n4];
                if (n5 == drawInfo.fragmentOffset) {
                    DrawLayer drawLayer = drawInfo.layers[n4];
                    drawInfo.layerActives[n4] = drawLayer.isActive(drawInfo, null);
                    drawInfo.layerActivityChangeOffsets[n4] = n5 = drawLayer.getNextActivityChangeOffset(drawInfo);
                }
                if (n5 > drawInfo.fragmentOffset && n5 < drawInfo.layerUpdateOffset) {
                    drawInfo.layerUpdateOffset = n5;
                }
                ++n4;
            }
        }
        if (drawInfo.drawMarkOffset < drawInfo.layerUpdateOffset) {
            drawInfo.drawMarkUpdate = true;
            drawInfo.updateOffset = drawInfo.drawMarkOffset;
        } else {
            drawInfo.drawMarkUpdate = false;
            drawInfo.updateOffset = drawInfo.layerUpdateOffset;
        }
    }

    private void computeFragmentLength(DrawInfo drawInfo) {
        drawInfo.fragmentStartIndex = drawInfo.fragmentOffset - drawInfo.bufferStartOffset;
        drawInfo.fragmentLength = Math.min(drawInfo.updateOffset - drawInfo.fragmentOffset, drawInfo.tokenLength - drawInfo.drawnLength);
        int n = Analyzer.findFirstTabOrLF(drawInfo.slotArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
        drawInfo.eol = drawInfo.fragmentOffset == drawInfo.docLen;
        drawInfo.tabsFragment = false;
        if (n >= 0) {
            if (n == drawInfo.fragmentStartIndex) {
                if (drawInfo.slotArray[n] == '\t') {
                    drawInfo.tabsFragment = true;
                    int n2 = Analyzer.findFirstNonTab(drawInfo.slotArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
                    if (n2 != -1) {
                        drawInfo.fragmentLength = n2 - drawInfo.fragmentStartIndex;
                    }
                } else {
                    drawInfo.eol = true;
                    drawInfo.fragmentLength = 1;
                }
            } else {
                drawInfo.fragmentLength = n - drawInfo.fragmentStartIndex;
            }
        }
    }

    private void computeFragmentDisplayWidth(DrawInfo drawInfo) {
        if (!drawInfo.eol) {
            int n = drawInfo.layers.length;
            int n2 = 0;
            while (n2 < n) {
                DrawLayer drawLayer = drawInfo.layers[n2];
                if (drawInfo.layerActives[n2]) {
                    drawInfo.layers[n2].updateContext(drawInfo);
                }
                ++n2;
            }
        }
        FontMetricsCache.Info info = FontMetricsCache.getInfo(drawInfo.font);
        drawInfo.spaceWidth = drawInfo.component != null ? info.getSpaceWidth(drawInfo.component) : drawInfo.editorUI.defaultSpaceWidth;
        drawInfo.fragmentCharCount = drawInfo.fragmentLength;
        if (drawInfo.tabsFragment) {
            drawInfo.fragmentCharCount = Analyzer.getColumn(drawInfo.slotArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
            drawInfo.fragmentWidth = drawInfo.fragmentCharCount * drawInfo.spaceWidth;
        } else {
            drawInfo.fragmentWidth = drawInfo.eol ? drawInfo.spaceWidth : (drawInfo.fragmentLength > 0 ? (drawInfo.component != null ? FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.slotArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength) : drawInfo.fragmentLength * drawInfo.spaceWidth) : 0);
        }
    }

    private void drawFragment(DrawInfo drawInfo) {
        if (drawInfo.eol) {
            int n = drawInfo.layers.length;
            boolean bl = false;
            int n2 = drawInfo.fragmentWidth;
            do {
                int n3;
                n2 = 0;
                if (drawInfo.bol) {
                    if (!bl) {
                        n3 = 0;
                        while (n3 < n) {
                            DrawLayer drawLayer;
                            if (drawInfo.layerActives[n3] && (drawLayer = drawInfo.layers[n3]).extendsEmptyLine()) {
                                bl = true;
                                drawLayer.updateContext(drawInfo);
                            }
                            ++n3;
                        }
                        if (bl) {
                            n2 = drawInfo.spaceWidth / 2;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (!bl) {
                    n3 = 0;
                    int n4 = 0;
                    while (n4 < n) {
                        DrawLayer drawLayer;
                        if (drawInfo.layerActives[n4] && (drawLayer = drawInfo.layers[n4]).extendsEOL()) {
                            n3 = 1;
                            drawLayer.updateContext(drawInfo);
                        }
                        ++n4;
                    }
                    if (n3 != 0 && drawInfo.component != null) {
                        n2 = drawInfo.component.getWidth();
                    }
                }
                if (n2 <= 0) continue;
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.fillRect(n2);
                if (!bl) continue;
                drawInfo.x += n2;
            } while (bl);
        } else {
            drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
            drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
            drawInfo.drawGraphics.setFont(drawInfo.font);
            if (drawInfo.tabsFragment) {
                drawInfo.drawGraphics.drawTabs(drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.fragmentCharCount, drawInfo.fragmentWidth, drawInfo.strikeThroughColor, drawInfo.underlineColor);
            } else {
                drawInfo.drawGraphics.drawChars(drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.fragmentWidth, drawInfo.strikeThroughColor, drawInfo.underlineColor);
            }
        }
    }

    private void checkTargetOffsetReached(DrawInfo drawInfo) {
        drawInfo.continueDraw = true;
        if (drawInfo.eol && (drawInfo.targetOffset == drawInfo.fragmentOffset || drawInfo.targetOffset == -1)) {
            char c = '\n';
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset, c, drawInfo.x, drawInfo.spaceWidth, drawInfo);
        } else if (drawInfo.targetOffset == -1 && drawInfo.fragmentLength > 0) {
            int n;
            int n2;
            int n3;
            int n4;
            FontMetrics fontMetrics = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component);
            int n5 = -1;
            int n6 = n4 = drawInfo.fragmentLength - 1;
            if (drawInfo.tabsFragment) {
                n3 = Analyzer.getColumn(drawInfo.slotArray, drawInfo.fragmentStartIndex, n4, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n2 = n3 * drawInfo.spaceWidth;
            } else {
                n2 = fontMetrics.charsWidth(drawInfo.slotArray, drawInfo.fragmentStartIndex, n4);
            }
            if (drawInfo.tabsFragment) {
                n = Analyzer.getColumn(drawInfo.slotArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n3 = n * drawInfo.spaceWidth;
            } else {
                n3 = fontMetrics.charsWidth(drawInfo.slotArray, drawInfo.fragmentStartIndex, drawInfo.fragmentLength);
            }
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n4, drawInfo.slotArray[drawInfo.fragmentStartIndex + n4], drawInfo.x + n2, n3 - n2, drawInfo);
            if (!drawInfo.continueDraw) {
                while (n5 <= n4) {
                    int n7;
                    n = (n5 + n4) / 2;
                    int n8 = 0;
                    if (n == n6 + 1) {
                        n8 = n3;
                    } else if (drawInfo.tabsFragment) {
                        n7 = Analyzer.getColumn(drawInfo.slotArray, drawInfo.fragmentStartIndex, n, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                        n8 = n7 * drawInfo.spaceWidth;
                    } else {
                        n8 = fontMetrics.charsWidth(drawInfo.slotArray, drawInfo.fragmentStartIndex, n);
                    }
                    n7 = 0;
                    if (n == n6 - 1) {
                        n7 = n2;
                    } else if (drawInfo.tabsFragment) {
                        int n9 = Analyzer.getColumn(drawInfo.slotArray, drawInfo.fragmentStartIndex, n + 1, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                        n7 = n9 * drawInfo.spaceWidth;
                    } else {
                        n7 = fontMetrics.charsWidth(drawInfo.slotArray, drawInfo.fragmentStartIndex, n + 1);
                    }
                    n2 = n8;
                    n3 = n7;
                    n6 = n;
                    drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n, drawInfo.slotArray[drawInfo.fragmentStartIndex + n], drawInfo.x + n8, n7 - n8, drawInfo);
                    if (drawInfo.continueDraw) {
                        n5 = n + 1;
                        continue;
                    }
                    if (n > n5 + 1) {
                        n4 = n;
                        continue;
                    }
                    break;
                }
            }
        } else if (drawInfo.targetOffset < drawInfo.fragmentOffset + drawInfo.fragmentLength && drawInfo.fragmentOffset <= drawInfo.targetOffset) {
            int n;
            int n10;
            int n11 = 0;
            int n12 = drawInfo.targetOffset - drawInfo.fragmentOffset;
            if (n12 > 0) {
                if (drawInfo.tabsFragment) {
                    n10 = Analyzer.getColumn(drawInfo.slotArray, drawInfo.fragmentStartIndex, n12, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                    n11 = n10 * drawInfo.spaceWidth;
                } else {
                    n11 = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.slotArray, drawInfo.fragmentStartIndex, n12);
                }
            }
            if (drawInfo.tabsFragment) {
                n10 = Analyzer.getColumn(drawInfo.slotArray, drawInfo.fragmentStartIndex, n12 + 1, drawInfo.tabSize, drawInfo.visualColumn) - drawInfo.visualColumn;
                n = n10 * drawInfo.spaceWidth;
            } else {
                n = FontMetricsCache.getFontMetrics(drawInfo.font, drawInfo.component).charsWidth(drawInfo.slotArray, drawInfo.fragmentStartIndex, n12 + 1);
            }
            drawInfo.continueDraw = drawInfo.drawGraphics.targetOffsetReached(drawInfo.fragmentOffset + n12, drawInfo.slotArray[drawInfo.fragmentStartIndex + n12], drawInfo.x + n11, n - n11, drawInfo);
        }
    }

    private void drawCurrentTokenFragment(DrawInfo drawInfo) {
        drawInfo.foreColor = drawInfo.defaultColoring.getForeColor();
        drawInfo.backColor = drawInfo.defaultColoring.getBackColor();
        drawInfo.font = drawInfo.defaultColoring.getFont();
        drawInfo.strikeThroughColor = null;
        drawInfo.underlineColor = null;
        if (drawInfo.bol) {
            this.handleBOL(drawInfo);
        }
        while (drawInfo.fragmentOffset == drawInfo.updateOffset) {
            this.updateOffsetReached(drawInfo);
        }
        this.computeFragmentLength(drawInfo);
        this.computeFragmentDisplayWidth(drawInfo);
        this.drawFragment(drawInfo);
        if (debugFragment) {
            System.err.println("DrawEngine:   FRAGMENT='" + EditorDebug.debugChars(drawInfo.buffer, drawInfo.fragmentStartIndex, drawInfo.fragmentLength) + "', at pos=" + drawInfo.fragmentOffset + ", bol=" + drawInfo.bol + ", eol=" + drawInfo.eol);
        }
        if (drawInfo.component != null) {
            this.checkTargetOffsetReached(drawInfo);
        }
        drawInfo.fragmentOffset += drawInfo.fragmentLength;
        drawInfo.drawnLength += drawInfo.fragmentLength;
        drawInfo.visualColumn += drawInfo.fragmentCharCount;
        drawInfo.x += drawInfo.fragmentWidth;
        drawInfo.bol = false;
        if (drawInfo.eol) {
            this.handleEOL(drawInfo);
            drawInfo.bol = true;
        }
        if (drawInfo.fragmentOffset >= drawInfo.endOffset && drawInfo.endOffset < drawInfo.docLen) {
            drawInfo.continueDraw = false;
        }
    }

    private void drawCurrentToken(DrawInfo drawInfo) {
        if (drawInfo.tokenID != null) {
            drawInfo.tokenContextPath = drawInfo.syntax.getTokenContextPath();
            drawInfo.tokenOffset = drawInfo.syntax.getTokenOffset() + drawInfo.bufferStartOffset;
            drawInfo.tokenLength = drawInfo.syntax.getTokenLength();
            if (drawInfo.tokenOffset + drawInfo.tokenLength <= drawInfo.startOffset) {
                return;
            }
        } else {
            drawInfo.tokenContextPath = null;
            drawInfo.tokenOffset = drawInfo.fragmentOffset;
            drawInfo.tokenLength = 0;
        }
        if (drawInfo.tokenOffset <= drawInfo.startOffset) {
            drawInfo.layerUpdateOffset = Integer.MAX_VALUE;
            int n = drawInfo.layers.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                DrawLayer drawLayer = drawInfo.layers[n2];
                drawInfo.layerActives[n2] = drawLayer.isActive(drawInfo, null);
                drawInfo.layerActivityChangeOffsets[n2] = n3 = drawLayer.getNextActivityChangeOffset(drawInfo);
                if (n3 > drawInfo.fragmentOffset && n3 < drawInfo.layerUpdateOffset) {
                    drawInfo.layerUpdateOffset = n3;
                }
                ++n2;
            }
            drawInfo.updateOffset = Math.min(drawInfo.layerUpdateOffset, drawInfo.drawMarkOffset);
        }
        drawInfo.drawnLength = drawInfo.fragmentOffset - drawInfo.tokenOffset;
        drawInfo.fragmentLength = 0;
        if (debug) {
            System.err.println("DrawEngine: TOKEN='" + EditorDebug.debugChars(drawInfo.getBuffer(), drawInfo.getTokenOffset() - drawInfo.getBufferStartOffset(), drawInfo.getTokenLength()) + "', tokenID=<" + (drawInfo.getTokenID() == null ? "null" : drawInfo.tokenID.getName()) + ">, tcp=" + drawInfo.getTokenContextPath() + ", pos=" + drawInfo.getTokenOffset());
        }
        do {
            this.drawCurrentTokenFragment(drawInfo);
        } while (drawInfo.continueDraw && drawInfo.drawnLength < drawInfo.tokenLength);
    }

    private void graphicsSpecificUpdates(DrawInfo drawInfo) {
        Rectangle rectangle = drawInfo.editorUI.getExtentBounds();
        Rectangle rectangle2 = drawInfo.graphics.getClipBounds();
        Insets insets = drawInfo.editorUI.getTextMargin();
        int n = insets.left - drawInfo.editorUI.lineNumberWidth - drawInfo.editorUI.textLeftMarginWidth;
        if (drawInfo.lineNumbering && !drawInfo.syncedLineNumbering) {
            Color color = drawInfo.lineNumberColoring.getBackColor();
            int n2 = drawInfo.startY;
            int n3 = rectangle.x + n;
            if (!color.equals(drawInfo.defaultColoring.getBackColor()) || rectangle.x > 0) {
                drawInfo.graphics.setColor(color);
                drawInfo.graphics.fillRect(n3, n2, drawInfo.editorUI.lineNumberWidth, drawInfo.lineIndex * drawInfo.lineHeight);
            }
            drawInfo.drawGraphics.setDefaultBackColor(color);
            int n4 = Math.max(drawInfo.lineNumberChars.length - 1, 0);
            int n5 = n3;
            if (drawInfo.editorUI.lineNumberMargin != null) {
                n5 += drawInfo.editorUI.lineNumberMargin.left;
            }
            drawInfo.bol = true;
            int n6 = 0;
            while (n6 < drawInfo.lineIndex) {
                drawInfo.fragmentOffset = drawInfo.lineStartOffsets[n6];
                drawInfo.foreColor = drawInfo.lineNumberColoring.getForeColor();
                drawInfo.backColor = color;
                drawInfo.font = drawInfo.lineNumberColoring.getFont();
                drawInfo.strikeThroughColor = null;
                drawInfo.underlineColor = null;
                int n7 = drawInfo.startLineNumber + n6;
                int n8 = drawInfo.layers.length;
                int n9 = 0;
                while (n9 < n8) {
                    n7 = drawInfo.layers[n9].updateLineNumberContext(n7, drawInfo);
                    ++n9;
                }
                int n10 = n4;
                do {
                    drawInfo.lineNumberChars[n10--] = (char)(48 + n7 % 10);
                } while ((n7 /= 10) != 0 && n10 >= 0);
                while (n10 >= 0) {
                    drawInfo.lineNumberChars[n10--] = 32;
                }
                drawInfo.drawGraphics.setY(n2);
                drawInfo.drawGraphics.setBuffer(drawInfo.lineNumberChars);
                drawInfo.drawGraphics.setForeColor(drawInfo.foreColor);
                drawInfo.drawGraphics.setBackColor(drawInfo.backColor);
                drawInfo.drawGraphics.setFont(drawInfo.font);
                drawInfo.drawGraphics.setX(n3);
                drawInfo.drawGraphics.fillRect(drawInfo.editorUI.lineNumberWidth);
                drawInfo.drawGraphics.setX(n5);
                drawInfo.drawGraphics.drawChars(0, drawInfo.lineNumberChars.length, drawInfo.lineNumberChars.length * drawInfo.editorUI.lineNumberDigitWidth, drawInfo.strikeThroughColor, drawInfo.underlineColor);
                drawInfo.drawGraphics.setBuffer(null);
                n2 += drawInfo.lineHeight;
                ++n6;
            }
        }
        drawInfo.graphics.setColor(drawInfo.defaultColoring.getBackColor());
        if (n > 0 && rectangle.x > 0) {
            drawInfo.graphics.fillRect(rectangle.x, drawInfo.startY, n, drawInfo.lineIndex * drawInfo.lineHeight);
        }
        if (drawInfo.editorUI.textLeftMarginWidth > 0 && rectangle.x > 0) {
            drawInfo.graphics.fillRect(rectangle.x + insets.left - drawInfo.editorUI.textLeftMarginWidth, drawInfo.startY, drawInfo.editorUI.textLeftMarginWidth, drawInfo.lineIndex * drawInfo.lineHeight);
        }
        if (insets.right > 0) {
            drawInfo.graphics.fillRect(rectangle.x + rectangle.width - insets.right, drawInfo.startY, insets.right, drawInfo.lineIndex * drawInfo.lineHeight);
        }
        if (insets.top > 0 && rectangle2.y < rectangle.y + insets.top) {
            drawInfo.graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, insets.top);
        }
        int n11 = rectangle.y + rectangle.height - insets.bottom;
        if (insets.bottom > 0 && rectangle2.y + rectangle2.height > n11) {
            drawInfo.graphics.fillRect(rectangle.x, n11, rectangle.width, insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draw(DrawGraphics drawGraphics, EditorUI editorUI, int n, int n2, int n3, int n4, int n5) throws BadLocationException {
        if (n < 0 || n2 < 0 || n > n2 || n3 < 0 || n4 < 0) {
            return;
        }
        if (debug) {
            System.err.println("DrawEngine:------------------ DRAWING ------------------------");
        }
        DrawInfo drawInfo = new DrawInfo();
        drawInfo.drawGraphics = drawGraphics;
        drawInfo.editorUI = editorUI;
        drawInfo.startOffset = n;
        drawInfo.endOffset = n2;
        drawInfo.startX = n3;
        drawInfo.startY = n4;
        drawInfo.targetOffset = n5;
        EditorUI editorUI2 = editorUI;
        synchronized (editorUI2) {
            drawInfo.doc = editorUI.getDocument();
            if (drawInfo.doc == null) {
                return;
            }
            drawInfo.slot = SyntaxSeg.getFreeSlot();
            drawInfo.syntax = drawInfo.doc.getFreeSyntax();
            drawInfo.doc.readLock();
            try {
                block15: {
                    drawInfo.component = editorUI.getComponent();
                    drawInfo.docLen = drawInfo.doc.getLength();
                    if (drawInfo.startOffset > drawInfo.docLen) break block15;
                    if (drawInfo.endOffset <= drawInfo.docLen) break block16;
                }
                Object var11_10 = null;
                drawInfo.drawGraphics.setBuffer(null);
                drawInfo.drawGraphics.finish();
                drawInfo.doc.releaseSyntax(drawInfo.syntax);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                drawInfo.drawGraphics.setBuffer(null);
                drawInfo.drawGraphics.finish();
                drawInfo.doc.releaseSyntax(drawInfo.syntax);
                SyntaxSeg.releaseSlot(drawInfo.slot);
                drawInfo.doc.readUnlock();
                throw throwable;
            }
            SyntaxSeg.releaseSlot(drawInfo.slot);
            drawInfo.doc.readUnlock();
            {
                block16: {
                    return;
                }
                if (drawInfo.endOffset < drawInfo.docLen) {
                    ++drawInfo.endOffset;
                }
                this.initInfo(drawInfo);
                do {
                    drawInfo.tokenID = drawInfo.syntax.nextToken();
                    this.drawCurrentToken(drawInfo);
                } while (drawInfo.continueDraw && drawInfo.tokenID != null);
                drawInfo.editorUI.updateVirtualWidth(drawInfo.widestWidth + drawInfo.editorUI.lineNumberWidth + 2 * drawInfo.editorUI.defaultSpaceWidth);
                if (drawInfo.graphics != null) {
                    this.graphicsSpecificUpdates(drawInfo);
                }
            }
            Object var11_11 = null;
            drawInfo.drawGraphics.setBuffer(null);
            drawInfo.drawGraphics.finish();
            drawInfo.doc.releaseSyntax(drawInfo.syntax);
            SyntaxSeg.releaseSlot(drawInfo.slot);
            drawInfo.doc.readUnlock();
        }
    }

    static {
        SPACE = new char[]{' '};
    }

    class DrawInfo
    extends DocMarks.Renderer
    implements DrawContext {
        Color foreColor;
        Color backColor;
        Color underlineColor;
        Color strikeThroughColor;
        Font font;
        int startOffset;
        int endOffset;
        boolean bol;
        boolean eol;
        EditorUI editorUI;
        char[] buffer;
        int bufferStartOffset;
        TokenID tokenID;
        TokenContextPath tokenContextPath;
        int tokenOffset;
        int tokenLength;
        int fragmentOffset;
        int fragmentLength;
        DrawGraphics drawGraphics;
        int targetOffset;
        SyntaxSeg.Slot slot;
        char[] slotArray;
        Syntax syntax;
        JTextComponent component;
        BaseDocument doc;
        int docLen;
        int visualColumn;
        int x;
        int y;
        int startX;
        int startY;
        int lineHeight;
        Coloring defaultColoring;
        int tabSize;
        int widestWidth;
        boolean continueDraw;
        int startLineNumber;
        int lineIndex;
        int[] lineStartOffsets;
        char[] lineNumberChars;
        Coloring lineNumberColoring;
        Graphics graphics;
        boolean lineNumbering;
        boolean syncedLineNumbering;
        DrawLayer[] layers;
        boolean[] layerActives;
        int[] layerActivityChangeOffsets;
        int updateOffset;
        int layerUpdateOffset;
        boolean drawMarkUpdate;
        int drawMarkIndex;
        MarkFactory.DrawMark drawMark;
        int drawMarkOffset;
        int drawnLength;
        int fragmentStartIndex;
        boolean tabsFragment;
        int spaceWidth;
        int fragmentWidth;
        int fragmentCharCount;
        int endTokenMarkOffset;
        MarkFactory.DrawMark[] rangeDrawMarkArray = new MarkFactory.DrawMark[20];
        int[] rangeOffsetArray = new int[20];
        int rangeMarkCount;

        DrawInfo() {
        }

        public Color getForeColor() {
            return this.foreColor;
        }

        public void setForeColor(Color color) {
            this.foreColor = color;
        }

        public Color getBackColor() {
            return this.backColor;
        }

        public void setBackColor(Color color) {
            this.backColor = color;
        }

        public Color getUnderlineColor() {
            return this.underlineColor;
        }

        public void setUnderlineColor(Color color) {
            this.underlineColor = color;
        }

        public Color getStrikeThroughColor() {
            return this.strikeThroughColor;
        }

        public void setStrikeThroughColor(Color color) {
            this.strikeThroughColor = color;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public boolean isBOL() {
            return this.bol;
        }

        public boolean isEOL() {
            return this.eol;
        }

        public EditorUI getEditorUI() {
            return this.editorUI;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public int getBufferStartOffset() {
            return this.bufferStartOffset;
        }

        public TokenID getTokenID() {
            return this.tokenID;
        }

        public TokenContextPath getTokenContextPath() {
            return this.tokenContextPath;
        }

        public int getTokenOffset() {
            return this.tokenOffset;
        }

        public int getTokenLength() {
            return this.tokenLength;
        }

        public int getFragmentOffset() {
            return this.fragmentOffset;
        }

        public int getFragmentLength() {
            return this.fragmentLength;
        }

        public void render() {
            Object object;
            Mark mark;
            Mark mark2 = this.getMarks().getLeftMark(this.startOffset, null);
            this.rangeMarkCount = 0;
            Mark[] markArray = this.getMarkArray();
            int n = this.getMarkIndex(mark2);
            int n2 = this.getMarkOffset(mark2);
            while (n2 < this.startOffset) {
                if ((n = this.getNextIndex(n)) >= this.getMarkArrayLength()) break;
                mark2 = markArray[n];
                n2 = this.getMarkOffset(mark2);
            }
            while (n2 <= this.endOffset) {
                if (mark2 instanceof MarkFactory.DrawMark && !((MarkFactory.DrawMark)(mark = (MarkFactory.DrawMark)mark2)).removeInvalid()) {
                    if (this.rangeOffsetArray.length < this.rangeMarkCount + 1) {
                        object = new MarkFactory.DrawMark[2 * this.rangeDrawMarkArray.length];
                        System.arraycopy(this.rangeDrawMarkArray, 0, object, 0, this.rangeMarkCount);
                        this.rangeDrawMarkArray = object;
                        int[] nArray = new int[((MarkFactory.DrawMark[])object).length];
                        System.arraycopy(this.rangeOffsetArray, 0, nArray, 0, this.rangeMarkCount);
                        this.rangeOffsetArray = nArray;
                    }
                    this.rangeDrawMarkArray[this.rangeMarkCount] = (MarkFactory.DrawMark)mark2;
                    this.rangeOffsetArray[this.rangeMarkCount++] = n2;
                }
                if ((n = this.getNextIndex(n)) >= this.getMarkArrayLength()) break;
                mark2 = markArray[n];
                n2 = this.getMarkOffset(mark2);
            }
            this.endTokenMarkOffset = this.docLen;
            while (true) {
                if (mark2 instanceof MarkFactory.SyntaxMark) {
                    mark = (MarkFactory.SyntaxMark)mark2;
                    object = ((MarkFactory.SyntaxMark)mark).getStateInfo();
                    if (object == null) {
                        block10: {
                            try {
                                this.doc.op.prepareSyntax(this.slot, this.syntax, this.doc.op.getLeftSyntaxMark(this.startOffset), this.startOffset, n2 - this.startOffset, true);
                            }
                            catch (BadLocationException badLocationException) {
                                if (System.getProperty("netbeans.debug.exceptions") == null) break block10;
                                badLocationException.printStackTrace();
                            }
                        }
                        object = ((MarkFactory.SyntaxMark)mark).getStateInfo();
                    }
                    if (n2 - object.getPreScan() > this.endOffset) {
                        this.endTokenMarkOffset = n2;
                        break;
                    }
                }
                if ((n = this.getNextIndex(n)) >= this.getMarkArrayLength()) break;
                mark2 = markArray[n];
                n2 = this.getMarkOffset(mark2);
            }
        }
    }
}

