/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import org.netbeans.editor.Acceptor;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Finder;

public class FinderFactory {

    public static interface BlocksFinder
    extends Finder {
        public void setBlocks(int[] var1);

        public int[] getBlocks();
    }

    public static interface StringFinder
    extends Finder {
        public int getFoundLength();
    }

    public static final class WholeWordsBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;
        BaseDocument doc;

        public WholeWordsBlocksFinder(BaseDocument baseDocument, String string, boolean bl) {
            this.doc = baseDocument;
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.firstCharWordPart = baseDocument.isIdentifierPart(this.chars[0]);
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            int n7 = n5 - n - 1;
            while (n6 >= n2 && n6 < n3) {
                int n8;
                char c = cArray[n6];
                if (!this.matchCase) {
                    c = Character.toLowerCase(c);
                }
                if (this.wordFound) {
                    if (this.doc.isIdentifierPart(c)) {
                        this.insideWord = this.firstCharWordPart;
                        n6 -= this.chars.length - 1;
                    } else {
                        n8 = n + n6;
                        this.addBlock(n8 - this.chars.length, n8);
                        this.insideWord = false;
                        ++n6;
                    }
                    this.wordFound = false;
                    this.stringInd = 0;
                    continue;
                }
                if (this.stringInd == 0) {
                    if (c != this.chars[0] || this.insideWord) {
                        this.insideWord = this.doc.isIdentifierPart(c);
                        ++n6;
                        continue;
                    }
                    this.stringInd = 1;
                    if (this.chars.length == 1) {
                        if (n6 == n7) {
                            n8 = n + n6;
                            this.addBlock(n8, n8 + 1);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++n6;
                    continue;
                }
                if (c == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        if (n6 == n7) {
                            n8 = n + 1;
                            this.addBlock(n8 - this.stringInd, n8);
                        } else {
                            this.wordFound = true;
                        }
                    }
                    ++n6;
                    continue;
                }
                n6 += 1 - this.stringInd;
                this.stringInd = 0;
                this.insideWord = this.firstCharWordPart;
            }
            n4 = n + n6;
            return n4;
        }
    }

    public static final class StringBlocksFinder
    extends AbstractBlocksFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public StringBlocksFinder(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
        }

        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (n6 >= n2 && n6 < n3) {
                char c = cArray[n6];
                if (!this.matchCase) {
                    c = Character.toLowerCase(c);
                }
                if (c == this.chars[this.stringInd]) {
                    ++this.stringInd;
                    if (this.stringInd == this.chars.length) {
                        int n7 = n + n6 + 1;
                        this.addBlock(n7 - this.stringInd, n7);
                        this.stringInd = 0;
                    }
                    ++n6;
                    continue;
                }
                n6 += 1 - this.stringInd;
                this.stringInd = 0;
            }
            n4 = n + n6;
            return n4;
        }
    }

    public static final class FalseBlocksFinder
    extends AbstractBlocksFinder {
        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            return -1;
        }
    }

    public static abstract class AbstractBlocksFinder
    extends AbstractFinder
    implements BlocksFinder {
        private static int[] EMPTY_INT_ARRAY = new int[0];
        private int[] blocks = EMPTY_INT_ARRAY;
        private int blocksInd;
        private boolean closed;

        public void reset() {
            this.blocksInd = 0;
            this.closed = false;
        }

        public int[] getBlocks() {
            if (!this.closed) {
                this.closeBlocks();
                this.closed = true;
            }
            return this.blocks;
        }

        public void setBlocks(int[] nArray) {
            this.blocks = nArray;
            this.closed = false;
        }

        protected void addBlock(int n, int n2) {
            if (this.blocksInd == this.blocks.length) {
                int[] nArray = new int[this.blocks.length * 2];
                System.arraycopy(this.blocks, 0, nArray, 0, this.blocks.length);
                this.blocks = nArray;
            }
            this.blocks[this.blocksInd++] = n;
            this.blocks[this.blocksInd++] = n2;
        }

        protected void closeBlocks() {
            this.addBlock(-1, -1);
        }

        public String debugBlocks() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (this.blocks[n] != -1) {
                stringBuffer.append(n / 2 + 1 + ": [" + this.blocks[n] + ", " + this.blocks[n + 1] + "]\n");
                n += 2;
            }
            return stringBuffer.toString();
        }
    }

    public static final class WholeWordsBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        boolean insideWord;
        boolean lastCharWordPart;
        boolean wordFound;
        int endInd;
        BaseDocument doc;

        public WholeWordsBwdFinder(BaseDocument baseDocument, String string, boolean bl) {
            this.doc = baseDocument;
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
            baseDocument.isIdentifierPart(this.chars[this.endInd]);
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = this.endInd;
        }

        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (this.wordFound) {
                if (this.doc.isIdentifierPart(c)) {
                    this.wordFound = false;
                    this.insideWord = this.lastCharWordPart;
                    this.stringInd = this.endInd;
                    return this.endInd;
                }
                this.found = true;
                return 1;
            }
            if (this.stringInd == this.endInd) {
                if (c != this.chars[this.endInd] || this.insideWord) {
                    this.insideWord = this.doc.isIdentifierPart(c);
                    return -1;
                }
                this.stringInd = this.endInd - 1;
                if (this.chars.length == 1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            if (c == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return -1;
                }
                return -1;
            }
            int n = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            this.insideWord = this.lastCharWordPart;
            return n;
        }
    }

    public static final class WholeWordsFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        BaseDocument doc;
        boolean insideWord;
        boolean firstCharWordPart;
        boolean wordFound;

        public WholeWordsFwdFinder(BaseDocument baseDocument, String string, boolean bl) {
            this.doc = baseDocument;
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.firstCharWordPart = baseDocument.isIdentifierPart(this.chars[0]);
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.insideWord = false;
            this.wordFound = false;
            this.stringInd = 0;
        }

        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (this.wordFound) {
                if (this.doc.isIdentifierPart(c)) {
                    this.wordFound = false;
                    this.insideWord = this.firstCharWordPart;
                    this.stringInd = 0;
                    return 1 - this.chars.length;
                }
                this.found = true;
                return -this.chars.length;
            }
            if (this.stringInd == 0) {
                if (c != this.chars[0] || this.insideWord) {
                    this.insideWord = this.doc.isIdentifierPart(c);
                    return 1;
                }
                this.stringInd = 1;
                if (this.chars.length == 1) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            if (c == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    if (bl) {
                        this.found = true;
                        return 1 - this.chars.length;
                    }
                    this.wordFound = true;
                    return 1;
                }
                return 1;
            }
            int n = 1 - this.stringInd;
            this.stringInd = 0;
            this.insideWord = this.firstCharWordPart;
            return n;
        }
    }

    public static class StringBwdFinder
    extends GenericBwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;
        int endInd;

        public StringBwdFinder(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
            this.endInd = this.chars.length - 1;
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.stringInd = this.endInd;
        }

        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (c == this.chars[this.stringInd]) {
                --this.stringInd;
                if (this.stringInd == -1) {
                    this.found = true;
                    return 0;
                }
                return -1;
            }
            if (this.stringInd == this.endInd) {
                return -1;
            }
            int n = this.chars.length - 2 - this.stringInd;
            this.stringInd = this.endInd;
            return n;
        }
    }

    public static final class StringFwdFinder
    extends GenericFwdFinder
    implements StringFinder {
        char[] chars;
        int stringInd;
        boolean matchCase;

        public StringFwdFinder(String string, boolean bl) {
            this.matchCase = bl;
            this.chars = (bl ? string : string.toLowerCase()).toCharArray();
        }

        public int getFoundLength() {
            return this.chars.length;
        }

        public void reset() {
            super.reset();
            this.stringInd = 0;
        }

        protected int scan(char c, boolean bl) {
            if (!this.matchCase) {
                c = Character.toLowerCase(c);
            }
            if (c == this.chars[this.stringInd]) {
                ++this.stringInd;
                if (this.stringInd == this.chars.length) {
                    this.found = true;
                    return 1 - this.stringInd;
                }
                return 1;
            }
            if (this.stringInd == 0) {
                return 1;
            }
            int n = 1 - this.stringInd;
            this.stringInd = 0;
            return n;
        }
    }

    public static class NonWhiteBwdFinder
    extends GenericBwdFinder {
        BaseDocument doc;
        private char foundChar;

        public NonWhiteBwdFinder(BaseDocument baseDocument) {
            this.doc = baseDocument;
        }

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char c, boolean bl) {
            if (!this.doc.isWhitespace(c)) {
                this.found = true;
                this.foundChar = c;
                return 0;
            }
            return -1;
        }
    }

    public static class NonWhiteFwdFinder
    extends GenericFwdFinder {
        BaseDocument doc;
        private char foundChar;

        public NonWhiteFwdFinder(BaseDocument baseDocument) {
            this.doc = baseDocument;
        }

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char c, boolean bl) {
            if (!this.doc.isWhitespace(c)) {
                this.found = true;
                this.foundChar = c;
                return 0;
            }
            return 1;
        }
    }

    public static class WhiteBwdFinder
    extends GenericBwdFinder {
        BaseDocument doc;
        private char foundChar;

        public WhiteBwdFinder(BaseDocument baseDocument) {
            this.doc = baseDocument;
        }

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char c, boolean bl) {
            if (this.doc.isWhitespace(c)) {
                this.found = true;
                this.foundChar = c;
                return 0;
            }
            return -1;
        }
    }

    public static class WhiteFwdFinder
    extends GenericFwdFinder {
        BaseDocument doc;
        private char foundChar;

        public WhiteFwdFinder(BaseDocument baseDocument) {
            this.doc = baseDocument;
        }

        public char getFoundChar() {
            return this.foundChar;
        }

        protected int scan(char c, boolean bl) {
            if (this.doc.isWhitespace(c)) {
                this.found = true;
                this.foundChar = c;
                return 0;
            }
            return 1;
        }
    }

    public static class PreviousWordBwdFinder
    extends GenericBwdFinder {
        BaseDocument doc;
        boolean inIdentifier;
        boolean inPunct;
        boolean stopOnEOL;
        boolean stopOnWhitespace;
        boolean firstChar;

        public PreviousWordBwdFinder(BaseDocument baseDocument, boolean bl, boolean bl2) {
            this.doc = baseDocument;
            this.stopOnEOL = bl;
            this.stopOnWhitespace = bl2;
        }

        public void reset() {
            super.reset();
            this.inIdentifier = false;
            this.inPunct = false;
            this.firstChar = true;
        }

        protected int scan(char c, boolean bl) {
            if (this.stopOnEOL) {
                if (c == '\n') {
                    this.found = true;
                    return this.firstChar ? 0 : 1;
                }
                this.firstChar = false;
            }
            if (this.inIdentifier) {
                if (this.doc.isIdentifierPart(c)) {
                    if (bl) {
                        this.found = true;
                        return 0;
                    }
                    return -1;
                }
                this.found = true;
                return 1;
            }
            if (this.inPunct) {
                if (this.doc.isIdentifierPart(c) || this.doc.isWhitespace(c) || bl) {
                    this.found = true;
                    return 1;
                }
                return -1;
            }
            if (this.doc.isWhitespace(c)) {
                if (this.stopOnWhitespace) {
                    this.found = true;
                    return 1;
                }
                return -1;
            }
            if (this.doc.isIdentifierPart(c)) {
                this.inIdentifier = true;
                if (bl) {
                    this.found = true;
                    return 0;
                }
                return -1;
            }
            this.inPunct = true;
            return -1;
        }
    }

    public static class NextWordFwdFinder
    extends GenericFwdFinder {
        BaseDocument doc;
        boolean inWhitespace;
        boolean inIdentifier;
        boolean inPunct;
        boolean firstChar;
        boolean stopOnEOL;
        boolean stopOnWhitespace;

        public NextWordFwdFinder(BaseDocument baseDocument, boolean bl, boolean bl2) {
            this.doc = baseDocument;
            this.stopOnEOL = bl;
            this.stopOnWhitespace = bl2;
        }

        public void reset() {
            super.reset();
            this.inWhitespace = false;
            this.inIdentifier = false;
            this.inPunct = false;
            this.firstChar = true;
        }

        protected int scan(char c, boolean bl) {
            if (this.stopOnEOL) {
                if (c == '\n') {
                    this.found = true;
                    return this.firstChar ? 1 : 0;
                }
                this.firstChar = false;
            }
            if (this.doc.isWhitespace(c)) {
                if (this.stopOnWhitespace) {
                    this.found = true;
                    return 0;
                }
                this.inWhitespace = true;
                return 1;
            }
            if (this.inWhitespace) {
                this.found = true;
                return 0;
            }
            if (this.inIdentifier) {
                if (this.doc.isIdentifierPart(c)) {
                    return 1;
                }
                this.found = true;
                return 0;
            }
            if (this.inPunct) {
                if (this.doc.isIdentifierPart(c)) {
                    this.found = true;
                    return 0;
                }
                return 1;
            }
            if (this.doc.isIdentifierPart(c)) {
                this.inIdentifier = true;
                return 1;
            }
            this.inPunct = true;
            return 1;
        }
    }

    public static class AcceptorBwdFinder
    extends GenericBwdFinder {
        Acceptor a;

        public AcceptorBwdFinder(Acceptor acceptor) {
            this.a = acceptor;
        }

        protected int scan(char c, boolean bl) {
            if (!this.a.accept(c)) {
                this.found = true;
                return 0;
            }
            return -1;
        }
    }

    public static class CharArrayBwdFinder
    extends GenericBwdFinder {
        char[] searchChars;
        char foundChar;

        public CharArrayBwdFinder(char[] cArray) {
            this.searchChars = cArray;
        }

        protected int scan(char c, boolean bl) {
            int n = 0;
            while (n < this.searchChars.length) {
                if (c == this.searchChars[n]) {
                    this.foundChar = this.searchChars[n];
                    this.found = true;
                    return 0;
                }
                ++n;
            }
            return -1;
        }

        public char getFoundChar() {
            return this.foundChar;
        }
    }

    public static class AcceptorFwdFinder
    extends GenericFwdFinder {
        Acceptor a;

        public AcceptorFwdFinder(Acceptor acceptor) {
            this.a = acceptor;
        }

        protected int scan(char c, boolean bl) {
            if (!this.a.accept(c)) {
                this.found = true;
                return 0;
            }
            return 1;
        }
    }

    public static class CharArrayFwdFinder
    extends GenericFwdFinder {
        char[] searchChars;
        char foundChar;

        public CharArrayFwdFinder(char[] cArray) {
            this.searchChars = cArray;
        }

        protected int scan(char c, boolean bl) {
            int n = 0;
            while (n < this.searchChars.length) {
                if (c == this.searchChars[n]) {
                    this.foundChar = this.searchChars[n];
                    this.found = true;
                    return 0;
                }
                ++n;
            }
            return 1;
        }

        public char getFoundChar() {
            return this.foundChar;
        }
    }

    public static class CharBwdFinder
    extends GenericBwdFinder {
        char searchChar;

        public CharBwdFinder(char c) {
            this.searchChar = c;
        }

        protected int scan(char c, boolean bl) {
            if (c == this.searchChar) {
                this.found = true;
                return 0;
            }
            return -1;
        }
    }

    public static class CharFwdFinder
    extends GenericFwdFinder {
        char searchChar;

        public CharFwdFinder(char c) {
            this.searchChar = c;
        }

        protected int scan(char c, boolean bl) {
            if (c == this.searchChar) {
                this.found = true;
                return 0;
            }
            return 1;
        }
    }

    public static abstract class GenericFinder
    extends AbstractFinder {
        protected boolean forward;

        public boolean isForward() {
            return this.forward;
        }

        public final int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            int n7 = n5 - n;
            if (this.forward) {
                --n7;
            }
            while (n6 >= n2 && n6 < n3) {
                n6 += this.scan(cArray[n6], n6 == n7);
                if (this.found) break;
            }
            return n + n6;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    public static abstract class GenericBwdFinder
    extends AbstractFinder {
        public final int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            int n7 = n5 - n;
            while (n6 >= n2 && n6 < n3) {
                n6 += this.scan(cArray[n6], n6 == n7);
                if (this.found) break;
            }
            return n + n6;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    public static abstract class GenericFwdFinder
    extends AbstractFinder {
        public final int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            int n7 = n5 - n - 1;
            while (n6 >= n2 && n6 < n3) {
                n6 += this.scan(cArray[n6], n6 == n7);
                if (this.found) break;
            }
            return n + n6;
        }

        protected abstract int scan(char var1, boolean var2);
    }

    public static final class VisColPosFwdFinder
    extends AbstractFinder {
        int visCol;
        int curVisCol;
        int tabSize;
        EditorUI editorUI;

        public void setVisCol(int n) {
            this.visCol = n;
        }

        public void setTabSize(int n) {
            this.tabSize = n;
        }

        public void reset() {
            super.reset();
            this.curVisCol = 0;
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (n6 < n3) {
                if (this.curVisCol >= this.visCol) {
                    this.found = true;
                    return n + n6;
                }
                switch (cArray[n6]) {
                    case '\t': {
                        this.curVisCol = (this.curVisCol + this.tabSize) / this.tabSize * this.tabSize;
                        break;
                    }
                    case '\n': {
                        this.found = true;
                        return n + n6;
                    }
                    default: {
                        ++this.curVisCol;
                    }
                }
                ++n6;
            }
            return n + n6;
        }
    }

    public static final class PosVisColFwdFinder
    extends AbstractFinder {
        int visCol;
        int tabSize;

        public int getVisCol() {
            return this.visCol;
        }

        public void setTabSize(int n) {
            this.tabSize = n;
        }

        public void reset() {
            super.reset();
            this.visCol = 0;
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (n6 < n3) {
                this.visCol = cArray[n6] == '\t' ? (this.visCol + this.tabSize) / this.tabSize * this.tabSize : ++this.visCol;
                ++n6;
            }
            return n + n6;
        }
    }

    public static final class BOLBwdFinder
    extends AbstractFinder {
        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (n6 >= n2) {
                if (cArray[n6] == '\n') {
                    this.found = true;
                    return n + n6;
                }
                --n6;
            }
            return n + n6;
        }
    }

    static final class BEOLPosFwdFinder
    extends AbstractFinder {
        int line;
        int tgtPos;
        int bolPos;

        BEOLPosFwdFinder() {
        }

        public void reset() {
            this.line = 0;
            this.bolPos = -1;
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (n6 < n3) {
                if (cArray[n6] == '\n') {
                    if (this.tgtPos <= n + n6) {
                        this.found = true;
                        return n + n6;
                    }
                    ++this.line;
                    this.bolPos = n + n6 + 1;
                }
                ++n6;
            }
            return n + n6;
        }
    }

    static final class BEOLLineFwdFinder
    extends AbstractFinder {
        int fwdLines;
        int bolPos;

        BEOLLineFwdFinder() {
        }

        public void reset() {
            this.bolPos = -1;
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (n6 < n3) {
                if (cArray[n6] == '\n') {
                    if (this.fwdLines-- == 0) {
                        this.found = true;
                        return n + n6;
                    }
                    this.bolPos = n + n6 + 1;
                }
                ++n6;
            }
            return n + n6;
        }
    }

    static final class NBOLFwdFinder
    extends AbstractFinder {
        int fwdLines;

        NBOLFwdFinder() {
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (n6 < n3) {
                if (cArray[n6] == '\n') {
                    --this.fwdLines;
                    if (this.fwdLines == 0) {
                        this.found = true;
                        return n + n6 + 1;
                    }
                }
                ++n6;
            }
            return n + n6;
        }
    }

    static final class EOLFwdFinder
    extends AbstractFinder {
        EOLFwdFinder() {
        }

        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            int n6 = n4 - n;
            while (n6 < n3) {
                if (cArray[n6] == '\n') {
                    this.found = true;
                    return n + n6;
                }
                ++n6;
            }
            return n + n6;
        }
    }

    public static class FalseFinder
    extends AbstractFinder
    implements StringFinder {
        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            return -1;
        }

        public int getFoundLength() {
            return 0;
        }
    }

    public static class TrueFinder
    extends AbstractFinder {
        public int find(int n, char[] cArray, int n2, int n3, int n4, int n5) {
            this.found = true;
            return n4;
        }
    }

    public static abstract class AbstractFinder
    implements Finder {
        protected boolean found;

        public final boolean isFound() {
            return this.found;
        }

        public void reset() {
            this.found = false;
        }
    }
}

