/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.Position;
import org.netbeans.editor.DocOp;
import org.netbeans.editor.InvalidMarkException;

public class Mark {
    private DocOp op;
    int offset;
    int line;
    boolean backwardBias;
    boolean valid;

    public Mark() {
        this(Position.Bias.Forward);
    }

    public Mark(Position.Bias bias) {
        this(bias == Position.Bias.Backward);
    }

    public Mark(boolean bl) {
        this.backwardBias = bl;
    }

    Mark(int n, int n2, boolean bl) {
        this.offset = n;
        this.line = n2;
        this.backwardBias = bl;
    }

    public final int getOffset() throws InvalidMarkException {
        try {
            DocOp docOp;
            DocOp docOp2 = docOp = this.op;
            synchronized (docOp2) {
                block6: {
                    if (docOp != this.op) break block6;
                    int n = docOp.marks.getOffset(this);
                    return n;
                }
                throw new InvalidMarkException();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidMarkException(nullPointerException.toString());
        }
    }

    public final int getLine() throws InvalidMarkException {
        try {
            DocOp docOp;
            DocOp docOp2 = docOp = this.op;
            synchronized (docOp2) {
                block6: {
                    if (docOp != this.op) break block6;
                    int n = docOp.marks.getLine(this);
                    return n;
                }
                throw new InvalidMarkException();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidMarkException(nullPointerException.toString());
        }
    }

    public final boolean getInsertAfter() {
        return this.backwardBias;
    }

    public final boolean getBackwardBias() {
        return this.getInsertAfter();
    }

    public final Position.Bias getBias() {
        return this.backwardBias ? Position.Bias.Backward : Position.Bias.Forward;
    }

    final void setOp(DocOp docOp) {
        this.op = docOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        try {
            DocOp docOp;
            DocOp docOp2 = docOp = this.op;
            synchronized (docOp2) {
                if (docOp != this.op || !this.valid) {
                    throw new IllegalStateException();
                }
                docOp.marks.dispose(this);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException(nullPointerException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove() throws InvalidMarkException {
        try {
            DocOp docOp = this.op;
            DocOp docOp2 = this.op;
            synchronized (docOp2) {
                if (docOp != this.op || !this.valid) {
                    throw new InvalidMarkException();
                }
                this.op.marks.remove(this);
                this.op = null;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidMarkException(nullPointerException.toString());
        }
    }

    final void removeDisposed() {
        this.op = null;
    }

    public final int compare(int n) throws InvalidMarkException {
        return this.getOffset() - n;
    }

    protected void removeUpdateAction(int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isValid() {
        try {
            DocOp docOp = this.op;
            synchronized (docOp) {
                boolean bl = this.valid;
                return bl;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public String toString() {
        return "rawOffset=" + this.offset + ", rawLine=" + this.line + ", backwardBias=" + this.backwardBias;
    }
}

