/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;

public interface CompletionQuery {
    public Result query(JTextComponent var1, int var2, SyntaxSupport var3);

    public static class DefaultResultItem
    extends AbstractResultItem {
        static JLabel rubberStamp = new JLabel();
        protected Color foreColor;

        public DefaultResultItem(String string, Color color) {
            super(string);
            this.foreColor = color;
        }

        public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
            rubberStamp.setText(" " + this.text);
            if (bl) {
                rubberStamp.setBackground(jList.getSelectionBackground());
                rubberStamp.setForeground(jList.getSelectionForeground());
            } else {
                rubberStamp.setBackground(jList.getBackground());
                rubberStamp.setForeground(this.foreColor);
            }
            return rubberStamp;
        }

        static {
            rubberStamp.setOpaque(true);
        }
    }

    public static abstract class AbstractResultItem
    implements ResultItem {
        protected String text;

        public AbstractResultItem(String string) {
            this.text = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            try {
                baseDocument.atomicLock();
                try {
                    baseDocument.remove(n, n2);
                    baseDocument.insertString(n, this.text.substring(0, n3), null);
                    Object var7_6 = null;
                    baseDocument.atomicUnlock();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    baseDocument.atomicUnlock();
                    throw throwable;
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            try {
                baseDocument.atomicLock();
                try {
                    baseDocument.remove(n, n2);
                    baseDocument.insertString(n, this.text, null);
                    Object var7_6 = null;
                    baseDocument.atomicUnlock();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    baseDocument.atomicUnlock();
                    throw throwable;
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            return true;
        }

        public String getItemText() {
            return this.text;
        }
    }

    public static interface ResultItem {
        public boolean substituteCommonText(JTextComponent var1, int var2, int var3, int var4);

        public boolean substituteText(JTextComponent var1, int var2, int var3, boolean var4);

        public String getItemText();

        public Component getPaintComponent(JList var1, boolean var2, boolean var3);
    }

    public static class DefaultResult
    extends AbstractResult {
        private JTextComponent component;
        private int offset;
        private int len;

        public DefaultResult(JTextComponent jTextComponent, String string, List list, int n, int n2) {
            super(list, string);
            this.component = jTextComponent;
            this.offset = n;
            this.len = n2;
        }

        private int getCommonPrefixLength(char[] cArray, int n, String string) {
            char[] cArray2 = string.toCharArray();
            int n2 = 0;
            if (n > cArray2.length) {
                n = cArray2.length;
            }
            while (n2 < n) {
                if (cArray[n2] != cArray2[n2]) break;
                ++n2;
            }
            return n2;
        }

        public boolean substituteCommonText(int n) {
            Object object;
            List list = this.getData();
            if (list.size() == 0) {
                return false;
            }
            Iterator iterator = list.iterator();
            char[] cArray = ((ResultItem)iterator.next()).getItemText().toCharArray();
            int n2 = cArray.length;
            while (iterator.hasNext()) {
                object = ((ResultItem)iterator.next()).getItemText();
                n2 = this.getCommonPrefixLength(cArray, n2, (String)object);
            }
            object = (ResultItem)list.get(n);
            return object.substituteCommonText(this.component, this.offset, this.len, n2);
        }

        public boolean substituteText(int n, boolean bl) {
            Object e = this.getData().get(n);
            return ((ResultItem)e).substituteText(this.component, this.offset, this.len, bl);
        }
    }

    public static abstract class AbstractResult
    implements Result {
        private List data;
        private String title;

        public AbstractResult(List list, String string) {
            this.data = list;
            this.title = string;
        }

        public List getData() {
            return this.data;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static interface Result {
        public List getData();

        public String getTitle();

        public boolean substituteText(int var1, boolean var2);

        public boolean substituteCommonText(int var1);
    }
}

