/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.EditorState;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.GotoDialogPanel;

public class GotoDialogSupport
implements ActionListener {
    private static final String BOUNDS_KEY = "GotoDialogSupport.bounds-goto-line";
    private JButton[] gotoButtons;
    private GotoDialogPanel gotoPanel;
    private static Dialog gotoDialog;

    public GotoDialogSupport() {
        JButton jButton = new JButton(LocaleSupport.getString("goto-button-goto"));
        JButton jButton2 = new JButton(LocaleSupport.getString("goto-button-cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_goto-button-goto"));
        jButton2.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_goto-button-cancel"));
        this.gotoButtons = new JButton[]{jButton, jButton2};
        this.gotoPanel = new GotoDialogPanel();
        this.gotoPanel.getGotoCombo().getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    GotoDialogSupport.this.actionPerformed(new ActionEvent(GotoDialogSupport.this.gotoButtons[0], 0, null));
                }
            }
        });
    }

    protected synchronized Dialog createGotoDialog() {
        if (gotoDialog == null) {
            gotoDialog = DialogSupport.createDialog(LocaleSupport.getString("goto-title"), this.gotoPanel, false, this.gotoButtons, false, 0, 1, this);
            gotoDialog.pack();
            Rectangle rectangle = (Rectangle)EditorState.get(BOUNDS_KEY);
            if (rectangle != null) {
                gotoDialog.setBounds(rectangle);
            } else {
                Dimension dimension = gotoDialog.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                int n = Math.max(0, (dimension2.width - dimension.width) / 2);
                int n2 = Math.max(0, (dimension2.height - dimension.height) / 2);
                gotoDialog.setLocation(n, n2);
            }
            return gotoDialog;
        }
        gotoDialog.toFront();
        return null;
    }

    protected synchronized void disposeGotoDialog() {
        if (gotoDialog != null) {
            EditorState.put(BOUNDS_KEY, gotoDialog.getBounds());
            gotoDialog.dispose();
            Utilities.returnFocus();
        }
        gotoDialog = null;
    }

    public void showGotoDialog() {
        Dialog dialog = this.createGotoDialog();
        if (dialog == null) {
            return;
        }
        this.gotoPanel.popupNotify();
        dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.gotoButtons[0] || object == this.gotoPanel) {
            if (this.performGoto()) {
                this.gotoPanel.updateHistory();
                this.disposeGotoDialog();
            }
        } else {
            this.disposeGotoDialog();
        }
    }

    protected boolean performGoto() {
        block5: {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            if (jTextComponent != null) {
                try {
                    Action action;
                    int n = Integer.parseInt(this.gotoPanel.getValue());
                    BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                    if (baseDocument == null) break block5;
                    int n2 = Utilities.getRowStartFromLineOffset(baseDocument, n - 1);
                    BaseKit baseKit = Utilities.getKit(jTextComponent);
                    if (baseKit != null && (action = baseKit.getActionByName("goto")) instanceof ExtKit.GotoAction) {
                        n2 = ((ExtKit.GotoAction)action).getOffsetFromLine(baseDocument, n - 1);
                    }
                    if (n2 != -1) {
                        jTextComponent.getCaret().setDot(n2);
                        break block5;
                    }
                    jTextComponent.getToolkit().beep();
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    jTextComponent.getToolkit().beep();
                    return false;
                }
            }
        }
        return true;
    }
}

