/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaFastImportPanel;

public class JavaFastImport
implements ActionListener {
    protected JTextComponent target;
    private String exp;
    private JavaFastImportPanel panel;
    private ListCellRenderer cellRenderer;
    private JList resultList;
    private Dialog dialog;
    private JButton[] buttons;

    public JavaFastImport(JTextComponent jTextComponent) {
        this.target = jTextComponent;
        this.exp = Utilities.getSelectionOrIdentifier(jTextComponent);
    }

    public void setDialogVisible(boolean bl) {
        List list = null;
        if (bl) {
            list = this.evaluate();
            if (list == null || list.size() == 0) {
                return;
            }
            this.populate(list);
        }
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.getResultList().requestFocus();
        this.dialog.setVisible(bl);
        if (bl) {
            this.getPanel().popupNotify();
        } else {
            this.dialog.dispose();
        }
    }

    protected void updateImport(Object object) {
    }

    protected ListCellRenderer createCellRenderer() {
        JCCellRenderer jCCellRenderer = new JCCellRenderer();
        jCCellRenderer.setClassDisplayFullName(true);
        return jCCellRenderer;
    }

    protected JList createResultList() {
        ListCompletionView listCompletionView = new ListCompletionView(this.getCellRenderer());
        listCompletionView.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JavaFastImport.this.actionPerformed(new ActionEvent(JavaFastImport.this.getButtons()[0], 0, ""));
                }
            }
        });
        return listCompletionView;
    }

    private JButton[] getButtons() {
        if (this.buttons == null) {
            this.buttons = new JButton[]{new JButton(LocaleSupport.getString("JFI_importButton", "Import Class")), new JButton(LocaleSupport.getString("JFI_cancelButton", "Cancel"))};
            String string = LocaleSupport.getString("JFI_importButtonMnemonic", "I");
            if (string != null && string.length() > 0) {
                this.buttons[0].setMnemonic(string.charAt(0));
            }
            if ((string = LocaleSupport.getString("JFI_cancelButtonMnemonic", "C")) != null && string.length() > 0) {
                this.buttons[1].setMnemonic(string.charAt(0));
            }
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_importButton"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_cancelButton"));
        }
        return this.buttons;
    }

    private Dialog createDialog() {
        String string = LocaleSupport.getString("JFI_title", "Import Class");
        Dialog dialog = DialogSupport.createDialog(string, this.getPanel(), true, this.getButtons(), false, 0, 1, this);
        return dialog;
    }

    private JavaFastImportPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JavaFastImportPanel(this);
        }
        return this.panel;
    }

    ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = this.createCellRenderer();
        }
        return this.cellRenderer;
    }

    JList getResultList() {
        if (this.resultList == null) {
            this.resultList = this.createResultList();
        }
        return this.resultList;
    }

    List evaluate() {
        List list = null;
        if (this.exp != null && this.exp.length() > 0) {
            JCFinder jCFinder = JavaCompletion.getFinder();
            list = jCFinder.findClasses(null, this.exp, true);
        }
        return list;
    }

    void populate(List list) {
        if (list != null && this.getResultList() instanceof ListCompletionView) {
            ((ListCompletionView)this.getResultList()).setResult(list);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttons[0]) {
            int n = this.getResultList().getSelectedIndex();
            if (n >= 0) {
                this.updateImport(this.getResultList().getModel().getElementAt(n));
            }
            this.setDialogVisible(false);
        } else if (object == this.buttons[1]) {
            this.setDialogVisible(false);
        }
    }
}

