/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Bookmarks;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUI;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.NbToolTip;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.TopManager;
import org.openide.actions.RedoAction;
import org.openide.actions.UndoAction;
import org.openide.awt.JPopupMenuPlus;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorKit
extends ExtKit {
    public static final String SYSTEM_ACTION_CLASS_NAME_PROPERTY = "systemActionClassName";
    public static final String BOOKMARK_ANNOTATION_TYPE = "editor-bookmark";
    static final long serialVersionUID = 4482122073483644089L;
    private static final Map contentTypeTable = new HashMap();
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$openide$actions$ReplaceAction;
    static /* synthetic */ Class class$org$openide$actions$GotoAction;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$org$openide$util$actions$SystemAction;
    static /* synthetic */ Class class$org$openide$actions$UndoAction;
    static /* synthetic */ Class class$org$openide$actions$RedoAction;
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbEditorKit;

    public NbEditorKit() {
        AllOptionsFolder.getDefault().loadMIMEOption(this.getClass());
    }

    public Document createDefaultDocument() {
        return new NbEditorDocument(this.getClass());
    }

    protected EditorUI createEditorUI() {
        return new NbEditorUI();
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new NbBuildPopupMenuAction(), new NbStopMacroRecordingAction(), new NbUndoAction(), new NbRedoAction(), new NbToggleBookmarkAction(), new NbGotoNextBookmarkAction("bookmark-next", false), new NbBuildToolTipAction(), new NbToggleLineNumbersAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    protected void addSystemActionMapping(String string, Class clazz) {
        Action action = this.getActionByName(string);
        if (action != null) {
            action.putValue(SYSTEM_ACTION_CLASS_NAME_PROPERTY, clazz.getName());
        }
    }

    protected void updateActions() {
        this.addSystemActionMapping("cut-to-clipboard", class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = NbEditorKit.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction);
        this.addSystemActionMapping("copy-to-clipboard", class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = NbEditorKit.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction);
        this.addSystemActionMapping("paste-from-clipboard", class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = NbEditorKit.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
        this.addSystemActionMapping("remove-selection", class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = NbEditorKit.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction);
        this.addSystemActionMapping("find", class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = NbEditorKit.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction);
        this.addSystemActionMapping("replace", class$org$openide$actions$ReplaceAction == null ? (class$org$openide$actions$ReplaceAction = NbEditorKit.class$("org.openide.actions.ReplaceAction")) : class$org$openide$actions$ReplaceAction);
        this.addSystemActionMapping("goto", class$org$openide$actions$GotoAction == null ? (class$org$openide$actions$GotoAction = NbEditorKit.class$("org.openide.actions.GotoAction")) : class$org$openide$actions$GotoAction);
    }

    public Class getFocusableComponentClass(JTextComponent jTextComponent) {
        return class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbEditorKit.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent;
    }

    public String getContentType() {
        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            System.out.println("Warning: KitClass " + this.getClass().getName() + " doesn't override the method getContentType.");
        }
        return contentTypeTable.containsKey(this.getClass().getName()) ? (String)contentTypeTable.get(this.getClass().getName()) : "text/" + this.getClass().getName().replace('.', '_');
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        contentTypeTable.put("org.netbeans.modules.properties.syntax.PropertiesKit", "text/x-properties");
        contentTypeTable.put("org.netbeans.modules.web.core.syntax.JSPKit", "text/x-jsp");
        contentTypeTable.put("org.netbeans.modules.css.text.syntax.CSSEditorKit", "text/css");
        contentTypeTable.put("org.netbeans.modules.xml.css.editor.CSSEditorKit", "text/css");
        contentTypeTable.put("org.netbeans.modules.xml.text.syntax.DTDKit", "text/x-dtd");
        contentTypeTable.put("org.netbeans.modules.xml.text.syntax.XMLKit", "text/xml");
        contentTypeTable.put("org.netbeans.modules.corba.idl.editor.coloring.IDLKit", "text/x-idl");
    }

    public static class NbBuildToolTipAction
    extends ExtKit.BuildToolTipAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                NbToolTip.buildToolTip(jTextComponent);
            }
        }
    }

    private static class Bookmark
    implements Bookmarks.Bookmark {
        private Annotation anno;

        public Bookmark(Annotation annotation) {
            this.anno = annotation;
        }

        public int getLine() {
            return ((Line)this.anno.getAttachedAnnotatable()).getLineNumber();
        }

        public Annotation getAnno() {
            return this.anno;
        }

        public void remove() {
            this.anno.detach();
            this.anno = null;
        }
    }

    private static class BookmarkAnnotation
    extends Annotation {
        private BookmarkAnnotation() {
        }

        public String getAnnotationType() {
            return NbEditorKit.BOOKMARK_ANNOTATION_TYPE;
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$NbEditorKit == null ? (class$org$netbeans$modules$editor$NbEditorKit = NbEditorKit.class$("org.netbeans.modules.editor.NbEditorKit")) : class$org$netbeans$modules$editor$NbEditorKit)).getString("Bookmark_Tooltip");
        }
    }

    public class NbToggleLineNumbersAction
    extends ActionFactory.ToggleLineNumbersAction {
        private BaseOptions bo;

        public NbToggleLineNumbersAction() {
            this.bo = BaseOptions.getOptions(NbEditorKit.this.getClass());
        }

        protected boolean isLineNumbersVisible() {
            return this.bo.getLineNumberVisible();
        }

        protected void toggleLineNumbers() {
            this.bo.setLineNumberVisible(!this.isLineNumbersVisible());
        }
    }

    public static class NbGotoNextBookmarkAction
    extends ActionFactory.GotoNextBookmarkAction {
        static final long serialVersionUID = -6305740718286540539L;

        public NbGotoNextBookmarkAction() {
            super(null, false);
        }

        public NbGotoNextBookmarkAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return;
            }
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            Caret caret = jTextComponent.getCaret();
            if (Utilities.getEditorUI(jTextComponent) == null || !Utilities.getEditorUI(jTextComponent).isGlyphGutterVisible()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            int n = 0;
            try {
                n = Utilities.getLineOffset(baseDocument, caret.getDot());
            }
            catch (BadLocationException badLocationException) {
                jTextComponent.getToolkit().beep();
                return;
            }
            Bookmarks bookmarks = baseDocument.getBookmarks();
            Bookmark bookmark = (Bookmark)bookmarks.getNextLineBookmark(n + 1);
            if (bookmark == null) {
                bookmark = (Bookmark)bookmarks.getNextLineBookmark(0);
            }
            if (bookmark == null) {
                return;
            }
            Annotation annotation = bookmark.getAnno();
            annotation.moveToFront();
            ((Line)annotation.getAttachedAnnotatable()).show(2);
        }
    }

    public static class NbToggleBookmarkAction
    extends ActionFactory.ToggleBookmarkAction {
        static final long serialVersionUID = 8870696224845563318L;

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return;
            }
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            Caret caret = jTextComponent.getCaret();
            if (Utilities.getEditorUI(jTextComponent) == null || !Utilities.getEditorUI(jTextComponent).isGlyphGutterVisible()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            int n = 0;
            try {
                n = Utilities.getLineOffset(baseDocument, caret.getDot());
            }
            catch (BadLocationException badLocationException) {
                jTextComponent.getToolkit().beep();
                return;
            }
            Bookmarks bookmarks = baseDocument.getBookmarks();
            Annotation annotation = null;
            Bookmark bookmark = (Bookmark)bookmarks.getBookmark(n);
            if (bookmark != null) {
                annotation = bookmark.getAnno();
            }
            if (annotation == null) {
                annotation = new BookmarkAnnotation();
                Line line = NbEditorUtilities.getLine(baseDocument, caret.getDot(), false);
                if (line == null) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                annotation.attach((Annotatable)line);
                bookmarks.putBookmark(new Bookmark(annotation));
            } else {
                annotation.detach();
                bookmarks.removeBookmark(bookmark);
            }
        }
    }

    public static class NbRedoAction
    extends ActionFactory.RedoAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (NbEditorUtilities.getTopManager() != null) {
                RedoAction redoAction = (RedoAction)SystemAction.get((Class)(class$org$openide$actions$RedoAction == null ? (class$org$openide$actions$RedoAction = NbEditorKit.class$("org.openide.actions.RedoAction")) : class$org$openide$actions$RedoAction));
                if (redoAction != null && redoAction.isEnabled()) {
                    redoAction.actionPerformed(actionEvent);
                }
            } else {
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }
    }

    public static class NbUndoAction
    extends ActionFactory.UndoAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (NbEditorUtilities.getTopManager() != null) {
                UndoAction undoAction = (UndoAction)SystemAction.get((Class)(class$org$openide$actions$UndoAction == null ? (class$org$openide$actions$UndoAction = NbEditorKit.class$("org.openide.actions.UndoAction")) : class$org$openide$actions$UndoAction));
                if (undoAction != null && undoAction.isEnabled()) {
                    undoAction.actionPerformed(actionEvent);
                }
            } else {
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }
    }

    public class NbStopMacroRecordingAction
    extends ActionFactory.StopMacroRecordingAction {
        private BaseOptions bo;

        private Map getKBMap() {
            List list = this.bo.getKeyBindingList();
            if (list.size() > 0 && (list.get(0) instanceof Class || list.get(0) instanceof String)) {
                list.remove(0);
            }
            Map map = OptionUtilities.makeKeyBindingsMap(list);
            return map;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            this.bo = BaseOptions.getOptions(NbEditorKit.this.getClass());
            Map map = null;
            Map map2 = null;
            if (this.bo != null) {
                map = this.bo.getMacroMap();
                map2 = this.getKBMap();
            }
            super.actionPerformed(actionEvent, jTextComponent);
            if (this.bo != null) {
                this.bo.setMacroDiffMap(OptionUtilities.getMapDiff(map, this.bo.getMacroMap(), true));
                this.bo.setKeyBindingsDiffMap(OptionUtilities.getMapDiff(map2, this.getKBMap(), true));
            }
        }
    }

    public class NbBuildPopupMenuAction
    extends ExtKit.BuildPopupMenuAction {
        static final long serialVersionUID = -8623762627678464181L;

        protected JPopupMenu buildPopupMenu(JTextComponent jTextComponent) {
            JPopupMenu jPopupMenu;
            Object object = System.getProperties().remove("hack.pendingNodeActivator");
            if (object instanceof Runnable) {
                ((Runnable)object).run();
            }
            if ((jPopupMenu = super.buildPopupMenu(jTextComponent)) instanceof JPopupMenuPlus) {
                return jPopupMenu;
            }
            Component[] componentArray = jPopupMenu.getComponents();
            jPopupMenu.removeAll();
            JPopupMenuPlus jPopupMenuPlus = new JPopupMenuPlus();
            int n = 0;
            while (n < componentArray.length) {
                jPopupMenuPlus.add(componentArray[n]);
                ++n;
            }
            return jPopupMenuPlus;
        }

        protected void addAction(JTextComponent jTextComponent, JPopupMenu jPopupMenu, String string) {
            if (string != null) {
                if ((class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbEditorKit.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).getName().equals(string)) {
                    TopComponent topComponent = NbEditorUtilities.getTopComponent(jTextComponent);
                    if (topComponent != null) {
                        SystemAction[] systemActionArray = topComponent.getSystemActions();
                        TopManager topManager = NbEditorUtilities.getTopManager();
                        if (topManager != null) {
                            int n = 0;
                            while (n < systemActionArray.length) {
                                if (systemActionArray[n] instanceof Presenter.Popup) {
                                    KeyStroke[] keyStrokeArray;
                                    JMenuItem jMenuItem = ((Presenter.Popup)systemActionArray[n]).getPopupPresenter();
                                    if (jMenuItem != null && !(jMenuItem instanceof JMenu) && (keyStrokeArray = topManager.getGlobalKeymap().getKeyStrokesForAction((Action)systemActionArray[n])) != null && keyStrokeArray.length > 0) {
                                        jMenuItem.setAccelerator(keyStrokeArray[0]);
                                    }
                                    if (jMenuItem != null) {
                                        jPopupMenu.add(jMenuItem);
                                    }
                                } else if (systemActionArray[n] == null) {
                                    jPopupMenu.addSeparator();
                                }
                                ++n;
                            }
                        }
                    }
                    return;
                }
                Class<?> clazz = null;
                TopManager topManager = NbEditorUtilities.getTopManager();
                try {
                    if (topManager != null) {
                        clazz = Class.forName(string, false, topManager.systemClassLoader());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (clazz != null && (class$org$openide$util$actions$SystemAction == null ? (class$org$openide$util$actions$SystemAction = NbEditorKit.class$("org.openide.util.actions.SystemAction")) : class$org$openide$util$actions$SystemAction).isAssignableFrom(clazz)) {
                    SystemAction systemAction;
                    if (topManager != null && (systemAction = SystemAction.get(clazz)) instanceof Presenter.Popup) {
                        KeyStroke[] keyStrokeArray;
                        JMenuItem jMenuItem = ((Presenter.Popup)systemAction).getPopupPresenter();
                        if (jMenuItem != null && !(jMenuItem instanceof JMenu) && (keyStrokeArray = topManager.getGlobalKeymap().getKeyStrokesForAction((Action)systemAction)) != null && keyStrokeArray.length > 0) {
                            jMenuItem.setAccelerator(keyStrokeArray[0]);
                        }
                        if (jMenuItem != null) {
                            jPopupMenu.add(jMenuItem);
                        }
                    }
                    return;
                }
            }
            super.addAction(jTextComponent, jPopupMenu, string);
        }
    }
}

