/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.html.HTMLCompletion;
import org.netbeans.editor.ext.html.HTMLSyntax;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.html.NbReaderProvider;

public class HTMLKit
extends NbEditorKit {
    static final long serialVersionUID = -1381945567613910297L;
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String shiftInsertBreakAction = "shift-insert-break";

    public String getContentType() {
        return HTML_MIME_TYPE;
    }

    public Syntax createSyntax(Document document) {
        return new HTMLSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new HTMLSyntaxSupport(baseDocument);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return new HTMLCompletion(extEditorUI);
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new HTMLShiftBreakAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    static {
        NbReaderProvider.setupReaders();
    }

    public static class HTMLShiftBreakAction
    extends BaseAction {
        static final long serialVersionUID = 4004043376345356061L;

        public HTMLShiftBreakAction() {
            super(HTMLKit.shiftInsertBreakAction, 14);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Completion completion;
            if (jTextComponent != null && (completion = ExtUtilities.getCompletion(jTextComponent)) != null && completion.isPaneVisible() && !completion.substituteText(true)) {
                completion.refresh(false);
            }
        }
    }
}

